// wrapfunptr.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "funptr.h"
// shroud
#include "wrapfunptr.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {

// splicer begin C_definitions
// splicer end C_definitions

/**
 * \brief Create abstract interface for function
 *
 */
// ----------------------------------------
// Function:  void callback1
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*incr1)(void)
// Statement: c_in_procedure
void FUN_callback1(void (*incr1)(void))
{
    // splicer begin function.callback1
    callback1(incr1);
    // splicer end function.callback1
}

/**
 * \brief Create abstract interface for function
 *
 * Create a Fortran wrapper to call the bind(C) interface.
 */
// ----------------------------------------
// Function:  void callback1_wrap
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*incr1_wrap)(void)
// Statement: c_in_procedure
void FUN_callback1_wrap(void (*incr1_wrap)(void))
{
    // splicer begin function.callback1_wrap
    callback1_wrap(incr1_wrap);
    // splicer end function.callback1_wrap
}

/**
 * \brief Declare callback as external
 *
 */
// ----------------------------------------
// Function:  void callback1_external
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*incr1_external)(void) +external
// Statement: c_in_procedure_external
void FUN_callback1_external(void (*incr1_external)(void))
{
    // splicer begin function.callback1_external
    callback1_external(incr1_external);
    // splicer end function.callback1_external
}

/**
 * \brief Declare callback as c_funptr
 *
 * The caller is responsible for using c_funloc to pass the function address.
 */
// ----------------------------------------
// Function:  void callback1_funptr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*incr1_funptr)(void) +funptr
// Statement: c_in_procedure_funptr
// start FUN_callback1_funptr
void FUN_callback1_funptr(void (*incr1_funptr)(void))
{
    // splicer begin function.callback1_funptr
    callback1_funptr(incr1_funptr);
    // splicer end function.callback1_funptr
}
// end FUN_callback1_funptr

/**
 * \brief Create abstract interface for function
 *
 */
// ----------------------------------------
// Function:  void callback2
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const char *name
// Statement: c_in_char*
// ----------------------------------------
// Argument:  int ival
// Statement: c_in_native
// ----------------------------------------
// Argument:  incrtype incr
// Statement: c_in_procedure
void FUN_callback2(const char *name, int ival, FUN_incrtype incr)
{
    // splicer begin function.callback2
    callback2(name, ival, incr);
    // splicer end function.callback2
}

/**
 * \brief Declare callback as external
 *
 */
// ----------------------------------------
// Function:  void callback2_external
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const char *name
// Statement: c_in_char*
// ----------------------------------------
// Argument:  int ival
// Statement: c_in_native
// ----------------------------------------
// Argument:  incrtype incr +external
// Statement: c_in_procedure_external
void FUN_callback2_external(const char *name, int ival,
    FUN_incrtype incr)
{
    // splicer begin function.callback2_external
    callback2_external(name, ival, incr);
    // splicer end function.callback2_external
}

/**
 * \brief Declare callback as c_funptr
 *
 * The caller is responsible for using c_funloc to pass the function address.
 * Allows any function to be passed as an argument.
 */
// ----------------------------------------
// Function:  void callback2_funptr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const char *name
// Statement: c_in_char*
// ----------------------------------------
// Argument:  int ival
// Statement: c_in_native
// ----------------------------------------
// Argument:  incrtype incr +funptr
// Statement: c_in_procedure_funptr
void FUN_callback2_funptr(const char *name, int ival, FUN_incrtype incr)
{
    // splicer begin function.callback2_funptr
    callback2_funptr(name, ival, incr);
    // splicer end function.callback2_funptr
}

/**
 * \brief Test function pointer with assumedtype
 *
 */
// ----------------------------------------
// Function:  void callback3
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int type
// Statement: c_in_native
// ----------------------------------------
// Argument:  void *in +assumedtype+intent(in)
// Statement: c_in_void*
// ----------------------------------------
// Argument:  void (*incr3)(void) +funptr
// Statement: c_in_procedure_funptr
void FUN_callback3(int type, void *in, void (*incr3)(void))
{
    // splicer begin function.callback3
    callback3(type, in, incr3);
    // splicer end function.callback3
}

/**
 * \brief Test attributes on callback arguments
 *
 */
// ----------------------------------------
// Function:  int callback4
// Statement: c_function_native
// ----------------------------------------
// Argument:  int *ilow +intent(in)+rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  int nargs +implied(size(ilow))
// Statement: c_in_native
// ----------------------------------------
// Argument:  int (*actor)(int *ilow +intent(in)+rank(1), int nargs +intent(in))
// Statement: c_in_procedure
int FUN_callback4(int *ilow, int nargs, int (*actor)(int *ilow,
    int nargs))
{
    // splicer begin function.callback4
    int SHC_rv = callback4(ilow, nargs, actor);
    return SHC_rv;
    // splicer end function.callback4
}

/**
 * \brief Return a C_PTR
 *
 * No other arguments to test that a function result
 * uses iso_c_binding C_PTR.
 */
// ----------------------------------------
// Function:  void callback_ptr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *(*get_ptr)(void)
// Statement: c_in_procedure
void FUN_callback_ptr(int *(*get_ptr)(void))
{
    // splicer begin function.callback_ptr
    callback_ptr(get_ptr);
    // splicer end function.callback_ptr
}

/**
 * \brief Return a scalar in the callback.
 *
 * Make the function result a different type than the
 * aruguments to ensure the USE is created fully.
 */
// ----------------------------------------
// Function:  void callback_double
// Statement: c_subroutine
// ----------------------------------------
// Argument:  double (*get)(int i, int)
// Statement: c_in_procedure
void FUN_callback_double(double (*get)(int i, int))
{
    // splicer begin function.callback_double
    callback_double(get);
    // splicer end function.callback_double
}

/**
 * \brief abstract argument
 *
 */
// ----------------------------------------
// Function:  int abstract1
// Statement: c_function_native
// ----------------------------------------
// Argument:  int input
// Statement: c_in_native
// ----------------------------------------
// Argument:  int (*get_abs)(double, int)
// Statement: c_in_procedure
int FUN_abstract1(int input, int (*get_abs)(double, int))
{
    // splicer begin function.abstract1
    int SHC_rv = abstract1(input, get_abs);
    return SHC_rv;
    // splicer end function.abstract1
}

/**
 * \brief Test void * argument
 *
 */
// ----------------------------------------
// Function:  void callback_void_ptr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*void_ptr_arg)(void *)
// Statement: c_in_procedure
void FUN_callback_void_ptr(void (*void_ptr_arg)(void *))
{
    // splicer begin function.callback_void_ptr
    callback_void_ptr(void_ptr_arg);
    // splicer end function.callback_void_ptr
}

/**
 * \brief Test callback argument types
 *
 */
// ----------------------------------------
// Function:  void callback_all_types
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void (*all_types)(int, int * +rank(1), char, char *, bool, bool *)
// Statement: c_in_procedure
void FUN_callback_all_types(void (*all_types)(int, int *, char, char *,
    bool, bool *))
{
    // splicer begin function.callback_all_types
    callback_all_types(all_types);
    // splicer end function.callback_all_types
}

}  // extern "C"
