! wrapffunptr.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapffunptr.f
!! \brief Shroud generated wrapper for funptr library
!<
! splicer begin file_top
! splicer end file_top
module funptr_mod
    use iso_c_binding, only : C_INT
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! typedef TypeID
    ! splicer begin typedef.TypeID
    integer, parameter :: type_id = C_INT
    ! splicer end typedef.TypeID

    abstract interface

        ! ----------------------------------------
        ! Function:  void incr1_external +external
        ! Statement: f_subroutine
        subroutine callback1_external_incr1_external() bind(C)
            implicit none
        end subroutine callback1_external_incr1_external

        ! ----------------------------------------
        ! Function:  void incr1
        ! Statement: f_subroutine
        subroutine callback1_incr1() bind(C)
            implicit none
        end subroutine callback1_incr1

        ! ----------------------------------------
        ! Function:  void incr1_wrap
        ! Statement: f_subroutine
        subroutine callback1_wrap_incr1_wrap() bind(C)
            implicit none
        end subroutine callback1_wrap_incr1_wrap

        ! ----------------------------------------
        ! Function:  int actor
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int *ilow +intent(in)+rank(1)
        ! Statement: f_in_native*
        ! ----------------------------------------
        ! Argument:  int nargs +intent(in)
        ! Statement: f_in_native
        function callback4_actor(ilow, nargs) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: ilow(*)
            integer(C_INT), value, intent(IN) :: nargs
            integer(C_INT) :: SHT_rv
        end function callback4_actor

        ! ----------------------------------------
        ! Function:  void all_types
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int * +rank(1)
        ! Statement: f_none_native*
        ! ----------------------------------------
        ! Argument:  char
        ! Statement: f_none_char
        ! ----------------------------------------
        ! Argument:  char *
        ! Statement: f_none_char*
        ! ----------------------------------------
        ! Argument:  bool
        ! Statement: f_none_bool
        ! ----------------------------------------
        ! Argument:  bool *
        ! Statement: f_none_bool*
        subroutine callback_all_types_all_types(arg0, arg1, arg2, arg3, &
            arg4, arg5) bind(C)
            use iso_c_binding, only : C_BOOL, C_CHAR, C_INT
            implicit none
            integer(C_INT), value :: arg0
            integer(C_INT) :: arg1(*)
            character(kind=C_CHAR), value :: arg2
            character(kind=C_CHAR) :: arg3(*)
            logical(C_BOOL), value :: arg4
            logical(C_BOOL) :: arg5
        end subroutine callback_all_types_all_types

        ! ----------------------------------------
        ! Function:  double get
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int i
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        function callback_double_get(i, arg1) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            integer(C_INT), value :: i
            integer(C_INT), value :: arg1
            real(C_DOUBLE) :: SHT_rv
        end function callback_double_get

        ! ----------------------------------------
        ! Function:  int *get_ptr
        ! Statement: f_function_native*_pointer
        function callback_ptr_get_ptr() &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function callback_ptr_get_ptr

        ! ----------------------------------------
        ! Function:  void void_ptr_arg
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void *
        ! Statement: f_none_void*
        subroutine callback_void_ptr_void_ptr_arg(arg0) bind(C)
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), value :: arg0
        end subroutine callback_void_ptr_void_ptr_arg

        ! ----------------------------------------
        ! Function:  int get_abs
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  double
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        function custom_funptr(XX0arg, XX1arg) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value :: XX0arg
            integer(C_INT), value :: XX1arg
            integer(C_INT) :: SHT_rv
        end function custom_funptr

        ! ----------------------------------------
        ! Function:  typedef int get_int
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  double
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        function get_int(arg0, arg1) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value :: arg0
            integer(C_INT), value :: arg1
            integer(C_INT) :: SHT_rv
        end function get_int

        ! ----------------------------------------
        ! Function:  typedef void incrtype
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int i
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  TypeID j
        ! Statement: f_none_native
        subroutine incrtype(i, j) bind(C)
            use iso_c_binding, only : C_INT
            import :: type_id
            implicit none
            integer(C_INT), value :: i
            integer(type_id), value :: j
        end subroutine incrtype

    end interface

    interface

        ! ----------------------------------------
        ! Function:  void callback1
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*incr1)(void)
        ! Statement: f_in_procedure
        subroutine callback1(incr1) &
                bind(C, name="callback1")
            import :: callback1_incr1
            implicit none
            procedure(callback1_incr1) :: incr1
        end subroutine callback1

        ! ----------------------------------------
        ! Function:  void callback1_wrap
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*incr1_wrap)(void)
        ! Statement: f_in_procedure
        subroutine c_callback1_wrap(incr1_wrap) &
                bind(C, name="callback1_wrap")
            import :: callback1_wrap_incr1_wrap
            implicit none
            procedure(callback1_wrap_incr1_wrap) :: incr1_wrap
        end subroutine c_callback1_wrap

        ! ----------------------------------------
        ! Function:  void callback1_external
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*incr1_external)(void) +external
        ! Statement: f_in_procedure_external
        subroutine c_callback1_external(incr1_external) &
                bind(C, name="callback1_external")
            import :: callback1_external_incr1_external
            implicit none
            procedure(callback1_external_incr1_external) :: incr1_external
        end subroutine c_callback1_external

        ! ----------------------------------------
        ! Function:  void callback1_funptr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*incr1_funptr)(void) +funptr
        ! Statement: f_in_procedure_funptr
        ! start callback1_funptr
        subroutine callback1_funptr(incr1_funptr) &
                bind(C, name="callback1_funptr")
            use iso_c_binding, only : C_FUNPTR
            implicit none
            type(C_FUNPTR), value :: incr1_funptr
        end subroutine callback1_funptr
        ! end callback1_funptr

        ! ----------------------------------------
        ! Function:  void callback2
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const char *name
        ! Statement: f_in_char*
        ! ----------------------------------------
        ! Argument:  int ival
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  incrtype incr
        ! Statement: f_in_procedure
        subroutine c_callback2(name, ival, incr) &
                bind(C, name="callback2")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: incrtype
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: ival
            procedure(incrtype) :: incr
        end subroutine c_callback2

        ! ----------------------------------------
        ! Function:  void callback2_external
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const char *name
        ! Statement: f_in_char*
        ! ----------------------------------------
        ! Argument:  int ival
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  incrtype incr +external
        ! Statement: f_in_procedure_external
        subroutine c_callback2_external(name, ival, incr) &
                bind(C, name="callback2_external")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: incrtype
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: ival
            procedure(incrtype) :: incr
        end subroutine c_callback2_external

        ! ----------------------------------------
        ! Function:  void callback2_funptr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const char *name
        ! Statement: f_in_char*
        ! ----------------------------------------
        ! Argument:  int ival
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  incrtype incr +funptr
        ! Statement: f_in_procedure_funptr
        subroutine c_callback2_funptr(name, ival, incr) &
                bind(C, name="callback2_funptr")
            use iso_c_binding, only : C_CHAR, C_FUNPTR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: ival
            type(C_FUNPTR), value :: incr
        end subroutine c_callback2_funptr

        ! ----------------------------------------
        ! Function:  void callback3
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int type
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  void *in +assumedtype+intent(in)
        ! Statement: f_in_void*
        ! ----------------------------------------
        ! Argument:  void (*incr3)(void) +funptr
        ! Statement: f_in_procedure_funptr
        subroutine callback3(type, in, incr3) &
                bind(C, name="callback3")
            use iso_c_binding, only : C_FUNPTR, C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: type
            type(*), intent(IN) :: in
            type(C_FUNPTR), value :: incr3
        end subroutine callback3

        ! ----------------------------------------
        ! Function:  int callback4
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int *ilow +intent(in)+rank(1)
        ! Statement: f_in_native*
        ! ----------------------------------------
        ! Argument:  int nargs +implied(size(ilow))
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int (*actor)(int *ilow +intent(in)+rank(1), int nargs +intent(in))
        ! Statement: f_in_procedure
        function c_callback4(ilow, nargs, actor) &
                result(SHT_rv) &
                bind(C, name="callback4")
            use iso_c_binding, only : C_INT
            import :: callback4_actor
            implicit none
            integer(C_INT), intent(IN) :: ilow(*)
            integer(C_INT), value, intent(IN) :: nargs
            procedure(callback4_actor) :: actor
            integer(C_INT) :: SHT_rv
        end function c_callback4

        ! ----------------------------------------
        ! Function:  void callback_ptr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int *(*get_ptr)(void)
        ! Statement: f_in_procedure
        subroutine callback_ptr(get_ptr) &
                bind(C, name="callback_ptr")
            import :: callback_ptr_get_ptr
            implicit none
            procedure(callback_ptr_get_ptr) :: get_ptr
        end subroutine callback_ptr

        ! ----------------------------------------
        ! Function:  void callback_double
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double (*get)(int i, int)
        ! Statement: f_in_procedure
        subroutine c_callback_double(get) &
                bind(C, name="callback_double")
            import :: callback_double_get
            implicit none
            procedure(callback_double_get) :: get
        end subroutine c_callback_double

        ! ----------------------------------------
        ! Function:  int abstract1
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int input
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int (*get_abs)(double, int)
        ! Statement: f_in_procedure
        function c_abstract1(input, get_abs) &
                result(SHT_rv) &
                bind(C, name="abstract1")
            use iso_c_binding, only : C_INT
            import :: custom_funptr
            implicit none
            integer(C_INT), value, intent(IN) :: input
            procedure(custom_funptr) :: get_abs
            integer(C_INT) :: SHT_rv
        end function c_abstract1

        ! ----------------------------------------
        ! Function:  void callback_void_ptr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*void_ptr_arg)(void *)
        ! Statement: f_in_procedure
        subroutine callback_void_ptr(void_ptr_arg) &
                bind(C, name="callback_void_ptr")
            import :: callback_void_ptr_void_ptr_arg
            implicit none
            procedure(callback_void_ptr_void_ptr_arg) :: void_ptr_arg
        end subroutine callback_void_ptr

        ! ----------------------------------------
        ! Function:  void callback_all_types
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*all_types)(int, int * +rank(1), char, char *, bool, bool *)
        ! Statement: f_in_procedure
        subroutine callback_all_types(all_types) &
                bind(C, name="callback_all_types")
            import :: callback_all_types_all_types
            implicit none
            procedure(callback_all_types_all_types) :: all_types
        end subroutine callback_all_types
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*incr1)(void)
    ! Statement: f_in_procedure
    !>
    !! \brief Create abstract interface for function
    !!
    !<
    subroutine callback1(incr1)
        procedure(callback1_incr1) :: incr1
        ! splicer begin function.callback1
        call c_callback1(incr1)
        ! splicer end function.callback1
    end subroutine callback1
#endif

    ! ----------------------------------------
    ! Function:  void callback1_wrap
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*incr1_wrap)(void)
    ! Statement: f_in_procedure
    !>
    !! \brief Create abstract interface for function
    !!
    !! Create a Fortran wrapper to call the bind(C) interface.
    !<
    subroutine callback1_wrap(incr1_wrap)
        procedure(callback1_wrap_incr1_wrap) :: incr1_wrap
        ! splicer begin function.callback1_wrap
        call c_callback1_wrap(incr1_wrap)
        ! splicer end function.callback1_wrap
    end subroutine callback1_wrap

    ! ----------------------------------------
    ! Function:  void callback1_external
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*incr1_external)(void) +external
    ! Statement: f_in_procedure_external
    !>
    !! \brief Declare callback as external
    !!
    !<
    subroutine callback1_external(incr1_external)
        external :: incr1_external
        ! splicer begin function.callback1_external
        call c_callback1_external(incr1_external)
        ! splicer end function.callback1_external
    end subroutine callback1_external

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback1_funptr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*incr1_funptr)(void) +funptr
    ! Statement: f_in_procedure_funptr
    !>
    !! \brief Declare callback as c_funptr
    !!
    !! The caller is responsible for using c_funloc to pass the function address.
    !<
    ! start callback1_funptr
    subroutine callback1_funptr(incr1_funptr)
        use iso_c_binding, only : C_FUNPTR
        type(C_FUNPTR) :: incr1_funptr
        ! splicer begin function.callback1_funptr
        call c_callback1_funptr(incr1_funptr)
        ! splicer end function.callback1_funptr
    end subroutine callback1_funptr
    ! end callback1_funptr
#endif

    ! ----------------------------------------
    ! Function:  void callback2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  int ival
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  incrtype incr
    ! Statement: f_in_procedure
    !>
    !! \brief Create abstract interface for function
    !!
    !<
    subroutine callback2(name, ival, incr)
        use iso_c_binding, only : C_INT, C_NULL_CHAR
        character(len=*), intent(IN) :: name
        integer(C_INT), value, intent(IN) :: ival
        procedure(incrtype) :: incr
        ! splicer begin function.callback2
        call c_callback2(trim(name)//C_NULL_CHAR, ival, incr)
        ! splicer end function.callback2
    end subroutine callback2

    ! ----------------------------------------
    ! Function:  void callback2_external
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  int ival
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  incrtype incr +external
    ! Statement: f_in_procedure_external
    !>
    !! \brief Declare callback as external
    !!
    !<
    subroutine callback2_external(name, ival, incr)
        use iso_c_binding, only : C_INT, C_NULL_CHAR
        character(len=*), intent(IN) :: name
        integer(C_INT), value, intent(IN) :: ival
        external :: incr
        ! splicer begin function.callback2_external
        call c_callback2_external(trim(name)//C_NULL_CHAR, ival, incr)
        ! splicer end function.callback2_external
    end subroutine callback2_external

    ! ----------------------------------------
    ! Function:  void callback2_funptr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  int ival
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  incrtype incr +funptr
    ! Statement: f_in_procedure_funptr
    !>
    !! \brief Declare callback as c_funptr
    !!
    !! The caller is responsible for using c_funloc to pass the function address.
    !! Allows any function to be passed as an argument.
    !<
    subroutine callback2_funptr(name, ival, incr)
        use iso_c_binding, only : C_FUNPTR, C_INT, C_NULL_CHAR
        character(len=*), intent(IN) :: name
        integer(C_INT), value, intent(IN) :: ival
        type(C_FUNPTR) :: incr
        ! splicer begin function.callback2_funptr
        call c_callback2_funptr(trim(name)//C_NULL_CHAR, ival, incr)
        ! splicer end function.callback2_funptr
    end subroutine callback2_funptr

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback3
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  void *in +assumedtype+intent(in)
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  void (*incr3)(void) +funptr
    ! Statement: f_in_procedure_funptr
    !>
    !! \brief Test function pointer with assumedtype
    !!
    !<
    subroutine callback3(type, in, incr3)
        use iso_c_binding, only : C_FUNPTR, C_INT, C_PTR
        integer(C_INT), value, intent(IN) :: type
        type(*), intent(IN) :: in
        type(C_FUNPTR) :: incr3
        ! splicer begin function.callback3
        call c_callback3(type, in, incr3)
        ! splicer end function.callback3
    end subroutine callback3
#endif

    ! ----------------------------------------
    ! Function:  int callback4
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int *ilow +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int nargs +implied(size(ilow))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  int (*actor)(int *ilow +intent(in)+rank(1), int nargs +intent(in))
    ! Statement: f_in_procedure
    !>
    !! \brief Test attributes on callback arguments
    !!
    !<
    function callback4(ilow, actor) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: ilow(:)
        integer(C_INT) :: SH_nargs
        procedure(callback4_actor) :: actor
        integer(C_INT) :: SHT_rv
        ! splicer begin function.callback4
        SH_nargs = size(ilow,kind=C_INT)
        SHT_rv = c_callback4(ilow, SH_nargs, actor)
        ! splicer end function.callback4
    end function callback4

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback_ptr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *(*get_ptr)(void)
    ! Statement: f_in_procedure
    !>
    !! \brief Return a C_PTR
    !!
    !! No other arguments to test that a function result
    !! uses iso_c_binding C_PTR.
    !<
    subroutine callback_ptr(get_ptr)
        procedure(callback_ptr_get_ptr) :: get_ptr
        ! splicer begin function.callback_ptr
        call c_callback_ptr(get_ptr)
        ! splicer end function.callback_ptr
    end subroutine callback_ptr
#endif

    ! ----------------------------------------
    ! Function:  void callback_double
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double (*get)(int i, int)
    ! Statement: f_in_procedure
    !>
    !! \brief Return a scalar in the callback.
    !!
    !! Make the function result a different type than the
    !! aruguments to ensure the USE is created fully.
    !<
    subroutine callback_double(get)
        procedure(callback_double_get) :: get
        ! splicer begin function.callback_double
        call c_callback_double(get)
        ! splicer end function.callback_double
    end subroutine callback_double

    ! ----------------------------------------
    ! Function:  int abstract1
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int input
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int (*get_abs)(double, int)
    ! Statement: f_in_procedure
    !>
    !! \brief abstract argument
    !!
    !<
    function abstract1(input, get_abs) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: input
        procedure(custom_funptr) :: get_abs
        integer(C_INT) :: SHT_rv
        ! splicer begin function.abstract1
        SHT_rv = c_abstract1(input, get_abs)
        ! splicer end function.abstract1
    end function abstract1

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback_void_ptr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*void_ptr_arg)(void *)
    ! Statement: f_in_procedure
    !>
    !! \brief Test void * argument
    !!
    !<
    subroutine callback_void_ptr(void_ptr_arg)
        procedure(callback_void_ptr_void_ptr_arg) :: void_ptr_arg
        ! splicer begin function.callback_void_ptr
        call c_callback_void_ptr(void_ptr_arg)
        ! splicer end function.callback_void_ptr
    end subroutine callback_void_ptr
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback_all_types
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*all_types)(int, int * +rank(1), char, char *, bool, bool *)
    ! Statement: f_in_procedure
    !>
    !! \brief Test callback argument types
    !!
    !<
    subroutine callback_all_types(all_types)
        procedure(callback_all_types_all_types) :: all_types
        ! splicer begin function.callback_all_types
        call c_callback_all_types(all_types)
        ! splicer end function.callback_all_types
    end subroutine callback_all_types
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module funptr_mod
