! wrapfUserLibrary_example_nested.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfUserLibrary_example_nested.f
!! \brief Shroud generated wrapper for nested namespace
!<
! splicer begin namespace.example::nested.file_top
! splicer end namespace.example::nested.file_top
module userlibrary_example_nested_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin namespace.example::nested.module_use
    ! splicer end namespace.example::nested.module_use
    implicit none

    ! splicer begin namespace.example::nested.module_top
    top of module namespace example splicer  3
    ! splicer end namespace.example::nested.module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! helper array_context
    type, bind(C) :: AA_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type AA_SHROUD_array

    ! helper capsule_data_helper
    type, bind(C) :: AA_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type AA_SHROUD_capsule_data

    type ex_class1
        type(AA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin namespace.example::nested.class.ExClass1.component_part
          component part 1a
          component part 1b
        ! splicer end namespace.example::nested.class.ExClass1.component_part
    contains
        procedure :: delete => ex_class1_dtor
        procedure :: increment_count => ex_class1_increment_count
        procedure :: get_name_error_check => ex_class1_get_name_error_check
        procedure :: get_name_arg => ex_class1_get_name_arg
        procedure :: get_value_from_int => ex_class1_get_value_from_int
        procedure :: get_value_1 => ex_class1_get_value_1
        procedure :: has_addr => ex_class1_has_addr
        procedure :: splicer_special => ex_class1_splicer_special
        procedure :: yadda => ex_class1_yadda
        procedure :: associated => ex_class1_associated
        generic :: get_value => get_value_from_int, get_value_1
        ! splicer begin namespace.example::nested.class.ExClass1.type_bound_procedure_part
          type bound procedure part 1
        ! splicer end namespace.example::nested.class.ExClass1.type_bound_procedure_part
    end type ex_class1

    type ex_class2
        type(AA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin namespace.example::nested.class.ExClass2.component_part
        ! splicer end namespace.example::nested.class.ExClass2.component_part
    contains
        procedure :: delete => ex_class2_dtor
        procedure :: get_name => ex_class2_get_name
        procedure :: get_name2 => ex_class2_get_name2
        procedure :: get_name3 => ex_class2_get_name3
        procedure :: get_name4 => ex_class2_get_name4
        procedure :: get_name_length => ex_class2_get_name_length
        procedure :: get_class1 => ex_class2_get_class1
        procedure :: destroyall => ex_class2_destroyall
        procedure :: set_value_int => ex_class2_set_value_int
        procedure :: set_value_long => ex_class2_set_value_long
        procedure :: set_value_float => ex_class2_set_value_float
        procedure :: set_value_double => ex_class2_set_value_double
        procedure :: get_value_int => ex_class2_get_value_int
        procedure :: get_value_double => ex_class2_get_value_double
        procedure :: yadda => ex_class2_yadda
        procedure :: associated => ex_class2_associated
        generic :: set_value => set_value_int, set_value_long,  &
            set_value_float, set_value_double
        ! splicer begin namespace.example::nested.class.ExClass2.type_bound_procedure_part
        ! splicer end namespace.example::nested.class.ExClass2.type_bound_procedure_part
    end type ex_class2

    interface operator (.eq.)
        module procedure ex_class1_eq
        module procedure ex_class2_eq
    end interface

    interface operator (.ne.)
        module procedure ex_class1_ne
        module procedure ex_class2_ne
    end interface

    abstract interface

        ! ----------------------------------------
        ! Function:  double get
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  double
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        function custom_funptr(XX0arg, XX1arg) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value :: XX0arg
            integer(C_INT), value :: XX1arg
            real(C_DOUBLE) :: SHT_rv
        end function custom_funptr

        ! ----------------------------------------
        ! Function:  void get
        ! Statement: f_subroutine
        subroutine func_ptr1_get() bind(C)
            implicit none
        end subroutine func_ptr1_get

        ! ----------------------------------------
        ! Function:  double *get
        ! Statement: f_function_native*_pointer
        function func_ptr2_get() &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function func_ptr2_get

        ! ----------------------------------------
        ! Function:  double get
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int i
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int
        ! Statement: f_none_native
        function func_ptr3_get(i, arg1) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            integer(C_INT), value :: i
            integer(C_INT), value :: arg1
            real(C_DOUBLE) :: SHT_rv
        end function func_ptr3_get

        ! ----------------------------------------
        ! Function:  void get
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int verylongname1
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname2
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname3
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname4
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname5
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname6
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname7
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname8
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname9
        ! Statement: f_none_native
        ! ----------------------------------------
        ! Argument:  int verylongname10
        ! Statement: f_none_native
        subroutine func_ptr5_get(verylongname1, verylongname2, &
            verylongname3, verylongname4, verylongname5, verylongname6, &
            verylongname7, verylongname8, verylongname9, &
            verylongname10) bind(C)
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value :: verylongname1
            integer(C_INT), value :: verylongname2
            integer(C_INT), value :: verylongname3
            integer(C_INT), value :: verylongname4
            integer(C_INT), value :: verylongname5
            integer(C_INT), value :: verylongname6
            integer(C_INT), value :: verylongname7
            integer(C_INT), value :: verylongname8
            integer(C_INT), value :: verylongname9
            integer(C_INT), value :: verylongname10
        end subroutine func_ptr5_get

    end interface

    interface

        ! ----------------------------------------
        ! Function:  ExClass1
        ! Statement: c_ctor_shadow_capptr
        function c_ex_class1_ctor_0(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="AA_example_nested_ExClass1_ctor_0")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_ex_class1_ctor_0

        ! ----------------------------------------
        ! Function:  ExClass1
        ! Statement: f_ctor_shadow_capsule
        subroutine c_ex_class1_ctor_0_bufferify(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_ctor_0_bufferify")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_ex_class1_ctor_0_bufferify

        ! ----------------------------------------
        ! Function:  ExClass1
        ! Statement: c_ctor_shadow_capptr
        ! ----------------------------------------
        ! Argument:  const string *name
        ! Statement: c_in_string*
        function c_ex_class1_ctor_1(name, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="AA_example_nested_ExClass1_ctor_1")
            use iso_c_binding, only : C_CHAR, C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_ex_class1_ctor_1

        ! ----------------------------------------
        ! Function:  ExClass1
        ! Statement: f_ctor_shadow_capsule
        ! ----------------------------------------
        ! Argument:  const string *name
        ! Statement: f_in_string*_buf
        subroutine c_ex_class1_ctor_1_bufferify(name, SHT_name_len, &
                SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_ctor_1_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_ex_class1_ctor_1_bufferify

        ! ----------------------------------------
        ! Function:  ~ExClass1
        ! Statement: f_dtor
        subroutine c_ex_class1_dtor(self) &
                bind(C, name="AA_example_nested_ExClass1_dtor")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_ex_class1_dtor

        ! ----------------------------------------
        ! Function:  int incrementCount
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int incr
        ! Statement: f_in_native
        function c_ex_class1_increment_count(self, incr) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_incrementCount")
            use iso_c_binding, only : C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: incr
            integer(C_INT) :: SHT_rv
        end function c_ex_class1_increment_count

        ! ----------------------------------------
        ! Function:  const string &getNameErrorCheck
        ! Statement: c_function_string&
        pure function c_ex_class1_get_name_error_check(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_getNameErrorCheck")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class1_get_name_error_check

        ! ----------------------------------------
        ! Function:  const string &getNameErrorCheck
        ! Statement: f_function_string&_cdesc_allocatable
        subroutine c_ex_class1_get_name_error_check_bufferify(self, &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="AA_example_nested_ExClass1_getNameErrorCheck_bufferify")
            import :: AA_SHROUD_array, AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_ex_class1_get_name_error_check_bufferify

        ! ----------------------------------------
        ! Function:  const string &getNameArg
        ! Statement: c_function_string&
        pure function c_ex_class1_get_name_arg(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_getNameArg")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class1_get_name_arg

        ! ----------------------------------------
        ! Function:  const string &getNameArg
        ! Statement: f_function_string&_buf_arg
        subroutine c_ex_class1_get_name_arg_bufferify(self, name, nname) &
                bind(C, name="AA_example_nested_ExClass1_getNameArg_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            character(kind=C_CHAR), intent(OUT) :: name(*)
            integer(C_INT), value, intent(IN) :: nname
        end subroutine c_ex_class1_get_name_arg_bufferify

        ! ----------------------------------------
        ! Function:  int getValue
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int value
        ! Statement: f_in_native
        function c_ex_class1_get_value_from_int(self, value) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_getValue_from_int")
            use iso_c_binding, only : C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: value
            integer(C_INT) :: SHT_rv
        end function c_ex_class1_get_value_from_int

        ! ----------------------------------------
        ! Function:  long getValue
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  long value
        ! Statement: f_in_native
        function c_ex_class1_get_value_1(self, value) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_getValue_1")
            use iso_c_binding, only : C_LONG
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_LONG), value, intent(IN) :: value
            integer(C_LONG) :: SHT_rv
        end function c_ex_class1_get_value_1

        ! ----------------------------------------
        ! Function:  bool hasAddr
        ! Statement: f_function_bool
        ! ----------------------------------------
        ! Argument:  bool in
        ! Statement: f_in_bool
        function c_ex_class1_has_addr(self, in) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass1_hasAddr")
            use iso_c_binding, only : C_BOOL
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            logical(C_BOOL), value, intent(IN) :: in
            logical(C_BOOL) :: SHT_rv
        end function c_ex_class1_has_addr

        ! ----------------------------------------
        ! Function:  void SplicerSpecial
        ! Statement: f_subroutine
        subroutine c_ex_class1_splicer_special(self) &
                bind(C, name="AA_example_nested_ExClass1_SplicerSpecial")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
        end subroutine c_ex_class1_splicer_special

        ! ----------------------------------------
        ! Function:  ExClass2
        ! Statement: c_ctor_shadow_capptr
        ! ----------------------------------------
        ! Argument:  const string *name +len_trim(trim_name)
        ! Statement: c_in_string*
        function c_ex_class2_ctor(name, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="AA_example_nested_ExClass2_ctor")
            use iso_c_binding, only : C_CHAR, C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_ex_class2_ctor

        ! ----------------------------------------
        ! Function:  ExClass2
        ! Statement: f_ctor_shadow_capsule
        ! ----------------------------------------
        ! Argument:  const string *name +len_trim(trim_name)
        ! Statement: f_in_string*_buf
        subroutine c_ex_class2_ctor_bufferify(name, SHT_name_len, &
                SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_ctor_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_ex_class2_ctor_bufferify

        ! ----------------------------------------
        ! Function:  ~ExClass2
        ! Statement: f_dtor
        subroutine c_ex_class2_dtor(self) &
                bind(C, name="AA_example_nested_ExClass2_dtor")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_ex_class2_dtor

        ! ----------------------------------------
        ! Function:  const string &getName +len(aa_exclass2_get_name_length({F_this}%{F_derived_member}))
        ! Statement: c_function_string&
        pure function c_ex_class2_get_name(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getName")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class2_get_name

        ! ----------------------------------------
        ! Function:  const string &getName +len(aa_exclass2_get_name_length({F_this}%{F_derived_member}))
        ! Statement: f_function_string&_buf_copy
        subroutine c_ex_class2_get_name_bufferify(self, SHT_rv, &
                SHT_rv_len) &
                bind(C, name="AA_example_nested_ExClass2_getName_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_ex_class2_get_name_bufferify

        ! ----------------------------------------
        ! Function:  const string &getName2
        ! Statement: c_function_string&
        function c_ex_class2_get_name2(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getName2")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class2_get_name2

        ! ----------------------------------------
        ! Function:  const string &getName2
        ! Statement: f_function_string&_cdesc_allocatable
        subroutine c_ex_class2_get_name2_bufferify(self, SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="AA_example_nested_ExClass2_getName2_bufferify")
            import :: AA_SHROUD_array, AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_ex_class2_get_name2_bufferify

        ! ----------------------------------------
        ! Function:  string &getName3
        ! Statement: c_function_string&
        pure function c_ex_class2_get_name3(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getName3")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class2_get_name3

        ! ----------------------------------------
        ! Function:  string &getName3
        ! Statement: f_function_string&_cdesc_allocatable
        subroutine c_ex_class2_get_name3_bufferify(self, SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="AA_example_nested_ExClass2_getName3_bufferify")
            import :: AA_SHROUD_array, AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_ex_class2_get_name3_bufferify

        ! ----------------------------------------
        ! Function:  string &getName4
        ! Statement: c_function_string&
        function c_ex_class2_get_name4(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getName4")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ex_class2_get_name4

        ! ----------------------------------------
        ! Function:  string &getName4
        ! Statement: f_function_string&_cdesc_allocatable
        subroutine c_ex_class2_get_name4_bufferify(self, SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="AA_example_nested_ExClass2_getName4_bufferify")
            import :: AA_SHROUD_array, AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_ex_class2_get_name4_bufferify

        ! ----------------------------------------
        ! Function:  int GetNameLength
        ! Statement: f_function_native
        pure function c_ex_class2_get_name_length(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_GetNameLength")
            use iso_c_binding, only : C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_ex_class2_get_name_length

        ! ----------------------------------------
        ! Function:  ExClass1 *get_class1
        ! Statement: c_function_shadow*_capptr
        ! ----------------------------------------
        ! Argument:  const ExClass1 *in
        ! Statement: c_in_shadow*
        function c_ex_class2_get_class1(self, in, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="AA_example_nested_ExClass2_get_class1")
            use iso_c_binding, only : C_PTR
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_capsule_data), intent(IN) :: in
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_ex_class2_get_class1

        ! ----------------------------------------
        ! Function:  ExClass1 *get_class1
        ! Statement: f_function_shadow*_capsule
        ! ----------------------------------------
        ! Argument:  const ExClass1 *in
        ! Statement: f_in_shadow*
        subroutine c_ex_class2_get_class1_bufferify(self, in, SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_get_class1_bufferify")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            type(AA_SHROUD_capsule_data), intent(IN) :: in
            type(AA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_ex_class2_get_class1_bufferify

        ! ----------------------------------------
        ! Function:  void destroyall
        ! Statement: f_subroutine
        subroutine c_ex_class2_destroyall(self) &
                bind(C, name="AA_example_nested_ExClass2_destroyall")
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
        end subroutine c_ex_class2_destroyall

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void setValue
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int value
        ! Statement: f_in_native
        subroutine c_ex_class2_set_value_int(self, value) &
                bind(C, name="AA_example_nested_ExClass2_setValue_int")
            use iso_c_binding, only : C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: value
        end subroutine c_ex_class2_set_value_int

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void setValue
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  long value
        ! Statement: f_in_native
        subroutine c_ex_class2_set_value_long(self, value) &
                bind(C, name="AA_example_nested_ExClass2_setValue_long")
            use iso_c_binding, only : C_LONG
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_LONG), value, intent(IN) :: value
        end subroutine c_ex_class2_set_value_long

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void setValue
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  float value
        ! Statement: f_in_native
        subroutine c_ex_class2_set_value_float(self, value) &
                bind(C, name="AA_example_nested_ExClass2_setValue_float")
            use iso_c_binding, only : C_FLOAT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            real(C_FLOAT), value, intent(IN) :: value
        end subroutine c_ex_class2_set_value_float

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void setValue
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double value
        ! Statement: f_in_native
        subroutine c_ex_class2_set_value_double(self, value) &
                bind(C, name="AA_example_nested_ExClass2_setValue_double")
            use iso_c_binding, only : C_DOUBLE
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            real(C_DOUBLE), value, intent(IN) :: value
        end subroutine c_ex_class2_set_value_double

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  int getValue
        ! Statement: f_function_native
        function c_ex_class2_get_value_int(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getValue_int")
            use iso_c_binding, only : C_INT
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_ex_class2_get_value_int

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  double getValue
        ! Statement: f_function_native
        function c_ex_class2_get_value_double(self) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_ExClass2_getValue_double")
            use iso_c_binding, only : C_DOUBLE
            import :: AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(IN) :: self
            real(C_DOUBLE) :: SHT_rv
        end function c_ex_class2_get_value_double

        ! ----------------------------------------
        ! Function:  void local_function1
        ! Statement: f_subroutine
        subroutine local_function1() &
                bind(C, name="AA_example_nested_local_function1")
            implicit none
        end subroutine local_function1

        ! ----------------------------------------
        ! Function:  bool isNameValid
        ! Statement: c_function_bool
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: c_in_string&
        function c_is_name_valid(name) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_isNameValid")
            use iso_c_binding, only : C_BOOL, C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            logical(C_BOOL) :: SHT_rv
        end function c_is_name_valid

        ! ----------------------------------------
        ! Function:  bool isNameValid
        ! Statement: f_function_bool
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: f_in_string&_buf
        function c_is_name_valid_bufferify(name, SHT_name_len) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_isNameValid_bufferify")
            use iso_c_binding, only : C_BOOL, C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            logical(C_BOOL) :: SHT_rv
        end function c_is_name_valid_bufferify

        ! ----------------------------------------
        ! Function:  bool isInitialized
        ! Statement: f_function_bool
        function c_is_initialized() &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_isInitialized")
            use iso_c_binding, only : C_BOOL
            implicit none
            logical(C_BOOL) :: SHT_rv
        end function c_is_initialized

        ! ----------------------------------------
        ! Function:  void test_names
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: c_in_string&
        subroutine c_test_names(name) &
                bind(C, name="AA_example_nested_test_names")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
        end subroutine c_test_names

        ! ----------------------------------------
        ! Function:  void test_names
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: f_in_string&_buf
        subroutine c_test_names_bufferify(name, SHT_name_len) &
                bind(C, name="AA_example_nested_test_names_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
        end subroutine c_test_names_bufferify

        ! ----------------------------------------
        ! Function:  void test_names
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: c_in_string&
        ! ----------------------------------------
        ! Argument:  int flag
        ! Statement: c_in_native
        subroutine c_test_names_flag(name, flag) &
                bind(C, name="AA_example_nested_test_names_flag")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: flag
        end subroutine c_test_names_flag

        ! ----------------------------------------
        ! Function:  void test_names
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const std::string &name
        ! Statement: f_in_string&_buf
        ! ----------------------------------------
        ! Argument:  int flag
        ! Statement: f_in_native
        subroutine c_test_names_flag_bufferify(name, SHT_name_len, flag) &
                bind(C, name="AA_example_nested_test_names_flag_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            integer(C_INT), value, intent(IN) :: flag
        end subroutine c_test_names_flag_bufferify

        ! Generated by has_default_arg
        ! ----------------------------------------
        ! Function:  void testoptional
        ! Statement: f_subroutine
        subroutine c_testoptional_0() &
                bind(C, name="AA_example_nested_testoptional_0")
            implicit none
        end subroutine c_testoptional_0

        ! Generated by has_default_arg
        ! ----------------------------------------
        ! Function:  void testoptional
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int i=1
        ! Statement: f_in_native
        subroutine c_testoptional_1(i) &
                bind(C, name="AA_example_nested_testoptional_1")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: i
        end subroutine c_testoptional_1

        ! ----------------------------------------
        ! Function:  void testoptional
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int i=1
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  long j=2
        ! Statement: f_in_native
        subroutine c_testoptional_2(i, j) &
                bind(C, name="AA_example_nested_testoptional_2")
            use iso_c_binding, only : C_INT, C_LONG
            implicit none
            integer(C_INT), value, intent(IN) :: i
            integer(C_LONG), value, intent(IN) :: j
        end subroutine c_testoptional_2

        ! ----------------------------------------
        ! Function:  size_t test_size_t
        ! Statement: f_function_native
        function test_size_t() &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_test_size_t")
            use iso_c_binding, only : C_SIZE_T
            implicit none
            integer(C_SIZE_T) :: SHT_rv
        end function test_size_t

#ifdef HAVE_MPI
        ! ----------------------------------------
        ! Function:  void testmpi
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  MPI_Comm comm
        ! Statement: f_in_unknown
        subroutine c_testmpi_mpi(comm) &
                bind(C, name="AA_example_nested_testmpi_mpi")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: comm
        end subroutine c_testmpi_mpi
#endif

#ifndef HAVE_MPI
        ! ----------------------------------------
        ! Function:  void testmpi
        ! Statement: f_subroutine
        subroutine c_testmpi_serial() &
                bind(C, name="AA_example_nested_testmpi_serial")
            implicit none
        end subroutine c_testmpi_serial
#endif

        ! ----------------------------------------
        ! Function:  void FuncPtr1
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*get)(void)
        ! Statement: f_in_procedure
        subroutine func_ptr1(get) &
                bind(C, name="AA_example_nested_FuncPtr1")
            import :: func_ptr1_get
            implicit none
            procedure(func_ptr1_get) :: get
        end subroutine func_ptr1

        ! ----------------------------------------
        ! Function:  void FuncPtr2
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double *(*get)(void)
        ! Statement: f_in_procedure
        subroutine func_ptr2(get) &
                bind(C, name="AA_example_nested_FuncPtr2")
            import :: func_ptr2_get
            implicit none
            procedure(func_ptr2_get) :: get
        end subroutine func_ptr2

        ! ----------------------------------------
        ! Function:  void FuncPtr3
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double (*get)(int i, int)
        ! Statement: f_in_procedure
        subroutine c_func_ptr3(get) &
                bind(C, name="AA_example_nested_FuncPtr3")
            import :: func_ptr3_get
            implicit none
            procedure(func_ptr3_get) :: get
        end subroutine c_func_ptr3

        ! ----------------------------------------
        ! Function:  void FuncPtr4
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double (*get)(double, int)
        ! Statement: f_in_procedure
        subroutine c_func_ptr4(get) &
                bind(C, name="AA_example_nested_FuncPtr4")
            import :: custom_funptr
            implicit none
            procedure(custom_funptr) :: get
        end subroutine c_func_ptr4

        ! ----------------------------------------
        ! Function:  void FuncPtr5
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void (*get)(int verylongname1, int verylongname2, int verylongname3, int verylongname4, int verylongname5, int verylongname6, int verylongname7, int verylongname8, int verylongname9, int verylongname10)
        ! Statement: f_in_procedure
        subroutine func_ptr5(get) &
                bind(C, name="AA_example_nested_FuncPtr5")
            import :: func_ptr5_get
            implicit none
            procedure(func_ptr5_get) :: get
        end subroutine func_ptr5

        ! ----------------------------------------
        ! Function:  void verylongfunctionname1
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int *verylongname1 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname2 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname3 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname4 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname5 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname6 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname7 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname8 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname9 +intent(inout)
        ! Statement: f_inout_native*
        ! ----------------------------------------
        ! Argument:  int *verylongname10 +intent(inout)
        ! Statement: f_inout_native*
        subroutine c_verylongfunctionname1(verylongname1, verylongname2, &
                verylongname3, verylongname4, verylongname5, &
                verylongname6, verylongname7, verylongname8, &
                verylongname9, verylongname10) &
                bind(C, name="AA_example_nested_verylongfunctionname1")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: verylongname1
            integer(C_INT), intent(INOUT) :: verylongname2
            integer(C_INT), intent(INOUT) :: verylongname3
            integer(C_INT), intent(INOUT) :: verylongname4
            integer(C_INT), intent(INOUT) :: verylongname5
            integer(C_INT), intent(INOUT) :: verylongname6
            integer(C_INT), intent(INOUT) :: verylongname7
            integer(C_INT), intent(INOUT) :: verylongname8
            integer(C_INT), intent(INOUT) :: verylongname9
            integer(C_INT), intent(INOUT) :: verylongname10
        end subroutine c_verylongfunctionname1

        ! ----------------------------------------
        ! Function:  int verylongfunctionname2
        ! Statement: f_function_native
        ! ----------------------------------------
        ! Argument:  int verylongname1
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname2
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname3
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname4
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname5
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname6
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname7
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname8
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname9
        ! Statement: f_in_native
        ! ----------------------------------------
        ! Argument:  int verylongname10
        ! Statement: f_in_native
        function c_verylongfunctionname2(verylongname1, verylongname2, &
                verylongname3, verylongname4, verylongname5, &
                verylongname6, verylongname7, verylongname8, &
                verylongname9, verylongname10) &
                result(SHT_rv) &
                bind(C, name="AA_example_nested_verylongfunctionname2")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: verylongname1
            integer(C_INT), value, intent(IN) :: verylongname2
            integer(C_INT), value, intent(IN) :: verylongname3
            integer(C_INT), value, intent(IN) :: verylongname4
            integer(C_INT), value, intent(IN) :: verylongname5
            integer(C_INT), value, intent(IN) :: verylongname6
            integer(C_INT), value, intent(IN) :: verylongname7
            integer(C_INT), value, intent(IN) :: verylongname8
            integer(C_INT), value, intent(IN) :: verylongname9
            integer(C_INT), value, intent(IN) :: verylongname10
            integer(C_INT) :: SHT_rv
        end function c_verylongfunctionname2

        ! ----------------------------------------
        ! Function:  void cos_doubles
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double *in +intent(in)+rank(2)
        ! Statement: f_in_native*
        ! ----------------------------------------
        ! Argument:  double *out +dimension(shape(in))+intent(out)
        ! Statement: f_out_native*
        ! ----------------------------------------
        ! Argument:  int sizein +implied(size(in))
        ! Statement: f_in_native
        subroutine c_cos_doubles(in, out, sizein) &
                bind(C, name="AA_example_nested_cos_doubles")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(*)
            real(C_DOUBLE), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_cos_doubles
    end interface

    interface ex_class1
        module procedure ex_class1_ctor_0
        module procedure ex_class1_ctor_1
    end interface ex_class1

    interface ex_class1_get_value
        module procedure ex_class1_get_value_from_int
        module procedure ex_class1_get_value_1
    end interface ex_class1_get_value

    interface ex_class2
        module procedure ex_class2_ctor
    end interface ex_class2

    interface ex_class2_set_value
        module procedure ex_class2_set_value_int
        module procedure ex_class2_set_value_long
        module procedure ex_class2_set_value_float
        module procedure ex_class2_set_value_double
    end interface ex_class2_set_value

    interface test_names
        module procedure test_names
        module procedure test_names_flag
    end interface test_names

    interface testmpi
#ifdef HAVE_MPI
        module procedure testmpi_mpi
#endif
#ifndef HAVE_MPI
        module procedure testmpi_serial
#endif
    end interface testmpi

    interface testoptional
        module procedure testoptional_0
        module procedure testoptional_1
        module procedure testoptional_2
    end interface testoptional

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine AA_SHROUD_capsule_dtor(ptr) &
            bind(C, name="AA_SHROUD_memory_destructor")
            import AA_SHROUD_capsule_data
            implicit none
            type(AA_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine AA_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine AA_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="AA_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import AA_SHROUD_array
            type(AA_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine AA_SHROUD_copy_string
    end interface

    ! splicer begin namespace.example::nested.additional_declarations
    ! splicer end namespace.example::nested.additional_declarations

contains

    ! ----------------------------------------
    ! Function:  ExClass1
    ! Statement: f_ctor_shadow_capsule
    function ex_class1_ctor_0() &
            result(SHT_rv)
        type(ex_class1) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.ctor_0
        call c_ex_class1_ctor_0_bufferify(SHT_rv%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass1.method.ctor_0
    end function ex_class1_ctor_0

    ! ----------------------------------------
    ! Function:  ExClass1
    ! Statement: f_ctor_shadow_capsule
    ! ----------------------------------------
    ! Argument:  const string *name
    ! Statement: f_in_string*_buf
    !>
    !! \brief constructor
    !!
    !! longer description
    !! usually multiple lines
    !!
    !! \return return new instance
    !<
    function ex_class1_ctor_1(name) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        type(ex_class1) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.ctor_1
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_ex_class1_ctor_1_bufferify(name, SHT_name_len, &
            SHT_rv%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass1.method.ctor_1
    end function ex_class1_ctor_1

    ! ----------------------------------------
    ! Function:  ~ExClass1
    ! Statement: f_dtor
    !>
    !! \brief destructor
    !!
    !! longer description joined with previous line
    !<
    subroutine ex_class1_dtor(obj)
        class(ex_class1), intent(INOUT) :: obj
        ! splicer begin namespace.example::nested.class.ExClass1.method.delete
        call c_ex_class1_dtor(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass1.method.delete
    end subroutine ex_class1_dtor

    ! ----------------------------------------
    ! Function:  int incrementCount
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int incr
    ! Statement: f_in_native
    function ex_class1_increment_count(obj, incr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ex_class1), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: incr
        integer(C_INT) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.increment_count
        SHT_rv = c_ex_class1_increment_count(obj%cxxmem, incr)
        ! splicer end namespace.example::nested.class.ExClass1.method.increment_count
    end function ex_class1_increment_count

    ! ----------------------------------------
    ! Function:  const string &getNameErrorCheck
    ! Statement: f_function_string&_cdesc_allocatable
    function ex_class1_get_name_error_check(obj) &
            result(SHT_rv)
        class(ex_class1), intent(IN) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.get_name_error_check
        type(AA_SHROUD_array) :: SHT_rv_cdesc
        type(AA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_ex_class1_get_name_error_check_bufferify(obj%cxxmem, &
            SHT_rv_cdesc, SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call AA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call AA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end namespace.example::nested.class.ExClass1.method.get_name_error_check
    end function ex_class1_get_name_error_check

    ! ----------------------------------------
    ! Function:  const string &getNameArg
    ! Statement: f_function_string&_buf_arg
    subroutine ex_class1_get_name_arg(obj, name)
        use iso_c_binding, only : C_INT
        class(ex_class1), intent(IN) :: obj
        character(len=*), intent(OUT) :: name
        ! splicer begin namespace.example::nested.class.ExClass1.method.get_name_arg
        integer(C_INT) nname
        nname = len(name, kind=C_INT)
        call c_ex_class1_get_name_arg_bufferify(obj%cxxmem, name, nname)
        ! splicer end namespace.example::nested.class.ExClass1.method.get_name_arg
    end subroutine ex_class1_get_name_arg

    ! ----------------------------------------
    ! Function:  int getValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    function ex_class1_get_value_from_int(obj, value) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ex_class1), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: value
        integer(C_INT) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.get_value_from_int
        SHT_rv = c_ex_class1_get_value_from_int(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass1.method.get_value_from_int
    end function ex_class1_get_value_from_int

    ! ----------------------------------------
    ! Function:  long getValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  long value
    ! Statement: f_in_native
    function ex_class1_get_value_1(obj, value) &
            result(SHT_rv)
        use iso_c_binding, only : C_LONG
        class(ex_class1), intent(INOUT) :: obj
        integer(C_LONG), value, intent(IN) :: value
        integer(C_LONG) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.get_value_1
        SHT_rv = c_ex_class1_get_value_1(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass1.method.get_value_1
    end function ex_class1_get_value_1

    ! ----------------------------------------
    ! Function:  bool hasAddr
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  bool in
    ! Statement: f_in_bool
    function ex_class1_has_addr(obj, in) &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL
        class(ex_class1), intent(INOUT) :: obj
        logical, value, intent(IN) :: in
        logical :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass1.method.has_addr
        logical(C_BOOL) :: SHT_in_cxx
        SHT_in_cxx = in  ! coerce to C_BOOL
        SHT_rv = c_ex_class1_has_addr(obj%cxxmem, SHT_in_cxx)
        ! splicer end namespace.example::nested.class.ExClass1.method.has_addr
    end function ex_class1_has_addr

    ! ----------------------------------------
    ! Function:  void SplicerSpecial
    ! Statement: f_subroutine
    subroutine ex_class1_splicer_special(obj)
        class(ex_class1), intent(INOUT) :: obj
        ! splicer begin namespace.example::nested.class.ExClass1.method.splicer_special
        blah blah blah
        ! splicer end namespace.example::nested.class.ExClass1.method.splicer_special
    end subroutine ex_class1_splicer_special

    ! Return pointer to C++ memory.
    function ex_class1_yadda(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(ex_class1), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function ex_class1_yadda

    function ex_class1_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(ex_class1), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function ex_class1_associated

    ! splicer begin namespace.example::nested.class.ExClass1.additional_functions
      insert extra functions here
    ! splicer end namespace.example::nested.class.ExClass1.additional_functions

    ! ----------------------------------------
    ! Function:  ExClass2
    ! Statement: f_ctor_shadow_capsule
    ! ----------------------------------------
    ! Argument:  const string *name +len_trim(trim_name)
    ! Statement: f_in_string*_buf
    !>
    !! \brief constructor
    !!
    !<
    function ex_class2_ctor(name) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        type(ex_class2) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.ctor
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_ex_class2_ctor_bufferify(name, SHT_name_len, &
            SHT_rv%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.ctor
    end function ex_class2_ctor

    ! ----------------------------------------
    ! Function:  ~ExClass2
    ! Statement: f_dtor
    !>
    !! \brief destructor
    !!
    !<
    subroutine ex_class2_dtor(obj)
        class(ex_class2), intent(INOUT) :: obj
        ! splicer begin namespace.example::nested.class.ExClass2.method.delete
        call c_ex_class2_dtor(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.delete
    end subroutine ex_class2_dtor

    ! ----------------------------------------
    ! Function:  const string &getName +len(aa_exclass2_get_name_length({F_this}%{F_derived_member}))
    ! Statement: f_function_string&_buf_copy
    function ex_class2_get_name(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ex_class2), intent(IN) :: obj
        character(len=aa_exclass2_get_name_length({F_this}%{F_derived_member})) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_name
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_ex_class2_get_name_bufferify(obj%cxxmem, SHT_rv, &
            SHT_rv_len)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_name
    end function ex_class2_get_name

    ! ----------------------------------------
    ! Function:  const string &getName2
    ! Statement: f_function_string&_cdesc_allocatable
    function ex_class2_get_name2(obj) &
            result(SHT_rv)
        class(ex_class2), intent(INOUT) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_name2
        type(AA_SHROUD_array) :: SHT_rv_cdesc
        type(AA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_ex_class2_get_name2_bufferify(obj%cxxmem, SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call AA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call AA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_name2
    end function ex_class2_get_name2

    ! ----------------------------------------
    ! Function:  string &getName3
    ! Statement: f_function_string&_cdesc_allocatable
    function ex_class2_get_name3(obj) &
            result(SHT_rv)
        class(ex_class2), intent(IN) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_name3
        type(AA_SHROUD_array) :: SHT_rv_cdesc
        type(AA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_ex_class2_get_name3_bufferify(obj%cxxmem, SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call AA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call AA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_name3
    end function ex_class2_get_name3

    ! ----------------------------------------
    ! Function:  string &getName4
    ! Statement: f_function_string&_cdesc_allocatable
    function ex_class2_get_name4(obj) &
            result(SHT_rv)
        class(ex_class2), intent(INOUT) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_name4
        type(AA_SHROUD_array) :: SHT_rv_cdesc
        type(AA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_ex_class2_get_name4_bufferify(obj%cxxmem, SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call AA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call AA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_name4
    end function ex_class2_get_name4

    ! ----------------------------------------
    ! Function:  int GetNameLength
    ! Statement: f_function_native
    !>
    !! \brief helper function for Fortran
    !!
    !<
    function ex_class2_get_name_length(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ex_class2), intent(IN) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_name_length
        SHT_rv = c_ex_class2_get_name_length(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_name_length
    end function ex_class2_get_name_length

    ! ----------------------------------------
    ! Function:  ExClass1 *get_class1
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  const ExClass1 *in
    ! Statement: f_in_shadow*
    function ex_class2_get_class1(obj, in) &
            result(SHT_rv)
        class(ex_class2), intent(INOUT) :: obj
        type(ex_class1), intent(IN) :: in
        type(ex_class1) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_class1
        call c_ex_class2_get_class1_bufferify(obj%cxxmem, in%cxxmem, &
            SHT_rv%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_class1
    end function ex_class2_get_class1

    ! ----------------------------------------
    ! Function:  void destroyall
    ! Statement: f_subroutine
    subroutine ex_class2_destroyall(obj)
        class(ex_class2), intent(INOUT) :: obj
        ! splicer begin namespace.example::nested.class.ExClass2.method.destroyall
        call c_ex_class2_destroyall(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.destroyall
    end subroutine ex_class2_destroyall

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void setValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    subroutine ex_class2_set_value_int(obj, value)
        use iso_c_binding, only : C_INT
        class(ex_class2), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: value
        ! splicer begin namespace.example::nested.class.ExClass2.method.set_value_int
        call c_ex_class2_set_value_int(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass2.method.set_value_int
    end subroutine ex_class2_set_value_int

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void setValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  long value
    ! Statement: f_in_native
    subroutine ex_class2_set_value_long(obj, value)
        use iso_c_binding, only : C_LONG
        class(ex_class2), intent(INOUT) :: obj
        integer(C_LONG), value, intent(IN) :: value
        ! splicer begin namespace.example::nested.class.ExClass2.method.set_value_long
        call c_ex_class2_set_value_long(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass2.method.set_value_long
    end subroutine ex_class2_set_value_long

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void setValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float value
    ! Statement: f_in_native
    subroutine ex_class2_set_value_float(obj, value)
        use iso_c_binding, only : C_FLOAT
        class(ex_class2), intent(INOUT) :: obj
        real(C_FLOAT), value, intent(IN) :: value
        ! splicer begin namespace.example::nested.class.ExClass2.method.set_value_float
        call c_ex_class2_set_value_float(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass2.method.set_value_float
    end subroutine ex_class2_set_value_float

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void setValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double value
    ! Statement: f_in_native
    subroutine ex_class2_set_value_double(obj, value)
        use iso_c_binding, only : C_DOUBLE
        class(ex_class2), intent(INOUT) :: obj
        real(C_DOUBLE), value, intent(IN) :: value
        ! splicer begin namespace.example::nested.class.ExClass2.method.set_value_double
        call c_ex_class2_set_value_double(obj%cxxmem, value)
        ! splicer end namespace.example::nested.class.ExClass2.method.set_value_double
    end subroutine ex_class2_set_value_double

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  int getValue
    ! Statement: f_function_native
    function ex_class2_get_value_int(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ex_class2), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_value_int
        SHT_rv = c_ex_class2_get_value_int(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_value_int
    end function ex_class2_get_value_int

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  double getValue
    ! Statement: f_function_native
    function ex_class2_get_value_double(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        class(ex_class2), intent(INOUT) :: obj
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin namespace.example::nested.class.ExClass2.method.get_value_double
        SHT_rv = c_ex_class2_get_value_double(obj%cxxmem)
        ! splicer end namespace.example::nested.class.ExClass2.method.get_value_double
    end function ex_class2_get_value_double

    ! Return pointer to C++ memory.
    function ex_class2_yadda(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(ex_class2), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function ex_class2_yadda

    function ex_class2_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(ex_class2), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function ex_class2_associated

    ! splicer begin namespace.example::nested.class.ExClass2.additional_functions
    ! splicer end namespace.example::nested.class.ExClass2.additional_functions

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void local_function1
    ! Statement: f_subroutine
    subroutine local_function1()
        ! splicer begin namespace.example::nested.function.local_function1
        call c_local_function1()
        ! splicer end namespace.example::nested.function.local_function1
    end subroutine local_function1
#endif

    ! ----------------------------------------
    ! Function:  bool isNameValid
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    function is_name_valid(name) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        logical :: SHT_rv
        ! splicer begin namespace.example::nested.function.is_name_valid
        rv = name .ne. " "
        ! splicer end namespace.example::nested.function.is_name_valid
    end function is_name_valid

    ! ----------------------------------------
    ! Function:  bool isInitialized
    ! Statement: f_function_bool
    function is_initialized() &
            result(SHT_rv)
        logical :: SHT_rv
        ! splicer begin namespace.example::nested.function.is_initialized
        SHT_rv = c_is_initialized()
        ! splicer end namespace.example::nested.function.is_initialized
    end function is_initialized

    ! ----------------------------------------
    ! Function:  void test_names
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    subroutine test_names(name)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        ! splicer begin namespace.example::nested.function.test_names
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_test_names_bufferify(name, SHT_name_len)
        ! splicer end namespace.example::nested.function.test_names
    end subroutine test_names

    ! ----------------------------------------
    ! Function:  void test_names
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    subroutine test_names_flag(name, flag)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        integer(C_INT), value, intent(IN) :: flag
        ! splicer begin namespace.example::nested.function.test_names_flag
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_test_names_flag_bufferify(name, SHT_name_len, flag)
        ! splicer end namespace.example::nested.function.test_names_flag
    end subroutine test_names_flag

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  void testoptional
    ! Statement: f_subroutine
    subroutine testoptional_0()
        ! splicer begin namespace.example::nested.function.testoptional_0
        call c_testoptional_0()
        ! splicer end namespace.example::nested.function.testoptional_0
    end subroutine testoptional_0

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  void testoptional
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int i=1
    ! Statement: f_in_native
    subroutine testoptional_1(i)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: i
        ! splicer begin namespace.example::nested.function.testoptional_1
        call c_testoptional_1(i)
        ! splicer end namespace.example::nested.function.testoptional_1
    end subroutine testoptional_1

    ! ----------------------------------------
    ! Function:  void testoptional
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int i=1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  long j=2
    ! Statement: f_in_native
    subroutine testoptional_2(i, j)
        use iso_c_binding, only : C_INT, C_LONG
        integer(C_INT), value, intent(IN) :: i
        integer(C_LONG), value, intent(IN) :: j
        ! splicer begin namespace.example::nested.function.testoptional_2
        call c_testoptional_2(i, j)
        ! splicer end namespace.example::nested.function.testoptional_2
    end subroutine testoptional_2

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  size_t test_size_t
    ! Statement: f_function_native
    function test_size_t() &
            result(SHT_rv)
        use iso_c_binding, only : C_SIZE_T
        integer(C_SIZE_T) :: SHT_rv
        ! splicer begin namespace.example::nested.function.test_size_t
        SHT_rv = c_test_size_t()
        ! splicer end namespace.example::nested.function.test_size_t
    end function test_size_t
#endif

#ifdef HAVE_MPI
    ! ----------------------------------------
    ! Function:  void testmpi
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  MPI_Comm comm
    ! Statement: f_in_unknown
    subroutine testmpi_mpi(comm)
        use iso_c_binding, only : C_INT
        integer, value, intent(IN) :: comm
        ! splicer begin namespace.example::nested.function.testmpi_mpi
        call c_testmpi_mpi(comm)
        ! splicer end namespace.example::nested.function.testmpi_mpi
    end subroutine testmpi_mpi
#endif

#ifndef HAVE_MPI
    ! ----------------------------------------
    ! Function:  void testmpi
    ! Statement: f_subroutine
    subroutine testmpi_serial()
        ! splicer begin namespace.example::nested.function.testmpi_serial
        call c_testmpi_serial()
        ! splicer end namespace.example::nested.function.testmpi_serial
    end subroutine testmpi_serial
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void FuncPtr1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*get)(void)
    ! Statement: f_in_procedure
    !>
    !! \brief subroutine
    !!
    !<
    subroutine func_ptr1(get)
        procedure(func_ptr1_get) :: get
        ! splicer begin namespace.example::nested.function.func_ptr1
        call c_func_ptr1(get)
        ! splicer end namespace.example::nested.function.func_ptr1
    end subroutine func_ptr1
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void FuncPtr2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *(*get)(void)
    ! Statement: f_in_procedure
    !>
    !! \brief return a pointer
    !!
    !<
    subroutine func_ptr2(get)
        procedure(func_ptr2_get) :: get
        ! splicer begin namespace.example::nested.function.func_ptr2
        call c_func_ptr2(get)
        ! splicer end namespace.example::nested.function.func_ptr2
    end subroutine func_ptr2
#endif

    ! ----------------------------------------
    ! Function:  void FuncPtr3
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double (*get)(int i, int)
    ! Statement: f_in_procedure
    !>
    !! \brief abstract argument
    !!
    !<
    subroutine func_ptr3(get)
        procedure(func_ptr3_get) :: get
        ! splicer begin namespace.example::nested.function.func_ptr3
        call c_func_ptr3(get)
        ! splicer end namespace.example::nested.function.func_ptr3
    end subroutine func_ptr3

    ! ----------------------------------------
    ! Function:  void FuncPtr4
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double (*get)(double, int)
    ! Statement: f_in_procedure
    !>
    !! \brief abstract argument
    !!
    !<
    subroutine func_ptr4(get)
        procedure(custom_funptr) :: get
        ! splicer begin namespace.example::nested.function.func_ptr4
        call c_func_ptr4(get)
        ! splicer end namespace.example::nested.function.func_ptr4
    end subroutine func_ptr4

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void FuncPtr5
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void (*get)(int verylongname1, int verylongname2, int verylongname3, int verylongname4, int verylongname5, int verylongname6, int verylongname7, int verylongname8, int verylongname9, int verylongname10)
    ! Statement: f_in_procedure
    subroutine func_ptr5(get)
        procedure(func_ptr5_get) :: get
        ! splicer begin namespace.example::nested.function.func_ptr5
        call c_func_ptr5(get)
        ! splicer end namespace.example::nested.function.func_ptr5
    end subroutine func_ptr5
#endif

    ! ----------------------------------------
    ! Function:  void verylongfunctionname1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *verylongname1 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname2 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname3 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname4 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname5 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname6 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname7 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname8 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname9 +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *verylongname10 +intent(inout)
    ! Statement: f_inout_native*
    subroutine verylongfunctionname1(verylongname1, verylongname2, &
            verylongname3, verylongname4, verylongname5, verylongname6, &
            verylongname7, verylongname8, verylongname9, verylongname10)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(INOUT) :: verylongname1
        integer(C_INT), intent(INOUT) :: verylongname2
        integer(C_INT), intent(INOUT) :: verylongname3
        integer(C_INT), intent(INOUT) :: verylongname4
        integer(C_INT), intent(INOUT) :: verylongname5
        integer(C_INT), intent(INOUT) :: verylongname6
        integer(C_INT), intent(INOUT) :: verylongname7
        integer(C_INT), intent(INOUT) :: verylongname8
        integer(C_INT), intent(INOUT) :: verylongname9
        integer(C_INT), intent(INOUT) :: verylongname10
        ! splicer begin namespace.example::nested.function.verylongfunctionname1
        call c_verylongfunctionname1(verylongname1, verylongname2, &
            verylongname3, verylongname4, verylongname5, verylongname6, &
            verylongname7, verylongname8, verylongname9, verylongname10)
        ! splicer end namespace.example::nested.function.verylongfunctionname1
    end subroutine verylongfunctionname1

    ! ----------------------------------------
    ! Function:  int verylongfunctionname2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int verylongname1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname2
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname3
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname4
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname5
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname6
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname7
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname8
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname9
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int verylongname10
    ! Statement: f_in_native
    function verylongfunctionname2(verylongname1, verylongname2, &
            verylongname3, verylongname4, verylongname5, verylongname6, &
            verylongname7, verylongname8, verylongname9, verylongname10) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: verylongname1
        integer(C_INT), value, intent(IN) :: verylongname2
        integer(C_INT), value, intent(IN) :: verylongname3
        integer(C_INT), value, intent(IN) :: verylongname4
        integer(C_INT), value, intent(IN) :: verylongname5
        integer(C_INT), value, intent(IN) :: verylongname6
        integer(C_INT), value, intent(IN) :: verylongname7
        integer(C_INT), value, intent(IN) :: verylongname8
        integer(C_INT), value, intent(IN) :: verylongname9
        integer(C_INT), value, intent(IN) :: verylongname10
        integer(C_INT) :: SHT_rv
        ! splicer begin namespace.example::nested.function.verylongfunctionname2
        SHT_rv = c_verylongfunctionname2(verylongname1, verylongname2, &
            verylongname3, verylongname4, verylongname5, verylongname6, &
            verylongname7, verylongname8, verylongname9, verylongname10)
        ! splicer end namespace.example::nested.function.verylongfunctionname2
    end function verylongfunctionname2

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(2)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  double *out +dimension(shape(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_default
    !>
    !! \brief Test multidimensional arrays with allocatable
    !!
    !<
    subroutine cos_doubles(in, out)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: in(:,:)
        real(C_DOUBLE), intent(OUT) :: out(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin namespace.example::nested.function.cos_doubles
        SH_sizein = size(in,kind=C_INT)
        call c_cos_doubles(in, out, SH_sizein)
        ! splicer end namespace.example::nested.function.cos_doubles
    end subroutine cos_doubles

    ! splicer begin namespace.example::nested.additional_functions
    ! splicer end namespace.example::nested.additional_functions

    function ex_class1_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ex_class1), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ex_class1_eq

    function ex_class1_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ex_class1), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ex_class1_ne

    function ex_class2_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ex_class2), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ex_class2_eq

    function ex_class2_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ex_class2), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ex_class2_ne

end module userlibrary_example_nested_mod
