! wrapfclibrary.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfclibrary.f
!! \brief Shroud generated wrapper for Clibrary library
!<
! splicer begin file_top
! splicer end file_top
module clibrary_mod
    use iso_c_binding, only : C_INT
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    integer, parameter :: MAXNAME = 20
    ! splicer end module_top

    ! typedef TypeID
    ! splicer begin typedef.TypeID
    integer, parameter :: type_id = C_INT
    ! splicer end typedef.TypeID

    ! typedef EnumTypeID
    ! splicer begin typedef.EnumTypeID
    integer, parameter :: enum_type_id = C_INT
    ! splicer end typedef.EnumTypeID


    type, bind(C) :: array_info
        integer(C_INT) :: tc
    end type array_info

    ! ----------------------------------------
    ! Function:  void alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int tc +intent(in)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  array_info *arr +intent(inout)
    ! Statement: f_inout_struct*
    abstract interface
        subroutine callback_set_alloc_alloc(tc, arr) bind(C)
            use iso_c_binding, only : C_INT
            import :: array_info
            implicit none
            integer(C_INT), value, intent(IN) :: tc
            type(array_info), intent(INOUT) :: arr
        end subroutine callback_set_alloc_alloc
    end interface

    ! ----------------------------------------
    ! Function:  void NoReturnNoArguments
    ! Statement: f_subroutine
    ! start no_return_no_arguments
    interface
        subroutine no_return_no_arguments() &
                bind(C, name="NoReturnNoArguments")
            implicit none
        end subroutine no_return_no_arguments
    end interface
    ! end no_return_no_arguments

    ! ----------------------------------------
    ! Function:  double PassByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    ! start pass_by_value
    interface
        function pass_by_value(arg1, arg2) &
                result(SHT_rv) &
                bind(C, name="PassByValue")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg1
            integer(C_INT), value, intent(IN) :: arg2
            real(C_DOUBLE) :: SHT_rv
        end function pass_by_value
    end interface
    ! end pass_by_value

    ! ----------------------------------------
    ! Function:  void PassByReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *arg1 +intent(in)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +intent(out)
    ! Statement: f_out_native*
    ! start pass_by_reference
    interface
        subroutine pass_by_reference(arg1, arg2) &
                bind(C, name="PassByReference")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: arg1
            integer(C_INT), intent(OUT) :: arg2
        end subroutine pass_by_reference
    end interface
    ! end pass_by_reference

    ! ----------------------------------------
    ! Function:  double PassByValueMacro
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    interface
        function pass_by_value_macro(arg2) &
                result(SHT_rv) &
                bind(C, name="CLI_PassByValueMacro_bufferify")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg2
            real(C_DOUBLE) :: SHT_rv
        end function pass_by_value_macro
    end interface

    ! ----------------------------------------
    ! Function:  void checkBool
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const bool arg1
    ! Statement: f_in_bool
    ! ----------------------------------------
    ! Argument:  bool *arg2 +intent(out)
    ! Statement: f_out_bool*
    ! ----------------------------------------
    ! Argument:  bool *arg3 +intent(inout)
    ! Statement: f_inout_bool*
    ! start c_check_bool
    interface
        subroutine c_check_bool(arg1, arg2, arg3) &
                bind(C, name="checkBool")
            use iso_c_binding, only : C_BOOL
            implicit none
            logical(C_BOOL), value, intent(IN) :: arg1
            logical(C_BOOL), intent(OUT) :: arg2
            logical(C_BOOL), intent(INOUT) :: arg3
        end subroutine c_check_bool
    end interface
    ! end c_check_bool

    ! ----------------------------------------
    ! Function:  char *Function4a +len(30)
    ! Statement: f_function_char*_buf_copy
    ! ----------------------------------------
    ! Argument:  const char *arg1
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  const char *arg2
    ! Statement: f_in_char*
    interface
        subroutine c_function4a_bufferify(arg1, arg2, SHT_rv, &
                SHT_rv_len) &
                bind(C, name="CLI_Function4a_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            character(kind=C_CHAR), intent(IN) :: arg2(*)
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_function4a_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void acceptName
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! start c_accept_name
    interface
        subroutine c_accept_name(name) &
                bind(C, name="acceptName")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
        end subroutine c_accept_name
    end interface
    ! end c_accept_name

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_buf
    interface
        subroutine c_pass_char_ptr_in_out_bufferify(s, SHT_s_len) &
                bind(C, name="CLI_passCharPtrInOut_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: s(*)
            integer(C_INT), value, intent(IN) :: SHT_s_len
        end subroutine c_pass_char_ptr_in_out_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void passCharPtrCAPI
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  char *in +api(capi)+intent(inout)
    ! Statement: f_inout_char*_capi
    ! ----------------------------------------
    ! Argument:  char *out +api(capi)+intent(out)
    ! Statement: f_out_char*_capi
    interface
        subroutine pass_char_ptr_capi(n, in, out) &
                bind(C, name="passCharPtrCAPI")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: n
            character(kind=C_CHAR), intent(INOUT) :: in(*)
            character(kind=C_CHAR), intent(OUT) :: out(*)
        end subroutine pass_char_ptr_capi
    end interface

    ! ----------------------------------------
    ! Function:  void returnOneName
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name1 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    ! start c_return_one_name_bufferify
    interface
        subroutine c_return_one_name_bufferify(name1, SHT_name1_len) &
                bind(C, name="CLI_returnOneName_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: name1(*)
            integer(C_INT), value, intent(IN) :: SHT_name1_len
        end subroutine c_return_one_name_bufferify
    end interface
    ! end c_return_one_name_bufferify

    ! ----------------------------------------
    ! Function:  void returnTwoNames
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name1 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  char *name2 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    interface
        subroutine c_return_two_names_bufferify(name1, SHT_name1_len, &
                name2, SHT_name2_len) &
                bind(C, name="CLI_returnTwoNames_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: name1(*)
            integer(C_INT), value, intent(IN) :: SHT_name1_len
            character(kind=C_CHAR), intent(OUT) :: name2(*)
            integer(C_INT), value, intent(IN) :: SHT_name2_len
        end subroutine c_return_two_names_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void ImpliedTextLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *text +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len(text))
    ! Statement: f_in_native
    ! start c_implied_text_len_bufferify
    interface
        subroutine c_implied_text_len_bufferify(text, SHT_text_len, &
                ltext) &
                bind(C, name="CLI_ImpliedTextLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: text(*)
            integer(C_INT), value, intent(IN) :: SHT_text_len
            integer(C_INT), value, intent(IN) :: ltext
        end subroutine c_implied_text_len_bufferify
    end interface
    ! end c_implied_text_len_bufferify

    ! ----------------------------------------
    ! Function:  int ImpliedLen
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *text +api(capi)
    ! Statement: f_in_char*_capi
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len(text))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  bool flag +implied(false)
    ! Statement: f_in_bool
    interface
        function c_implied_len(text, ltext, flag) &
                result(SHT_rv) &
                bind(C, name="ImpliedLen")
            use iso_c_binding, only : C_BOOL, C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: text(*)
            integer(C_INT), value, intent(IN) :: ltext
            logical(C_BOOL), value, intent(IN) :: flag
            integer(C_INT) :: SHT_rv
        end function c_implied_len
    end interface

    ! ----------------------------------------
    ! Function:  int ImpliedLenTrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *text +api(capi)
    ! Statement: f_in_char*_capi
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len_trim(text))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  bool flag +implied(true)
    ! Statement: f_in_bool
    interface
        function c_implied_len_trim(text, ltext, flag) &
                result(SHT_rv) &
                bind(C, name="ImpliedLenTrim")
            use iso_c_binding, only : C_BOOL, C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: text(*)
            integer(C_INT), value, intent(IN) :: ltext
            logical(C_BOOL), value, intent(IN) :: flag
            integer(C_INT) :: SHT_rv
        end function c_implied_len_trim
    end interface

    ! ----------------------------------------
    ! Function:  bool ImpliedBoolTrue
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  bool flag +implied(true)
    ! Statement: f_in_bool
    interface
        function c_implied_bool_true(flag) &
                result(SHT_rv) &
                bind(C, name="ImpliedBoolTrue")
            use iso_c_binding, only : C_BOOL
            implicit none
            logical(C_BOOL), value, intent(IN) :: flag
            logical(C_BOOL) :: SHT_rv
        end function c_implied_bool_true
    end interface

    ! ----------------------------------------
    ! Function:  bool ImpliedBoolFalse
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  bool flag +implied(false)
    ! Statement: f_in_bool
    interface
        function c_implied_bool_false(flag) &
                result(SHT_rv) &
                bind(C, name="ImpliedBoolFalse")
            use iso_c_binding, only : C_BOOL
            implicit none
            logical(C_BOOL), value, intent(IN) :: flag
            logical(C_BOOL) :: SHT_rv
        end function c_implied_bool_false
    end interface

    ! ----------------------------------------
    ! Function:  void bindC1
    ! Statement: f_subroutine
    interface
        subroutine Fortran_bindC1a() &
                bind(C, name="bindC1")
            implicit none
        end subroutine Fortran_bindC1a
    end interface

    ! ----------------------------------------
    ! Function:  void bindC2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *outbuf +intent(out)
    ! Statement: f_out_char*_buf
    interface
        subroutine c_bind_c2_bufferify(outbuf, SHT_outbuf_len) &
                bind(C, name="CLI_bindC2_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: outbuf(*)
            integer(C_INT), value, intent(IN) :: SHT_outbuf_len
        end subroutine c_bind_c2_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void passVoidStarStar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void *in +intent(in)
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  void **out +intent(out)
    ! Statement: f_out_void**
    ! start pass_void_star_star
    interface
        subroutine pass_void_star_star(in, out) &
                bind(C, name="passVoidStarStar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), value, intent(IN) :: in
            type(C_PTR), intent(OUT) :: out
        end subroutine pass_void_star_star
    end interface
    ! end pass_void_star_star

    ! ----------------------------------------
    ! Function:  int passAssumedType
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype
    ! Statement: f_in_void*
    ! start pass_assumed_type
    interface
        function pass_assumed_type(arg) &
                result(SHT_rv) &
                bind(C, name="passAssumedType")
            use iso_c_binding, only : C_INT
            implicit none
            type(*), intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function pass_assumed_type
    end interface
    ! end pass_assumed_type

    ! ----------------------------------------
    ! Function:  void passAssumedTypeRank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype+rank(1)
    ! Statement: f_in_void*
    ! start pass_assumed_type_rank
    interface
        subroutine pass_assumed_type_rank(arg) &
                bind(C, name="passAssumedTypeRank")
            implicit none
            type(*), intent(IN) :: arg(*)
        end subroutine pass_assumed_type_rank
    end interface
    ! end pass_assumed_type_rank

    ! ----------------------------------------
    ! Function:  int passAssumedTypeBuf
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  char *outbuf +intent(out)
    ! Statement: f_out_char*_buf
    interface
        function c_pass_assumed_type_buf_bufferify(arg, outbuf, &
                SHT_outbuf_len) &
                result(SHT_rv) &
                bind(C, name="CLI_passAssumedTypeBuf_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            type(*), intent(IN) :: arg
            character(kind=C_CHAR), intent(OUT) :: outbuf(*)
            integer(C_INT), value, intent(IN) :: SHT_outbuf_len
            integer(C_INT) :: SHT_rv
        end function c_pass_assumed_type_buf_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void callback_set_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int tc
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  array_info *arr +intent(inout)
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  void (*alloc)(int tc +intent(in), array_info *arr +intent(inout))
    ! Statement: f_in_procedure
    interface
        subroutine callback_set_alloc(tc, arr, alloc) &
                bind(C, name="callback_set_alloc")
            use iso_c_binding, only : C_INT
            import :: array_info, callback_set_alloc_alloc
            implicit none
            integer(C_INT), value, intent(IN) :: tc
            type(array_info), intent(INOUT) :: arr
            procedure(callback_set_alloc_alloc) :: alloc
        end subroutine callback_set_alloc
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void NoReturnNoArguments
    ! Statement: f_subroutine
    ! start no_return_no_arguments
    subroutine no_return_no_arguments()
        ! splicer begin function.no_return_no_arguments
        call c_no_return_no_arguments()
        ! splicer end function.no_return_no_arguments
    end subroutine no_return_no_arguments
    ! end no_return_no_arguments
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  double PassByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    ! start pass_by_value
    function pass_by_value(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), value, intent(IN) :: arg1
        integer(C_INT), value, intent(IN) :: arg2
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.pass_by_value
        SHT_rv = c_pass_by_value(arg1, arg2)
        ! splicer end function.pass_by_value
    end function pass_by_value
    ! end pass_by_value
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void PassByReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *arg1 +intent(in)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +intent(out)
    ! Statement: f_out_native*
    ! start pass_by_reference
    subroutine pass_by_reference(arg1, arg2)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: arg1
        integer(C_INT), intent(OUT) :: arg2
        ! splicer begin function.pass_by_reference
        call c_pass_by_reference(arg1, arg2)
        ! splicer end function.pass_by_reference
    end subroutine pass_by_reference
    ! end pass_by_reference
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  double PassByValueMacro
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    !>
    !! PassByValueMacro is a #define macro. Force a C wrapper
    !! to allow Fortran to have an actual function to call.
    !<
    function pass_by_value_macro(arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        integer(C_INT), value, intent(IN) :: arg2
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.pass_by_value_macro
        SHT_rv = c_pass_by_value_macro_bufferify(arg2)
        ! splicer end function.pass_by_value_macro
    end function pass_by_value_macro
#endif

    ! ----------------------------------------
    ! Function:  void checkBool
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const bool arg1
    ! Statement: f_in_bool
    ! ----------------------------------------
    ! Argument:  bool *arg2 +intent(out)
    ! Statement: f_out_bool*
    ! ----------------------------------------
    ! Argument:  bool *arg3 +intent(inout)
    ! Statement: f_inout_bool*
    !>
    !! \brief Check intent with bool
    !!
    !<
    ! start check_bool
    subroutine check_bool(arg1, arg2, arg3)
        use iso_c_binding, only : C_BOOL
        logical, value, intent(IN) :: arg1
        logical, intent(OUT) :: arg2
        logical, intent(INOUT) :: arg3
        ! splicer begin function.check_bool
        logical(C_BOOL) :: SHT_arg1_cxx
        logical(C_BOOL) :: SHT_arg2_cxx
        logical(C_BOOL) :: SHT_arg3_cxx
        SHT_arg1_cxx = arg1  ! coerce to C_BOOL
        SHT_arg3_cxx = arg3  ! coerce to C_BOOL
        call c_check_bool(SHT_arg1_cxx, SHT_arg2_cxx, SHT_arg3_cxx)
        arg2 = SHT_arg2_cxx  ! coerce to logical
        arg3 = SHT_arg3_cxx  ! coerce to logical
        ! splicer end function.check_bool
    end subroutine check_bool
    ! end check_bool

    ! ----------------------------------------
    ! Function:  char *Function4a +len(30)
    ! Statement: f_function_char*_buf_copy
    ! ----------------------------------------
    ! Argument:  const char *arg1
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  const char *arg2
    ! Statement: f_in_char*
    function function4a(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_NULL_CHAR
        character(len=*), intent(IN) :: arg1
        character(len=*), intent(IN) :: arg2
        character(len=30) :: SHT_rv
        ! splicer begin function.function4a
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_function4a_bufferify(trim(arg1)//C_NULL_CHAR, &
            trim(arg2)//C_NULL_CHAR, SHT_rv, SHT_rv_len)
        ! splicer end function.function4a
    end function function4a

    ! ----------------------------------------
    ! Function:  void acceptName
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! start accept_name
    subroutine accept_name(name)
        use iso_c_binding, only : C_NULL_CHAR
        character(len=*), intent(IN) :: name
        ! splicer begin function.accept_name
        call c_accept_name(trim(name)//C_NULL_CHAR)
        ! splicer end function.accept_name
    end subroutine accept_name
    ! end accept_name

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_buf
    !>
    !! \brief toupper
    !!
    !! Change a string in-place.
    !! For Python, return a new string since strings are immutable.
    !<
    subroutine pass_char_ptr_in_out(s)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: s
        ! splicer begin function.pass_char_ptr_in_out
        integer(C_INT) SHT_s_len
        SHT_s_len = len(s, kind=C_INT)
        call c_pass_char_ptr_in_out_bufferify(s, SHT_s_len)
        ! splicer end function.pass_char_ptr_in_out
    end subroutine pass_char_ptr_in_out

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passCharPtrCAPI
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  char *in +api(capi)+intent(inout)
    ! Statement: f_inout_char*_capi
    ! ----------------------------------------
    ! Argument:  char *out +api(capi)+intent(out)
    ! Statement: f_out_char*_capi
    !>
    !! \brief api(capi) with intent(out) and intent(inout)
    !!
    !! Only the interface is needed.
    !<
    subroutine pass_char_ptr_capi(n, in, out)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: n
        character(len=*), intent(INOUT) :: in
        character(len=*), intent(OUT) :: out
        ! splicer begin function.pass_char_ptr_capi
        call c_pass_char_ptr_capi(n, in, out)
        ! splicer end function.pass_char_ptr_capi
    end subroutine pass_char_ptr_capi
#endif

    ! ----------------------------------------
    ! Function:  void returnOneName
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name1 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! \brief Test charlen attribute
    !!
    !! Each argument is assumed to be at least MAXNAME long.
    !! This define is provided by the user.
    !! The function will copy into the user provided buffer.
    !<
    ! start return_one_name
    subroutine return_one_name(name1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: name1
        ! splicer begin function.return_one_name
        integer(C_INT) SHT_name1_len
        SHT_name1_len = len(name1, kind=C_INT)
        call c_return_one_name_bufferify(name1, SHT_name1_len)
        ! splicer end function.return_one_name
    end subroutine return_one_name
    ! end return_one_name

    ! ----------------------------------------
    ! Function:  void returnTwoNames
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name1 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  char *name2 +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! \brief Test charlen attribute
    !!
    !! Each argument is assumed to be at least MAXNAME long.
    !! This define is provided by the user.
    !! The function will copy into the user provided buffer.
    !<
    subroutine return_two_names(name1, name2)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: name1
        character(len=*), intent(OUT) :: name2
        ! splicer begin function.return_two_names
        integer(C_INT) SHT_name1_len
        integer(C_INT) SHT_name2_len
        SHT_name1_len = len(name1, kind=C_INT)
        SHT_name2_len = len(name2, kind=C_INT)
        call c_return_two_names_bufferify(name1, SHT_name1_len, name2, &
            SHT_name2_len)
        ! splicer end function.return_two_names
    end subroutine return_two_names

    ! ----------------------------------------
    ! Function:  void ImpliedTextLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *text +charlen(MAXNAME)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len(text))
    ! Statement: c_default
    !>
    !! \brief Fill text, at most ltext characters.
    !!
    !<
    ! start implied_text_len
    subroutine implied_text_len(text)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: text
        integer(C_INT) :: SH_ltext
        ! splicer begin function.implied_text_len
        integer(C_INT) SHT_text_len
        SHT_text_len = len(text, kind=C_INT)
        SH_ltext = len(text,kind=C_INT)
        call c_implied_text_len_bufferify(text, SHT_text_len, SH_ltext)
        ! splicer end function.implied_text_len
    end subroutine implied_text_len
    ! end implied_text_len

    ! ----------------------------------------
    ! Function:  int ImpliedLen
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *text +api(capi)
    ! Statement: f_in_char*_capi
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len(text))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  bool flag +implied(false)
    ! Statement: c_default
    !>
    !! \brief Return the implied argument - text length
    !!
    !! Pass the Fortran length of the char argument directy to the C function.
    !! Use api(capi) to avoid needlessly copying the string.
    !<
    function implied_len(text) &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL, C_INT
        character(len=*), intent(IN) :: text
        integer(C_INT) :: SH_ltext
        logical(C_BOOL) :: SH_flag
        integer(C_INT) :: SHT_rv
        ! splicer begin function.implied_len
        SH_ltext = len(text,kind=C_INT)
        SH_flag = .FALSE._C_BOOL
        SHT_rv = c_implied_len(text, SH_ltext, SH_flag)
        ! splicer end function.implied_len
    end function implied_len

    ! ----------------------------------------
    ! Function:  int ImpliedLenTrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *text +api(capi)
    ! Statement: f_in_char*_capi
    ! ----------------------------------------
    ! Argument:  int ltext +implied(len_trim(text))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  bool flag +implied(true)
    ! Statement: c_default
    !>
    !! \brief Return the implied argument - text length
    !!
    !! Pass the Fortran length of the char argument directy to the C function.
    !! Use api(capi) to avoid needlessly copying the string.
    !<
    function implied_len_trim(text) &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL, C_INT
        character(len=*), intent(IN) :: text
        integer(C_INT) :: SH_ltext
        logical(C_BOOL) :: SH_flag
        integer(C_INT) :: SHT_rv
        ! splicer begin function.implied_len_trim
        SH_ltext = len_trim(text,kind=C_INT)
        SH_flag = .TRUE._C_BOOL
        SHT_rv = c_implied_len_trim(text, SH_ltext, SH_flag)
        ! splicer end function.implied_len_trim
    end function implied_len_trim

    ! ----------------------------------------
    ! Function:  bool ImpliedBoolTrue
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  bool flag +implied(true)
    ! Statement: c_default
    !>
    !! \brief Single, implied bool argument
    !!
    !<
    function implied_bool_true() &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL
        logical(C_BOOL) :: SH_flag
        logical :: SHT_rv
        ! splicer begin function.implied_bool_true
        SH_flag = .TRUE._C_BOOL
        SHT_rv = c_implied_bool_true(SH_flag)
        ! splicer end function.implied_bool_true
    end function implied_bool_true

    ! ----------------------------------------
    ! Function:  bool ImpliedBoolFalse
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  bool flag +implied(false)
    ! Statement: c_default
    !>
    !! \brief Single, implied bool argument
    !!
    !<
    function implied_bool_false() &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL
        logical(C_BOOL) :: SH_flag
        logical :: SHT_rv
        ! splicer begin function.implied_bool_false
        SH_flag = .FALSE._C_BOOL
        SHT_rv = c_implied_bool_false(SH_flag)
        ! splicer end function.implied_bool_false
    end function implied_bool_false

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void bindC1
    ! Statement: f_subroutine
    !>
    !! \brief Rename Fortran name for interface only function
    !!
    !! This creates only an interface.
    !<
    subroutine Fortran_bindC1a()
        ! splicer begin function.bind_c1
        call Fortran_bindC1b()
        ! splicer end function.bind_c1
    end subroutine Fortran_bindC1a
#endif

    ! ----------------------------------------
    ! Function:  void bindC2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *outbuf +intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! \brief Rename Fortran name for interface only function
    !!
    !! This creates a Fortran bufferify function and an interface.
    !<
    subroutine Fortran_bindC2a(outbuf)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: outbuf
        ! splicer begin function.bind_c2
        integer(C_INT) SHT_outbuf_len
        SHT_outbuf_len = len(outbuf, kind=C_INT)
        call c_bind_c2_bufferify(outbuf, SHT_outbuf_len)
        ! splicer end function.bind_c2
    end subroutine Fortran_bindC2a

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passVoidStarStar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void *in +intent(in)
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  void **out +intent(out)
    ! Statement: f_out_void**
    !>
    !! \brief Assign in to out.
    !!
    !! No bufferify function is created, only an interface.
    !<
    ! start pass_void_star_star
    subroutine pass_void_star_star(in, out)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(IN) :: in
        type(C_PTR), intent(OUT) :: out
        ! splicer begin function.pass_void_star_star
        call c_pass_void_star_star(in, out)
        ! splicer end function.pass_void_star_star
    end subroutine pass_void_star_star
    ! end pass_void_star_star
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int passAssumedType
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype
    ! Statement: f_in_void*
    !>
    !! \brief Test assumed-type
    !!
    !! No bufferify function is created, only an interface.
    !! Should only be call with an C_INT argument, and will
    !! return the value passed in.
    !<
    ! start pass_assumed_type
    function pass_assumed_type(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(*), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.pass_assumed_type
        SHT_rv = c_pass_assumed_type(arg)
        ! splicer end function.pass_assumed_type
    end function pass_assumed_type
    ! end pass_assumed_type
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passAssumedTypeRank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype+rank(1)
    ! Statement: f_in_void*
    !>
    !! \brief Test assumed-type with rank(1)
    !!
    !<
    ! start pass_assumed_type_rank
    subroutine pass_assumed_type_rank(arg)
        use iso_c_binding, only : C_PTR
        type(*), intent(IN) :: arg
        ! splicer begin function.pass_assumed_type_rank
        call c_pass_assumed_type_rank(arg)
        ! splicer end function.pass_assumed_type_rank
    end subroutine pass_assumed_type_rank
    ! end pass_assumed_type_rank
#endif

    ! ----------------------------------------
    ! Function:  int passAssumedTypeBuf
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *arg +assumedtype
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  char *outbuf +intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! \brief Test assumed-type
    !!
    !! A bufferify function is created.
    !! Should only be call with an C_INT argument, and will
    !! return the value passed in.
    !<
    function pass_assumed_type_buf(arg, outbuf) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(*), intent(IN) :: arg
        character(len=*), intent(OUT) :: outbuf
        integer(C_INT) :: SHT_rv
        ! splicer begin function.pass_assumed_type_buf
        integer(C_INT) SHT_outbuf_len
        SHT_outbuf_len = len(outbuf, kind=C_INT)
        SHT_rv = c_pass_assumed_type_buf_bufferify(arg, outbuf, &
            SHT_outbuf_len)
        ! splicer end function.pass_assumed_type_buf
    end function pass_assumed_type_buf

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void callback_set_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int tc
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  array_info *arr +intent(inout)
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  void (*alloc)(int tc +intent(in), array_info *arr +intent(inout))
    ! Statement: f_in_procedure
    !>
    !! The function argument takes a struct argument
    !! which is defined in this library.
    !! Use IMPORT.
    !<
    subroutine callback_set_alloc(tc, arr, alloc)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: tc
        type(array_info), intent(INOUT) :: arr
        procedure(callback_set_alloc_alloc) :: alloc
        ! splicer begin function.callback_set_alloc
        call c_callback_set_alloc(tc, arr, alloc)
        ! splicer end function.callback_set_alloc
    end subroutine callback_set_alloc
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module clibrary_mod
