// pyClibrarymodule.c
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
#include "pyClibrarymodule.h"

// splicer begin include
// splicer end include

#ifdef __cplusplus
#define SHROUD_UNUSED(param)
#else
#define SHROUD_UNUSED(param) param
#endif

#if PY_MAJOR_VERSION >= 3
#define PyInt_AsLong PyLong_AsLong
#define PyInt_FromLong PyLong_FromLong
#define PyInt_FromSize_t PyLong_FromSize_t
#define PyString_FromString PyUnicode_FromString
#define PyString_FromStringAndSize PyUnicode_FromStringAndSize
#endif

// splicer begin C_definition
// splicer end C_definition
PyObject *PY_error_obj;

// splicer begin additional_functions
// splicer end additional_functions

// ----------------------------------------
// Function:  void NoReturnNoArguments
// Statement: py_subroutine
static char PY_NoReturnNoArguments__doc__[] =
"documentation"
;

static PyObject *
PY_NoReturnNoArguments(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.NoReturnNoArguments
    NoReturnNoArguments();
    Py_RETURN_NONE;
// splicer end function.NoReturnNoArguments
}

// ----------------------------------------
// Function:  double PassByValue
// Statement: py_function_native
// ----------------------------------------
// Argument:  double arg1
// Statement: py_in_native
// ----------------------------------------
// Argument:  int arg2
// Statement: py_in_native
static char PY_PassByValue__doc__[] =
"documentation"
;

static PyObject *
PY_PassByValue(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.PassByValue
    double arg1;
    int arg2;
    char *SHT_kwlist[] = {
        "arg1",
        "arg2",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "di:PassByValue",
        SHT_kwlist, &arg1, &arg2))
        return NULL;

    double SHCXX_rv = PassByValue(arg1, arg2);

    // post_call
    SHTPy_rv = PyFloat_FromDouble(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.PassByValue
}

// ----------------------------------------
// Function:  void PassByReference
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double *arg1 +intent(in)
// Statement: py_in_native*
// ----------------------------------------
// Argument:  int *arg2 +intent(out)
// Statement: py_out_native*
static char PY_PassByReference__doc__[] =
"documentation"
;

static PyObject *
PY_PassByReference(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.PassByReference
    double arg1;
    int arg2;
    char *SHT_kwlist[] = {
        "arg1",
        NULL };
    PyObject * SHPy_arg2 = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "d:PassByReference",
        SHT_kwlist, &arg1))
        return NULL;

    PassByReference(&arg1, &arg2);

    // post_call
    SHPy_arg2 = PyInt_FromLong(arg2);

    return (PyObject *) SHPy_arg2;
// splicer end function.PassByReference
}

// ----------------------------------------
// Function:  double PassByValueMacro
// Statement: py_function_native
// ----------------------------------------
// Argument:  int arg2
// Statement: py_in_native
static char PY_PassByValueMacro__doc__[] =
"documentation"
;

/**
 * PassByValueMacro is a #define macro. Force a C wrapper
 * to allow Fortran to have an actual function to call.
 */
static PyObject *
PY_PassByValueMacro(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.PassByValueMacro
    int arg2;
    char *SHT_kwlist[] = {
        "arg2",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:PassByValueMacro",
        SHT_kwlist, &arg2))
        return NULL;

    double SHCXX_rv = PassByValueMacro(arg2);

    // post_call
    SHTPy_rv = PyFloat_FromDouble(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.PassByValueMacro
}

// ----------------------------------------
// Function:  void checkBool
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const bool arg1
// Statement: py_in_bool
// ----------------------------------------
// Argument:  bool *arg2 +intent(out)
// Statement: py_out_bool*
// ----------------------------------------
// Argument:  bool *arg3 +intent(inout)
// Statement: py_inout_bool*
static char PY_checkBool__doc__[] =
"documentation"
;

/**
 * \brief Check intent with bool
 *
 */
static PyObject *
PY_checkBool(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.checkBool
    bool arg1;
    PyObject * SHPy_arg1;
    bool arg2;
    PyObject * SHPy_arg2 = NULL;
    bool arg3;
    PyObject * SHPy_arg3;
    char *SHT_kwlist[] = {
        "arg1",
        "arg3",
        NULL };
    PyObject *SHTPy_rv = NULL;  // return value object

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O!O!:checkBool",
        SHT_kwlist, &PyBool_Type, &SHPy_arg1, &PyBool_Type, &SHPy_arg3))
        return NULL;

    // pre_call
    arg1 = PyObject_IsTrue(SHPy_arg1);
    arg3 = PyObject_IsTrue(SHPy_arg3);

    checkBool(arg1, &arg2, &arg3);

    // post_call
    SHPy_arg2 = PyBool_FromLong(arg2);
    if (SHPy_arg2 == NULL) goto fail;
    SHPy_arg3 = PyBool_FromLong(arg3);
    if (SHPy_arg3 == NULL) goto fail;
    SHTPy_rv = Py_BuildValue("NN", SHPy_arg2, SHPy_arg3);

    return SHTPy_rv;

fail:
    Py_XDECREF(SHPy_arg2);
    Py_XDECREF(SHPy_arg3);
    return NULL;
// splicer end function.checkBool
}

// ----------------------------------------
// Function:  char *Function4a +len(30)
// Statement: py_function_char*
// ----------------------------------------
// Argument:  const char *arg1
// Statement: py_in_char*
// ----------------------------------------
// Argument:  const char *arg2
// Statement: py_in_char*
static char PY_Function4a__doc__[] =
"documentation"
;

static PyObject *
PY_Function4a(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.Function4a
    char *arg1;
    char *arg2;
    char *SHT_kwlist[] = {
        "arg1",
        "arg2",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "ss:Function4a",
        SHT_kwlist, &arg1, &arg2))
        return NULL;

    char *SHCXX_rv = Function4a(arg1, arg2);

    // post_call
    SHTPy_rv = PyString_FromString(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.Function4a
}

// ----------------------------------------
// Function:  void acceptName
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const char *name
// Statement: py_in_char*
static char PY_acceptName__doc__[] =
"documentation"
;

static PyObject *
PY_acceptName(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.acceptName
    char *name;
    char *SHT_kwlist[] = {
        "name",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "s:acceptName",
        SHT_kwlist, &name))
        return NULL;

    acceptName(name);
    Py_RETURN_NONE;
// splicer end function.acceptName
}

// ----------------------------------------
// Function:  void passCharPtrInOut
// Statement: py_subroutine
// ----------------------------------------
// Argument:  char *s +intent(inout)
// Statement: py_inout_char*
static char PY_passCharPtrInOut__doc__[] =
"documentation"
;

/**
 * \brief toupper
 *
 * Change a string in-place.
 * For Python, return a new string since strings are immutable.
 */
static PyObject *
PY_passCharPtrInOut(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.passCharPtrInOut
    char *s;
    char *SHT_kwlist[] = {
        "s",
        NULL };
    PyObject * SHPy_s = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "s:passCharPtrInOut",
        SHT_kwlist, &s))
        return NULL;

    passCharPtrInOut(s);

    // post_call
    SHPy_s = PyString_FromString(s);

    return (PyObject *) SHPy_s;
// splicer end function.passCharPtrInOut
}

// ----------------------------------------
// Function:  void returnOneName
// Statement: py_subroutine
// ----------------------------------------
// Argument:  char *name1 +charlen(MAXNAME)+intent(out)
// Statement: py_out_char*_charlen
static char PY_returnOneName__doc__[] =
"documentation"
;

/**
 * \brief Test charlen attribute
 *
 * Each argument is assumed to be at least MAXNAME long.
 * This define is provided by the user.
 * The function will copy into the user provided buffer.
 */
static PyObject *
PY_returnOneName(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnOneName
    char name1[MAXNAME];  // intent(out)
    PyObject * SHPy_name1 = NULL;

    returnOneName(name1);

    // post_call
    SHPy_name1 = PyString_FromString(name1);

    return (PyObject *) SHPy_name1;
// splicer end function.returnOneName
}

// ----------------------------------------
// Function:  void returnTwoNames
// Statement: py_subroutine
// ----------------------------------------
// Argument:  char *name1 +charlen(MAXNAME)+intent(out)
// Statement: py_out_char*_charlen
// ----------------------------------------
// Argument:  char *name2 +charlen(MAXNAME)+intent(out)
// Statement: py_out_char*_charlen
static char PY_returnTwoNames__doc__[] =
"documentation"
;

/**
 * \brief Test charlen attribute
 *
 * Each argument is assumed to be at least MAXNAME long.
 * This define is provided by the user.
 * The function will copy into the user provided buffer.
 */
static PyObject *
PY_returnTwoNames(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnTwoNames
    char name1[MAXNAME];  // intent(out)
    char name2[MAXNAME];  // intent(out)
    PyObject *SHTPy_rv = NULL;  // return value object

    returnTwoNames(name1, name2);

    // post_call
    SHTPy_rv = Py_BuildValue("ss", name1, name2);

    return SHTPy_rv;
// splicer end function.returnTwoNames
}

// ----------------------------------------
// Function:  void ImpliedTextLen
// Statement: py_subroutine
// ----------------------------------------
// Argument:  char *text +charlen(MAXNAME)+intent(out)
// Statement: py_out_char*_charlen
// ----------------------------------------
// Argument:  int ltext +implied(len(text))
// Statement: py_implied_native
static char PY_ImpliedTextLen__doc__[] =
"documentation"
;

/**
 * \brief Fill text, at most ltext characters.
 *
 */
static PyObject *
PY_ImpliedTextLen(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ImpliedTextLen
    char text[MAXNAME];  // intent(out)
    int ltext;
    PyObject * SHPy_text = NULL;

    // pre_call
    ltext = MAXNAME;

    ImpliedTextLen(text, ltext);

    // post_call
    SHPy_text = PyString_FromString(text);

    return (PyObject *) SHPy_text;
// splicer end function.ImpliedTextLen
}

// ----------------------------------------
// Function:  int ImpliedLen
// Statement: py_function_native
// ----------------------------------------
// Argument:  const char *text +api(capi)
// Statement: py_in_char*
// ----------------------------------------
// Argument:  int ltext +implied(len(text))
// Statement: py_implied_native
// ----------------------------------------
// Argument:  bool flag +implied(false)
// Statement: py_implied_bool
static char PY_ImpliedLen__doc__[] =
"documentation"
;

/**
 * \brief Return the implied argument - text length
 *
 * Pass the Fortran length of the char argument directy to the C function.
 * Use api(capi) to avoid needlessly copying the string.
 */
static PyObject *
PY_ImpliedLen(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.ImpliedLen
    char *text;
    int ltext;
    bool flag;
    char *SHT_kwlist[] = {
        "text",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "s:ImpliedLen",
        SHT_kwlist, &text))
        return NULL;

    // pre_call
    ltext = strlen(text);
    flag = false;

    int SHCXX_rv = ImpliedLen(text, ltext, flag);

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.ImpliedLen
}

// ----------------------------------------
// Function:  int ImpliedLenTrim
// Statement: py_function_native
// ----------------------------------------
// Argument:  const char *text +api(capi)
// Statement: py_in_char*
// ----------------------------------------
// Argument:  int ltext +implied(len_trim(text))
// Statement: py_implied_native
// ----------------------------------------
// Argument:  bool flag +implied(true)
// Statement: py_implied_bool
static char PY_ImpliedLenTrim__doc__[] =
"documentation"
;

/**
 * \brief Return the implied argument - text length
 *
 * Pass the Fortran length of the char argument directy to the C function.
 * Use api(capi) to avoid needlessly copying the string.
 */
static PyObject *
PY_ImpliedLenTrim(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.ImpliedLenTrim
    char *text;
    int ltext;
    bool flag;
    char *SHT_kwlist[] = {
        "text",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "s:ImpliedLenTrim",
        SHT_kwlist, &text))
        return NULL;

    // pre_call
    ltext = strlen(text);
    flag = true;

    int SHCXX_rv = ImpliedLenTrim(text, ltext, flag);

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.ImpliedLenTrim
}

// ----------------------------------------
// Function:  bool ImpliedBoolTrue
// Statement: py_function_bool
// ----------------------------------------
// Argument:  bool flag +implied(true)
// Statement: py_implied_bool
static char PY_ImpliedBoolTrue__doc__[] =
"documentation"
;

/**
 * \brief Single, implied bool argument
 *
 */
static PyObject *
PY_ImpliedBoolTrue(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ImpliedBoolTrue
    bool flag;
    PyObject * SHTPy_rv = NULL;

    // pre_call
    flag = true;

    bool SHCXX_rv = ImpliedBoolTrue(flag);

    // post_call
    SHTPy_rv = PyBool_FromLong(SHCXX_rv);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.ImpliedBoolTrue
}

// ----------------------------------------
// Function:  bool ImpliedBoolFalse
// Statement: py_function_bool
// ----------------------------------------
// Argument:  bool flag +implied(false)
// Statement: py_implied_bool
static char PY_ImpliedBoolFalse__doc__[] =
"documentation"
;

/**
 * \brief Single, implied bool argument
 *
 */
static PyObject *
PY_ImpliedBoolFalse(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ImpliedBoolFalse
    bool flag;
    PyObject * SHTPy_rv = NULL;

    // pre_call
    flag = false;

    bool SHCXX_rv = ImpliedBoolFalse(flag);

    // post_call
    SHTPy_rv = PyBool_FromLong(SHCXX_rv);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.ImpliedBoolFalse
}
static PyMethodDef PY_methods[] = {
{"NoReturnNoArguments", (PyCFunction)PY_NoReturnNoArguments,
    METH_NOARGS, PY_NoReturnNoArguments__doc__},
{"PassByValue", (PyCFunction)PY_PassByValue, METH_VARARGS|METH_KEYWORDS,
    PY_PassByValue__doc__},
{"PassByReference", (PyCFunction)PY_PassByReference,
    METH_VARARGS|METH_KEYWORDS, PY_PassByReference__doc__},
{"PassByValueMacro", (PyCFunction)PY_PassByValueMacro,
    METH_VARARGS|METH_KEYWORDS, PY_PassByValueMacro__doc__},
{"checkBool", (PyCFunction)PY_checkBool, METH_VARARGS|METH_KEYWORDS,
    PY_checkBool__doc__},
{"Function4a", (PyCFunction)PY_Function4a, METH_VARARGS|METH_KEYWORDS,
    PY_Function4a__doc__},
{"acceptName", (PyCFunction)PY_acceptName, METH_VARARGS|METH_KEYWORDS,
    PY_acceptName__doc__},
{"passCharPtrInOut", (PyCFunction)PY_passCharPtrInOut,
    METH_VARARGS|METH_KEYWORDS, PY_passCharPtrInOut__doc__},
{"returnOneName", (PyCFunction)PY_returnOneName, METH_NOARGS,
    PY_returnOneName__doc__},
{"returnTwoNames", (PyCFunction)PY_returnTwoNames, METH_NOARGS,
    PY_returnTwoNames__doc__},
{"ImpliedTextLen", (PyCFunction)PY_ImpliedTextLen, METH_NOARGS,
    PY_ImpliedTextLen__doc__},
{"ImpliedLen", (PyCFunction)PY_ImpliedLen, METH_VARARGS|METH_KEYWORDS,
    PY_ImpliedLen__doc__},
{"ImpliedLenTrim", (PyCFunction)PY_ImpliedLenTrim,
    METH_VARARGS|METH_KEYWORDS, PY_ImpliedLenTrim__doc__},
{"ImpliedBoolTrue", (PyCFunction)PY_ImpliedBoolTrue, METH_NOARGS,
    PY_ImpliedBoolTrue__doc__},
{"ImpliedBoolFalse", (PyCFunction)PY_ImpliedBoolFalse, METH_NOARGS,
    PY_ImpliedBoolFalse__doc__},
{NULL,   (PyCFunction)NULL, 0, NULL}            /* sentinel */
};

/*
 * initclibrary - Initialization function for the module
 * *must* be called initclibrary
 */
static char PY__doc__[] =
"library documentation"
;

struct module_state {
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

#if PY_MAJOR_VERSION >= 3
static int clibrary_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int clibrary_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "clibrary", /* m_name */
    PY__doc__, /* m_doc */
    sizeof(struct module_state), /* m_size */
    PY_methods, /* m_methods */
    NULL, /* m_reload */
    clibrary_traverse, /* m_traverse */
    clibrary_clear, /* m_clear */
    NULL  /* m_free */
};

#define RETVAL m
#define INITERROR return NULL
#else
#define RETVAL
#define INITERROR return
#endif

PyMODINIT_FUNC
#if PY_MAJOR_VERSION >= 3
PyInit_clibrary(void)
#else
initclibrary(void)
#endif
{
    PyObject *m = NULL;
    const char * error_name = "clibrary.Error";

    // splicer begin C_init_locals
    // splicer end C_init_locals


    /* Create the module and add the functions */
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule4("clibrary", PY_methods,
        PY__doc__,
        (PyObject*)NULL,PYTHON_API_VERSION);
#endif
    if (m == NULL)
        return RETVAL;
    struct module_state *st = GETSTATE(m);

    PY_error_obj = PyErr_NewException((char *) error_name, NULL, NULL);
    if (PY_error_obj == NULL)
        return RETVAL;
    st->error = PY_error_obj;
    PyModule_AddObject(m, "Error", st->error);

    // splicer begin C_init_body
    // splicer end C_init_body

    /* Check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module clibrary");
    return RETVAL;
}

