! wrapfclasses.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfclasses.f
!! \brief Shroud generated wrapper for classes namespace
!<
! splicer begin file_top
! splicer end file_top
module classes_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: CLA_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type CLA_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: CLA_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type CLA_SHROUD_capsule_data
    ! end helper capsule_data_helper

    !  enum classes::Class1::DIRECTION
    integer, parameter :: class1_direction = C_INT
    ! splicer begin class.Class1.enum.DIRECTION
    integer(class1_direction), parameter :: class1_up = 2
    integer(class1_direction), parameter :: class1_down = 3
    integer(class1_direction), parameter :: class1_left = 100
    integer(class1_direction), parameter :: class1_right = 101
    ! splicer end class.Class1.enum.DIRECTION

    ! start derived-type class1
    type class1
        type(CLA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Class1.component_part
        ! splicer end class.Class1.component_part
    contains
        procedure :: delete => class1_delete
        procedure :: method1 => class1_method1
        procedure :: equivalent => class1_equivalent
        procedure :: return_this => class1_return_this
        procedure :: return_this_buffer => class1_return_this_buffer
        procedure :: getclass3 => class1_getclass3
        procedure :: get_name => class1_get_name
        procedure :: direction_func => class1_direction_func
        procedure :: get_m_flag => class1_get_m_flag
        procedure :: get_test => class1_get_test
        procedure :: set_test => class1_set_test
        procedure :: get_m_bool => class1_get_m_bool
        procedure :: set_m_bool => class1_set_m_bool
        procedure :: get_m_name => class1_get_m_name
        procedure :: set_m_name => class1_set_m_name
        procedure :: get_instance => class1_get_instance
        procedure :: set_instance => class1_set_instance
        procedure :: associated => class1_associated
        ! splicer begin class.Class1.type_bound_procedure_part
        ! splicer end class.Class1.type_bound_procedure_part
    end type class1
    ! end derived-type class1

    type class2
        type(CLA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Class2.component_part
        ! splicer end class.Class2.component_part
    contains
        procedure :: get_name => class2_get_name
        procedure :: get_instance => class2_get_instance
        procedure :: set_instance => class2_set_instance
        procedure :: associated => class2_associated
        ! splicer begin class.Class2.type_bound_procedure_part
        ! splicer end class.Class2.type_bound_procedure_part
    end type class2

    ! start derived-type singleton
    type singleton
        type(CLA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Singleton.component_part
        ! splicer end class.Singleton.component_part
    contains
        procedure, nopass :: get_reference => singleton_get_reference
        ! splicer begin class.Singleton.type_bound_procedure_part
        ! splicer end class.Singleton.type_bound_procedure_part
    end type singleton
    ! end derived-type singleton

    type shape
        type(CLA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Shape.component_part
        ! splicer end class.Shape.component_part
    contains
        procedure :: get_ivar => shape_get_ivar
        procedure :: get_instance => shape_get_instance
        procedure :: set_instance => shape_set_instance
        procedure :: associated => shape_associated
        ! splicer begin class.Shape.type_bound_procedure_part
        ! splicer end class.Shape.type_bound_procedure_part
    end type shape

    type, extends(shape) :: circle
        ! splicer begin class.Circle.component_part
        ! splicer end class.Circle.component_part
    contains
        ! splicer begin class.Circle.type_bound_procedure_part
        ! splicer end class.Circle.type_bound_procedure_part
    end type circle

    ! start derived-type data
    type data
        type(CLA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Data.component_part
        ! splicer end class.Data.component_part
    contains
        procedure :: allocate => data_allocate
        procedure :: free => data_free
        procedure :: dtor => data_dtor
        procedure :: get_nitems => data_get_nitems
        procedure :: set_nitems => data_set_nitems
        procedure :: get_items => data_get_items
        procedure :: set_items => data_set_items
        ! splicer begin class.Data.type_bound_procedure_part
        ! splicer end class.Data.type_bound_procedure_part
    end type data
    ! end derived-type data

    interface operator (.eq.)
        module procedure class1_eq
        module procedure class2_eq
        module procedure singleton_eq
        module procedure shape_eq
        module procedure circle_eq
        module procedure data_eq
    end interface

    interface operator (.ne.)
        module procedure class1_ne
        module procedure class2_ne
        module procedure singleton_ne
        module procedure shape_ne
        module procedure circle_ne
        module procedure data_ne
    end interface

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: c_ctor_shadow_capptr
    ! start c_class1_ctor_default
    interface
        function c_class1_ctor_default(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Class1_ctor_default")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_class1_ctor_default
    end interface
    ! end c_class1_ctor_default

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: f_ctor_shadow_capsule
    ! start c_class1_ctor_default_bufferify
    interface
        subroutine c_class1_ctor_default_bufferify(SHT_rv) &
                bind(C, name="CLA_Class1_ctor_default_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_class1_ctor_default_bufferify
    end interface
    ! end c_class1_ctor_default_bufferify

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: c_ctor_shadow_capptr
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: c_in_native
    ! start c_class1_ctor_flag
    interface
        function c_class1_ctor_flag(flag, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Class1_ctor_flag")
            use iso_c_binding, only : C_INT, C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_class1_ctor_flag
    end interface
    ! end c_class1_ctor_flag

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: f_ctor_shadow_capsule
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start c_class1_ctor_flag_bufferify
    interface
        subroutine c_class1_ctor_flag_bufferify(flag, SHT_rv) &
                bind(C, name="CLA_Class1_ctor_flag_bufferify")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_class1_ctor_flag_bufferify
    end interface
    ! end c_class1_ctor_flag_bufferify

    ! ----------------------------------------
    ! Function:  ~Class1 +name(delete)
    ! Statement: f_dtor
    ! start c_class1_delete
    interface
        subroutine c_class1_delete(self) &
                bind(C, name="CLA_Class1_delete")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_class1_delete
    end interface
    ! end c_class1_delete

    ! ----------------------------------------
    ! Function:  int Method1
    ! Statement: f_function_native
    ! start c_class1_method1
    interface
        function c_class1_method1(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_Method1")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_class1_method1
    end interface
    ! end c_class1_method1

    ! ----------------------------------------
    ! Function:  bool equivalent
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  const Class1 &obj2
    ! Statement: f_in_shadow&
    ! start c_class1_equivalent
    interface
        pure function c_class1_equivalent(self, obj2) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_equivalent")
            use iso_c_binding, only : C_BOOL
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_capsule_data), intent(IN) :: obj2
            logical(C_BOOL) :: SHT_rv
        end function c_class1_equivalent
    end interface
    ! end c_class1_equivalent

    ! ----------------------------------------
    ! Function:  Class1 *returnThis
    ! Statement: f_function_shadow*_this
    ! start c_class1_return_this
    interface
        subroutine c_class1_return_this(self) &
                bind(C, name="CLA_Class1_returnThis")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
        end subroutine c_class1_return_this
    end interface
    ! end c_class1_return_this

    ! ----------------------------------------
    ! Function:  Class1 *returnThisBuffer
    ! Statement: c_function_shadow*_capptr
    ! ----------------------------------------
    ! Argument:  std::string &name +intent(in)
    ! Statement: c_in_string&
    ! ----------------------------------------
    ! Argument:  bool flag
    ! Statement: c_in_bool
    ! start c_class1_return_this_buffer
    interface
        function c_class1_return_this_buffer(self, name, flag, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Class1_returnThisBuffer")
            use iso_c_binding, only : C_BOOL, C_CHAR, C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            character(kind=C_CHAR), intent(IN) :: name(*)
            logical(C_BOOL), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_class1_return_this_buffer
    end interface
    ! end c_class1_return_this_buffer

    ! ----------------------------------------
    ! Function:  Class1 *returnThisBuffer
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  std::string &name +intent(in)
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  bool flag
    ! Statement: f_in_bool
    ! start c_class1_return_this_buffer_bufferify
    interface
        subroutine c_class1_return_this_buffer_bufferify(self, name, &
                SHT_name_len, flag, SHT_rv) &
                bind(C, name="CLA_Class1_returnThisBuffer_bufferify")
            use iso_c_binding, only : C_BOOL, C_CHAR, C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            logical(C_BOOL), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_class1_return_this_buffer_bufferify
    end interface
    ! end c_class1_return_this_buffer_bufferify

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: c_function_shadow*_capptr
    ! start c_class1_getclass3
    interface
        function c_class1_getclass3(self, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Class1_getclass3")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_class1_getclass3
    end interface
    ! end c_class1_getclass3

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: f_function_shadow*_capsule
    ! start c_class1_getclass3_bufferify
    interface
        subroutine c_class1_getclass3_bufferify(self, SHT_rv) &
                bind(C, name="CLA_Class1_getclass3_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_class1_getclass3_bufferify
    end interface
    ! end c_class1_getclass3_bufferify

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: c_function_string&
    ! start c_class1_get_name
    interface
        function c_class1_get_name(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_getName")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_class1_get_name
    end interface
    ! end c_class1_get_name

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: f_function_string&_cdesc_allocatable
    ! start c_class1_get_name_bufferify
    interface
        subroutine c_class1_get_name_bufferify(self, SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="CLA_Class1_getName_bufferify")
            import :: CLA_SHROUD_array, CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_class1_get_name_bufferify
    end interface
    ! end c_class1_get_name_bufferify

    ! ----------------------------------------
    ! Function:  DIRECTION directionFunc
    ! Statement: c_function_enum
    ! ----------------------------------------
    ! Argument:  DIRECTION arg
    ! Statement: c_in_enum
    ! start c_class1_direction_func
    interface
        function c_class1_direction_func(self, arg) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_directionFunc")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function c_class1_direction_func
    end interface
    ! end c_class1_direction_func

    ! ----------------------------------------
    ! Function:  DIRECTION directionFunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  DIRECTION arg
    ! Statement: f_in_enum
    ! start c_class1_direction_func_bufferify
    interface
        function c_class1_direction_func_bufferify(self, arg) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_directionFunc_bufferify")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function c_class1_direction_func_bufferify
    end interface
    ! end c_class1_direction_func_bufferify

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_m_flag +intent(getter)
    ! Statement: f_getter_native
    ! start c_class1_get_m_flag
    interface
        function c_class1_get_m_flag(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_get_m_flag")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_class1_get_m_flag
    end interface
    ! end c_class1_get_m_flag

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_test +intent(getter)
    ! Statement: f_getter_native
    ! start c_class1_get_test
    interface
        function c_class1_get_test(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_get_test")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_class1_get_test
    end interface
    ! end c_class1_get_test

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_test +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_class1_set_test
    interface
        subroutine c_class1_set_test(self, val) &
                bind(C, name="CLA_Class1_set_test")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_class1_set_test
    end interface
    ! end c_class1_set_test

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  bool get_m_bool +intent(getter)
    ! Statement: f_getter_bool
    ! start c_class1_get_m_bool
    interface
        function c_class1_get_m_bool(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class1_get_m_bool")
            use iso_c_binding, only : C_BOOL
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            logical(C_BOOL) :: SHT_rv
        end function c_class1_get_m_bool
    end interface
    ! end c_class1_get_m_bool

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_m_bool +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  bool val +intent(setter)
    ! Statement: f_setter_bool
    ! start c_class1_set_m_bool
    interface
        subroutine c_class1_set_m_bool(self, val) &
                bind(C, name="CLA_Class1_set_m_bool")
            use iso_c_binding, only : C_BOOL
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            logical(C_BOOL), value, intent(IN) :: val
        end subroutine c_class1_set_m_bool
    end interface
    ! end c_class1_set_m_bool

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  std::string get_m_name +intent(getter)
    ! Statement: f_getter_string_cdesc_allocatable
    ! start c_class1_get_m_name
    interface
        subroutine c_class1_get_m_name(self, SHT_rv_cdesc) &
                bind(C, name="CLA_Class1_get_m_name")
            import :: CLA_SHROUD_array, CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_class1_get_m_name
    end interface
    ! end c_class1_get_m_name

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_m_name +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  std::string val +intent(setter)
    ! Statement: f_setter_string_buf
    ! start c_class1_set_m_name
    interface
        subroutine c_class1_set_m_name(self, val, SHT_val_len) &
                bind(C, name="CLA_Class1_set_m_name")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            character(kind=C_CHAR), intent(IN) :: val(*)
            integer(C_INT), value, intent(IN) :: SHT_val_len
        end subroutine c_class1_set_m_name
    end interface
    ! end c_class1_set_m_name

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: c_function_string&
    interface
        function c_class2_get_name(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Class2_getName")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_class2_get_name
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: f_function_string&_cdesc_allocatable
    interface
        subroutine c_class2_get_name_bufferify(self, SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="CLA_Class2_getName_bufferify")
            import :: CLA_SHROUD_array, CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_class2_get_name_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  static Singleton &getReference
    ! Statement: c_function_shadow&_capptr
    ! start c_singleton_get_reference
    interface
        function c_singleton_get_reference(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Singleton_getReference")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_singleton_get_reference
    end interface
    ! end c_singleton_get_reference

    ! ----------------------------------------
    ! Function:  static Singleton &getReference
    ! Statement: f_function_shadow&_capsule
    ! start c_singleton_get_reference_bufferify
    interface
        subroutine c_singleton_get_reference_bufferify(SHT_rv) &
                bind(C, name="CLA_Singleton_getReference_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_singleton_get_reference_bufferify
    end interface
    ! end c_singleton_get_reference_bufferify

    ! ----------------------------------------
    ! Function:  Shape
    ! Statement: c_ctor_shadow_capptr
    interface
        function c_shape_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Shape_ctor")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_shape_ctor
    end interface

    ! ----------------------------------------
    ! Function:  Shape
    ! Statement: f_ctor_shadow_capsule
    interface
        subroutine c_shape_ctor_bufferify(SHT_rv) &
                bind(C, name="CLA_Shape_ctor_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_shape_ctor_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int get_ivar
    ! Statement: f_function_native
    interface
        pure function c_shape_get_ivar(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Shape_get_ivar")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_shape_get_ivar
    end interface

    ! ----------------------------------------
    ! Function:  Circle
    ! Statement: c_ctor_shadow_capptr
    interface
        function c_circle_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Circle_ctor")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_circle_ctor
    end interface

    ! ----------------------------------------
    ! Function:  Circle
    ! Statement: f_ctor_shadow_capsule
    interface
        subroutine c_circle_ctor_bufferify(SHT_rv) &
                bind(C, name="CLA_Circle_ctor_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_circle_ctor_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void allocate
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    ! start c_data_allocate
    interface
        subroutine c_data_allocate(self, n) &
                bind(C, name="CLA_Data_allocate")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: n
        end subroutine c_data_allocate
    end interface
    ! end c_data_allocate

    ! ----------------------------------------
    ! Function:  void free
    ! Statement: f_subroutine
    ! start c_data_free
    interface
        subroutine c_data_free(self) &
                bind(C, name="CLA_Data_free")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
        end subroutine c_data_free
    end interface
    ! end c_data_free

    ! ----------------------------------------
    ! Function:  Data
    ! Statement: c_ctor_shadow_capptr
    ! start c_data_ctor
    interface
        function c_data_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_Data_ctor")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_data_ctor
    end interface
    ! end c_data_ctor

    ! ----------------------------------------
    ! Function:  Data
    ! Statement: f_ctor_shadow_capsule
    ! start c_data_ctor_bufferify
    interface
        subroutine c_data_ctor_bufferify(SHT_rv) &
                bind(C, name="CLA_Data_ctor_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_data_ctor_bufferify
    end interface
    ! end c_data_ctor_bufferify

    ! ----------------------------------------
    ! Function:  ~Data
    ! Statement: f_dtor
    ! start c_data_dtor
    interface
        subroutine c_data_dtor(self) &
                bind(C, name="CLA_Data_dtor")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_data_dtor
    end interface
    ! end c_data_dtor

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_nitems +intent(getter)
    ! Statement: f_getter_native
    ! start c_data_get_nitems
    interface
        function c_data_get_nitems(self) &
                result(SHT_rv) &
                bind(C, name="CLA_Data_get_nitems")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_data_get_nitems
    end interface
    ! end c_data_get_nitems

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_nitems +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_data_set_nitems
    interface
        subroutine c_data_set_nitems(self, val) &
                bind(C, name="CLA_Data_set_nitems")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_data_set_nitems
    end interface
    ! end c_data_set_nitems

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int *get_items +dimension(nitems)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! start c_data_get_items
    interface
        subroutine c_data_get_items(self, SHT_rv_cdesc) &
                bind(C, name="CLA_Data_get_items")
            import :: CLA_SHROUD_array, CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            type(CLA_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_data_get_items
    end interface
    ! end c_data_get_items

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_items +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    ! start c_data_set_items
    interface
        subroutine c_data_set_items(self, val) &
                bind(C, name="CLA_Data_set_items")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), intent(IN) :: val(*)
        end subroutine c_data_set_items
    end interface
    ! end c_data_set_items

    ! ----------------------------------------
    ! Function:  Class1::DIRECTION directionFunc
    ! Statement: c_function_enum
    ! ----------------------------------------
    ! Argument:  Class1::DIRECTION arg
    ! Statement: c_in_enum
    interface
        function c_direction_func(arg) &
                result(SHT_rv) &
                bind(C, name="CLA_directionFunc")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function c_direction_func
    end interface

    ! ----------------------------------------
    ! Function:  Class1::DIRECTION directionFunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  Class1::DIRECTION arg
    ! Statement: f_in_enum
    interface
        function direction_func(arg) &
                result(SHT_rv) &
                bind(C, name="CLA_directionFunc_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function direction_func
    end interface

    ! ----------------------------------------
    ! Function:  void passClassByValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Class1 arg
    ! Statement: f_in_shadow
    interface
        subroutine c_pass_class_by_value(arg) &
                bind(C, name="CLA_passClassByValue")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN), value :: arg
        end subroutine c_pass_class_by_value
    end interface

    ! ----------------------------------------
    ! Function:  int useclass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Class1 *arg
    ! Statement: f_in_shadow*
    interface
        function c_useclass(arg) &
                result(SHT_rv) &
                bind(C, name="CLA_useclass")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function c_useclass
    end interface

    ! ----------------------------------------
    ! Function:  const Class1 *getclass2
    ! Statement: c_function_shadow*_capptr
    interface
        function c_getclass2(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_getclass2")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_getclass2
    end interface

    ! ----------------------------------------
    ! Function:  const Class1 *getclass2
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_getclass2_bufferify(SHT_rv) &
                bind(C, name="CLA_getclass2_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_getclass2_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: c_function_shadow*_capptr
    interface
        function c_getclass3(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_getclass3")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_getclass3
    end interface

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_getclass3_bufferify(SHT_rv) &
                bind(C, name="CLA_getclass3_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_getclass3_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const Class1 *getclass2_void
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_getclass2_void(SHT_rv) &
                bind(C, name="CLA_getclass2_void")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_getclass2_void
    end interface

    ! ----------------------------------------
    ! Function:  Class1 *getclass3_void
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_getclass3_void(SHT_rv) &
                bind(C, name="CLA_getclass3_void")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_getclass3_void
    end interface

    ! ----------------------------------------
    ! Function:  const Class1 &getConstClassReference
    ! Statement: c_function_shadow&_capptr
    interface
        function c_get_const_class_reference(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_getConstClassReference")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_get_const_class_reference
    end interface

    ! ----------------------------------------
    ! Function:  const Class1 &getConstClassReference
    ! Statement: f_function_shadow&_capsule
    interface
        subroutine c_get_const_class_reference_bufferify(SHT_rv) &
                bind(C, name="CLA_getConstClassReference_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_get_const_class_reference_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Class1 &getClassReference
    ! Statement: c_function_shadow&_capptr
    interface
        function c_get_class_reference(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_getClassReference")
            use iso_c_binding, only : C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_get_class_reference
    end interface

    ! ----------------------------------------
    ! Function:  Class1 &getClassReference
    ! Statement: f_function_shadow&_capsule
    interface
        subroutine c_get_class_reference_bufferify(SHT_rv) &
                bind(C, name="CLA_getClassReference_bufferify")
            import :: CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_get_class_reference_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Class1 getClassCopy
    ! Statement: c_function_shadow_capptr
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: c_in_native
    interface
        function c_get_class_copy(flag, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="CLA_getClassCopy")
            use iso_c_binding, only : C_INT, C_PTR
            import :: CLA_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_get_class_copy
    end interface

    ! ----------------------------------------
    ! Function:  Class1 getClassCopy
    ! Statement: f_function_shadow_capsule
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    interface
        subroutine c_get_class_copy_bufferify(flag, SHT_rv) &
                bind(C, name="CLA_getClassCopy_bufferify")
            use iso_c_binding, only : C_INT
            import :: CLA_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(CLA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_get_class_copy_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void set_global_flag
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int arg
    ! Statement: f_in_native
    interface
        subroutine set_global_flag(arg) &
                bind(C, name="CLA_set_global_flag")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
        end subroutine set_global_flag
    end interface

    ! ----------------------------------------
    ! Function:  int get_global_flag
    ! Statement: f_function_native
    interface
        function get_global_flag() &
                result(SHT_rv) &
                bind(C, name="CLA_get_global_flag")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function get_global_flag
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: c_function_string&
    interface
        function c_last_function_called() &
                result(SHT_rv) &
                bind(C, name="CLA_LastFunctionCalled")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_last_function_called
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: f_function_string&_buf_copy
    interface
        subroutine c_last_function_called_bufferify(SHT_rv, SHT_rv_len) &
                bind(C, name="CLA_LastFunctionCalled_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_last_function_called_bufferify
    end interface

    interface circle
        module procedure circle_ctor
    end interface circle

    ! start generic interface class1
    interface class1
        module procedure class1_ctor_default
        module procedure class1_ctor_flag
    end interface class1
    ! end generic interface class1

    ! start generic interface data
    interface data
        module procedure data_ctor
    end interface data
    ! end generic interface data

    interface shape
        module procedure shape_ctor
    end interface shape

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine CLA_SHROUD_capsule_dtor(ptr) &
            bind(C, name="CLA_SHROUD_memory_destructor")
            import CLA_SHROUD_capsule_data
            implicit none
            type(CLA_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine CLA_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine CLA_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="CLA_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import CLA_SHROUD_array
            type(CLA_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine CLA_SHROUD_copy_string
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: f_ctor_shadow_capsule
    ! start class1_ctor_default
    function class1_ctor_default() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin class.Class1.method.ctor_default
        call c_class1_ctor_default_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Class1.method.ctor_default
    end function class1_ctor_default
    ! end class1_ctor_default

    ! ----------------------------------------
    ! Function:  Class1
    ! Statement: f_ctor_shadow_capsule
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start class1_ctor_flag
    function class1_ctor_flag(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: flag
        type(class1) :: SHT_rv
        ! splicer begin class.Class1.method.ctor_flag
        call c_class1_ctor_flag_bufferify(flag, SHT_rv%cxxmem)
        ! splicer end class.Class1.method.ctor_flag
    end function class1_ctor_flag
    ! end class1_ctor_flag

    ! ----------------------------------------
    ! Function:  ~Class1 +name(delete)
    ! Statement: f_dtor
    ! start class1_delete
    subroutine class1_delete(obj)
        class(class1), intent(INOUT) :: obj
        ! splicer begin class.Class1.method.delete
        call c_class1_delete(obj%cxxmem)
        ! splicer end class.Class1.method.delete
    end subroutine class1_delete
    ! end class1_delete

    ! ----------------------------------------
    ! Function:  int Method1
    ! Statement: f_function_native
    !>
    !! \brief returns the value of flag member
    !!
    !<
    ! start class1_method1
    function class1_method1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Class1.method.method1
        SHT_rv = c_class1_method1(obj%cxxmem)
        ! splicer end class.Class1.method.method1
    end function class1_method1
    ! end class1_method1

    ! ----------------------------------------
    ! Function:  bool equivalent
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  const Class1 &obj2
    ! Statement: f_in_shadow&
    !>
    !! \brief Pass in reference to instance
    !!
    !<
    ! start class1_equivalent
    function class1_equivalent(obj, obj2) &
            result(SHT_rv)
        class(class1), intent(IN) :: obj
        type(class1), intent(IN) :: obj2
        logical :: SHT_rv
        ! splicer begin class.Class1.method.equivalent
        SHT_rv = c_class1_equivalent(obj%cxxmem, obj2%cxxmem)
        ! splicer end class.Class1.method.equivalent
    end function class1_equivalent
    ! end class1_equivalent

    ! ----------------------------------------
    ! Function:  Class1 *returnThis
    ! Statement: f_function_shadow*_this
    !>
    !! \brief Return pointer to 'this' to allow chaining calls
    !!
    !<
    ! start class1_return_this
    subroutine class1_return_this(obj)
        class(class1), intent(INOUT) :: obj
        ! splicer begin class.Class1.method.return_this
        call c_class1_return_this(obj%cxxmem)
        ! splicer end class.Class1.method.return_this
    end subroutine class1_return_this
    ! end class1_return_this

    ! ----------------------------------------
    ! Function:  Class1 *returnThisBuffer
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  std::string &name +intent(in)
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  bool flag
    ! Statement: f_in_bool
    !>
    !! \brief Return pointer to 'this' to allow chaining calls
    !!
    !<
    ! start class1_return_this_buffer
    function class1_return_this_buffer(obj, name, flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL, C_INT
        class(class1), intent(INOUT) :: obj
        character(len=*), intent(IN) :: name
        logical, value, intent(IN) :: flag
        type(class1) :: SHT_rv
        ! splicer begin class.Class1.method.return_this_buffer
        integer(C_INT) SHT_name_len
        logical(C_BOOL) :: SHT_flag_cxx
        SHT_name_len = len(name, kind=C_INT)
        SHT_flag_cxx = flag  ! coerce to C_BOOL
        call c_class1_return_this_buffer_bufferify(obj%cxxmem, name, &
            SHT_name_len, SHT_flag_cxx, SHT_rv%cxxmem)
        ! splicer end class.Class1.method.return_this_buffer
    end function class1_return_this_buffer
    ! end class1_return_this_buffer

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: f_function_shadow*_capsule
    !>
    !! \brief Test const method
    !!
    !<
    ! start class1_getclass3
    function class1_getclass3(obj) &
            result(SHT_rv)
        class(class1), intent(IN) :: obj
        type(class1) :: SHT_rv
        ! splicer begin class.Class1.method.getclass3
        call c_class1_getclass3_bufferify(obj%cxxmem, SHT_rv%cxxmem)
        ! splicer end class.Class1.method.getclass3
    end function class1_getclass3
    ! end class1_getclass3

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: f_function_string&_cdesc_allocatable
    !>
    !! \brief test helper
    !!
    !<
    ! start class1_get_name
    function class1_get_name(obj) &
            result(SHT_rv)
        class(class1), intent(INOUT) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin class.Class1.method.get_name
        type(CLA_SHROUD_array) :: SHT_rv_cdesc
        type(CLA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_class1_get_name_bufferify(obj%cxxmem, SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call CLA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call CLA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end class.Class1.method.get_name
    end function class1_get_name
    ! end class1_get_name

    ! ----------------------------------------
    ! Function:  DIRECTION directionFunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  DIRECTION arg
    ! Statement: f_in_enum
    ! start class1_direction_func
    function class1_direction_func(obj, arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Class1.method.direction_func
        SHT_rv = c_class1_direction_func_bufferify(obj%cxxmem, arg)
        ! splicer end class.Class1.method.direction_func
    end function class1_direction_func
    ! end class1_direction_func

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_m_flag +intent(getter)
    ! Statement: f_getter_native
    ! start class1_get_m_flag
    function class1_get_m_flag(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Class1.method.get_m_flag
        SHT_rv = c_class1_get_m_flag(obj%cxxmem)
        ! splicer end class.Class1.method.get_m_flag
    end function class1_get_m_flag
    ! end class1_get_m_flag

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_test +intent(getter)
    ! Statement: f_getter_native
    ! start class1_get_test
    function class1_get_test(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Class1.method.get_test
        SHT_rv = c_class1_get_test(obj%cxxmem)
        ! splicer end class.Class1.method.get_test
    end function class1_get_test
    ! end class1_get_test

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_test +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start class1_set_test
    subroutine class1_set_test(obj, val)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Class1.method.set_test
        call c_class1_set_test(obj%cxxmem, val)
        ! splicer end class.Class1.method.set_test
    end subroutine class1_set_test
    ! end class1_set_test

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  bool get_m_bool +intent(getter)
    ! Statement: f_getter_bool
    ! start class1_get_m_bool
    function class1_get_m_bool(obj) &
            result(SHT_rv)
        class(class1), intent(INOUT) :: obj
        logical :: SHT_rv
        ! splicer begin class.Class1.method.get_m_bool
        SHT_rv = c_class1_get_m_bool(obj%cxxmem)
        ! splicer end class.Class1.method.get_m_bool
    end function class1_get_m_bool
    ! end class1_get_m_bool

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_m_bool +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  bool val +intent(setter)
    ! Statement: f_setter_bool
    ! start class1_set_m_bool
    subroutine class1_set_m_bool(obj, val)
        use iso_c_binding, only : C_BOOL
        class(class1), intent(INOUT) :: obj
        logical, value, intent(IN) :: val
        ! splicer begin class.Class1.method.set_m_bool
        logical(C_BOOL) :: SHT_val_cxx
        SHT_val_cxx = val  ! coerce to C_BOOL
        call c_class1_set_m_bool(obj%cxxmem, SHT_val_cxx)
        ! splicer end class.Class1.method.set_m_bool
    end subroutine class1_set_m_bool
    ! end class1_set_m_bool

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  std::string get_m_name +intent(getter)
    ! Statement: f_getter_string_cdesc_allocatable
    ! start class1_get_m_name
    function class1_get_m_name(obj) &
            result(SHT_rv)
        class(class1), intent(INOUT) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin class.Class1.method.get_m_name
        type(CLA_SHROUD_array) :: SHT_rv_cdesc
        call c_class1_get_m_name(obj%cxxmem, SHT_rv_cdesc)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call CLA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        ! splicer end class.Class1.method.get_m_name
    end function class1_get_m_name
    ! end class1_get_m_name

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_m_name +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  std::string val +intent(setter)
    ! Statement: f_setter_string_buf
    ! start class1_set_m_name
    subroutine class1_set_m_name(obj, val)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        character(len=*), intent(IN) :: val
        ! splicer begin class.Class1.method.set_m_name
        integer(C_INT) SHT_val_len
        SHT_val_len = len(val, kind=C_INT)
        call c_class1_set_m_name(obj%cxxmem, val, SHT_val_len)
        ! splicer end class.Class1.method.set_m_name
    end subroutine class1_set_m_name
    ! end class1_set_m_name

    ! Return pointer to C++ memory.
    function class1_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class1), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function class1_get_instance

    subroutine class1_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class1), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine class1_set_instance

    function class1_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class1), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function class1_associated

    ! splicer begin class.Class1.additional_functions
    ! splicer end class.Class1.additional_functions

    ! ----------------------------------------
    ! Function:  const std::string &getName
    ! Statement: f_function_string&_cdesc_allocatable
    !>
    !! \brief test helper
    !!
    !<
    function class2_get_name(obj) &
            result(SHT_rv)
        class(class2), intent(INOUT) :: obj
        character(len=:), allocatable :: SHT_rv
        ! splicer begin class.Class2.method.get_name
        type(CLA_SHROUD_array) :: SHT_rv_cdesc
        type(CLA_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_class2_get_name_bufferify(obj%cxxmem, SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call CLA_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call CLA_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end class.Class2.method.get_name
    end function class2_get_name

    ! Return pointer to C++ memory.
    function class2_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class2), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function class2_get_instance

    subroutine class2_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class2), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine class2_set_instance

    function class2_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class2), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function class2_associated

    ! splicer begin class.Class2.additional_functions
    ! splicer end class.Class2.additional_functions

    ! ----------------------------------------
    ! Function:  static Singleton &getReference
    ! Statement: f_function_shadow&_capsule
    ! start singleton_get_reference
    function singleton_get_reference() &
            result(SHT_rv)
        type(singleton) :: SHT_rv
        ! splicer begin class.Singleton.method.get_reference
        call c_singleton_get_reference_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Singleton.method.get_reference
    end function singleton_get_reference
    ! end singleton_get_reference

    ! splicer begin class.Singleton.additional_functions
    ! splicer end class.Singleton.additional_functions

    ! ----------------------------------------
    ! Function:  Shape
    ! Statement: f_ctor_shadow_capsule
    function shape_ctor() &
            result(SHT_rv)
        type(shape) :: SHT_rv
        ! splicer begin class.Shape.method.ctor
        call c_shape_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Shape.method.ctor
    end function shape_ctor

    ! ----------------------------------------
    ! Function:  int get_ivar
    ! Statement: f_function_native
    function shape_get_ivar(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(shape), intent(IN) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Shape.method.get_ivar
        SHT_rv = c_shape_get_ivar(obj%cxxmem)
        ! splicer end class.Shape.method.get_ivar
    end function shape_get_ivar

    ! Return pointer to C++ memory.
    function shape_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(shape), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function shape_get_instance

    subroutine shape_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(shape), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine shape_set_instance

    function shape_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(shape), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function shape_associated

    ! splicer begin class.Shape.additional_functions
    ! splicer end class.Shape.additional_functions

    ! ----------------------------------------
    ! Function:  Circle
    ! Statement: f_ctor_shadow_capsule
    function circle_ctor() &
            result(SHT_rv)
        type(circle) :: SHT_rv
        ! splicer begin class.Circle.method.ctor
        call c_circle_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Circle.method.ctor
    end function circle_ctor

    ! splicer begin class.Circle.additional_functions
    ! splicer end class.Circle.additional_functions

    ! ----------------------------------------
    ! Function:  void allocate
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    ! start data_allocate
    subroutine data_allocate(obj, n)
        use iso_c_binding, only : C_INT
        class(data), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: n
        ! splicer begin class.Data.method.allocate
        call c_data_allocate(obj%cxxmem, n)
        ! splicer end class.Data.method.allocate
    end subroutine data_allocate
    ! end data_allocate

    ! ----------------------------------------
    ! Function:  void free
    ! Statement: f_subroutine
    ! start data_free
    subroutine data_free(obj)
        class(data), intent(INOUT) :: obj
        ! splicer begin class.Data.method.free
        call c_data_free(obj%cxxmem)
        ! splicer end class.Data.method.free
    end subroutine data_free
    ! end data_free

    ! ----------------------------------------
    ! Function:  Data
    ! Statement: f_ctor_shadow_capsule
    ! start data_ctor
    function data_ctor() &
            result(SHT_rv)
        type(data) :: SHT_rv
        ! splicer begin class.Data.method.ctor
        call c_data_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Data.method.ctor
    end function data_ctor
    ! end data_ctor

    ! ----------------------------------------
    ! Function:  ~Data
    ! Statement: f_dtor
    ! start data_dtor
    subroutine data_dtor(obj)
        class(data), intent(INOUT) :: obj
        ! splicer begin class.Data.method.dtor
        call c_data_dtor(obj%cxxmem)
        ! splicer end class.Data.method.dtor
    end subroutine data_dtor
    ! end data_dtor

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_nitems +intent(getter)
    ! Statement: f_getter_native
    ! start data_get_nitems
    function data_get_nitems(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(data), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Data.method.get_nitems
        SHT_rv = c_data_get_nitems(obj%cxxmem)
        ! splicer end class.Data.method.get_nitems
    end function data_get_nitems
    ! end data_get_nitems

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_nitems +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start data_set_nitems
    subroutine data_set_nitems(obj, val)
        use iso_c_binding, only : C_INT
        class(data), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Data.method.set_nitems
        call c_data_set_nitems(obj%cxxmem, val)
        ! splicer end class.Data.method.set_nitems
    end subroutine data_set_nitems
    ! end data_set_nitems

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int *get_items +dimension(nitems)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! start data_get_items
    function data_get_items(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        class(data), intent(INOUT) :: obj
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin class.Data.method.get_items
        type(CLA_SHROUD_array) :: SHT_rv_cdesc
        call c_data_get_items(obj%cxxmem, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end class.Data.method.get_items
    end function data_get_items
    ! end data_get_items

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_items +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    ! start data_set_items
    subroutine data_set_items(obj, val)
        use iso_c_binding, only : C_INT
        class(data), intent(INOUT) :: obj
        integer(C_INT), intent(IN) :: val(:)
        ! splicer begin class.Data.method.set_items
        call c_data_set_items(obj%cxxmem, val)
        ! splicer end class.Data.method.set_items
    end subroutine data_set_items
    ! end data_set_items

    ! splicer begin class.Data.additional_functions
    ! splicer end class.Data.additional_functions

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  Class1::DIRECTION directionFunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  Class1::DIRECTION arg
    ! Statement: f_in_enum
    function direction_func(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.direction_func
        SHT_rv = c_direction_func_bufferify(arg)
        ! splicer end function.direction_func
    end function direction_func
#endif

    ! ----------------------------------------
    ! Function:  void passClassByValue
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Class1 arg
    ! Statement: f_in_shadow
    !>
    !! \brief Pass arguments to a function.
    !!
    !<
    subroutine pass_class_by_value(arg)
        type(class1), intent(IN) :: arg
        ! splicer begin function.pass_class_by_value
        call c_pass_class_by_value(arg%cxxmem)
        ! splicer end function.pass_class_by_value
    end subroutine pass_class_by_value

    ! ----------------------------------------
    ! Function:  int useclass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Class1 *arg
    ! Statement: f_in_shadow*
    function useclass(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        type(class1), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.useclass
        SHT_rv = c_useclass(arg%cxxmem)
        ! splicer end function.useclass
    end function useclass

    ! ----------------------------------------
    ! Function:  const Class1 *getclass2
    ! Statement: f_function_shadow*_capsule
    !>
    !! \brief Return const class pointer
    !!
    !<
    function getclass2() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.getclass2
        call c_getclass2_bufferify(SHT_rv%cxxmem)
        ! splicer end function.getclass2
    end function getclass2

    ! ----------------------------------------
    ! Function:  Class1 *getclass3
    ! Statement: f_function_shadow*_capsule
    !>
    !! \brief Return class pointer
    !!
    !<
    function getclass3() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.getclass3
        call c_getclass3_bufferify(SHT_rv%cxxmem)
        ! splicer end function.getclass3
    end function getclass3

    ! ----------------------------------------
    ! Function:  const Class1 *getclass2_void
    ! Statement: f_function_shadow*_capsule
    !>
    !! \brief C wrapper will return void
    !!
    !<
    function getclass2_void() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.getclass2_void
        call c_getclass2_void(SHT_rv%cxxmem)
        ! splicer end function.getclass2_void
    end function getclass2_void

    ! ----------------------------------------
    ! Function:  Class1 *getclass3_void
    ! Statement: f_function_shadow*_capsule
    !>
    !! \brief C wrapper will return void
    !!
    !<
    function getclass3_void() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.getclass3_void
        call c_getclass3_void(SHT_rv%cxxmem)
        ! splicer end function.getclass3_void
    end function getclass3_void

    ! ----------------------------------------
    ! Function:  const Class1 &getConstClassReference
    ! Statement: f_function_shadow&_capsule
    function get_const_class_reference() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.get_const_class_reference
        call c_get_const_class_reference_bufferify(SHT_rv%cxxmem)
        ! splicer end function.get_const_class_reference
    end function get_const_class_reference

    ! ----------------------------------------
    ! Function:  Class1 &getClassReference
    ! Statement: f_function_shadow&_capsule
    function get_class_reference() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.get_class_reference
        call c_get_class_reference_bufferify(SHT_rv%cxxmem)
        ! splicer end function.get_class_reference
    end function get_class_reference

    ! ----------------------------------------
    ! Function:  Class1 getClassCopy
    ! Statement: f_function_shadow_capsule
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    !>
    !! \brief Return Class1 instance by value, uses copy constructor
    !!
    !<
    function get_class_copy(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: flag
        type(class1) :: SHT_rv
        ! splicer begin function.get_class_copy
        call c_get_class_copy_bufferify(flag, SHT_rv%cxxmem)
        ! splicer end function.get_class_copy
    end function get_class_copy

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void set_global_flag
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int arg
    ! Statement: f_in_native
    subroutine set_global_flag(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: arg
        ! splicer begin function.set_global_flag
        call c_set_global_flag(arg)
        ! splicer end function.set_global_flag
    end subroutine set_global_flag
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int get_global_flag
    ! Statement: f_function_native
    function get_global_flag() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.get_global_flag
        SHT_rv = c_get_global_flag()
        ! splicer end function.get_global_flag
    end function get_global_flag
#endif

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: f_function_string&_buf_copy
    function last_function_called() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.last_function_called
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_last_function_called_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.last_function_called
    end function last_function_called

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function class1_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_eq

    function class1_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_ne

    function class2_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class2), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class2_eq

    function class2_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class2), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class2_ne

    function singleton_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(singleton), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function singleton_eq

    function singleton_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(singleton), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function singleton_ne

    function shape_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(shape), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function shape_eq

    function shape_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(shape), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function shape_ne

    function circle_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(circle), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function circle_eq

    function circle_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(circle), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function circle_ne

    function data_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(data), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function data_eq

    function data_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(data), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function data_ne

end module classes_mod
