// wrapclasses.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "classes.hpp"
// typemap
#include <string>
// shroud
#include <cstring>
#include "wrapclasses.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  Class1::DIRECTION directionFunc
// Statement: c_function_enum
// ----------------------------------------
// Argument:  Class1::DIRECTION arg
// Statement: c_in_enum
enum CLA_Class1_DIRECTION CLA_directionFunc(
    enum CLA_Class1_DIRECTION arg)
{
    // splicer begin function.directionFunc
    classes::Class1::DIRECTION SHCXX_arg =
        static_cast<classes::Class1::DIRECTION>(arg);
    classes::Class1::DIRECTION SHCXX_rv = classes::directionFunc(
        SHCXX_arg);
    enum CLA_Class1_DIRECTION SHC_rv =
        static_cast<enum CLA_Class1_DIRECTION>(SHCXX_rv);
    return SHC_rv;
    // splicer end function.directionFunc
}

// ----------------------------------------
// Function:  Class1::DIRECTION directionFunc
// Statement: f_function_enum
// ----------------------------------------
// Argument:  Class1::DIRECTION arg
// Statement: f_in_enum
int CLA_directionFunc_bufferify(int arg)
{
    // splicer begin function.directionFunc_bufferify
    classes::Class1::DIRECTION SHCXX_arg =
        static_cast<classes::Class1::DIRECTION>(arg);
    classes::Class1::DIRECTION SHCXX_rv = classes::directionFunc(
        SHCXX_arg);
    int SHC_rv = static_cast<int>(SHCXX_rv);
    return SHC_rv;
    // splicer end function.directionFunc_bufferify
}

/**
 * \brief Pass arguments to a function.
 *
 */
// ----------------------------------------
// Function:  void passClassByValue
// Statement: c_subroutine
// ----------------------------------------
// Argument:  Class1 arg
// Statement: c_in_shadow
void CLA_passClassByValue(CLA_Class1 arg)
{
    // splicer begin function.passClassByValue
    classes::Class1 * SHC_arg_cxx = static_cast<classes::Class1 *>
        (arg.addr);
    classes::passClassByValue(*SHC_arg_cxx);
    // splicer end function.passClassByValue
}

// ----------------------------------------
// Function:  int useclass
// Statement: c_function_native
// ----------------------------------------
// Argument:  const Class1 *arg
// Statement: c_in_shadow*
int CLA_useclass(CLA_Class1 * arg)
{
    // splicer begin function.useclass
    const classes::Class1 * SHC_arg_cxx =
        static_cast<const classes::Class1 *>(arg->addr);
    int SHC_rv = classes::useclass(SHC_arg_cxx);
    return SHC_rv;
    // splicer end function.useclass
}

/**
 * \brief Return const class pointer
 *
 */
// ----------------------------------------
// Function:  const Class1 *getclass2
// Statement: c_function_shadow*_capptr
CLA_Class1 * CLA_getclass2(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass2
    const classes::Class1 *SHC_rv_cxx = classes::getclass2();
    SHC_rv->addr  = const_cast<classes::Class1 *>(SHC_rv_cxx);
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.getclass2
}

/**
 * \brief Return const class pointer
 *
 */
// ----------------------------------------
// Function:  const Class1 *getclass2
// Statement: f_function_shadow*_capsule
void CLA_getclass2_bufferify(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass2_bufferify
    const classes::Class1 *SHC_rv_cxx = classes::getclass2();
    SHC_rv->addr  = const_cast<classes::Class1 *>(SHC_rv_cxx);
    SHC_rv->idtor = 0;
    // splicer end function.getclass2_bufferify
}

/**
 * \brief Return class pointer
 *
 */
// ----------------------------------------
// Function:  Class1 *getclass3
// Statement: c_function_shadow*_capptr
CLA_Class1 * CLA_getclass3(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass3
    classes::Class1 *SHC_rv_cxx = classes::getclass3();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.getclass3
}

/**
 * \brief Return class pointer
 *
 */
// ----------------------------------------
// Function:  Class1 *getclass3
// Statement: f_function_shadow*_capsule
void CLA_getclass3_bufferify(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass3_bufferify
    classes::Class1 *SHC_rv_cxx = classes::getclass3();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.getclass3_bufferify
}

/**
 * \brief C wrapper will return void
 *
 */
// ----------------------------------------
// Function:  const Class1 *getclass2_void
// Statement: c_function_shadow*_capsule
void CLA_getclass2_void(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass2_void
    const classes::Class1 *SHC_rv_cxx = classes::getclass2_void();
    SHC_rv->addr  = const_cast<classes::Class1 *>(SHC_rv_cxx);
    SHC_rv->idtor = 0;
    // splicer end function.getclass2_void
}

/**
 * \brief C wrapper will return void
 *
 */
// ----------------------------------------
// Function:  Class1 *getclass3_void
// Statement: c_function_shadow*_capsule
void CLA_getclass3_void(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getclass3_void
    classes::Class1 *SHC_rv_cxx = classes::getclass3_void();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.getclass3_void
}

// ----------------------------------------
// Function:  const Class1 &getConstClassReference
// Statement: c_function_shadow&_capptr
CLA_Class1 * CLA_getConstClassReference(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getConstClassReference
    const classes::Class1 &SHC_rv_cxx = classes::getConstClassReference(
        );
    SHC_rv->addr  = const_cast<classes::Class1 *>(&SHC_rv_cxx);
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.getConstClassReference
}

// ----------------------------------------
// Function:  const Class1 &getConstClassReference
// Statement: f_function_shadow&_capsule
void CLA_getConstClassReference_bufferify(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getConstClassReference_bufferify
    const classes::Class1 &SHC_rv_cxx = classes::getConstClassReference(
        );
    SHC_rv->addr  = const_cast<classes::Class1 *>(&SHC_rv_cxx);
    SHC_rv->idtor = 0;
    // splicer end function.getConstClassReference_bufferify
}

// ----------------------------------------
// Function:  Class1 &getClassReference
// Statement: c_function_shadow&_capptr
CLA_Class1 * CLA_getClassReference(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getClassReference
    classes::Class1 &SHC_rv_cxx = classes::getClassReference();
    SHC_rv->addr  = &SHC_rv_cxx;
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.getClassReference
}

// ----------------------------------------
// Function:  Class1 &getClassReference
// Statement: f_function_shadow&_capsule
void CLA_getClassReference_bufferify(CLA_Class1 * SHC_rv)
{
    // splicer begin function.getClassReference_bufferify
    classes::Class1 &SHC_rv_cxx = classes::getClassReference();
    SHC_rv->addr  = &SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.getClassReference_bufferify
}

/**
 * \brief Return Class1 instance by value, uses copy constructor
 *
 */
// ----------------------------------------
// Function:  Class1 getClassCopy
// Statement: c_function_shadow_capptr
// ----------------------------------------
// Argument:  int flag
// Statement: c_in_native
CLA_Class1 * CLA_getClassCopy(int flag, CLA_Class1 * SHC_rv)
{
    // splicer begin function.getClassCopy
    classes::Class1 *SHC_rv_cxx = new classes::Class1;
    *SHC_rv_cxx = classes::getClassCopy(flag);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 1;
    return SHC_rv;
    // splicer end function.getClassCopy
}

/**
 * \brief Return Class1 instance by value, uses copy constructor
 *
 */
// ----------------------------------------
// Function:  Class1 getClassCopy
// Statement: f_function_shadow_capsule
// ----------------------------------------
// Argument:  int flag
// Statement: f_in_native
void CLA_getClassCopy_bufferify(int flag, CLA_Class1 * SHC_rv)
{
    // splicer begin function.getClassCopy_bufferify
    classes::Class1 *SHC_rv_cxx = new classes::Class1;
    *SHC_rv_cxx = classes::getClassCopy(flag);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 1;
    // splicer end function.getClassCopy_bufferify
}

// ----------------------------------------
// Function:  void set_global_flag
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int arg
// Statement: c_in_native
void CLA_set_global_flag(int arg)
{
    // splicer begin function.set_global_flag
    classes::set_global_flag(arg);
    // splicer end function.set_global_flag
}

// ----------------------------------------
// Function:  int get_global_flag
// Statement: c_function_native
int CLA_get_global_flag(void)
{
    // splicer begin function.get_global_flag
    int SHC_rv = classes::get_global_flag();
    return SHC_rv;
    // splicer end function.get_global_flag
}

// ----------------------------------------
// Function:  const std::string &LastFunctionCalled +len(30)
// Statement: c_function_string&
const char * CLA_LastFunctionCalled(void)
{
    // splicer begin function.LastFunctionCalled
    const std::string &SHCXX_rv = classes::LastFunctionCalled();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.LastFunctionCalled
}

// ----------------------------------------
// Function:  const std::string &LastFunctionCalled +len(30)
// Statement: f_function_string&_buf_copy
void CLA_LastFunctionCalled_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.LastFunctionCalled_bufferify
    const std::string &SHCXX_rv = classes::LastFunctionCalled();
    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.LastFunctionCalled_bufferify
}

}  // extern "C"
