// wrapClass2.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "classes.hpp"
// typemap
#include <string>
// shroud
#include <cstddef>
#include <cstring>
#include "wrapClass2.h"

// splicer begin class.Class2.CXX_definitions
// splicer end class.Class2.CXX_definitions

extern "C" {


// start helper string_to_cdesc
// helper string_to_cdesc
// Save std::string metadata into array to allow Fortran to access values.
// CHARACTER(len=elem_size) src
static void ShroudStringToCdesc(CLA_SHROUD_array *cdesc,
    const std::string * src)
{
    if (src->empty()) {
        cdesc->base_addr = NULL;
        cdesc->elem_len = 0;
    } else {
        cdesc->base_addr = const_cast<char *>(src->data());
        cdesc->elem_len = src->length();
    }
    cdesc->size = 1;
    cdesc->rank = 0;  // scalar
}
// end helper string_to_cdesc

// splicer begin class.Class2.C_definitions
// splicer end class.Class2.C_definitions

/**
 * \brief test helper
 *
 */
// ----------------------------------------
// Function:  const std::string &getName
// Statement: c_function_string&
const char * CLA_Class2_getName(CLA_Class2 * self)
{
    classes::Class2 *SH_this = static_cast<classes::Class2 *>
        (self->addr);
    // splicer begin class.Class2.method.getName
    const std::string &SHCXX_rv = SH_this->getName();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end class.Class2.method.getName
}

/**
 * \brief test helper
 *
 */
// ----------------------------------------
// Function:  const std::string &getName
// Statement: f_function_string&_cdesc_allocatable
void CLA_Class2_getName_bufferify(CLA_Class2 * self,
    CLA_SHROUD_array *SHT_rv_cdesc,
    CLA_SHROUD_capsule_data *SHT_rv_capsule)
{
    classes::Class2 *SH_this = static_cast<classes::Class2 *>
        (self->addr);
    // splicer begin class.Class2.method.getName_bufferify
    const std::string &SHCXX_rv = SH_this->getName();
    ShroudStringToCdesc(SHT_rv_cdesc, &SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(&SHCXX_rv);
    SHT_rv_capsule->idtor = 0;
    // splicer end class.Class2.method.getName_bufferify
}

}  // extern "C"
