// pyccomplexmodule.c
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
#include "pyccomplexmodule.h"

// splicer begin include
// splicer end include

#ifdef __cplusplus
#define SHROUD_UNUSED(param)
#else
#define SHROUD_UNUSED(param) param
#endif

#if PY_MAJOR_VERSION >= 3
#define PyInt_AsLong PyLong_AsLong
#define PyInt_FromLong PyLong_FromLong
#define PyInt_FromSize_t PyLong_FromSize_t
#define PyString_FromString PyUnicode_FromString
#define PyString_FromStringAndSize PyUnicode_FromStringAndSize
#endif

// splicer begin C_definition
// splicer end C_definition
PyObject *PY_error_obj;

// splicer begin additional_functions
// splicer end additional_functions

// ----------------------------------------
// Function:  void acceptDoubleComplexInoutPtr
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double complex *arg1
// Statement: py_inout_native*
static char PY_acceptDoubleComplexInoutPtr__doc__[] =
"documentation"
;

static PyObject *
PY_acceptDoubleComplexInoutPtr(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.acceptDoubleComplexInoutPtr
    double complex arg1;
    Py_complex SHCPY_arg1;
    char *SHT_kwlist[] = {
        "arg1",
        NULL };
    PyObject * SHPy_arg1 = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds,
        "D:acceptDoubleComplexInoutPtr", SHT_kwlist, &SHCPY_arg1))
        return NULL;

    // post_parse
    arg1 = SHCPY_arg1.real + SHCPY_arg1.imag * I;

    acceptDoubleComplexInoutPtr(&arg1);

    // post_call
    SHPy_arg1 = PyComplex_FromDoubles(creal(arg1), cimag(arg1));

    return (PyObject *) SHPy_arg1;
// splicer end function.acceptDoubleComplexInoutPtr
}

// ----------------------------------------
// Function:  void acceptDoubleComplexOutPtr
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double complex *arg1 +intent(out)
// Statement: py_out_native*
static char PY_acceptDoubleComplexOutPtr__doc__[] =
"documentation"
;

static PyObject *
PY_acceptDoubleComplexOutPtr(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.acceptDoubleComplexOutPtr
    double complex arg1;
    PyObject * SHPy_arg1 = NULL;

    acceptDoubleComplexOutPtr(&arg1);

    // post_call
    SHPy_arg1 = PyComplex_FromDoubles(creal(arg1), cimag(arg1));

    return (PyObject *) SHPy_arg1;
// splicer end function.acceptDoubleComplexOutPtr
}

// ----------------------------------------
// Function:  void acceptDoubleComplexInoutPtrFlag
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double complex *arg1
// Statement: py_inout_native*
// ----------------------------------------
// Argument:  int *flag +intent(out)
// Statement: py_out_native*
static char PY_acceptDoubleComplexInoutPtrFlag__doc__[] =
"documentation"
;

/**
 * Return two values so Py_BuildValue is used.
 */
static PyObject *
PY_acceptDoubleComplexInoutPtrFlag(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.acceptDoubleComplexInoutPtrFlag
    double complex arg1;
    Py_complex SHCPY_arg1;
    int flag;
    char *SHT_kwlist[] = {
        "arg1",
        NULL };
    PyObject *SHTPy_rv = NULL;  // return value object

    if (!PyArg_ParseTupleAndKeywords(args, kwds,
        "D:acceptDoubleComplexInoutPtrFlag", SHT_kwlist, &SHCPY_arg1))
        return NULL;

    // post_parse
    arg1 = SHCPY_arg1.real + SHCPY_arg1.imag * I;

    acceptDoubleComplexInoutPtrFlag(&arg1, &flag);

    // post_call
    SHCPY_arg1.real = creal(arg1);
    SHCPY_arg1.imag = cimag(arg1);
    SHTPy_rv = Py_BuildValue("Di", &SHCPY_arg1, flag);

    return SHTPy_rv;
// splicer end function.acceptDoubleComplexInoutPtrFlag
}

// ----------------------------------------
// Function:  void acceptDoubleComplexOutPtrFlag
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double complex *arg1 +intent(out)
// Statement: py_out_native*
// ----------------------------------------
// Argument:  int *flag +intent(out)
// Statement: py_out_native*
static char PY_acceptDoubleComplexOutPtrFlag__doc__[] =
"documentation"
;

/**
 * Return two values so Py_BuildValue is used.
 * Creates a Py_complex for intent(out)
 */
static PyObject *
PY_acceptDoubleComplexOutPtrFlag(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.acceptDoubleComplexOutPtrFlag
    double complex arg1;
    int flag;
    Py_complex SHCPY_arg1;
    PyObject *SHTPy_rv = NULL;  // return value object

    acceptDoubleComplexOutPtrFlag(&arg1, &flag);

    // post_call
    SHCPY_arg1.real = creal(arg1);
    SHCPY_arg1.imag = cimag(arg1);
    SHTPy_rv = Py_BuildValue("Di", &SHCPY_arg1, flag);

    return SHTPy_rv;
// splicer end function.acceptDoubleComplexOutPtrFlag
}
static PyMethodDef PY_methods[] = {
{"acceptDoubleComplexInoutPtr",
    (PyCFunction)PY_acceptDoubleComplexInoutPtr,
    METH_VARARGS|METH_KEYWORDS, PY_acceptDoubleComplexInoutPtr__doc__},
{"acceptDoubleComplexOutPtr", (PyCFunction)PY_acceptDoubleComplexOutPtr,
    METH_NOARGS, PY_acceptDoubleComplexOutPtr__doc__},
{"acceptDoubleComplexInoutPtrFlag",
    (PyCFunction)PY_acceptDoubleComplexInoutPtrFlag,
    METH_VARARGS|METH_KEYWORDS,
    PY_acceptDoubleComplexInoutPtrFlag__doc__},
{"acceptDoubleComplexOutPtrFlag",
    (PyCFunction)PY_acceptDoubleComplexOutPtrFlag, METH_NOARGS,
    PY_acceptDoubleComplexOutPtrFlag__doc__},
{NULL,   (PyCFunction)NULL, 0, NULL}            /* sentinel */
};

/*
 * initccomplex - Initialization function for the module
 * *must* be called initccomplex
 */
static char PY__doc__[] =
"library documentation"
;

struct module_state {
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

#if PY_MAJOR_VERSION >= 3
static int ccomplex_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int ccomplex_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "ccomplex", /* m_name */
    PY__doc__, /* m_doc */
    sizeof(struct module_state), /* m_size */
    PY_methods, /* m_methods */
    NULL, /* m_reload */
    ccomplex_traverse, /* m_traverse */
    ccomplex_clear, /* m_clear */
    NULL  /* m_free */
};

#define RETVAL m
#define INITERROR return NULL
#else
#define RETVAL
#define INITERROR return
#endif

PyMODINIT_FUNC
#if PY_MAJOR_VERSION >= 3
PyInit_ccomplex(void)
#else
initccomplex(void)
#endif
{
    PyObject *m = NULL;
    const char * error_name = "ccomplex.Error";

    // splicer begin C_init_locals
    // splicer end C_init_locals


    /* Create the module and add the functions */
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule4("ccomplex", PY_methods,
        PY__doc__,
        (PyObject*)NULL,PYTHON_API_VERSION);
#endif
    if (m == NULL)
        return RETVAL;
    struct module_state *st = GETSTATE(m);

    PY_error_obj = PyErr_NewException((char *) error_name, NULL, NULL);
    if (PY_error_obj == NULL)
        return RETVAL;
    st->error = PY_error_obj;
    PyModule_AddObject(m, "Error", st->error);

    // splicer begin C_init_body
    // splicer end C_init_body

    /* Check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module ccomplex");
    return RETVAL;
}

