! wrapfarrayclass.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfarrayclass.f
!! \brief Shroud generated wrapper for arrayclass library
!<
! splicer begin file_top
! splicer end file_top
module arrayclass_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! helper array_context
    type, bind(C) :: ARR_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type ARR_SHROUD_array

    ! helper capsule_data_helper
    type, bind(C) :: ARR_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type ARR_SHROUD_capsule_data

    type ArrayWrapper
        type(ARR_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.ArrayWrapper.component_part
        ! splicer end class.ArrayWrapper.component_part
    contains
        procedure :: setSize => ArrayWrapper_setSize
        procedure :: getSize => ArrayWrapper_getSize
        procedure :: fillSize => ArrayWrapper_fillSize
        procedure :: allocate => ArrayWrapper_allocate
        procedure :: getArray => ArrayWrapper_getArray
        procedure :: getArrayConst => ArrayWrapper_getArrayConst
        procedure :: getArrayC => ArrayWrapper_getArrayC
        procedure :: getArrayConstC => ArrayWrapper_getArrayConstC
        procedure :: fetchArrayPtr => ArrayWrapper_fetchArrayPtr
        procedure :: fetchArrayRef => ArrayWrapper_fetchArrayRef
        procedure :: fetchArrayPtrConst => ArrayWrapper_fetchArrayPtrConst
        procedure :: fetchArrayRefConst => ArrayWrapper_fetchArrayRefConst
        procedure :: fetchVoidPtr => ArrayWrapper_fetchVoidPtr
        procedure :: fetchVoidRef => ArrayWrapper_fetchVoidRef
        procedure :: checkPtr => ArrayWrapper_checkPtr
        procedure :: sumArray => ArrayWrapper_sumArray
        procedure :: get_instance => ArrayWrapper_get_instance
        procedure :: set_instance => ArrayWrapper_set_instance
        procedure :: associated => ArrayWrapper_associated
        ! splicer begin class.ArrayWrapper.type_bound_procedure_part
        ! splicer end class.ArrayWrapper.type_bound_procedure_part
    end type ArrayWrapper

    interface operator (.eq.)
        module procedure ArrayWrapper_eq
    end interface

    interface operator (.ne.)
        module procedure ArrayWrapper_ne
    end interface

    interface

        ! ----------------------------------------
        ! Function:  ArrayWrapper
        ! Statement: c_ctor_shadow_capptr
        function c_ArrayWrapper_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="ARR_ArrayWrapper_ctor")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_ArrayWrapper_ctor

        ! ----------------------------------------
        ! Function:  ArrayWrapper
        ! Statement: f_ctor_shadow_capsule
        subroutine c_ArrayWrapper_ctor_bufferify(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_ctor_bufferify")
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_ArrayWrapper_ctor_bufferify

        ! ----------------------------------------
        ! Function:  void setSize
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int size
        ! Statement: f_in_native
        subroutine c_ArrayWrapper_setSize(self, size) &
                bind(C, name="ARR_ArrayWrapper_setSize")
            use iso_c_binding, only : C_INT
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: size
        end subroutine c_ArrayWrapper_setSize

        ! ----------------------------------------
        ! Function:  int getSize
        ! Statement: f_function_native
        pure function c_ArrayWrapper_getSize(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_getSize")
            use iso_c_binding, only : C_INT
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_ArrayWrapper_getSize

        ! ----------------------------------------
        ! Function:  void fillSize
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int &size +intent(out)
        ! Statement: f_out_native&
        subroutine c_ArrayWrapper_fillSize(self, size) &
                bind(C, name="ARR_ArrayWrapper_fillSize")
            use iso_c_binding, only : C_INT
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), intent(OUT) :: size
        end subroutine c_ArrayWrapper_fillSize

        ! ----------------------------------------
        ! Function:  void allocate
        ! Statement: f_subroutine
        subroutine c_ArrayWrapper_allocate(self) &
                bind(C, name="ARR_ArrayWrapper_allocate")
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
        end subroutine c_ArrayWrapper_allocate

        ! ----------------------------------------
        ! Function:  double *getArray +dimension(getSize())
        ! Statement: c_function_native*
        function c_ArrayWrapper_getArray(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_getArray")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ArrayWrapper_getArray

        ! ----------------------------------------
        ! Function:  double *getArray +dimension(getSize())
        ! Statement: f_function_native*_cdesc_pointer
        subroutine c_ArrayWrapper_getArray_bufferify(self, SHT_rv_cdesc) &
                bind(C, name="ARR_ArrayWrapper_getArray_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_ArrayWrapper_getArray_bufferify

        ! ----------------------------------------
        ! Function:  double *getArrayConst +dimension(getSize())
        ! Statement: c_function_native*
        pure function c_ArrayWrapper_getArrayConst(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_getArrayConst")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ArrayWrapper_getArrayConst

        ! ----------------------------------------
        ! Function:  double *getArrayConst +dimension(getSize())
        ! Statement: f_function_native*_cdesc_pointer
        subroutine c_ArrayWrapper_getArrayConst_bufferify(self, &
                SHT_rv_cdesc) &
                bind(C, name="ARR_ArrayWrapper_getArrayConst_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_ArrayWrapper_getArrayConst_bufferify

        ! ----------------------------------------
        ! Function:  const double *getArrayC +dimension(getSize())
        ! Statement: c_function_native*
        function c_ArrayWrapper_getArrayC(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_getArrayC")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ArrayWrapper_getArrayC

        ! ----------------------------------------
        ! Function:  const double *getArrayC +dimension(getSize())
        ! Statement: f_function_native*_cdesc_pointer
        subroutine c_ArrayWrapper_getArrayC_bufferify(self, &
                SHT_rv_cdesc) &
                bind(C, name="ARR_ArrayWrapper_getArrayC_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_ArrayWrapper_getArrayC_bufferify

        ! ----------------------------------------
        ! Function:  const double *getArrayConstC +dimension(getSize())
        ! Statement: c_function_native*
        pure function c_ArrayWrapper_getArrayConstC(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_getArrayConstC")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR) :: SHT_rv
        end function c_ArrayWrapper_getArrayConstC

        ! ----------------------------------------
        ! Function:  const double *getArrayConstC +dimension(getSize())
        ! Statement: f_function_native*_cdesc_pointer
        subroutine c_ArrayWrapper_getArrayConstC_bufferify(self, &
                SHT_rv_cdesc) &
                bind(C, name="ARR_ArrayWrapper_getArrayConstC_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_ArrayWrapper_getArrayConstC_bufferify

        ! ----------------------------------------
        ! Function:  void fetchArrayPtr
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  double **array +dimension(isize)+intent(out)
        ! Statement: c_out_native**
        ! ----------------------------------------
        ! Argument:  int *isize +hidden
        ! Statement: c_inout_native*
        subroutine c_ArrayWrapper_fetchArrayPtr(self, array, isize) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayPtr")
            use iso_c_binding, only : C_INT, C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
            integer(C_INT), intent(INOUT) :: isize
        end subroutine c_ArrayWrapper_fetchArrayPtr

        ! ----------------------------------------
        ! Function:  void fetchArrayPtr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double **array +dimension(isize)+intent(out)
        ! Statement: f_out_native**_cdesc_pointer
        subroutine c_ArrayWrapper_fetchArrayPtr_bufferify(self, &
                SHT_array_cdesc) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayPtr_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_array_cdesc
        end subroutine c_ArrayWrapper_fetchArrayPtr_bufferify

        ! ----------------------------------------
        ! Function:  void fetchArrayRef
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  double *&array +dimension(isize)+intent(out)
        ! Statement: c_out_native*&
        ! ----------------------------------------
        ! Argument:  int &isize +hidden
        ! Statement: c_inout_native&
        subroutine c_ArrayWrapper_fetchArrayRef(self, array, isize) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayRef")
            use iso_c_binding, only : C_INT, C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
            integer(C_INT), intent(INOUT) :: isize
        end subroutine c_ArrayWrapper_fetchArrayRef

        ! ----------------------------------------
        ! Function:  void fetchArrayRef
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  double *&array +dimension(isize)+intent(out)
        ! Statement: f_out_native*&_cdesc_pointer
        subroutine c_ArrayWrapper_fetchArrayRef_bufferify(self, &
                SHT_array_cdesc) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayRef_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_array_cdesc
        end subroutine c_ArrayWrapper_fetchArrayRef_bufferify

        ! ----------------------------------------
        ! Function:  void fetchArrayPtrConst
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  const double **array +dimension(isize)+intent(out)
        ! Statement: c_out_native**
        ! ----------------------------------------
        ! Argument:  int *isize +hidden
        ! Statement: c_inout_native*
        subroutine c_ArrayWrapper_fetchArrayPtrConst(self, array, isize) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayPtrConst")
            use iso_c_binding, only : C_INT, C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
            integer(C_INT), intent(INOUT) :: isize
        end subroutine c_ArrayWrapper_fetchArrayPtrConst

        ! ----------------------------------------
        ! Function:  void fetchArrayPtrConst
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const double **array +dimension(isize)+intent(out)
        ! Statement: f_out_native**_cdesc_pointer
        subroutine c_ArrayWrapper_fetchArrayPtrConst_bufferify(self, &
                SHT_array_cdesc) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayPtrConst_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_array_cdesc
        end subroutine c_ArrayWrapper_fetchArrayPtrConst_bufferify

        ! ----------------------------------------
        ! Function:  void fetchArrayRefConst
        ! Statement: c_subroutine
        ! ----------------------------------------
        ! Argument:  const double *&array +dimension(isize)+intent(out)
        ! Statement: c_out_native*&
        ! ----------------------------------------
        ! Argument:  int &isize +hidden
        ! Statement: c_inout_native&
        subroutine c_ArrayWrapper_fetchArrayRefConst(self, array, isize) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayRefConst")
            use iso_c_binding, only : C_INT, C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
            integer(C_INT), intent(INOUT) :: isize
        end subroutine c_ArrayWrapper_fetchArrayRefConst

        ! ----------------------------------------
        ! Function:  void fetchArrayRefConst
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const double *&array +dimension(isize)+intent(out)
        ! Statement: f_out_native*&_cdesc_pointer
        subroutine c_ArrayWrapper_fetchArrayRefConst_bufferify(self, &
                SHT_array_cdesc) &
                bind(C, name="ARR_ArrayWrapper_fetchArrayRefConst_bufferify")
            import :: ARR_SHROUD_array, ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(ARR_SHROUD_array), intent(OUT) :: SHT_array_cdesc
        end subroutine c_ArrayWrapper_fetchArrayRefConst_bufferify

        ! ----------------------------------------
        ! Function:  void fetchVoidPtr
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void **array +intent(out)
        ! Statement: f_out_void**
        subroutine c_ArrayWrapper_fetchVoidPtr(self, array) &
                bind(C, name="ARR_ArrayWrapper_fetchVoidPtr")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
        end subroutine c_ArrayWrapper_fetchVoidPtr

        ! ----------------------------------------
        ! Function:  void fetchVoidRef
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  void *&array +intent(out)
        ! Statement: f_out_void*&
        subroutine c_ArrayWrapper_fetchVoidRef(self, array) &
                bind(C, name="ARR_ArrayWrapper_fetchVoidRef")
            use iso_c_binding, only : C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), intent(OUT) :: array
        end subroutine c_ArrayWrapper_fetchVoidRef

        ! ----------------------------------------
        ! Function:  bool checkPtr
        ! Statement: f_function_bool
        ! ----------------------------------------
        ! Argument:  void *array
        ! Statement: f_in_void*
        function c_ArrayWrapper_checkPtr(self, array) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_checkPtr")
            use iso_c_binding, only : C_BOOL, C_PTR
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            type(C_PTR), value, intent(IN) :: array
            logical(C_BOOL) :: SHT_rv
        end function c_ArrayWrapper_checkPtr

        ! ----------------------------------------
        ! Function:  double sumArray
        ! Statement: f_function_native
        function c_ArrayWrapper_sumArray(self) &
                result(SHT_rv) &
                bind(C, name="ARR_ArrayWrapper_sumArray")
            use iso_c_binding, only : C_DOUBLE
            import :: ARR_SHROUD_capsule_data
            implicit none
            type(ARR_SHROUD_capsule_data), intent(IN) :: self
            real(C_DOUBLE) :: SHT_rv
        end function c_ArrayWrapper_sumArray
    end interface

    interface ArrayWrapper
        module procedure ArrayWrapper_ctor
    end interface ArrayWrapper

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  ArrayWrapper
    ! Statement: f_ctor_shadow_capsule
    function ArrayWrapper_ctor() &
            result(SHT_rv)
        type(ArrayWrapper) :: SHT_rv
        ! splicer begin class.ArrayWrapper.method.ctor
        call c_ArrayWrapper_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.ArrayWrapper.method.ctor
    end function ArrayWrapper_ctor

    ! ----------------------------------------
    ! Function:  void setSize
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int size
    ! Statement: f_in_native
    subroutine ArrayWrapper_setSize(obj, size)
        use iso_c_binding, only : C_INT
        class(ArrayWrapper), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: size
        ! splicer begin class.ArrayWrapper.method.setSize
        call c_ArrayWrapper_setSize(obj%cxxmem, size)
        ! splicer end class.ArrayWrapper.method.setSize
    end subroutine ArrayWrapper_setSize

    ! ----------------------------------------
    ! Function:  int getSize
    ! Statement: f_function_native
    function ArrayWrapper_getSize(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(ArrayWrapper), intent(IN) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.ArrayWrapper.method.getSize
        SHT_rv = c_ArrayWrapper_getSize(obj%cxxmem)
        ! splicer end class.ArrayWrapper.method.getSize
    end function ArrayWrapper_getSize

    ! ----------------------------------------
    ! Function:  void fillSize
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int &size +intent(out)
    ! Statement: f_out_native&
    subroutine ArrayWrapper_fillSize(obj, size)
        use iso_c_binding, only : C_INT
        class(ArrayWrapper), intent(INOUT) :: obj
        integer(C_INT), intent(OUT) :: size
        ! splicer begin class.ArrayWrapper.method.fillSize
        call c_ArrayWrapper_fillSize(obj%cxxmem, size)
        ! splicer end class.ArrayWrapper.method.fillSize
    end subroutine ArrayWrapper_fillSize

    ! ----------------------------------------
    ! Function:  void allocate
    ! Statement: f_subroutine
    subroutine ArrayWrapper_allocate(obj)
        class(ArrayWrapper), intent(INOUT) :: obj
        ! splicer begin class.ArrayWrapper.method.allocate
        call c_ArrayWrapper_allocate(obj%cxxmem)
        ! splicer end class.ArrayWrapper.method.allocate
    end subroutine ArrayWrapper_allocate

    ! ----------------------------------------
    ! Function:  double *getArray +dimension(getSize())
    ! Statement: f_function_native*_cdesc_pointer
    function ArrayWrapper_getArray(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), pointer :: SHT_rv(:)
        ! splicer begin class.ArrayWrapper.method.getArray
        type(ARR_SHROUD_array) :: SHT_rv_cdesc
        call c_ArrayWrapper_getArray_bufferify(obj%cxxmem, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.getArray
    end function ArrayWrapper_getArray

    ! ----------------------------------------
    ! Function:  double *getArrayConst +dimension(getSize())
    ! Statement: f_function_native*_cdesc_pointer
    function ArrayWrapper_getArrayConst(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(IN) :: obj
        real(C_DOUBLE), pointer :: SHT_rv(:)
        ! splicer begin class.ArrayWrapper.method.getArrayConst
        type(ARR_SHROUD_array) :: SHT_rv_cdesc
        call c_ArrayWrapper_getArrayConst_bufferify(obj%cxxmem, &
            SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.getArrayConst
    end function ArrayWrapper_getArrayConst

    ! ----------------------------------------
    ! Function:  const double *getArrayC +dimension(getSize())
    ! Statement: f_function_native*_cdesc_pointer
    function ArrayWrapper_getArrayC(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), pointer :: SHT_rv(:)
        ! splicer begin class.ArrayWrapper.method.getArrayC
        type(ARR_SHROUD_array) :: SHT_rv_cdesc
        call c_ArrayWrapper_getArrayC_bufferify(obj%cxxmem, &
            SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.getArrayC
    end function ArrayWrapper_getArrayC

    ! ----------------------------------------
    ! Function:  const double *getArrayConstC +dimension(getSize())
    ! Statement: f_function_native*_cdesc_pointer
    function ArrayWrapper_getArrayConstC(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(IN) :: obj
        real(C_DOUBLE), pointer :: SHT_rv(:)
        ! splicer begin class.ArrayWrapper.method.getArrayConstC
        type(ARR_SHROUD_array) :: SHT_rv_cdesc
        call c_ArrayWrapper_getArrayConstC_bufferify(obj%cxxmem, &
            SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.getArrayConstC
    end function ArrayWrapper_getArrayConstC

    ! ----------------------------------------
    ! Function:  void fetchArrayPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double **array +dimension(isize)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    subroutine ArrayWrapper_fetchArrayPtr(obj, array)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), intent(OUT), pointer :: array(:)
        ! splicer begin class.ArrayWrapper.method.fetchArrayPtr
        type(ARR_SHROUD_array) :: SHT_array_cdesc
        call c_ArrayWrapper_fetchArrayPtr_bufferify(obj%cxxmem, &
            SHT_array_cdesc)
        call c_f_pointer(SHT_array_cdesc%base_addr, array, &
            SHT_array_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.fetchArrayPtr
    end subroutine ArrayWrapper_fetchArrayPtr

    ! ----------------------------------------
    ! Function:  void fetchArrayRef
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *&array +dimension(isize)+intent(out)
    ! Statement: f_out_native*&_cdesc_pointer
    subroutine ArrayWrapper_fetchArrayRef(obj, array)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), intent(OUT), pointer :: array(:)
        ! splicer begin class.ArrayWrapper.method.fetchArrayRef
        type(ARR_SHROUD_array) :: SHT_array_cdesc
        call c_ArrayWrapper_fetchArrayRef_bufferify(obj%cxxmem, &
            SHT_array_cdesc)
        call c_f_pointer(SHT_array_cdesc%base_addr, array, &
            SHT_array_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.fetchArrayRef
    end subroutine ArrayWrapper_fetchArrayRef

    ! ----------------------------------------
    ! Function:  void fetchArrayPtrConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const double **array +dimension(isize)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    subroutine ArrayWrapper_fetchArrayPtrConst(obj, array)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), intent(OUT), pointer :: array(:)
        ! splicer begin class.ArrayWrapper.method.fetchArrayPtrConst
        type(ARR_SHROUD_array) :: SHT_array_cdesc
        call c_ArrayWrapper_fetchArrayPtrConst_bufferify(obj%cxxmem, &
            SHT_array_cdesc)
        call c_f_pointer(SHT_array_cdesc%base_addr, array, &
            SHT_array_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.fetchArrayPtrConst
    end subroutine ArrayWrapper_fetchArrayPtrConst

    ! ----------------------------------------
    ! Function:  void fetchArrayRefConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const double *&array +dimension(isize)+intent(out)
    ! Statement: f_out_native*&_cdesc_pointer
    subroutine ArrayWrapper_fetchArrayRefConst(obj, array)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE), intent(OUT), pointer :: array(:)
        ! splicer begin class.ArrayWrapper.method.fetchArrayRefConst
        type(ARR_SHROUD_array) :: SHT_array_cdesc
        call c_ArrayWrapper_fetchArrayRefConst_bufferify(obj%cxxmem, &
            SHT_array_cdesc)
        call c_f_pointer(SHT_array_cdesc%base_addr, array, &
            SHT_array_cdesc%shape(1:1))
        ! splicer end class.ArrayWrapper.method.fetchArrayRefConst
    end subroutine ArrayWrapper_fetchArrayRefConst

    ! ----------------------------------------
    ! Function:  void fetchVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **array +intent(out)
    ! Statement: f_out_void**
    subroutine ArrayWrapper_fetchVoidPtr(obj, array)
        use iso_c_binding, only : C_PTR
        class(ArrayWrapper), intent(INOUT) :: obj
        type(C_PTR), intent(OUT) :: array
        ! splicer begin class.ArrayWrapper.method.fetchVoidPtr
        call c_ArrayWrapper_fetchVoidPtr(obj%cxxmem, array)
        ! splicer end class.ArrayWrapper.method.fetchVoidPtr
    end subroutine ArrayWrapper_fetchVoidPtr

    ! ----------------------------------------
    ! Function:  void fetchVoidRef
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void *&array +intent(out)
    ! Statement: f_out_void*&
    subroutine ArrayWrapper_fetchVoidRef(obj, array)
        use iso_c_binding, only : C_PTR
        class(ArrayWrapper), intent(INOUT) :: obj
        type(C_PTR), intent(OUT) :: array
        ! splicer begin class.ArrayWrapper.method.fetchVoidRef
        call c_ArrayWrapper_fetchVoidRef(obj%cxxmem, array)
        ! splicer end class.ArrayWrapper.method.fetchVoidRef
    end subroutine ArrayWrapper_fetchVoidRef

    ! ----------------------------------------
    ! Function:  bool checkPtr
    ! Statement: f_function_bool
    ! ----------------------------------------
    ! Argument:  void *array
    ! Statement: f_in_void*
    function ArrayWrapper_checkPtr(obj, array) &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        class(ArrayWrapper), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: array
        logical :: SHT_rv
        ! splicer begin class.ArrayWrapper.method.checkPtr
        SHT_rv = c_ArrayWrapper_checkPtr(obj%cxxmem, array)
        ! splicer end class.ArrayWrapper.method.checkPtr
    end function ArrayWrapper_checkPtr

    ! ----------------------------------------
    ! Function:  double sumArray
    ! Statement: f_function_native
    function ArrayWrapper_sumArray(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        class(ArrayWrapper), intent(INOUT) :: obj
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin class.ArrayWrapper.method.sumArray
        SHT_rv = c_ArrayWrapper_sumArray(obj%cxxmem)
        ! splicer end class.ArrayWrapper.method.sumArray
    end function ArrayWrapper_sumArray

    ! Return pointer to C++ memory.
    function ArrayWrapper_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(ArrayWrapper), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function ArrayWrapper_get_instance

    subroutine ArrayWrapper_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(ArrayWrapper), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine ArrayWrapper_set_instance

    function ArrayWrapper_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(ArrayWrapper), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function ArrayWrapper_associated

    ! splicer begin class.ArrayWrapper.additional_functions
    ! splicer end class.ArrayWrapper.additional_functions

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function ArrayWrapper_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ArrayWrapper), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ArrayWrapper_eq

    function ArrayWrapper_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(ArrayWrapper), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function ArrayWrapper_ne

end module arrayclass_mod
