! Copyright (c) 2017-2022, Lawrence Livermore National Security, LLC. 
!
! Produced at the Lawrence Livermore National Laboratory 
!
! LLNL-CODE-738041.
!
! All rights reserved. 
!
! This file is part of Shroud.
!
! For details about use and distribution, please read LICENSE.
!
! #######################################################################
!
! Test code generated by the struct test
!
program tester
  use fruit
  use iso_c_binding
  use cstruct
  implicit none
  logical ok

  call init_fruit

  call swig_struct

  call fruit_summary
  call fruit_finalize

  call is_all_successful(ok)
  if (.not. ok) then
     call exit(1)
  endif

contains

  subroutine swig_struct

    integer(C_INT) rvi
    type(Cstruct1) str1

    call set_case_name("test_struct")

    str1 = Cstruct1()
    call str1%set_ifield(2)
    call str1%set_dfield(2.0_C_DOUBLE)

! Error: 'ifield' at (1) is not a member of the 'cstruct1' structure
!    str1%ifield = 2_C_INT
!    str1%dfield = 2.0_C_DOUBLE
    rvi = passStructByValue(str1)
    call assert_equals(4, rvi, "passStructByValue")

  end subroutine swig_struct

end program tester
