# How to contribute
Contributing includes many different actions. It is not only writing code. Contributions like discussing solutions in open issues are easily as valuable as contributing code as we can then find the best solution with the perspective of multiple people.

## Bugs and feature requests
If you find any bugs in the project or have requests for features, then please [Open a new Issue](https://github.com/KristofferStrube/Blazor.FileSystemAccess/issues/new).

## Contributing Code and Samples
Before you contribute to the project, you will need to get confirmation from the library author that the contribution is welcome.
This can help align the scope of the contribution so that you and the author agree on the solution and how you ensure the change is maintainable with the existing users in mind.
Once you are ready to start coding try to follow these code guidelines:
- Make a fork of the current `main` branch.
- Follow the existing coding conventions used in the project. This includes tab style, naming conventions, etc.
- If your contribution is a new feature, try to add a demo that demonstrates how this will be used in the sample project.
- Any code or sample you share as a part of the resulting Pull Request should fall under the MIT license agreement.
- You don't need to update the version number of the project as the maintainer will do this when making the next release after the Pull Request has been merged.
- Keep your Pull Request to the point. I.e., if your Pull Request is related to fixing a bug then try not to touch any other files than the ones related to that issue as this will make the chance of the PR being merged without change requests more likely.

## Submitting a Pull Request
If you don't know what a pull request is, read this article: https://help.github.com/articles/using-pull-requests. Make sure the repository can be built and that the related sample project still works as intended. It is also a good idea to familiarize yourself with the project workflow and our coding conventions.

## Ensuring that your contribution will be accepted
You might also read these two blog posts on contributing code: [Open Source Contribution Etiquette](http://tirania.org/blog/archive/2010/Dec-31.html) by Miguel de Icaza and [Don't "Push" Your Pull Requests](https://www.igvita.com/2011/12/19/dont-push-your-pull-requests/) by Ilya Grigorik. These blog posts highlight good open-source collaboration etiquette and help align expectations between you and us.
