# User Needs for the LLM-assisted Task "Assisting in User Story Creation"

| Step Name | Summary of User Needs | Prompts |
|-----------|-----------------------|---------|
| **Persona** | Describe a persona | Could you describe a persona who represents the typical user of this ontology? Include details such as their name, age, occupation, skills, and interests. Please provide as much detail as possible to create a comprehensive profile. |
|           | Detail persona traits | Could you improve the persona by detailing specific traits for their occupation, skills, and interests that are necessary for helping in writing an ontology user story? Explain why these traits are important with examples. |
|           | Add persona details | Could you provide the persona by adding details for their occupation, skills, and interests that are crucial for this project? Give specific examples and explain how these traits influence the project's success. |
|           | Elaborate persona aspects | Could you improve the persona by detailing the aspects of their occupation, skills, and interests? Elaborate on why each detail is relevant to the ontology user story, using examples. |
| **Goal**  | Describe the goal | Could you describe the goal by writing a concise statement about what this persona aims to achieve using this ontology? Include a few keywords summarising their main goals and provide detailed examples. |
|           | Improve goal description | Could you improve the goal by providing a more detailed description, including keywords that summarize the persona's objectives? Explain why these goals are important and align them with the persona's interests and skills. |
|           | Focused goal | Could you provide a goal that focuses on what this persona aims to achieve using this ontology? Emphasize the main objectives and desired outcomes. |
|           | Keywords for goals | Could you provide a few keywords that summarize the main goals of the persona? Ensure these keywords capture the essence of their objectives. |
|           | Short-term goals | Could you improve the goal by providing a more detailed description of the persona's short-term goals? Include specific examples and explain their significance. |
|           | Long-term goals | Could you improve the goal by providing a more detailed description of the persona's long-term goals? Include specific examples and explain their significance. |
|           | Methodology for goals | Could you improve the goal by explaining the methodology the persona will use to achieve their goals? Discuss relevant strategies, processes, or approaches in detail. |
|           | Tools for goals | Could you improve the goal by describing the tools the persona will use to achieve their goals? Mention specific software, technologies, or resources with examples. |
|           | Interdisciplinary insights | Could you improve the goal by explaining the interdisciplinary insights the persona will consider? Discuss how knowledge from other fields will contribute to achieving their goals, with examples. |
|           | Relevant factors for goals | Could you improve the goal by considering relevant factors when defining it? Include any external factors, constraints, or considerations that might impact the goals. |
|           | Specific requirements | Could you improve the goal by making the description more specific and clear, and include any specific requirements? Ensure all necessary details and conditions are addressed with examples. |
| **Scenario** | Current situation | Could you describe the current situation or context that has led to this scenario in more detail? Provide specific examples. |
|           | Existing conditions | Could you explain the existing conditions or status quo in this scenario? Include detailed descriptions and examples. |
|           | Specific problems | Could you provide more details about the specific problems or pain points you are encountering? Use examples to illustrate these issues. |
|           | Impact on goals | Could you describe how these issues affect your ability to achieve your goals? Provide specific examples and details. |
|           | Sequence of actions | Could you outline the steps or processes currently being followed in this scenario? Include a detailed sequence of actions. |
|           | Details on actions | Could you provide more details on the sequence of actions taken in this scenario? Use examples to elaborate. |
|           | Key players | Could you describe who the key players or stakeholders involved in this scenario are and what roles they play? Provide specific details. |
|           | Interactions | Could you explain how these key players or stakeholders interact with each other? Include examples and detailed descriptions. |
|           | Desired changes | Could you describe the changes or improvements you would like to see in this scenario? Provide specific details and examples. |
|           | Ideal scenario | Could you provide more details on how you envision the ideal scenario or end state? Include specific improvements and examples. |
|           | Expected benefits | Could you describe the expected benefits or positive impacts of resolving this scenario? Provide detailed explanations and examples. |
|           | Contribution to goals | Could you explain how resolving this scenario will contribute to achieving your overall goals? Provide specific examples and details. |
|           | Environmental data project | Could you describe the main objective of your environmental data analysis project in more detail? Provide specific examples and details. |
|           | Beneficiaries | Could you explain who will benefit from your findings and how? |
|           | Current methods | Could you provide more details on the current methods you use to collect environmental data? |
|           | Data analysis challenges | Could you describe the challenges you face with your current data analysis process in more detail? |
|           | Narrative story | Could you narrate a story about how the persona currently performs tasks related to their goal and how the system will improve this process? Include what happens before, during, and after using the system. Provide specific examples and practical insights. |
|           | Detailed narrative | Could you improve the scenario by providing a more detailed description of how the persona currently performs tasks related to their goal and how the system will improve this process? Include what happens before, during, and after using the system. Explain the significance of each stage. |
|           | Story before using system | Could you describe the scenario by narrating a story about what happens before using the system? Include specific tasks, challenges, and examples. |
|           | Story during system use | Could you describe the scenario by narrating a story about what happens during using the system? Include specific tasks, improvements, and examples. |
|           | Story after system use | Could you describe the scenario by narrating a story about what happens after using the system? Include specific outcomes, benefits, and examples. |
|           | Practical challenges | Could you improve the scenario by explaining the practical challenges the persona might face in more detail? Provide examples and possible solutions. |
|           | Stakeholder interactions | Could you improve the scenario by describing the interactions the persona might have with stakeholders? Include specific examples and the impact of these interactions. |
|           | Success indicators | Could you improve the scenario by providing more detailed success indicators for the persona? Explain how success is measured and why these indicators are important. |
|           | Practical steps | Could you improve the scenario by describing the practical steps the persona will follow in more detail? Include specific actions, processes, and examples. |
|           | Additional details | Could you improve the scenario by including additional details that are important for clarity? Ensure all relevant information is covered and provide examples. |
|           | Alternative answers | Could you improve the scenario by explaining why a given detail is not correct and providing an alternative answer with substantiation? Include evidence or reasoning to support the alternative. |
|           | Specific factors | Could you improve the scenario by considering specific factors when developing it? Include any external factors, constraints, or considerations that might impact the scenario. |
| **Example Data** | General overview | Could you provide a general overview of the category in more detail? Use online sources and cite your sources. |
|           | Key elements | Could you describe the key elements or components of the category? Use online sources and cite your sources. |
|           | Basic information | Could you provide more details on the basic information needed to identify the category? Use online sources and cite your sources. |
|           | Specific examples | Could you list some specific examples of the category and their identifying features? Use online sources and cite your sources. |
|           | Main attributes | Could you describe the main attributes or features of the category in more detail? Use online sources and cite your sources. |
|           | Detailed description | Could you provide a detailed description of the characteristics of a specific category item? Use online sources and cite your sources. |
|           | Relationships | Could you explain the relationships or associations that exist within the category in more detail? Use online sources and cite your sources. |
|           | Related items | Could you provide examples of how different items in the category are related? Use online sources and cite your sources. |
|           | Context or background | Could you describe the context or background information relevant to the category? Use online sources and cite your sources. |
|           | Historical details | Could you explain any historical or situational details that affect the category? Use online sources and cite your sources. |
|           | Typical use | Could you provide more details on how the category is typically used or applied? Use online sources and cite your sources. |
|           | Practical applications | Could you give examples of practical applications or scenarios involving the category? Use online sources and cite your sources. |
|           | Reliable sources | Could you list reliable sources where information about the category can be found? Use online sources and cite your sources. |
|           | Detailed data sources | Could you provide references or sources that offer detailed data on the category? Use online sources and cite your sources. |
|           | Recent trends | Could you describe recent trends or changes in the category? Use online sources and cite your sources. |
|           | Evolution over time | Could you explain how the category has evolved over time? Use online sources and cite your sources. |
|           | Challenges | Could you provide more details on the challenges associated with the category? Use online sources and cite your sources. |
|           | Considerations | Could you describe the considerations that should be kept in mind when dealing with the category? Use online sources and cite your sources. |
|           | Detailed data types | Could you provide the example data by describing what types of data the persona will work with in more detail? Include specific categories and examples. Use online sources and cite your sources. |
|           | Type of information | Could you improve the example data by describing the type of information this ontology will include, considering what this information looks like (e.g., text, numbers, pictures), and providing a few examples such as book titles and authors if your persona is a librarian, or song titles and artists if they are a music enthusiast? Explain how this data is used in your ontology and why it is important for the persona's goals. Use online sources and cite your sources. |
|           | Specific examples | Could you improve the example data by describing what types of data the persona will work with in more detail? Include specific examples and categories. Use online sources and cite your sources. |
|           | Concrete examples | Could you improve the example data by providing more concrete examples of the data the persona will use? Explain the relevance and application of this data. Use online sources and cite your sources. |
|           | Specific categories | Could you provide the example data by describing what types of category the persona will work with in more detail? Include specific examples. Use online sources and cite your sources. |
|           | Category details | Could you provide the example data by describing what data of a category the persona will work with in more detail? Explain how this data will be used and why it is important. Use online sources and cite your sources. |
|           | Identify resources | Could you improve the example data by identifying potential data resources using specific criteria? Provide examples and explain why these resources are relevant. Use online sources and cite your sources. |
|           | Check data resources | Could you improve the example data by checking whether these data resources contain relevant data? Provide detailed analysis and examples. Use online sources and cite your sources. |
| **Data Resource** | Primary sources | Could you provide more primary sources of data for this category? Use online sources and cite your sources. |
|           | Databases and repositories | Could you list more databases, websites, or repositories where relevant data can be found? Use online sources and cite your sources. |
|           | Data formats | Could you specify what formats the data come in (e.g., CSV, JSON, XML) in more detail? Use online sources and cite your sources. |
|           | Types of data | Could you describe more types of data included (e.g., textual, numerical, multimedia)? Use online sources and cite your sources. |
|           | Specific information | Could you provide more specific information that each source provides? Use online sources and cite your sources. |
|           | Data and metadata | Could you describe the kind of data or metadata available from each source in more detail? Use online sources and cite your sources. |
|           | Data access | Could you provide more details on how the data can be accessed? Are there APIs or download options available? Use online sources and cite your sources. |
|           | Access restrictions | Could you explain more about any restrictions or requirements for accessing the data? Use online sources and cite your sources. |
|           | Data comprehensiveness | Could you describe how comprehensive the data from each source is? Does it cover all necessary aspects? Use online sources and cite your sources. |
|           | Relevant and high-quality sources | Could you specify which sources provide the most relevant and high-quality data for your needs? Use online sources and cite your sources. |
|           | Data integration | Could you provide more details on how you plan to integrate data from multiple sources? Use online sources and cite your sources. |
|           | Data consistency | Could you describe what steps are necessary to ensure consistency and compatibility between data from different sources? Use online sources and cite your sources. |
|           | Case studies | Could you provide more specific examples or case studies that illustrate the use of data from these sources? Use online sources and cite your sources. |
|           | Notable projects | Could you mention any notable projects or research that have successfully used data from these sources? Use online sources and cite your sources. |
|           | Data update frequency | Could you specify how frequently the data is updated? Use online sources and cite your sources. |
|           | Data maintenance | Could you describe what mechanisms are in place for maintaining and updating the data? Use online sources and cite your sources. |
|           | Legal and ethical considerations | Could you provide more details on any legal or ethical considerations associated with using data from these sources? Use online sources and cite your sources. |
|           | Licensing and restrictions | Could you describe what licensing or usage restrictions apply to the data in more detail? Use online sources and cite your sources. |
|           | Tools and technologies | Could you provide more tools or technologies required to work with data from these sources? Use online sources and cite your sources. |
|           | Recommended software | Could you specify any specific software or platforms recommended for processing or analyzing this data? Use online sources and cite your sources. |
|           | Helpful resources | Could you provide more names and links of websites, books, tools, or other materials the persona might find helpful to explore with the ontology? Include a brief description of each resource. Use online sources and cite your sources. |
|           | Detailed resource descriptions | Could you provide more names and links along with detailed descriptions of websites, books, tools, or other materials the persona might find helpful to explore with the ontology? Explain why these resources are useful. Use online sources and cite your sources. |
|           | Potential directions | Could you find resources by referencing potential directions? Include names, links, and brief descriptions. Use online sources and cite your sources. |
|           | Platforms or databases | Could you describe what platforms or databases the persona will use for data in more detail? Provide names, links, and a brief description of each. Use online sources and cite your sources. |
|           | Resource description | Could you provide a more detailed description of this resource? Include its relevance and application. Use online sources and cite your sources. |
|           | Resource relevance | Could you provide a more detailed description of this resource? Explain its relevance, features, and how it supports the persona's goals. Use online sources and cite your sources. |

