# Study Script for User Story Writing

| **Step**                                               | **Script**                                                                                                                                                                                                                                                       |
|--------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Materials/activities pre-Interview**                 | Ask participants to prepare by reflecting on their current processes for writing user stories or defining user requirements in any software or ontology project. Request any relevant documentation or examples they might need during the interview.                |
| **<5 minutes> Opening**                                | - Introductions and pleasantries. <br> - Provide and explain the consent form. <br> - Fill out the demographics form.                                                                                                                                              |
| **<10 minutes> Discussion of current practices in user story/requirement writing** | - Can you briefly describe your persona in this user story or requirement you wrote? <br> - Can you describe, with examples, what kinds of user story or requirement writing you do as part of your role? <br> - Can you describe, with examples, what tools you use for writing user stories or requirements? <br> - Can you describe, with examples, how you write a user story from scratch? <br> - Can you describe a user story or requirement writing problem, potentially fictional, you may encounter in the future? <br> - If this produces a satisfactory scenario, proceed to turn taking. If not, ask: Can you share an example of a problem that required you to develop a new workflow for writing user stories or requirements? |
| **<30 minutes> Participatory prompting, turn taking: per turn** | - Is this useful? Why or why not? <br> - Are you confused, surprised, or indirectly inspired? <br> - To progress, choose one or more of: <br> - What would you like to know next? What else would you need to know to follow these suggestions? <br> - What would you change in your query to make this more useful? Would you ask this a different way? <br> - (Experimenter driven, at most once in a row) Let's see what happens if we try (X). Alternatively: I propose to continue by X, what would you have done (e.g., continued by Y, different task, abandon tool)? <br> - (If issue with result) I see that there is an issue here with (X), if we do this (new prompt) we can get that data back for you (if participant wants this, continue, else first question). <br> - (If participant is stuck, only thinking in terms of "classical" search engines) Imagine you're talking to a colleague and bouncing ideas off them. |
| **<15 minutes> Post activity interview**               | - How would a tool like this fit or not fit into your workflow? If the participant says something like "If it could do X that would be helpful," try it out, get feedback from the participant, but keep time in mind. <br> - What benefits does this LLM-assisted user story/requirement writing workflow provide over your existing workflow? <br> - When you were surprised/inspired by X (from turn taking), what features/capabilities would be useful in exploring this inspiration further? <br> - What features do you believe would increase the frequency and effectiveness of these inspiring results/moments (e.g., suggested prompts)? <br> - How would your user story/requirement writing workflow change with a tool like this? <br> - What barriers or frustrations did you have with this experience that prevented you from exploring the question to your satisfaction? <br> - What are the advantages or disadvantages of using a chat-based interface for writing user stories or requirements? |

