package zn.html.bean;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.net.URLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Iterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import util.DaoService;


/**
 * 网页生成器
 * 生成静态网页 创建服务器文章ID
 * @author Administrator
 *
 */

public class PublishJianTaiMyPage {
	private String htmlStoreDir;
	private String urlHost;
	private int urlPort;
	private String urlPath;
	private String qureyString[];
	private String  fileEncode="utf-8";
	private Log log=LogFactory.getLog(PublishJianTaiMyPage.class);
	private String sessionId="";
	private boolean isgetIdFromRemoteServer=false;
	private StringBuffer logBf=new StringBuffer();
	//获取网页数据授权码，位于juuluuConfig.properties publish.getDateAppURL.MemberIdPermission
	//默认值21ds5f3eas43dfw6ev4sd_juuluu_org
	private String memberIdGetDateActionPermission="21ds5f3eas43dfw6ev4sd_juuluu_org";
	public PublishJianTaiMyPage(){
		
		
	}
	/**
	 * 设置网页创建器参数
	 * @param URlHost 主机地址，如localhost www.juuluu.org
	 * @param URLPort 主机地址端口
	 * @param pathGetDateURLPath 获取网页数据的相对链接 
	 * @param qureyString 链接参数值
	 * @param fileEncode 生成网页编码
	 */
	
	public void setProperty(String URlHost,int URLPort,String pathGetDateURLPath,String qureyString[],String fileEncode){
		setUrlHost(URlHost);
		setUrlPort(URLPort);
		setQueryString( qureyString);
		setUrlPath(pathGetDateURLPath);
		setFileEncode(fileEncode);
	}
	/**
	 * 由网页生成器配置，创建获取网页数据URL，
	 * 以HTTP方式获取URL数据
	 * @param URlHost 主机
	 * @param URLFile 相对路径
	 * @param URLPort 端口
	 * @return
	 */
	public URL createURL(String URlHost,String URLFile,int URLPort){
		if(URlHost==null||URlHost.equals("")){
			this.logBf.append("主机地址没设置，无法获取网页数据！");
		}
		
		URL url=null;
		 try {
			 StringBuffer urlStr=new StringBuffer();
			 urlStr.append("http://");
			 urlStr.append(URlHost);
			 urlStr.append(":");
			 urlStr.append(URLPort);
			 urlStr.append(URLFile);
			 
			 //添加获取数据授权访问用户密码
			 String memberIDPersissionGetDate="memberIdPermission="+this.memberIdGetDateActionPermission;
			 if(urlStr.indexOf("?")!=-1){
				 urlStr.append("&"+memberIDPersissionGetDate);
			 }else{
				 urlStr.append("?"+memberIDPersissionGetDate);
			 }
			 //添加会话ID；
			 if(this.sessionId!=null&&this.sessionId.equals("")==false){
				 // 是否已有参数
				 if(urlStr.indexOf("?")!=-1){
					 urlStr.append("&"+this.sessionId);
				 }else{
					 urlStr.append("?"+this.sessionId);
				 }
				
			 }
			 
			 
			url=new URL(urlStr.toString());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return url;
		
	}
	
	
	/**
	 * 生成静态网页
	 * @param ShopProductId
	 * @throws Exception
	 */
	
	

	
	//首页
	public void src_list_IndexHtml_all(long pid){
		int pageid=1;
	
	
		 try {
			 createSrcList_html_OfPage_all( pid,  pageid);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	/**
	 * 根据栏目ID，分页ID，创建静态分页
	 * @param catid
	 * @param pageid
	 * @param ShopProductcatDir
	 * @throws Exception
	 */
	public void createSrcList_html_OfPage_all(long projectid, int pageid)
	throws Exception{

		DownHtmlPathBean pathShopBean=new DownHtmlPathBean();
		String listPathAndFileName=pathShopBean.getSrc_list_pagePath_all(projectid, pageid);
		
		//组建完整网址
		String URLFile= getUrlPath()+"&pageId="+pageid;
		this.logBf.append("创建栏目页，模板："+URLFile);
		//生成获取数据网址，并追回授权码
		URL url=createURL(urlHost,URLFile, urlPort);
		DaoService.getIntrance();
		
		short catPageidFirst=1;
		if(pageid!=1){
			
			createHtml( url,listPathAndFileName,getFileEncode());
		}else if(pageid==catPageidFirst){
			//创建第一页
			createHtml( url,listPathAndFileName,getFileEncode());
			
			//第一页作为栏目首页
				String catPathAndFileName=pathShopBean.getSrc_list_pagePath_all_index(projectid);
				if(catPathAndFileName.equals("")!=true){
					createHtml( url,catPathAndFileName,getFileEncode());
					createHtml( url,listPathAndFileName,getFileEncode());
				}
				}
		
		
	}
	//生成列表页
	public void createSrcList_html_OfPage_web(long projectid, int pageid)
	throws Exception{

		DownHtmlPathBean pathShopBean=new DownHtmlPathBean();
		String listPathAndFileName=pathShopBean.getSrc_list_pagePath_web(projectid, pageid);
		
		//组建完整网址
		String URLFile= getUrlPath()+"&pageId="+pageid;
		this.logBf.append("创建栏目页，模板："+URLFile);
		System.out.println("创建栏目页，模板："+URLFile);
		//生成获取数据网址，并追回授权码
		URL url=createURL(urlHost,URLFile, urlPort);
		DaoService.getIntrance();
		
		short catPageidFirst=1;
		if(pageid!=1){
			
			createHtml( url,listPathAndFileName,getFileEncode());
		}else if(pageid==catPageidFirst){
			//创建第一页
			createHtml( url,listPathAndFileName,getFileEncode());
			
			//第一页作为栏目首页
				String catPathAndFileName=pathShopBean.getSrc_list_pagePath_web_index(projectid);
				if(catPathAndFileName.equals("")!=true){
					createHtml( url,catPathAndFileName,getFileEncode());
					createHtml( url,listPathAndFileName,getFileEncode());
				}
				}
		
		
	}
	
	
	public void createSrcList_html_OfPage_src(long projectid, int pageid)
	throws Exception{

		DownHtmlPathBean pathShopBean=new DownHtmlPathBean();
		String listPathAndFileName=pathShopBean.getSrc_list_pagePath_src(projectid, pageid);
		
		//组建完整网址
		String URLFile= getUrlPath()+"&pageId="+pageid;
		this.logBf.append("创建栏目页，模板："+URLFile);
		//生成获取数据网址，并追回授权码
		URL url=createURL(urlHost,URLFile, urlPort);
		DaoService.getIntrance();
		
		short catPageidFirst=1;
		if(pageid!=1){
			
			createHtml( url,listPathAndFileName,getFileEncode());
		}else if(pageid==catPageidFirst){
			//创建第一页
			createHtml( url,listPathAndFileName,getFileEncode());
			
			//第一页作为栏目首页
				String catPathAndFileName=pathShopBean.getSrc_list_pagePath_src_index(projectid);
				if(catPathAndFileName.equals("")!=true){
					createHtml( url,catPathAndFileName,getFileEncode());
					createHtml( url,listPathAndFileName,getFileEncode());
				}
				}
		
		
	}
	
	//生成获取数据程序路径
	/**
	 * /shop/action/ShopJinTaiTempleteViewActlion.do?method=cat&catId&pageId=1
	 */


	
	
	
	/**
	 * 生成网页，
	 * @param savePathAndFileName 网页保存文件名及路径
	 * @throws Exception
	 */
	public boolean commentHtmlCreate(String savePathAndFileName)
	throws Exception{
		boolean isok=false;
		String URLFile=  getUrlPath();
		//根据网页生成器配置，创建目标网页访问URL，准备通过HTTP方式获取数据
		URL url=createURL(urlHost,URLFile, urlPort);
		//DaoService.getIntrance();		
		if(savePathAndFileName.equals("")!=true){
			//由URL，编码，保存地址等信息，生成静态网页
			isok=createHtml( url,savePathAndFileName,getFileEncode());			
		}	
		return isok;
	}
	

	/**
	 * 从网站获取文件，保存到本地
	 * @param url
	 * @param PathAndFileName
	 * @param encode
	 * @return
	 * @throws Exception
	 */
	
	public boolean createHtml(URL url,String PathAndFileName,String encode)
	throws Exception{
		boolean isCreateOk=false;
		//String path="生成文章,模板："+url.getProtocol()+"://"+url.getHost()+":"+url.getPort()+url.getPath()+"?"+url.getQuery();
//this.logBf.append(path);
		//  System.out.println(path);
try {
				InputStream in;
			// url=new URL("http://localhost:8080<bean:write name="SystemConfigApp" property="appContext"/>/watchAritcleAction.do?ShopProductId=3");
			
			 URLConnection cnn= url.openConnection();
			 HttpURLConnection httpurlc= (HttpURLConnection)cnn;
			 httpurlc.setRequestMethod("POST"); 
			 //设置会话ID
			 httpurlc.setRequestProperty("Cookie", sessionId); 

			 httpurlc.connect();
			 //;jsessionid=
			 //httpurlc.getHeaderField(name)
			 
			  String cookieValue=httpurlc.getHeaderField("Set-Cookie"); 
			  if(cookieValue!=null){
				  this.logBf.append("cookie value:"+cookieValue); 
		            String sessionId=cookieValue.substring(0, cookieValue.indexOf(";")); 
		            this.logBf.append("sessionId:"+sessionId);
		           // return sessionId; 
		            //判断sessionid是否相等
		            if(this.sessionId.equals(sessionId)==false){
		            	this.sessionId=sessionId;
		            	this.logBf.append("获取会话ID:"+this.sessionId);
		            }
			  }else{
				  this.logBf.append("无法获取会话ID:"+this.sessionId);
			  }
            

			 //处理异常
			 int error;
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_OK){
				 this.logBf.append("get url resource sucess.");
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_ENTITY_TOO_LARGE){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("HTTP_ENTITY_TOO_LARGE."+httpurlc.getResponseMessage());
				 return false;//返回,处理下一文章
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_CLIENT_TIMEOUT){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("CLIENT_TIMEOUT."+httpurlc.getResponseMessage());
				 return false;
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_NOT_FOUND){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("NOT_FOUND."+httpurlc.getResponseMessage());
				 
				 return false;
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_INTERNAL_ERROR){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				
				 this.logBf.append("服务器错误，内存溢出，或文章不存在；server error. may be file not exits.HTTP_INTERNAL_ERROR."+httpurlc.getResponseMessage());
				 
				 return false;
			 }
			 // httpurlc.setConnectTimeout(3000);
				
			 //ystem.out.println(httpurlc.getReadTimeout());
			// this.logBf.append(httpurlc.getReadTimeout());
			 
			 //this.logBf.append();
		//	this.logBf.append(httpurlc.getResponseMessage());
			
			// this.logBf.append("rulc encode:"+cnn.getContentEncoding());
			// this.logBf.append("rulc ContentTyp:"+cnn.getContentType());
			// this.logBf.append("rulc Properties:"+cnn.getRequestProperties());
		//	 this.logBf.append("rulc lenght:"+cnn.getContentLength());

			 
			 
			 in =  cnn.getInputStream();
			 
		//	 this.logBf.append(url.getContent());
		//	 this.logBf.append(url.getFile());
			// this.logBf.append(url.getHost());
			// this.logBf.append(url.getPath());
			// this.logBf.append(url.getQuery());
			// this.logBf.append(url.getHost());
			// this.logBf.append(url.getProtocol());
			 if(htmlStoreDir==null){
				 throw new Exception("palease set htmlStoreDir");
			 }
			 String file;
			 if(PathAndFileName.indexOf("/")==0){
				 file=htmlStoreDir+PathAndFileName;
					
			 }else{
				 file=htmlStoreDir+"/"+PathAndFileName;
					
			 }
				this.logBf.append("保存路径："+file);
			 
			 File f=new File(file);
			 String dirs=f.getPath();
			 File d=new File(dirs);
			 if(d.exists()==false){
				 d.mkdirs();
			 }
			 if(f.exists()){
				 f.delete();
				 f.createNewFile();
				 if(f.isDirectory()){
					 f.delete();
					 f.createNewFile();
			       }
				
			 }else{
				 f.createNewFile();
				 if(f.isDirectory()){
					 f.delete();
					 f.createNewFile();
				 }
			 }
			 
			 this.logBf.append("保存文章:"+f.getPath());
			 System.out.println("保存文章:"+f.getPath());
			// this.logBf.append("Parent:"+f.getParent());
			// this.logBf.append("exite:"+f.exists());
			
			 OutputStream out=new FileOutputStream(f);
			 
			 InputStreamReader inr=new InputStreamReader(in,encode );
			 
			 OutputStreamWriter outs=new OutputStreamWriter(out,encode);
			
			
			//this.logBf.append("encode:"+inr.getEncoding());
			 
			 char[] b = new char[2048];
			  String k="";
			  BufferedReader br=new BufferedReader(inr);
			  BufferedWriter bw=new BufferedWriter(outs);
			  StringBuffer bf=new StringBuffer();
			  int i=0;
			  while(k!=null){
				  k=br.readLine();
				  if(k!=null){
					  bf.append(k);
					  bf.append("\n");
				  }
				 
				 // this.logBf.append(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>"+ ++i);
				 
			  } //this.logBf.append(bf.toString());
			 
			  bw.flush();
			  bw.write(bf.toString());
			  
			  
				br.close();
				bw.close();
			in.close();
			out.close();
		
			httpurlc.disconnect();
			//保存成功
			isCreateOk=true;
			  /*
			while(in.read()!=-1){
				in.read(b);
				for(int i=0;i<b.length;i++){
					this.logBf.append(b[i]);
				}
				
			}
				
		*/
				
		   } catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			   this.logBf.append("生成静态失败，无法获取网站内容。");
			e.printStackTrace();
		}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
			
			
		return isCreateOk;
	}
	
	//public 

	/**
	 * @param args
	 */
	public void setHtmlStoreDir(String htmlStoreDir) {
		this.htmlStoreDir = htmlStoreDir;
	}

	public String getHtmlStoreDir() {
		return htmlStoreDir;
	}
	


	public void setUrlPath(String urlPath) {
		this.urlPath = urlPath;
	}
	public String getUrlPath() {
		return urlPath;
	}
	public void setQueryString(String qureyString[]) {
		this.qureyString = qureyString;
	}

	public String[] getQueryString() {
		return qureyString;
	}
	public void setUrlHost(String urlHost) {
		this.urlHost = urlHost;
	}
	public String getUrlHost() {
		return urlHost;
	}
	public void setUrlPort(int urlPort) {
		this.urlPort = urlPort;
	}
	public int getUrlPort() {
		return urlPort;
	}
	public void setFileEncode(String fileEncode) {
		this.fileEncode = fileEncode;
	}
	public String getFileEncode() {
		return fileEncode;
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub
	PublishJianTaiMyPage p=new PublishJianTaiMyPage();
	p.setHtmlStoreDir("html");
	//String query[]={"pageId=","ShopProductcatId="};
	String query[]={"objectId="};
	//p.setProperty("localhost", 8080, "/watchAritcleAction.do", query, "utf-8");
	p.setProperty("localhost", 8080, "/action/daoAction/ShopProductAction.do?method=readView&forward=update&type=int&", query, "utf-8");
	try{
		short s=122;
		//p.createShopProductListHtmlOfPage(s, 2, "jiancai");
	//	p.createShopProductListHtmlBySite();
		//p.createShopProductHtml(2);
	//	p.createShopProductHtmlBySite();
	}catch(Exception e){
		e.printStackTrace();
	}
	}


	public void setIsgetIdFromRemoteServer(boolean isgetIdFromRemoteServer) {
		this.isgetIdFromRemoteServer = isgetIdFromRemoteServer;
	}

	public boolean isIsgetIdFromRemoteServer() {
		return isgetIdFromRemoteServer;
	}
	public void setMemberIdGetDateActionPermission(
			String memberIdGetDateActionPermission) {
		this.memberIdGetDateActionPermission = memberIdGetDateActionPermission;
	}
	public String getMemberIdGetDateActionPermission() {
		return memberIdGetDateActionPermission;
	}
	public void setLogBf(StringBuffer logBf) {
		this.logBf = logBf;
	}
	public StringBuffer getLogBf() {
		return logBf;
	}


}
