package store.file.web.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.util.Streams;

/**
 * 保存网站上传文件
 * 
 * @author Administrator
 *
 */
public class FileUploadIoUtil {
	public static String IOType_Stream_ch="ch";
	public static String IOType_Stream_Bytes="Bytes";
	public static String IOType_Stream_Chars="Chars";
	public static String IOType_Stream_Buffer_Chars="Buffer_Chars";
	public static String IOType_Stream_Buffer_String="Buffer_String";
	public static String IOType_FileOutputStream="FileOutputStream";
	public static String IOType_Apache_StramsCopy="Apache_StreamsCopy";
	//保存IO方式 ch Bytes Chars Buffer_Chars Buffer_String
	public void writeFileToLocal(String ioType,File fileSaved,java.io.InputStream  ins){
		if(ioType==null){
			saveFileToLocal_bytes(fileSaved,ins);
		}else if(ioType.equals(IOType_Stream_ch)){
			saveFileToLocal_ch(fileSaved,ins);
		}else if(ioType.equals(IOType_Stream_Chars)){
			saveFileToLocal_chars(fileSaved,ins);
		}else if(ioType.equals(IOType_Stream_Bytes)){
			this.saveFileToLocal_bytes(fileSaved, ins);//(fileSaved, ins);//(fileSaved,ins);
		}else if(ioType.equals(IOType_Stream_Buffer_Chars)){
			this.saveFileToLocal_Buffer_chars(fileSaved, ins);//(fileSaved,ins);
		}else if(ioType.equals(IOType_Stream_Buffer_String)){
			this.saveFileToLocal_Buffer_String(fileSaved,ins);
		}else if(ioType.equals(IOType_FileOutputStream)){
			this.saveFileToLocal_Buffer_String(fileSaved,ins);
		}else if(ioType.equals(IOType_Apache_StramsCopy)){
			this.saveFileToLocal_ByApache_StramsCopy(fileSaved,ins);
		}
		
		else{
			this.saveFileToLocal_bytes(fileSaved, ins);
		}
	}
	//直接保存网络文件
	public void saveFile_ByFileoutPutStream(File fileSaved,java.io.InputStream  ins){
		try {
			java.io.FileOutputStream fo=new java.io.FileOutputStream (fileSaved);
			
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
//二进制方式存储
	/**
	 * 性能：逐字方式，性能较差，但准确性高
	 * 图形文件：能正常写入保存gif,png,jpg等
	 * 压缩文件：rar部分不能保存，zip能正常保存
	 * 办公文件：pdf无法保存 doc正常 xls正常(excel)
	 * 影音：mp3正常 rmvb无法IO保存
	 * 
	 */
	
public void saveFileToLocal_ch(File fileSaved,java.io.InputStream  ins){
	 
	     
      java.io.FileOutputStream fout;
	try {
			fout = new java.io.FileOutputStream(fileSaved);
	
    // java.io.InputStreamReader ir=new java.io.InputStreamReader(ins);
    // java.io.OutputStreamWriter outs=new java.io.OutputStreamWriter(fout);
     //java.io.BufferedReader br=new java.io.BufferedReader(ir);
     //java.io.BufferedWriter bufout=new java.io.BufferedWriter(outs);
      //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
				byte[] readB=new byte[1024];
      //char [] chbuf=new char[1024];
      			int r=ins.read();
      		int c=0;
      //String str=br.readLine();
      	while(r!=-1){
    	 // if(c==0){
      		///System.out.println("输出第一行:"+r);
      		//}
    	  ////c++;
    	  char ch=(char)r;
      
			fout.write(ch);
		
      	//r=br.read();
      	// str=br.readLine();
      	//r=br.read(chbuf);
				r=ins.read();
      		}
      //bufout.flush();
      
     // //System.out.println("共有读取:"+c+"次数据");
		} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}
	}//end method

//字节数组方式保存
/**
 * 性能 doc 正常  xls正常  
 * 图形：gif jpg png写入不正常
 * 办公：doc 正常  xls正常  pdf 写入不正常 html No 
 * 影音：rmvb 写入失败 mp3 写入不正常 
 * 
 */
public void saveFileToLocal_bytes(File fileSaved,java.io.InputStream  ins){
	 
	     
      java.io.FileOutputStream fout;
	try {
			fout = new java.io.FileOutputStream(fileSaved);
	
    // java.io.InputStreamReader ir=new java.io.InputStreamReader(ins);
    // java.io.OutputStreamWriter outs=new java.io.OutputStreamWriter(fout);
     //java.io.BufferedReader br=new java.io.BufferedReader(ir);
     //java.io.BufferedWriter bufout=new java.io.BufferedWriter(outs);
      //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
				byte[] readB=new byte[4096];
      //char [] chbuf=new char[1024];
      			int r=ins.read(readB);
      		int c=0;
      //String str=br.readLine();
      	while(r!=-1){
    	 // if(c==0){
      		//System.out.println("输出第一行:"+r);
      		//}
    	  ////c++;
    	 // char ch=(char)r;
      
			fout.write(readB);
		
      	//r=br.read();
      	// str=br.readLine();
      //	r=br.read(readB);
				r=ins.read(readB);
      		}
      //bufout.flush();
      
      	////System.out.println("共有读取:"+c+"次数据");
		} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}
	}//end method
//字符数组方式保存
public void saveFileToLocal_chars(File fileSaved,java.io.InputStream  ins){
	 
    
    java.io.FileOutputStream fout;
	try {
			fout = new java.io.FileOutputStream(fileSaved);
	
 java.io.InputStreamReader ir=new java.io.InputStreamReader(ins);
  java.io.OutputStreamWriter outs=new java.io.OutputStreamWriter(fout);
   //java.io.BufferedReader br=new java.io.BufferedReader(ir);
   //java.io.BufferedWriter bufout=new java.io.BufferedWriter(outs);
    //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
				byte[] readB=new byte[1024];
    char [] chbuf=new char[4096];
    			int r=ir.read(chbuf);
    		int c=0;
    //String str=br.readLine();
    	while(r!=-1){
  	  if(c==0){
    		//System.out.println("输出第一行:"+r);
    		}
  	  ////c++;
  	 // char ch=(char)r;
    
  	  outs.write(chbuf);
  	r=ir.read(chbuf);
    	//r=br.read();
    	// str=br.readLine();
    //	r=br.read(readB);
				//r=ins.read(readB);
    		}
    //bufout.flush();
    
    	////System.out.println("共有读取:"+c+"次数据");
		} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}
	}//end method
//字节数组方式保存
/**
 * 性能
 * 图形：gif jpg png写入不正常
 * 办公：pdf 写入不正常 html No doc 乱码  xls乱码 
 * 影音：rmvb 写入失败 mp3 写入不正常 
 * 
 */
public void saveFileToLocal_Buffer_chars(File fileSaved,java.io.InputStream  ins){
	 
	     
      java.io.FileOutputStream fout;
	try {
			fout = new java.io.FileOutputStream(fileSaved);
	
     java.io.InputStreamReader ir=new java.io.InputStreamReader(ins);
     java.io.OutputStreamWriter outs=new java.io.OutputStreamWriter(fout);
     
     java.io.BufferedReader brIn=new java.io.BufferedReader(ir);
     
    java.io.BufferedWriter bufout=new java.io.BufferedWriter(outs);
     //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
			//	byte[] readB=new byte[1024];
      char [] chbuf=new char[1024];
      			int r=brIn.read(chbuf);
      		int c=0;
     // String str=br.readLine();
      	while(r!=-1){
    	  if(c==0){
      		//System.out.println("输出第一行:"+r);
      		}
    	  ////c++;
    	//  char ch=(char)r;
      
    	  bufout.write(chbuf);
		
      	//r=br.read();
      	// str=br.readLine();
      	//r=br.read(chbuf);
    	  r=brIn.read(chbuf);
      		}
      bufout.flush();
      
      	////System.out.println("共有读取:"+c+"次数据");
		} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}
	}//end method

public void saveFileToLocal_Buffer_String(File fileSaved,java.io.InputStream  ins){
	 
    
    java.io.FileOutputStream fout;
	try {
			fout = new java.io.FileOutputStream(fileSaved);
	
   java.io.InputStreamReader ir=new java.io.InputStreamReader(ins);
   java.io.OutputStreamWriter outs=new java.io.OutputStreamWriter(fout);
   
   java.io.BufferedReader brIn=new java.io.BufferedReader(ir);
   
  java.io.BufferedWriter bufout=new java.io.BufferedWriter(outs);
   //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
			//	byte[] readB=new byte[1024];
    char [] chbuf=new char[1024];
    			int r=brIn.read(chbuf);
    		int c=0;
     String str=brIn.readLine();
    	while(str!=null){
  	  if(c==0){
    		//System.out.println("输出第一行:"+r);
    		}
  	  //c++;
  	 // char ch=(char)r;
    
  	  bufout.write(str);
		
    	//r=br.read();
    	// str=br.readLine();
    	//r=br.read(chbuf);
  	 // r=brIn.read(chbuf);
  	str=brIn.readLine();
    		}
   bufout.flush();
    
    	//System.out.println("共有读取:"+c+"次数据");
		} catch (FileNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}
	}//end method

//通过apche上传组件默认流复制方式写入
public void saveFileToLocal_ByApache_StramsCopy(File fileSaved,java.io.InputStream  ins){
	 
    
    java.io.FileOutputStream fout;

			try {
				fout = new java.io.FileOutputStream(fileSaved);
				 
				   java.io.BufferedInputStream brIn=new java.io.BufferedInputStream(ins);
				   
				  java.io.BufferedOutputStream bufout=new java.io.BufferedOutputStream(fout);
				   //java.io. bout=new  java.io.ByteArrayOutputStream(fout);
				  try {
					Streams.copy(brIn, bufout, true);
				} catch (IOException e) {
					// TODO Auto-generated catch block
				
					e.printStackTrace();
				}
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	
		
	}//end method

}
