package plugs.juuluu.imgplugs.images;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
/*
 * 　plugs.juuluu.imgplugs.images.ImgCropServlet
 * 使用过程：
 * 发起文件载图申请，提交文件地址／回调程序和安全认证到载图程序
 * 截图完成，返回回调程序
 */
public class ImgCropServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doPost(request, response);

	}
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
	//权限认证	
	Boolean isCheckPermission=	(Boolean) request.getSession().getAttribute("bcheckUserImgAction");//, true);
	if(isCheckPermission==null ||isCheckPermission==false){
		request.setAttribute("info", "非法操作，请确认您拥有图片编辑权限！");
		request.getRequestDispatcher("/info/info.jsp").forward(request,response);
		return ;
	}
	//创建新图片
	do_createNewImg(request,response);
	
	//操作完成，清除权限标识
	 request.getSession().removeAttribute("bcheckUserImgAction");
	}
	public void do_createNewImg(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		System.out.println("x: " + request.getParameter("x") + "," + request.getParameter("y") + "," + request.getParameter("w") + "," + request.getParameter("h"));

		// 获取图片坐标
		Integer x = Integer.parseInt(request.getParameter("x"));
		Integer y = Integer.parseInt(request.getParameter("y"));
		Integer w = Integer.parseInt(request.getParameter("w"));
		Integer h = Integer.parseInt(request.getParameter("h"));
		
		//原图片
		String oldImgPath = request.getParameter("oldImgPath");
		//文件类型
	//	String imgFileExt = request.getParameter("imgFileExt");
		
		String imgFileExt = getFileType(oldImgPath);
		//String imgRoot =  request.getParameter("imgRoot");
		String imgRoot = "/imgUpload";
		//Integer width = Integer.parseInt(request.getParameter("width"));
		//Integer height = Integer.parseInt(request.getParameter("height"));
		
		//WEB
		String webAppPath = getServletContext().getRealPath("/");
		
		/**创建图片路径参数*/
		SimpleDateFormat formatter = new SimpleDateFormat("/yyyy/MM/dd/hhmmss/");
		String imgFileId = formatter.format(new Date());
		String imgName =  imgRoot + imgFileId + System.currentTimeMillis() + "." + imgFileExt;			
		//新文件路径
		String createImgPath = webAppPath + imgName;
		//创建文件的父目录
		File file=new File(createImgPath);
		File parent=file.getParentFile();
		if(parent.exists()==false){
			parent.mkdirs();
		}
		
		//֮ǰ�ϴ���ͼƬ·��
	String oldfilePath_ful=	webAppPath += oldImgPath;
		
		System.out.println("将图片" + webAppPath + ",截取为: " + createImgPath);
		
		//将图片路径保存到会话
		request.getSession().setAttribute("newFilePathimg_zt", imgName);
		//生成截图
		ImageCut.abscut(oldfilePath_ful, createImgPath, x,y,w, h);
		
		 File f = new File(createImgPath);								
		 if(f.exists()){						
			 System.out.println("创建文件: "+w+"*"+h+"成功！");
		 }	
		 
		//String path = "/plugs/imgPlugs/imgcrop.jsp?tag=1&oldImgPath="+oldImgPath+"&imgFileExt="+imgFileExt+"&imgRoot="+imgRoot + "&imgName="+imgName+"&height=" + height + "&width=" + width;
		 String path = "/plugs/imgPlugs/imgcrop_hand.jsp?tag=0&oldImgPath="+oldImgPath+"&newfile="+imgName+"&imgFileExt="+imgFileExt+"&imgRoot="+imgRoot;
			
		System.out.println("imgCrop: " + path);
		
		//获取回调程序
		
		String callbackAppUrl=request.getParameter("callbackAppUrl");
		if(callbackAppUrl!=null){
			request.getRequestDispatcher(callbackAppUrl).forward(request,response);
		}else{
			request.getRequestDispatcher(path).forward(request,response);
		}
		
	}
	public String getFileType(String fp){
		System.out.println(fp);
		File f=new File(fp);
		String fn=f.getName();
		int cstart=fn.lastIndexOf('.');
		String type=fn.substring(cstart+1,fn.length());
		System.out.println(fp+" file type:"+type);
		return type;
	}
}
