package plugs.juuluu.imgplugs.images;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
/**
 * 图片缩放工具
 * @author root
 * web图片缩放
 */
public class ImageScalaUtil {
	private int imgWidth=700;
	private int imgHeight=500;
	
	public void scalaDefaultImg(String imgWebAppPath) throws IOException{
		int imgWidth=this.imgWidth;
		int imgHeight=this.imgHeight;
		
		scalaImg(imgWebAppPath,imgWidth,imgHeight);
	}
	
	private String []imglist={"jpg","jpeg","gif","png"};
	
	
public void scalaImg(String imgWebAppPath,int imgWidth,int imgHeight) throws IOException{
	
	//判断是否图片类型
	if(isimgFile(imgWebAppPath)==false){
		System.out.println("非图片类型，不作处理。");
		return ;
	}
	
	//
	BufferedImage src = ImageIO.read(new File(imgWebAppPath));
	// 
					 
	int imgSrcWidth = src.getWidth();
	//
						 
	//

	imgWidth = imgSrcWidth > imgWidth ? imgWidth : imgSrcWidth;
	
	int imgSrcHeight = src.getHeight(); // 

	imgHeight = imgSrcHeight > imgHeight ? imgHeight : imgSrcHeight;

	//

	ImageCut.scale(imgWebAppPath, imgWebAppPath,imgWidth,imgHeight);
	 File f = new File(imgWebAppPath);	
	 
	 if(f.exists()){						
		 System.out.println("scala img:"+imgWidth+"*"+imgHeight+"");
	
	 }				

}



public void scalaNewImg(String srcimg,String targetImg,int imgWidth,int imgHeight) throws IOException{

System.out.println("压缩图片，源图："+srcimg+" 目标图："+ targetImg);	
	//
BufferedImage src = ImageIO.read(new File(srcimg));
// 
				 
int imgSrcWidth = src.getWidth();
//
					 
//

imgWidth = imgSrcWidth > imgWidth ? imgWidth : imgSrcWidth;

int imgSrcHeight = src.getHeight(); // 

imgHeight = imgSrcHeight > imgHeight ? imgHeight : imgSrcHeight;

//目标文件

//String targetImg=getFileNameTarget(srcimg);

ImageCut.scale(srcimg, targetImg,imgWidth,imgHeight);
 File f = new File(targetImg);	
 
 if(f.exists()){						
	 System.out.println("new img:"+imgWidth+"*"+imgHeight+" success!");

 }				

}

//从源文件生成新目标文件路径
public String getFilePathTarget(String src){
	File f=new File(src);
	
	String fname=getFileNameTarget( src);
	String path=f.getParent()+"/"+fname;
	
	return path;
}
//生存相近目录结构文件
public String getFileNameTarget(String src){
	System.out.println(src);
	File f=new File(src);
	String fn=f.getName();
	int cstart=fn.lastIndexOf('.');
	String type=fn.substring(cstart+1,fn.length());
	
	String name2="_"+(int)(Math.random()*100)+"."+type;
	System.out.println(src+" file type:"+type);
	
	//新文件名
	String old_str=fn.substring(0,cstart);
	String newfileName=old_str+name2;
	return newfileName;
}

public String getFileType(String fp){
	System.out.println(fp);
	File f=new File(fp);
	String fn=f.getName();
	int cstart=fn.lastIndexOf('.');
	String type=fn.substring(cstart+1,fn.length());
	System.out.println(fp+" file type:"+type);
	return type;
}

public boolean isimgFile(String path){
	
	File f=new File(path);
	String name=f.getName();
	
	boolean isimg=false;
	for(int i=0;i<imglist.length;i++){
		String type=imglist[i];
		
		String s=name.toLowerCase();
		
		if(s.indexOf(type)!=-1){
			isimg= true;
			break;
		}
		
	}
	
	
	return isimg;
}

}
