package org.juuluu.pay.paypal;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.juuluu.pay.bean.OrderPayUpdateUtil;
import org.juuluu.pay.bean.PayInfoBean;
import org.juuluu.pay.bean.PayMethodUtil;

import com.paypal.sdk.core.nvp.NVPDecoder;

/**
 * paypal支付完成后，更新订单
 * @author Administrator
 *org.juuluu.pay.paypal.PaypalUpdateOrderUtil
 */
public class PaypalUpdateOrderUtil {
//创建订单信息
	/**
	 * decoder DoExpressCheckoutPayment 响应编码值map数据集
	 */
	public PayInfoBean getPayInfo(NVPDecoder decoder){
		
		PayInfoBean pay=new PayInfoBean();
		//支付工具标识
		pay.setPayThreeSystemKey(PayMethodUtil.payMetodKey_paypal_checkOut);
		pay.setBcommplee(true);
		
		
		
		Map payMap=decoder.getMap();
		String tokenPay=(String) payMap.get("TOKEN");
		//TRANSACTIONID          付款的唯一交易号
		String TRANSACTIONID=(String) payMap.get("TRANSACTIONID");
		pay.setPayTRANSACTIONID(TRANSACTIONID);
		
		//FEEAMT                 对交易收取的PayPal费用金额 
		//AMT                    收取的最终金额，包括您“商家用户信息”中的任何运费和税金。
		 //SETTLEAMT              币种兑换后存入您PayPal账户中的金额。 

        // 可能的值：取决于特定交易 
		//PAYMENTTYPE            指示是即时付款还是延迟付款。 ? none  ? echeck ? instant 
		
		String PAYMENTTYPE=(String) payMap.get("PAYMENTTYPE");
		if(PAYMENTTYPE.equals("none")){
			pay.setPayType("未设置");
		}else if(PAYMENTTYPE.equals("echeck")){
			
			pay.setPayType("延迟付款");
		}else if(PAYMENTTYPE.equals("instant")){
			pay.setPayType("即时付款");
		}
		//(PAYMENTSTATUS);

         //TAXAMT                 对交易收取的税金。
		//EXCHANGERATE           进行币种兑换时所用的汇率。只有以非主要币种结算时才适用。 
		pay.setTokenPay(tokenPay);	
		
		//交易状态 paymentState
		//PAYMENTSTATUS          付款的状态：         Completed：付款已完成，资金已成功注入您的账户余额中。 

       // Pending：付款待处理。
		String PAYMENTSTATUS=(String) payMap.get("PAYMENTSTATUS");
		pay.setPaySatate(PAYMENTSTATUS);	
		
		//EMAIL                付款人的电子邮件地址。 

        
        //PAYERID              唯一的PayPal客户账户识别号。 
		String PAYERID=(String) payMap.get("PAYERID");
		pay.setPayUserEmail(PAYERID);//(PAYMENTSTATUS);	
		
		if(PAYMENTSTATUS.equals("Completed")){
			
		}else if(PAYMENTSTATUS.equals("Pending")){
			
		}
		System.out.println("更新订单，获取paypal支付信息：PAYERID"+PAYERID+"PAYMENTTYPE"+PAYMENTTYPE+"PAYMENTSTATUS"+PAYMENTSTATUS+"TRANSACTIONID"+TRANSACTIONID);
		return pay;
	}
	//更新支付订单 
	public void updatePayOrder(HttpServletRequest request,NVPDecoder decoder){
		
		PayInfoBean infopay=getPayInfo(decoder);
		OrderPayUpdateUtil p=new OrderPayUpdateUtil();
		p.updateOrderByPayThree(request, infopay);
	}
	/**
	 * 字符长度和限制：20个单字节字符 

DoExpressCheckoutPayment 响应 

表A.17 DoExpressCheckoutPayment 响应字段 

 字段                     说明 

 TOKEN                  由SetExpressCheckout响应返回并通过 
 GetExpressCheckoutDetails 

                        请求传递的时间戳标记值。 

                        字符长度和限制：20个单字节字符 
                        允许值：请参阅表A.12  “SetExpressCheckout响应字段”中有关 

 TOKEN 的 

                        说明。 

 TRANSACTIONID          付款的唯一交易号。 

                       注意：如果请求中的PaymentAction为Authorization或 

                             Order，则该值为您用于授权与捕获API的AuthorizationID 。 

                        字符长度和限制：19个单字节字符 

                        可能的值：取决于特定交易 

 TRANSACTIONTYPE        交易的类型 

                        字符长度和限制：15个单字节字符 

                        可能的值： 
                        ? cart 

                        ? express-checkout 

 PAYMENTTYPE            指示是即时付款还是延迟付款。 

                        字符长度和限制：七个单字节字符 

                        可能的值： 
                        ? none 

                        ? echeck 

                        ? instant 

 ORDERTIME              付款的时间/日期戳 

                        可能的值：取决于特定交易 

 AMT                    收取的最终金额，包括您“商家用户信息”中的任何运费和税金。 

 字符长度 

                        和限制：任何币种的金额都不超过10,000美元。无货币符号。不管 
 币种如 
                        何，小数点都是英文句号(.)，可选的千位分割符是英文逗号(,)。 

      美元的 

                        等值金额最多9个字符。 

                        可能的值：取决于特定交易 

                              CURRENCYCODE            “PayPal支持的交易币种”中所列币种之一的三字符币种代码。 

                        默认值：USD。 

表A.17 DoExpressCheckoutPayment 响应字段 

 字段                     说明 

 FEEAMT                 对交易收取的PayPal费用金额 

                        字符长度和限制：任何币种的金额都不超过10,000美元。无货币符 

 号。不管币 

                        种如何，小数点都是英文句号(.)，可选的千位分割符是英文逗号(,)。 

                        美元的等值金额等值金额最多9个字符。 

                        可能的值：取决于特定交易 

 SETTLEAMT              币种兑换后存入您PayPal账户中的金额。 

                        可能的值：取决于特定交易 

 TAXAMT                 对交易收取的税金。 

                        字符长度和限制：任何币种的金额都不超过10,000美元。无货币符 

 号。不管币 

                        种如何，小数点都是英文句号(.)，可选的千位分割符是英文逗号(,)。 

                        美元的等值金额等值金额最多9个字符。 

                        可能的值：取决于特定交易 

 EXCHANGERATE           进行币种兑换时所用的汇率。只有以非主要币种结算时才适用。 

 如果客户选 

                        择用该非主要币种之外的其他币种付款，则会在客户的账户中进 

 行兑换。 

                        字符长度和限制：不超过17个字符（包括小数点）的小数 

                        可能的值：取决于特定交易 

 PAYMENTSTATUS          付款的状态： 

                        Completed：付款已完成，资金已成功注入您的账户余额中。 

                        Pending：付款待处理。有关详细信息，请参见PendingReason 

 元素。 

表A.17 DoExpressCheckout 付款响应字段 

 字段                     说明 

 PENDINGREASON          付款待处理的原因： 

                         ? none：无待处理原因 

                         ? address：付款待处理的原因是，客户未提供经确认的送货地 

                           址，而且您的“收款习惯设定”设为每笔付款均需手动接受或 

                           拒绝。若要更改习惯设定，请前往“用户信息”的“习惯设定” 

                           部分。 

                         ? echeck：付款待处理的原因是：通过电子支票付款，而电子 

                           支票尚未结清。 
                            ? intl：付款待处理的原因是：您持有非美国账户，且不具备提 

                           现功能。您必须在“账户信息”页面中手动接受或拒绝此笔付 

                           款。 

                        ? multi-currency：所发送的币种没有余额，并且未将“收款 

                           习惯设定”设为自动兑换和接受付款。您必须手动接受或拒绝 

                           此付款。 

                        ? verify：付款待处理的原因是：您尚未获得认证。您必须认 

                           证您的账户才能接受此付款。 

                        ? other：付款待处理非上述原因所致。欲知更多信息，请联系 

                           PayPal客户服务。 

REASONCODE              撤销原因（TransactionType为reversal时）： 

                        ? none：无原因代码 

                        ? chargeback：由于客户提出退单，因此撤销这笔交易。 

                        ? guarantee：由于客户启动退款担保，因此撤销这笔交易。 

                        ? buyer-complaint：由于客户对交易提出投诉，因此撤销这 

                           笔交易。 

                        ? refund：由于您向客户退款，因此撤销这笔交易。 

                        ? other：交易的撤销非上述原因所致。 

REDIRECTREQUIRED        用于指示完成交易后是否需要将客户跳转回PayPal的标记。 

                       注意：只有在德国使用giropay或银行转账付款方式时才使用该字 

                             段。 

L_FMFfilter IDn         过滤器号，包括过滤器类型（ACCEPT 或DENY）和从0开始的项 

号。 

L_FMFfilter NAMEn       过滤器名称，包括过滤器类型（ACCEPT 或DENY）和从0开始的 

项号。 

                              


	 */
	
}
