package net.juuluu.spider.core.web;

/**
 * 网络图片处理，采集，保存等
 *  * @author Administrator
 *
 */
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.net.URLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Iterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;

import net.juuluu.spider.core.SpiderPath;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import util.DaoService;


import java.awt.image.BufferedImage;
import java.awt.Image;
import javax.swing.ImageIcon;
import  sun.awt.image.URLImageSource;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.ImageDecoder;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.ImageIO;
import net.juuluu.spider.core.ImageDownLoad;

public class WebImgBean {
	private SpiderPath spiderPath;
	public WebImgBean (SpiderPath spiderPath){
		this.spiderPath= spiderPath;
	}
	private URL imageURL;
	private Log log=LogFactory.getLog(WebImgBean.class);
	
	public BufferedImage spider(){
		SpiderPath p=getSpiderPath();
		
		URL url=p.createURLByFullFilePath();
		 return spiderURL(url);
	}
	
	public BufferedImage spiderURL(URL url){
		
		this.imageURL=url;
		
		//System.out.println("网络文件路径："+url.getProtocol()+"://"+url.getHost()+":"+url.getPort()+""+url.getPath());
		  StringBuffer bf=new StringBuffer();
		  BufferedImage imge=null;
		  
		   try {
				
			// url=new URL("http://localhost:8080<bean:write name="SystemConfigApp" property="appContext"/>/watchAritcleAction.do?articleId=3");
			
			 URLConnection cnn= url.openConnection();
			 HttpURLConnection httpurlc= (HttpURLConnection)cnn;
			 httpurlc.connect();
			 //处理异常
			 int error;
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_OK){
				 //System.out.println("服务器连接测试成功：get url resource sucess.");
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_ENTITY_TOO_LARGE){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 //System.out.println("HTTP_ENTITY_TOO_LARGE."+httpurlc.getResponseMessage());
				 //return null;//返回,处理下一文章
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_CLIENT_TIMEOUT){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 //System.out.println("CLIENT_TIMEOUT."+httpurlc.getResponseMessage());
				 //return null;
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_NOT_FOUND){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 //System.out.println("NOT_FOUND."+httpurlc.getResponseMessage());
				 
				// return null;
			 }
			 
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_INTERNAL_ERROR){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 //System.out.println("server error. may be file not exits.HTTP_INTERNAL_ERROR."+httpurlc.getResponseMessage());
				 
				// return null;
			 }
			 // httpurlc.setConnectTimeout(3000);
				
			 //ystem.out.println(httpurlc.getReadTimeout());
			// //System.out.println(httpurlc.getReadTimeout());
			 
			 ////System.out.println();
		//	//System.out.println(httpurlc.getResponseMessage());
			
			// //System.out.println("rulc encode:"+cnn.getContentEncoding());
			// //System.out.println("rulc ContentTyp:"+cnn.getContentType());
			// //System.out.println("rulc Properties:"+cnn.getRequestProperties());
		//	 //System.out.println("rulc lenght:"+cnn.getContentLength());
			
			 
			//打开网络文件流 
			 //System.out.println("正获取网络文件.");
			 InputStream in;
			 Object imagO=null;
			 try{
				 imagO =httpurlc.getContent();
				
			 }catch(java.io.FileNotFoundException e){
				 System.out.println("找不到网络图片："+e.getMessage());
				 return null;
			 }
			
			 if(imagO!=null){
				 ////System.out.println("获取文件成功。");
			 }else{
				 ////System.out.println("获取文件失败。imagO==null 路径："+url.getPath());
			 }
			 
			 if(imagO instanceof URLImageSource){
				 URLImageSource  ic=(URLImageSource)cnn.getContent();
				// InputStreamImageSource is=new InputStreamImageSource();
				 
				 InputStreamImageSource ee=ic;
				BufferedImage ibf= ImageIO.read(cnn.getInputStream());
				
				 imge=ibf;
				 
				 if(imge!=null){
					 ////System.out.println("获取文件成功。");
				 }else{
					 ////System.out.println("获取文件失败。 路径："+url.getPath());
				 }
				 
				 return imge;
			 }else{
				 ////System.out.println("不是图片，放弃采集， 路径："+url.getPath());
				 ////System.out.println(httpurlc.getContentType());
				 return null;
			 }
				
				
		//	 ////System.out.println("path:"+f.getPath());
			// ////System.out.println("Parent:"+f.getParent());
			// ////System.out.println("exite:"+f.exists());
			
			
				
		   } catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		
		 if(imge!=null){
			
			 ////System.out.println("获取文件失败。");
			 return imge;
		 }else{
			 return null;
		 }
		 
	}

	public void setSpiderPath(SpiderPath spiderPath) {
		this.spiderPath = spiderPath;
	}
	public SpiderPath getSpiderPath() {
		return spiderPath;
	}

	public void setImageURL(URL imageURL) {
		this.imageURL = imageURL;
	}

	public URL getImageURL() {
		if(imageURL==null){
			//System.out.println("错误，URL 要调用spider()后才能生成。");
		}
		
		return imageURL;
	}
	public String getSpiderURLPath(){
		URL url= getImageURL();
		String s=url.getProtocol()+"://"+url.getHost()+":"+url.getPort()+""+url.getPath();
		return s;
	}
	//img01.taobaocdn.com
	public static void main(String argv[]){
		WebImgBean ib= new WebImgBean(null);
		URL url;
		try {
			
			url = new URL("http://img01.taobaocdn.com/bao/uploaded/i5/T1eMJTXcFIXXcbBWI2_043146.jpg_310x310.jpg");
			BufferedImage image=ib. spiderURL( url);
			
			//保存本地
			
			ImageDownLoad  d=new ImageDownLoad(null) ;
			// SpiderPath s =getSpiderPath();
			// d.setSpiderPath(s);
			///imgDir/2011/05/02/07/32/110502073228218.jpg
			String pathLocal="E:/app/kgcms/ROOT/myimg/2011/05/02/07/32/110502073228218.jpeg";
		String imgPathSaveLocal=	d.saveImg(image, pathLocal,"jpeg");
			
			
		
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
	}
}
