package net.juuluu.spider.core;
/**
 * 功能：文章ID的网页路径编码
 * 根据协议，主机名，生成网页URL路径
 * 生成保存图片路径
 * 使用说明：
 * 
	private String urlPath;	网络文件路径，只接受相对路径
	
 * @author Administrator
 *
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import net.juuluu.spider.core.web.LinkPathBean;
import util.TimeUtil;

public class SpiderPath {
	//文件保存路径
	private String htmlStoreDir;
	private String urlHost;
	//主机名，格式：localhost www.zsba.net
	private int urlPort=80;
	//网络文件路径，只接受相对路径
	private String urlPath;
	//不含参数文件路径 包括静态，动态的？的前面部分
	private String qureyString[];
	//文件请求路径的查询参数  参数名和参数值，只接受参数名，值由系统提供
	private String  fileEncode="utf-8";
	//源文件的编码
	private String webFileAgreement="http://";
	//完整路径
	private String filePath;
	private String saveFileType;
	private String saveSiteDir;
	private String saveFileTypeList;
	private String spiderfileTypeList;
	private String [][] ids={{"0","xb"},{"1","ge"},{"2","cw"},{"3","7b"},{"4","bg"},{"5","oq"},{"6","au"},{"7","ve"},{"8","zo"},{"9","ps"}};
	private TimeUtil timeUtil=TimeUtil.getInstance();
	//所有	文件保存的相对路径
	private String filesaveDir;
	//单个	文件保存的相对路径
	private String filesavePath;
	//默认源文件编码
	private String encodeSource="utf-8";

	public SpiderPath(){
		
	}/**
	检查图片链接的图片类型，在保存图片类型列表中找不到时，设置为默认值jpeg
	*/
	public String checkSaveFileType(){
		String urlp=getUrlPath();
		File f=new File(urlp);
		String fn=f.getName();
		String type=getSaveFileType();
		java.util.StringTokenizer st=new StringTokenizer(getSaveFileTypeList(),"|");
		String typer=null;
		while(st.hasMoreTokens()){
			String saveType=st.nextToken();
			if(fn.indexOf(saveType)!=-1){
				
				typer= saveType;
				break;
				
		}else{
			continue;
		}
		}
		//
		if(typer==null){
			typer="jpeg";
		}
		return typer;
	}
	public Long idsReEnCode(String path){
	      byte[] pb=	path.getBytes();
		String idCode ="" ;
		String [][] ids=getIds();
		int t=0;
		ArrayList<String > codeList=new ArrayList<String > ();
		//切分路径，生成编码元素
		for(int j=0;j<pb.length;j++){
			if(t==0){
				idCode =Byte.toString(pb[j]);
				t++;
			}else if(t==1){
				idCode=idCode+Byte.toString(pb[j]);
				idCode=null;
				codeList.add(idCode);
				t--;
			}
			
		}
		Iterator <String >iidlist=codeList.iterator();
		StringBuffer reID=new StringBuffer();
		while(iidlist.hasNext()){
			String idp=iidlist.next();
			int l=ids.length;
				for(int i=0;i<l;i++){
					String idv=ids[i][0];
					String code=ids[i][1];
					if(idp.equals(code)==true){
						reID.append(idv);
					}
				}
		
		}
		
		Long id=Long.parseLong(reID.toString());
		return id;
	}
	public String idsEnCode(String id){
		StringBuffer path=new StringBuffer();
		String [][] ids=getIds();
		int l=ids.length;
		byte[] c=id.getBytes();
		for(int k=0;k<c.length;k++){
			Byte ib=c[k];
			String ibstr=ib.toString();
			
			for(int i=0;i<l;i++){
				String idv=ids[i][0];
				String code=ids[i][1];
				if(ibstr.equals(idv)==true){
					path.append(code);
				}
			}
		}

	
			return path.toString();
	}
	public String urlFilePatchCheck(String urlpath){
		if(urlpath.indexOf("/")==-1){
			urlpath="/"+urlpath;
			return urlpath;
		}else if(urlpath.indexOf("/")>0){
			urlpath="/"+urlpath;
			return urlpath;
		}else{
			return urlpath;
		}
		
	}

	/**
	 * 
	 * @return
	 */
	public URL createURLByFullFilePath(){
		String agreement=getWebFileAgreement(); 
		String URlHost=getUrlHost();
	
	
		URL url=null;
		String URLFile=getUrlPath();
		//分析路径是否包含http
		String pathHttp=URLFile.toLowerCase();
		if(pathHttp!=null&&pathHttp.indexOf("http://")!=-1){
			//包含http://，为完整路径，直接创建url
			
			try {
				url=new URL(URLFile);
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			//相对路径，
			
		}else{
			int URLPort=getUrlPort();	
			
			 try {
				 StringBuffer urlStr=new StringBuffer();
				 urlStr.append(agreement);
				 urlStr.append(URlHost);
				 urlStr.append(":");
				 urlStr.append(URLPort);
				 
				 //是否包含绝对路径
				 if(!isStartChharFirst(URLFile,"/")){					 
				
					 urlStr.append("/");
				 }
				 
				 urlStr.append(URLFile);
				url=new URL(urlStr.toString());
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}//end if
		
		
		return url;
		
	}
	
	public boolean isStartChharFirst(String URLFile,String s){
		if(URLFile==null||URLFile.equals("")){
			return false;
		}
		
		int start=URLFile.indexOf(s);
		if(start!=-1){
			char c=URLFile.charAt(0);
			String c2=String.valueOf(c);
			if(c2.equals(s)){
				return true;
			}else{
				return false;
			}
			
			
		}else{
			return false;
		}
	}
	/**
	 * 
	 * @param dir 绝对路径
	 * @return
	 */
		public String getAbsSavePathByTime(){
			String dir=getSaveSiteDir();
			String fileType=checkSaveFileType();
			String path=dir+"/"+getFilesaveDir() +"/"+getFileSavePathByTime();
			this.filesavePath="/"+getFilesaveDir() +"/"+getFileSavePathByTime();;
			return path;
		}
/**
 * 
 * @param dir 相对路径
 * @return
 */
	public String getFileSavePathByTime(){
		
		String fileType=checkSaveFileType();
		String path=getTimeUtil().getTimeFilePath()+getTimeUtil() .getYYMMddhhmmssSSS()+"."+fileType;
	     
	     this.saveFileType=checkSaveFileType();
		return path;
	}
	
	
	
	public void setHtmlStoreDir(String htmlStoreDir) {
		this.htmlStoreDir = htmlStoreDir;
	}
	public String getHtmlStoreDir() {
		return htmlStoreDir;
	}
	public void setUrlHost(String urlHost) {
		this.urlHost = urlHost;
	}
	public String getUrlHost() {
		return urlHost;
	}
	public void setUrlPort(int urlPort) {
		this.urlPort = urlPort;
	}
	public int getUrlPort() {
		return urlPort;
	}
	public void setUrlPath(String urlPath) {
		this.urlPath = urlPath;

	}
	public String getUrlPath() {
		return urlPath;
	}
	public void setQureyString(String qureyString[]) {
		this.qureyString = qureyString;
	}
	public String[] getQureyString() {
		return qureyString;
	}
	public void setFileEncode(String fileEncode) {
		this.fileEncode = fileEncode;
	}
	public String getFileEncode() {
		return fileEncode;
	}
	public void setWebFileAgreement(String webFileAgreement) {
		this.webFileAgreement = webFileAgreement;
	}
	public String getWebFileAgreement() {
		return webFileAgreement;
	}
	public void setIds(String [][] ids) {
		this.ids = ids;
	}
	public String [][] getIds() {
		return ids;
	}
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	public String getFilePath() {
		return filePath;
	}
	public void setTimeUtil(TimeUtil timeUtil) {
		this.timeUtil = timeUtil;
	}
	public TimeUtil getTimeUtil() {
		return timeUtil;
	}
	public void setSaveSiteDir(String saveSiteDir) {
		this.saveSiteDir = saveSiteDir;
	}
	public String getSaveSiteDir() {
		return saveSiteDir;
	}
	public void setSaveFileType(String saveFileType) {
		this.saveFileType = saveFileType;
	}
	public String getSaveFileType() {
		return saveFileType;
	}
	public void setSpiderFileType(String spiderFileType) {
		this.spiderfileTypeList = spiderFileType;
	}
	public String getSpiderFileType() {
		return spiderfileTypeList;
	}
	public void setFilesavePath(String filesavePath) {
		this.filesavePath = filesavePath;
	}
	public String getFilesavePath() {
		return filesavePath;
	}
	public void setSaveFileTypeList(String saveFileTypeList) {
		this.saveFileTypeList = saveFileTypeList;
	}
	public String getSaveFileTypeList() {
		return saveFileTypeList;
	}
	public void setFilesaveDir(String filesaveDir) {
		this.filesaveDir = filesaveDir;
	}
	public String getFilesaveDir() {
		return filesaveDir;
	}
	public void setEncodeSource(String encodeSource) {
		this.encodeSource = encodeSource;
	}
	public String getEncodeSource() {
		return encodeSource;
	}


}
