/**
 * 下载图片，保存到本地
 */
package net.juuluu.spider.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;


import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import java.awt.Image;
import java.awt.Graphics;
import javax.imageio.ImageIO;

import net.juuluu.spider.core.SpiderPath;
import net.juuluu.spider.core.web.WebImgBean;



public class ImageDownLoad {
	
	private SpiderPath spiderPath;
	
	public ImageDownLoad (SpiderPath spiderPath){
		///this.setConfig(config);
	
		this.spiderPath=spiderPath;
		
		WebImgBean load=new WebImgBean(spiderPath);
		
	}
	
	public String saveImage(BufferedImage image){
		if(image==null){
			////System.out.println("采集图片失败。");
			return "";
		}
		SpiderPath p=getSpiderPath();

		ImageIcon ii=new ImageIcon(image);
		int w=ii.getIconWidth();
		int h=ii.getIconHeight();
		////System.out.println("图片大小：w:"+w+" h:"+h);
	
		
		BufferedImage bi=new BufferedImage(w,h,BufferedImage.TYPE_INT_RGB);
		
		Graphics g=	bi.getGraphics();
		//加载图片到内存
		Image cacheImage=ii.getImage();
		g.drawImage(cacheImage,0,0,  w, h, null);
		
		g.dispose();
		if(bi==null){
			////System.out.println(" error bi is null：w:"+w+" h:"+h);
		}
	
		String imgSaveLocalPath=p.getAbsSavePathByTime();
		String fileSaveType=p.getSaveFileType();
		saveImg( image,imgSaveLocalPath,fileSaveType);
		return imgSaveLocalPath;
		
	}
	public  String saveImg(BufferedImage image,String pathLocal,String fileSaveType){
		
			if(image==null){
				////System.out.println("采集图片失败。");
				return "";
			}
			SpiderPath p=getSpiderPath();

			ImageIcon ii=new ImageIcon(image);
			int w=ii.getIconWidth();
			int h=ii.getIconHeight();
			////System.out.println("图片大小：w:"+w+" h:"+h);
		
			
			BufferedImage bi=new BufferedImage(w,h,BufferedImage.TYPE_INT_RGB);
			
			Graphics g=	bi.getGraphics();
			//加载图片到内存
			Image cacheImage=ii.getImage();
			g.drawImage(cacheImage,0,0,  w, h, null);
			
			g.dispose();
			if(bi==null){
				////System.out.println(" error bi is null：w:"+w+" h:"+h);
			}
		
			String imgSaveLocalPath=pathLocal;
			System.out.println("保存到本地图片路径："+imgSaveLocalPath);
			 File f=new File(imgSaveLocalPath);
			 String dirs=f.getPath();
			 File d=new File(dirs);
			 if(d.exists()==false){
				 d.mkdirs();
			 }
			 if(f.exists()){
				 f.delete();
				 try {
					f.createNewFile();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				 if(f.isDirectory()){
					 f.delete();
					 try {
						f.createNewFile();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			       }
				
			 }else{
				 try {
					f.createNewFile();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				 if(f.isDirectory()){
					 f.delete();
					 try {
						f.createNewFile();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				 }
			 }
			 if(f.exists()==false){
				 try {
					f.createNewFile();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			 }
			 OutputStream out=null;
			try {
				out = new FileOutputStream(f);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			 
				try {
					if(bi==null){
					//	ImageIO.write(bi, p.getSpiderFileType(), out);
						////System.out.println("图片为空");
					}else{
						////System.out.println("保存文件类型："+p.getSaveFileType());
						String saveType=fileSaveType;
						ImageIO.write(bi, saveType, out);
						System.out.println("保存图片完毕："+"路径："+imgSaveLocalPath+"格式："+fileSaveType);
						//bi.flush();
					
						
					}
							} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			
			return imgSaveLocalPath;
			
		
	}



	public void setSpiderPath(SpiderPath spiderPath) {
		this.spiderPath = spiderPath;
	}

	public SpiderPath getSpiderPath() {
		return spiderPath;
	}

	public static void main(String argv[]){
		SpiderPath p =new SpiderPath ();
		p.setUrlHost("localhost");
		p.setUrlPort(80);
		p.setWebFileAgreement("http://");
		p.setUrlPath("code/images/logo.jpg");
		p.setSpiderFileType("jpeg|jpg|gif");
		p.setSaveFileTypeList("jpeg|gif");
		p.setSaveSiteDir("e:/www");
		p.setFilesaveDir("imgUpLoad");
		
		net.juuluu.spider.core.web.WebImgBean ib=new net.juuluu.spider.core.web.WebImgBean(p);
		ImageDownLoad d=new ImageDownLoad(p);
		d.setSpiderPath(p);
		d.saveImage(ib.spider());
		
	
	
	}
}
