package net.juuluu.plugs.webapp.strutsex.util;


/**
 * 字符串处理工具
 * @author Administrator
 *
 */
public class SringUtil {
	private static SringUtil instance;

	public static SringUtil getInstance() {
		if(instance==null){
			instance=new SringUtil();
		}
		return instance;
	}
	private SringUtil(){}
    public static String bSubstring(String s, int length) throws Exception
    {

        byte[] bytes = s.getBytes("Unicode");
        int n = 0; // 表示当前的字节数
        int i = 2; // 要截取的字节数，从第3个字节开始
        for (; i < bytes.length && n < length; i++)
        {
            // 奇数位置，如3、5、7等，为UCS2编码中两个字节的第二个字节
            if (i % 2 == 1)
            {
                n++; // 在UCS2第二个字节时n加1
            }
            else
            {
                // 当UCS2编码的第一个字节不等于0时，该UCS2字符为汉字，一个汉字算两个字节
                if (bytes[i] != 0)
                {
                    n++;
                }
            }
        }
        // 如果i为奇数时，处理成偶数
        if (i % 2 == 1)

        {
            // 该UCS2字符是汉字时，去掉这个截一半的汉字
            if (bytes[i - 1] != 0)
                i = i - 1;
            // 该UCS2字符是字母或数字，则保留该字符
            else
                i = i + 1;
        }

        return new String(bytes, 0, i, "Unicode");
    }

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		//
	    //下面代码使用了bSubstring方法：
//中國電信（香港）國際有限公司召開2011年运营商大会 
	 //   String s = "a加b等于c，如果a等1、b等于2，那么c等3";
		String s = "中國電信（香港）國際有限公司召開2011年运营商大会";
	    try {
			System.out.println(bSubstring(s, 26));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}




}
