/*******************************************************************************
 * Copyright (c) 2005 Eteration A.S. and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Eteration A.S. - initial API and implementation
 ******************************************************************************/
package net.juuluu.plugs.webapp.strutsex.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;


import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

import util.ObjectMorePageView;




public class MorePageViewAction {
	
	
	
	private boolean hasParentId;
	private  int morePageViewPersistId=-1;
	private int defaultPageId=1;

	private static String listViewDateName="MorePageDivInstance";
	private String pageIdJumpActionPath="/action/CodeAction.do?method=getObjectList&pageId=1";

	
	 
	 public void init (HttpServletRequest request,java.util.List<Object> listDataAll){
		 //将全部数据设置到分页器
		 setObjectMorePageView( request,listDataAll,getMorePageViewPersistId());
		 System.out.println("#########\n########\n#########session id:"+getMorePageViewPersistId());
		}
	 
	 //获取分页器
public static MorePageViewAction getMorePageDivBean(HttpServletRequest request,int divPageInstanceID){
	String IDName=MorePageViewAction.listViewDateName+divPageInstanceID;
	MorePageViewAction pageBean=(MorePageViewAction)request.getSession(true).getAttribute(IDName);
	return pageBean;
}

//获取分页器
public static void  setMorePageDivBean(MorePageViewAction bean,HttpServletRequest request,int divPageInstanceID){
	String IDName=MorePageViewAction.listViewDateName+divPageInstanceID;
request.getSession(true).setAttribute(IDName,bean);

}
/**
 * 设置分页数据
 * @param request
 * @throws IOException
 * @throws ServletException
 */
	public void setPageListDateToRequest(HttpServletRequest request)
			throws IOException, ServletException {
		//获取数据集父类ID
		int parentId=-1;
		//设置分页显示标识
		 System.out.println("#########创建分页器#######session id:"+getMorePageViewPersistId());
		//初始化数据
			ObjectMorePageView morePageUtil=getObjectMorePageView( request, getMorePageViewPersistId());
		
		//div
		int pageId;
		if(request.getParameter("pageId")==null){
			pageId=getDefaultPageId();
		}else{
			 pageId=Integer.parseInt(request.getParameter("pageId"));
			
		}
			//获取当前
	 //构造当前页面访问路径//_列表页ID.html
		String prefixPath=getPageIdJumpActionPath()+"&parentId="+parentId+"&pageId=";
		
	//生成对象列表	 
	 
	 List<Object> pageList=null;
	try {
		//获取网页数据
		pageList = morePageUtil.getobjectListByPage(pageId);
		 request.setAttribute(getListViewDateName(), pageList);
		
	} catch (java.lang.Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	 
	
	// ###########前缀+pageId=完整路径
	 String previousPage=prefixPath;
	 
	 //获取上一页
	
	//导航条链接路径  
	 
	  if(morePageUtil.getPreviousPageId()!=-1){
		  //上一页 导航条链接路径
		 previousPage= prefixPath+morePageUtil.getPreviousPageId();
		java.util.HashMap<Integer,String> m =new java.util.HashMap<Integer,String>();
		 m.put(Integer.valueOf(morePageUtil.getPreviousPageId()), previousPage);
		 request.setAttribute("previousPage", m);
	 }
	  //获取下一页
		 String nextPage=null;
		 
		  if(morePageUtil.getNextPageId()!=-1){
			  // 导航条链接路径
			  
			  nextPage= prefixPath+morePageUtil.getNextPageId();
			 	java.util.HashMap<Integer,String> m =new java.util.HashMap<Integer,String>();
				 m.put(Integer.valueOf(morePageUtil.getNextPageId()), nextPage);
				
			 request.setAttribute("nextPage", m);
		 
		 }
	//获取页导航条
		 List<java.util.HashMap<Integer,String>> pageIdListBar =new ArrayList<java.util.HashMap<Integer,String>>();
	    List<String> pageIdList=morePageUtil.getAllPageIdOFListBar();
	  for(int i=0;i<pageIdList.size();i++){
		  java.util.HashMap<Integer,String> m=new java.util.HashMap<Integer,String>();
		  String pagePatch=prefixPath+pageIdList.get(i);
		  m.put(Integer.valueOf(pageIdList.get(i)), pagePatch);
		  pageIdListBar.add(m);
	  }
	 request.setAttribute("articleCount", morePageUtil.getobjectSize());
	 request.setAttribute("pageCount", morePageUtil.getPageTotal());
	  request.setAttribute("pageIdListBar", pageIdListBar);
	
	  
		//div page
		
	
         
}
	
	//初始化分页器，
	private void setObjectMorePageView(HttpServletRequest request,java.util.List<Object> listall,int morePageViewId) {
		if(listall==null){
			listall=new java.util.ArrayList<Object>();
		}
		String sessionObjectAttr=this.listViewDateName+"DateListBean"+morePageViewId;
		//创建分页分页逻辑器
		 ObjectMorePageView morepageUtil=new ObjectMorePageView();
		 //将全部分页数据设置到分页器
		 morepageUtil.setobjectList(listall);
		 //数据设置到缓存
		  request.getSession(true).setAttribute(sessionObjectAttr,morepageUtil);
		  System.out.println("分页数据逻辑器："+sessionObjectAttr+ "  记录数："+listall.size());
	}
		
		private ObjectMorePageView getObjectMorePageView(HttpServletRequest request,int morePageViewId) {
			
			String sessionObjectAttr=this.listViewDateName+"DateListBean"+morePageViewId;
			System.out.println("获取分页数据逻辑器："+sessionObjectAttr);
			  
			  return (ObjectMorePageView) request.getSession(true).getAttribute(sessionObjectAttr);
			
			}



		public void setListViewDateName(String listViewDateName) {
			this.listViewDateName = listViewDateName;
		}



		public String getListViewDateName() {
			return listViewDateName;
		}



	


		public void setHasParentId(boolean hasParentId) {
			this.hasParentId = hasParentId;
		}



		public boolean isHasParentId() {
			return hasParentId;
		}



		public void setPageIdJumpActionPath(String pageIdJumpActionPath) {
			this.pageIdJumpActionPath = pageIdJumpActionPath;
		}



		public String getPageIdJumpActionPath() {
			return pageIdJumpActionPath;
		}



		public void setMorePageViewPersistId(int morePageViewPersistId) {
			this.morePageViewPersistId = morePageViewPersistId;
		}



		public  int getMorePageViewPersistId() {
			return morePageViewPersistId;
		}




		protected void setDefaultPageId(int defaultPageId) {
			this.defaultPageId = defaultPageId;
		}

		protected int getDefaultPageId() {
			return defaultPageId;
		}

	
	
		

		
}
