package net.juluu.app.core.webstart.tomcat;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hibernate.SessionFactory;
import org.juuluu.html.PublishConfig;

import util.DaoService;

/** mall.kgmall.config.HibernateUitlService
 * Servlet implementation class HibernateUitlService
 */


public class CommentWebAppStart extends HttpServlet {
	private static final long serialVersionUID = 1L;
    private  DaoService hibernateUtil;
    
    /**
     * @see HttpServlet#HttpServlet()
     */
    public CommentWebAppStart() {
        super();
        // TODO Auto-generated constructor stub
      
    }

	/**
	 * @see Servlet#init(ServletConfig)
	 * 
	 */
	public void init(ServletConfig config) throws ServletException {
		// TODO Auto-generated method stub
		PublishConfig cf=	PublishConfig.getInstance()
		;
		if(cf.isBStartHibernate()==true){
			System.out.println("加载hibernate启动配置，自动启动");	
			ServletContext ctx=config.getServletContext();
			startHibernateAndSetToContext(ctx);
		}else{
			System.out.println("加载hibernate启动配置，不是自动启动");
		}
	}

	/**
	 * @see Servlet#getServletConfig()
	 */
	public ServletConfig getServletConfig() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("startCms")!=null){
			System.out.println("启动内容管理系统！");
			startCms(request);
			System.out.println("hibernate启动完毕！");
		}else{
			System.out.println("无hibernate启动参数！");
		}
	}
	
	public void startCms(HttpServletRequest request){
		ServletContext ctx=null;
		ctx=request.getSession(true).getServletContext();
		startHibernateAndSetToContext(ctx);
	}
	
	public void startHibernateAndSetToContext(ServletContext ctx){
		DaoService ds=	DaoService.getIntrance();
		//  DaoService.getWebSessionFactory();
		  ds.startHibernate();
		PublishConfig cf=	PublishConfig.getInstance()
			;
			String sessionFactoryName=cf.getHibernatesessionFactoryName();
		  System.out.println("#########################\n\n");
		  System.out.println("zsbacms,启动完毕!\n\n");
		  System.out.println(ctx.getServletContextName());
		  //测试hibernate启动是否成功
		  try {
			  SessionFactory sessionFactory=	 (SessionFactory) new InitialContext()
						.lookup(sessionFactoryName);
			  if(sessionFactory!=null){
				  
				  //加载系统安装目录，模板，JS路径，CSS文件,数据库配置等信息
				  System.out.println("\n\n###########加载系统环境变量##############\n\n");
				  service.entryService.SystemConfigAppEntryService sb= service.entryService.SystemConfigAppEntryService.getInstance();
				  dao.SystemConfigApp configApp=sb.getConfigByName("systemBaseConfig");
				  ctx.setAttribute("SystemConfigApp", configApp);
				  System.out.println("\n系统安装目录:"+configApp.getAppContext());
				  
				  //加载系统变量
				  javax.servlet.ServletContext servletContext= ctx;
				  mall.validaty.AppContextValidatyBean appValidatty=mall.validaty.AppContextValidatyBean.getInstance();
				  appValidatty.initWebContextValdiaty(servletContext);
				  
				  
				  
				  
			  }
			} catch (java.lang.Exception e) {
				e.printStackTrace();
				 System.out.println("\nhibernate 未正常启动!");
				
				//throw new IllegalStateException(
					//	"Could not locate SessionFactory in JNDI");
			}
	}
	/**
	 * 重新加载系统变量
	 */
	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub

	}
	 public  void destroy(){
		 
		  System.out.println("#########################\n\n");
		  System.out.println("释放hibernate资源...\n\n");
		  DaoService.getWebSessionFactory().close();
		  System.out.println("\n\n########################释放hibernate资源,完毕!#\n\n");
		
	  }
}
