package net.juluu.app.core.webstart.jboss;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hibernate.SessionFactory;

/* 插件平台基础配置：hibernate,系统变量等
 * net.juluu.app.core.webstart.jboss.WebAppStartHttpServletJboss7
 */

public class PlugsWebAppStartHttpServletJboss7  extends HttpServlet {
	private static final long serialVersionUID = 1L;
    private  HibernateDaoServiceBean hibernateUtil;
    
    /**
     * @see HttpServlet#HttpServlet()
     */
    public PlugsWebAppStartHttpServletJboss7() {
        super();
        // TODO Auto-generated constructor stub
      
    }

	/**
	 * @see Servlet#init(ServletConfig)
	 * 
	 */
	public void init(ServletConfig config) throws ServletException {
		// TODO Auto-generated method stub
		WebAppBaseConfig cf=	WebAppBaseConfig.getInstance()
		;
		if(cf.isBStartHibernate()==true){
			System.out.println("加载hibernate启动配置，自动启动");	
			ServletContext ctx=config.getServletContext();
			startHibernateAndSetToContext(ctx);
		}else{
			System.out.println("加载hibernate启动配置，不是自动启动");
		}
	}

	/**
	 * @see Servlet#getServletConfig()
	 */
	public ServletConfig getServletConfig() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("startCms")!=null){
			System.out.println("启动内容管理系统！");
			startCms(request);
			System.out.println("hibernate启动完毕！");
		}else{
			System.out.println("无hibernate启动参数！");
		}
	}
	
	public void startCms(HttpServletRequest request){
		ServletContext ctx=null;
		ctx=request.getSession(true).getServletContext();
		startHibernateAndSetToContext(ctx);
	}
	
	public void startHibernateAndSetToContext(ServletContext ctx){
		
		System.out.println("加载插件环境配置");
		HibernateDaoServiceBean ds=	HibernateDaoServiceBean.getIntrance();
		Boolean hibernate_started=(Boolean) ctx.getAttribute("hibernate_started");
		
		if(hibernate_started==null||hibernate_started==false){
			System.out.println("启动hibernate");
			  ds.startHibernate();
				WebAppBaseConfig cf=	WebAppBaseConfig.getInstance();
				//设置为已启动hibernate
				cf.setBStartHibernate(true);				
				ctx.setAttribute("hibernate_started", true);
						
		}else{
			System.out.println("已启动hibernate");
		}
			WebAppBaseConfig cf=	WebAppBaseConfig.getInstance()
			;
			String sessionFactoryName=cf.getHibernatesessionFactoryName();
		  System.out.println("#########################\n\n");
		  System.out.println("zsbacms,启动完毕!\n\n");
		  System.out.println(ctx.getServletContextName());
		  //测试hibernate启动是否成功
		  try {
			  SessionFactory sessionFactory=	 (SessionFactory) new InitialContext()
						.lookup(sessionFactoryName);
			  if(sessionFactory!=null){
				  
				  //加载系统安装目录，模板，JS路径，CSS文件,数据库配置等信息
				  System.out.println("\n\n###########加载系统环境变量##############\n\n");
				  service.entryService.SystemConfigAppEntryService sb= service.entryService.SystemConfigAppEntryService.getInstance();
				  dao.SystemConfigApp configApp=sb.getConfigByName("systemBaseConfig");
				  ctx.setAttribute("SystemConfigApp", configApp);
				  System.out.println("\n系统安装目录:"+configApp.getAppContext());
				  
				  //加载系统变量
				  javax.servlet.ServletContext servletContext= ctx;
				  net.juuluu.plugs.webapp.strutsex.validaty.AppContextValidatyBean appValidatty=net.juuluu.plugs.webapp.strutsex.validaty.AppContextValidatyBean.getInstance();
				  appValidatty.initWebContextValdiaty(servletContext);
				  
				  
				  
				  
			  }
			} catch (java.lang.Exception e) {
				e.printStackTrace();
				 System.out.println("\nhibernate 未正常启动!");
				
				//throw new IllegalStateException(
					//	"Could not locate SessionFactory in JNDI");
			}
	}
	/**
	 * 重新加载系统变量
	 */
	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub

	}
	 public  void destroy(){
		 
		  System.out.println("#########################\n\n");
		  System.out.println("释放hibernate资源...\n\n");
		  HibernateDaoServiceBean.getWebSessionFactory().close();
		  System.out.println("\n\n########################释放hibernate资源,完毕!#\n\n");
		
	  }

}
