package net.juluu.app.core.webstart.jboss;

import java.io.File;

import javax.naming.*;

import org.hibernate.cfg.Configuration;
import org.hibernate.SessionFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.apache.naming.NamingService;
import org.hibernate.Session;



import java.lang.ThreadLocal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Driver;

import org.apache.juli.logging.LogFactory;


/**
 *  util.DaoService 
 * @author root
 *
 */
public class HibernateDaoServiceBean{
	
	
	private static final String SessionFactoryName = "zsbacmsSessionFactory";

	private static  SessionFactory sessionFactory;
	
	private static ThreadLocalSessionContext ctx;
	
	private static HibernateDaoServiceBean  daoService=new HibernateDaoServiceBean();
	private static String configFile="/hibernate.cfg.xml";
	private static boolean isStarted=false;
	
	
static{
	if(getSessionFactory()==null){
		//改为手动启动
		//setSessionFactory(getWebSessionFactory());
	}else {
		if (daoService==null){
			daoService=new HibernateDaoServiceBean();
		}		
	}	
}


private HibernateDaoServiceBean(){

}
	
	public static HibernateDaoServiceBean getIntrance() {
		if (daoService==null){
			daoService=new HibernateDaoServiceBean();
			//改为手动启动
			//setSessionFactory(getWebSessionFactory());
			return daoService;
		}else{
			return daoService;
		}
		
	}
	 //启动hibernate 
	public void startHibernate(){
		this.isStarted=true;
		setSessionFactory(getWebSessionFactory());
		
		 util.DaoService ds= util.DaoService.getIntrance();
		 
		 System.out.println("Set Jboss Hibernate to App System Cache!");
		 ds.setSessionFactory(getSessionFactory());
	}
	
	
	
  public static  SessionFactory getWebSessionFactory(){
	  
	  if(HibernateDaoServiceBean.isStarted==false){
		  System.out.println("Hibernate未启动，请手动启动hibernate!");
		//  throw new Exception(""Hibernate未启动，请手动启动hibernate!"");
		 return null;
	  }
		 SessionFactory ss=null;		

		  if(sessionFactory!=null){
			  return sessionFactory;
		  }else{
				
			 // ss=fileStartHibernate();
			  //jboss7
				ss=fileStartHibernate_webinf();		
				
		  sessionFactory=ss;
		  return sessionFactory;
		  }
	     
  }
  

  
  @SuppressWarnings("static-access")
public static  SessionFactory getGUISessionFactory(){
	  
	  if(HibernateDaoServiceBean.isStarted==false){
		  System.out.println("Hibernate未启动，请手动启动hibernate!");
		//  throw new Exception(""Hibernate未启动，请手动启动hibernate!"");
		 return null;
	  }
		 SessionFactory ss=null;		

		  if(sessionFactory!=null){
			  return sessionFactory;
		  }else{	  
								
		//ss=fileStartHibernate();
			  //jboss7
		ss=fileStartHibernate_webinf();		
		  sessionFactory=ss;
		  return sessionFactory;
		  }
}
  
  
  //for jboss7
  public static SessionFactory fileStartHibernate_webinf(){
	  
	  SessionFactory ss=null;	
	  try{ 
			
			
			System.setProperty("java.naming.factory.initial",  
			 "org.apache.naming.java.javaURLContextFactory");
			 System.setProperty("java.naming.factory.pkgs",  "org.apache.naming");
		
		
			// ss=new Configuration().configure(configFile).buildSessionFactory();
            // URL root=       ClassLoader.getSystemResource("/");
		       URL root=       ClassLoader.getSystemResource("/");
            
		       
		       URL currentDir=  HibernateDaoServiceBean.class.getResource("");
            
             
             if(root!=null){
                  System.out.println("ClassLoader.getSystemResource 系统根目录："+String.valueOf(root));
             }else{
          	   System.out.println("ClassLoader.getSystemResource(\" / \") 不支持！");
                 
             }
             
             //配置文件路径 
             String appRoot="";
             Configuration ct=new Configuration();
             // System.out.println("hibernate目录："+  ct.getClass().getResource(""));

               
               //获取当前类文件路径，根据类文件路径获取hibernate配置文件
          
             if(currentDir!=null){
             	//获取根文件路径和hibernate配置文件
                 appRoot=String.valueOf(currentDir);
                 File dirDaoserverUtil=new File(appRoot);
                 System.out.println("\n\n网站类根目录："+dirDaoserverUtil.getParent());
                 
           
                 
                 //创建配置路径
                 String hibernateFile=currentDir+"/hibernate.cfg.xml";
                 
                 //linux系统下要求带/ 完整为file:/
                 hibernateFile=   hibernateFile.replace("file:", "");
                 hibernateFile=   hibernateFile.replace("file:", "");               
                 //jboss 7
                 hibernateFile=	hibernateFile.replace("vfs:", "");
                 
                 hibernateFile=hibernateFile.replace("/net/juluu/app/core/webstart/jboss", "");
               
                     File hfile=new File(hibernateFile);
                     
                     
                     System.out.println("\n\nhibernate 配置文件："+hfile.getPath());
                    if(hfile.exists()==false){
                        hfile.createNewFile();
                    }
                    
                    System.out.println("  当前目录："+String.valueOf(currentDir)
                    		+" getFile():"+hibernateFile
                   );
           
               
             //创建sessionFactory	
             //  File hibernateParentDir=new File()
  			 ss=ct.configure(hfile).buildSessionFactory();
  			 //无法获取类路径时，使用根文件
             }else{
             	System.out.println("  无法获取当前目录");
             //创建sessionFactory	 
    			 ss=ct.configure(configFile).buildSessionFactory();
             }


	  	}catch(Exception e){
	  		e.printStackTrace();
	  	}
	  
	  return ss;
  }
  
  
  //for tomcat5,6,7
  public static SessionFactory fileStartHibernate(){
	  
	  SessionFactory ss=null;	
	  try{ 
			
			
			System.setProperty("java.naming.factory.initial",  
			 "org.apache.naming.java.javaURLContextFactory");
			 System.setProperty("java.naming.factory.pkgs",  "org.apache.naming");
		
		
			// ss=new Configuration().configure(configFile).buildSessionFactory();
            // URL root=       ClassLoader.getSystemResource("/");
		       URL root=       ClassLoader.getSystemResource("/");
            
		       
		       URL currentDir=  HibernateDaoServiceBean.class.getResource("");
            
             
             if(root!=null){
                  System.out.println("ClassLoader.getSystemResource 系统根目录："+String.valueOf(root));
             }else{
          	   System.out.println("ClassLoader.getSystemResource(\" / \") 不支持！");
                 
             }
             
             //配置文件路径 
             String appRoot="";
             Configuration ct=new Configuration();
             // System.out.println("hibernate目录："+  ct.getClass().getResource(""));

               
               //获取当前类文件路径，根据类文件路径获取hibernate配置文件
          
             if(currentDir!=null){
             	//获取根文件路径和hibernate配置文件
                 appRoot=String.valueOf(currentDir);
                 File dirDaoserverUtil=new File(appRoot);
                 System.out.println("\n\n网站类根目录："+dirDaoserverUtil.getParent());
              
                 
                 //创建配置路径
                 String hibernateFile=dirDaoserverUtil.getParent()+"/hibernate.cfg.xml";
                 //linux系统下要求带/ 完整为file:/
                 //创建配置路径
            
                 //linux系统下要求带/ 完整为file:/
                 hibernateFile=   hibernateFile.replace("file:", "");
                 hibernateFile=   hibernateFile.replace("file:", "");               
  		
                 hibernateFile=	hibernateFile.replace("vfs:", "");
                 hibernateFile=hibernateFile.replace("/net/juluu/app/core/webstart/jboss", "");
          
                     File hfile=new File(hibernateFile);
                     System.out.println("\n\nhibernate 配置文件："+hfile.getPath());
                    if(hfile.exists()==false){
                        hfile.createNewFile();
                    }
                    
                    System.out.println("  当前目录："+String.valueOf(currentDir)+" getFile():"+currentDir.getFile()
                   );
           
               
             //创建sessionFactory	
             //  File hibernateParentDir=new File()
  			 ss=ct.configure(hfile).buildSessionFactory();
  			 //无法获取类路径时，使用根文件
             }else{
             	System.out.println("  无法获取当前目录");
             //创建sessionFactory	 
    			 ss=ct.configure(configFile).buildSessionFactory();
             }


	  	}catch(Exception e){
	  		e.printStackTrace();
	  	}
	  
	  return ss;
  }
  

//启动事务
 public Transaction beginTransaction(){

		SessionFactory ss=this.sessionFactory;
		if(ss==null){
			try {
				ss = (SessionFactory)	new InitialContext()
				.lookup(SessionFactoryName);
				setSessionFactory(ss);
				
			} catch (NamingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	
	  Session session=ss.getCurrentSession();
	 
	 return  session.beginTransaction();
 
	  }
 //关闭事务
 public void commitTransaction(Transaction transaction){
	  transaction.commit(); 
	  //关闭会话
	  this.closeSession();
 }
 
 
 


 


public static void close() {
	// TODO Auto-generated method stub
	
//	getSessionFactory().close();
}

public static void setSessionFactory(SessionFactory sessionFactory) {
	HibernateDaoServiceBean.sessionFactory = sessionFactory;
}

public static SessionFactory getSessionFactory() {
	return sessionFactory;
}
/**
* 通过线程变量管理hibernate 会话变量,建立多线程访问会话机制
*/
public static final ThreadLocal sessionThread = new ThreadLocal();

public static Session openSession() throws HibernateException { 
	Session s = (Session) sessionThread.get();
	// Open a new Session, if this Thread has none yet 
if (s == null) { 
	//System.out.println("创建hibernate session");
	s = sessionFactory.openSession();
	sessionThread.set(s); 
}
return s; 
} 

public static void closeSession() throws 
HibernateException { 
	Session s = (Session) sessionThread.get(); 
	sessionThread.set(null);
if (s != null) s.close();
} 

public   static void  main(String argv[]){
	 
	  System.setProperty("java.naming.factory.initial",  
		 "org.apache.naming.java.javaURLContextFactory");
		 System.setProperty("java.naming.factory.pkgs",  "org.apache.naming");
 
        HibernateDaoServiceBean ds=HibernateDaoServiceBean.getIntrance();
        ds.startHibernate();
       org.hibernate.Transaction ts= ds.beginTransaction();
		
			com.juuluu.kgcore.dao.MenuHome a=new com.juuluu.kgcore.dao.MenuHome();
			//dao.Menu b= (dao.Menu)((dao.MenuHome)a).findById(30);
			// System.out.println(b.getAddtime()+"lssssssssssssssss"
			//		 +b.getCmsArticledata().getContent()
				//	 +"ddddddddddddddddddddd");
			System.out.println(a.getList().size());
			 
		ts.commit();
ds.closeSession();
			
	  
 }



public void setStarted(boolean isStarted) {
	this.isStarted = isStarted;
}

public boolean isStarted() {
	return isStarted;
}
 
}
