package mall.saler;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import service.entryService.MallShopDianPuEntryService;
import service.entryService.MallShopDianpuUserEntryService;

import com.juuluu.kgcore.dao.Member;
import dao.MallShopDianPu;
import dao.MallShopDianpuUser;
/**
 * 项目商家操作权限审核
 * @author Administrator
 *
 */

import mall.saler.validaty.SessionValidaty;
import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;

public class QuanXangSaler {
private QuanXangSaler(){}
private static QuanXangSaler instance;
public static int Type_SuperAdmin=1;
public static int Type_SalerAdmin=2;
public static int Type_BuyerAdmin=3;
public static int Type_NoLoginEdUser=4;
private static String loginPage="/mall/systemManage/KgMallSalerAdminHome/loginforward.jsp";
public static QuanXangSaler getInstance(){
	if(instance==null){
		instance=new QuanXangSaler();
	}
	return instance;
}

//项目商家操作权限审核
public boolean checkMustSalerCaoZeoQuanXang( HttpServletRequest request,  HttpServletResponse response){
	com.juuluu.kgcore.base.SystemUserLogin ulogin=SessionValidaty.getInstance()
			.getSystemUserLoginSession(request);
	//登录超时，或未登录
	//未登录
	if(ulogin==null){	
		System.out.println("未登录用户！");
		 toLoginSalerJsp(request,response);	
		 return false;
	}//end if
	dao.MallShopDianpuUser userDianPu=	
			(dao.MallShopDianpuUser)SessionValidaty.getInstance()
			.getMallShopDianpuUserSession(request);
	com.juuluu.kgcore.dao.Member userSystem=ulogin.getUser();	
	
	//未以店铺用户登录，
	if(userDianPu==null){
		//是否开通店铺
		com.juuluu.kgcore.base.SystemUserLogin userSystemlogined=SessionValidaty.getInstance()
				.getSystemUserLoginSession(request);
		com.juuluu.kgcore.dao.Member uedit=userSystemlogined.getUser();
		//获取店主资料
		long systemUserId0=uedit.getUserid();
		  dao.MallShopDianpuUser ud=(MallShopDianpuUser) service.entryService.MallShopDianpuUserEntryService.getInstance()
		  .getUserBYSystemUserId(systemUserId0);
		 //注册用户未开通店铺，转到店铺注册页
		  if(ud==null){
			  //未开通店铺
			 toLoginSalerJsp(request,response);		
			 return false;
			
		  }//end if
		  
		  	//将默认店铺添加到会话
		  SessionValidaty.getInstance().setMallShopDianpuUserSession(request, ud);
		  	//.setMallShopDianpuUserSession(request,ud);
			
		  //获取店主默认店铺
			Integer dianPuid=ud.getDefaultDianPuId();
			
			if(dianPuid==null){
				request.setAttribute("info", "错误，无权编辑！");
				 return false;
			}
			
				mall.edit.DianPuEditInitBean db=mall.edit.DianPuEditInitBean.getInstance();
			//初始化店主环境
				boolean d=	db.initEdit(dianPuid,request);
				if(d==false){
					request.setAttribute("info", "错误，无权编辑！");
				
				}else{
				
				}	
		 // request.setAttribute("ShopDianpuUser", ud);
		
		  userDianPu=ud;
		
	}//end if
	

		//项目商家未登录
		if(userDianPu==null){
			System.out.println("未以项目商家身份登录，无会话ID。");
			request.setAttribute("info", "无此操作权限，请先登录网站。");
			 toLoginSalerJsp(request,response);	
			
		}
	
	//不是超级管理员,判断是否项目商家及本人
	if(ulogin.isBsuerAdmin()==false){
		if(ulogin.getUserLoginType().equals(ulogin.Type_User_ShopSaler)==false){
			System.out.println("未以项目商家身份登录！");
			 toLoginSalerJsp(request,response);	
		}else{
			//不是登录项目商家
			System.out.println("安全过滤：确认项目商家身份登录，通过");
		}//end if
	}else{
		System.out.println("安全过滤：超级管理员身份登录，通过");
	}
	
	
		
	
	//加载店铺信息
return true;
	
}//end method

private void toLoginSalerJsp(HttpServletRequest request,
		HttpServletResponse response) {
	// TODO Auto-generated method stub
	 try {  
		  //将商城会员添加到缓存
		  request.setAttribute("info","无相关操作权限，请以项目商家登录系统。");
		  Member regUser	= SessionValidaty.getInstance().getMemberSession(request);//(request, ud);
		  //=sysUserBean.getByUserLoginName(user.getUserName());
		  
		  if(regUser!=null){
			  request.getSession(true).setAttribute("MemberLogined", regUser);
		  }else{
			  System.out.println("未登录用户，无权执行该操作，请先登录系统。");
			  request.setAttribute("login_msg", "未登录用户，无权执行该操作，请先登录系统。");
			  
			  
			 }
		
		//  request.setAttribute("info", "无此操作权限，请先登录网站。");
		 // System.out.println("您尚未开通店铺业务");
		  if(response.isCommitted()==false){
			try {
				System.out.println("isCommitted false");
				request.getRequestDispatcher(loginPage).forward(request, response);
				
				 System.out.println("1");
				} catch (ServletException e) {
			// TODO Auto-generated catch block
					e.printStackTrace();
				}
					return ;
				}else{
					
					 System.out.println("flushBuffer");
				response.flushBuffer();
		
				request.getRequestDispatcher(loginPage).forward(request, response);
				
		
			}
	  	} catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	  	} catch (ServletException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}			
	
}

//判断是否本人操作,用于防止串改数据情况
public boolean isMyselfSalerLogined(long uid, HttpServletRequest request,  HttpServletResponse response){
	com.juuluu.kgcore.base.SystemUserLogin ulogin=SessionValidaty.getInstance()
			.getSystemUserLoginSession(request);
dao.MallShopDianpuUser userDianPu=	
SessionValidaty.getInstance().getMallShopDianpuUserSession(request);

//取会话中的用户及ID
   long duid=userDianPu.getUserid();
   if(duid==uid){
	   return true;
   }else{
	   return false;
   }
   
}
public dao.MallShopDianPu getDianPuEditCurrent(HttpServletRequest request,HttpServletResponse response){
	com.juuluu.kgcore.base.SystemUserLogin ulogin=
			SessionValidaty.getInstance().getSystemUserLoginSession(request);
	if(ulogin==null){
		return null;
	}
	
	MallShopDianPu userDianPu=	
			 SessionValidaty.getInstance().getMallShopDianPuSession(request);//, ud);
if(userDianPu==null){
	
	
	com.juuluu.kgcore.dao.Member sysuser=ulogin.getUser();
	long systemUserId0=sysuser.getUserid();
	dao.MallShopDianpuUser dbuser= MallShopDianpuUserEntryService.getInstance()
			.getUserBYSystemUserId(systemUserId0);
	
	if(dbuser==null){
		return null;
	}
	
	dao.MallShopDianPu dp=MallShopDianPuEntryService.getInstance()
			.getByDianPuName(dbuser.getDefalutDianPuName());
	
	
	if(dp!=null){
		 SessionValidaty.getInstance().setMallShopDianpuUserSession(request,dbuser);
		 SessionValidaty.getInstance().setMallShopDianPuSession(request,  dp);
		
		
		
		
		return dp;
	}else{
		request.setAttribute("info", "当前未发现编辑店铺，请选择。");
		try {
			if(response.isCommitted()==false){
				request.getRequestDispatcher(loginPage).forward(request, response);
				return null;
			}else{
				response.flushBuffer();
				response.sendRedirect(loginPage);
				return null;
			}
		} catch (ServletException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	
}
return userDianPu;
}


public dao.MallShopDianpuUser getDianPuUser( HttpServletRequest request,  HttpServletResponse response){
	com.juuluu.kgcore.base.SystemUserLogin ulogin=SessionValidaty.getInstance()
			.getSystemUserLoginSession(request);
dao.MallShopDianpuUser userDianPu=  SessionValidaty.getInstance().getMallShopDianpuUserSession(request);//("MallShopDianpuUserSession");

//取会话中的用户及ID

if(userDianPu==null){
	request.setAttribute("info", "项目商家未登录，请登录。");
	try {
		if(response.isCommitted()==false){
			request.getRequestDispatcher(loginPage).forward(request, response);
			return null;
		}else{
			response.flushBuffer();
			response.sendRedirect(loginPage);
		}
	} catch (ServletException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (IOException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
}//end if
return userDianPu;
}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
