package mall.myshop.DpCMS.view;

import java.util.List;

import mall.myshop.DpCMS.MyShopCmsUtil;

import service.entryService.MallShopCmsCatEntryService;
import service.entryService.MallShopDianPuEntryService;
import service.entryService.MallShopMallArticleEntryService;
import dao.MallShopCmsCat;
import dao.MallShopDianPu;
import dao.MallShopMallArticle;
/*
 * mall.myshop.DpCMS.view.DpCmsViewUtil
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class DpCmsViewUtil {

	public MallShopMallArticle getArticleView(int dianpuId, String title,
			String catname) {
		// TODO Auto-generated method stub

		MallShopMallArticle a=null;
		//通过英文文章分类查找
		a=(MallShopMallArticle)
				MallShopMallArticleEntryService.getInstance()
				.getByDpIdTitleCNCatName((long)dianpuId, title, catname);
		//通过中文文章分类查找
		if(a==null){
			a=(MallShopMallArticle)
					MallShopMallArticleEntryService.getInstance()
					.getByDpIdTitleEnCatName((long)dianpuId, title, catname);
			
		}
		
		return a;
	}
	
	
	public MallShopMallArticle getArticleBySysKey(int dianpuId, String catname_en,String syskey
			) {
		// TODO Auto-generated method stub

		//	cat		
		MallShopCmsCat cat=(MallShopCmsCat)
				MallShopCmsCatEntryService.getInstance()
		.getCatByDpIdCatNameEn(dianpuId, catname_en);
		
		if(cat==null){
			System.out.println("店铺文章分类不存在，创建默认分类："+catname_en);
			cat=new MallShopCmsCat();
			
			cat.setShopDpId(dianpuId);
			dao.MallShopDianPu dp=(MallShopDianPu) MallShopDianPuEntryService.getInstance()
					.get(dianpuId);
			cat.setShopDpName(dp.getDianpuName());
			
			cat.setCatNameCn(catname_en);
			cat.setCatNameEn(catname_en);
			cat.setHtmlTitle(catname_en);
			cat.setHtmlKeyWord(catname_en);
			cat.setHtmlDescription(catname_en);
			MallShopCmsCatEntryService.getInstance()
			.merge(cat);
			 cat=(MallShopCmsCat)
						MallShopCmsCatEntryService.getInstance()
				.getCatByDpIdCatNameEn(dianpuId, catname_en);
		}
		

		
		MallShopMallArticle a=null;
		//通过英文文章分类查找
		a=(MallShopMallArticle)
				MallShopMallArticleEntryService.getInstance()
				.getArticleByDpIdEnCatNameSysKey((long)dianpuId, catname_en, syskey);
		//((long)dianpuId, title, catname);
		
		if(a==null){
			
			System.out.println("店铺文章不存在，创建默认文章,文章系统标识："+syskey);
			
			a=new MallShopMallArticle();
			a.setCatId(cat.getCatId());
			a.setCatNameCn(cat.getCatNameCn());
			a.setCatNameEn(cat.getCatNameEn());
			a.setContent(syskey);
			a.setCreateTime(new java.util.Date(System.currentTimeMillis()));
			a.setDianpuId((long)cat.getShopDpId());
			a.setDianPuName(cat.getShopDpName());
			a.setSystemTag(syskey);
			a.setTitle(syskey);
			
			MallShopMallArticleEntryService.getInstance()
			.merge(a);
			a=(MallShopMallArticle)
					MallShopMallArticleEntryService.getInstance()
					.getArticleByDpIdEnCatNameSysKey((long)dianpuId, catname_en, syskey);
		
		}
		
		
		return a;
	}

	public List<ShopCmsIndexCatArticleListViewBean> getCmsIndexCatArticleListTags(dao.MallShopDianPu  dp){
		
		int dpid=dp.getDianPuId();
		
		MyShopCmsUtil cmsutil=new MyShopCmsUtil();
		List<MallShopCmsCat> listCat=cmsutil.getShopCmsCatList(dp);
		List<ShopCmsIndexCatArticleListViewBean> catDataListIndex=new java.util.ArrayList<ShopCmsIndexCatArticleListViewBean>();
		for(int i=0;i<listCat.size();i++){

			ShopCmsIndexCatArticleListViewBean catView=new ShopCmsIndexCatArticleListViewBean();
			
			MallShopCmsCat cat=listCat.get(i);
			
			catView.setDpId(dp.getDianPuId());
			
			catView.setCatId(cat.getCatId());
			
			catView.setCatNameCn(cat.getCatNameCn());
			
			catView.setCatNameEn(cat.getCatNameEn());
		
			
			MallShopMallArticleEntryService as=	MallShopMallArticleEntryService.getInstance()
			;
			int maxResult=10;
			List<MallShopMallArticle> newArticleList=as.getListByDpCmsCatId(cat.getCatId(), maxResult);
		
			catView.setNewArticleList(newArticleList);
			
			catDataListIndex.add(catView);
		}
		
		return catDataListIndex;
		
	}
	public ShopCmsCatTopArticleListViewBean getShopCmsCatTopArticleListViewBean(int catid){
		ShopCmsCatTopArticleListViewBean catView=new ShopCmsCatTopArticleListViewBean();
		
		MallShopCmsCat cat=(MallShopCmsCat) MallShopCmsCatEntryService.getInstance()
				.get(catid);
		List<MallShopMallArticle>	alist=getTopNewCatArticleListTags( cat);
		
		catView.setDpId(cat.getShopDpId());
		
		catView.setCatId(cat.getCatId());
		
		catView.setCatNameCn(cat.getCatNameCn());
		
		catView.setCatNameEn(cat.getCatNameEn());
		
		catView.setNewArticleList(alist);
		
		return catView;
	
	}
	
	public List<MallShopMallArticle>	getTopNewCatArticleListTags(MallShopCmsCat cat){
		
		
		MyShopCmsUtil cmsutil=new MyShopCmsUtil();
		List<ShopCmsIndexCatArticleListViewBean> catDataListIndex=new java.util.ArrayList<ShopCmsIndexCatArticleListViewBean>();
		

			
			MallShopMallArticleEntryService as=	MallShopMallArticleEntryService.getInstance()
			;
			int maxResult=10;
			List<MallShopMallArticle> newArticleList=as.getListByDpCmsCatId(cat.getCatId(), maxResult);
		
			
		
		return newArticleList;
		
	}
}
