package mall.kgmall.webCount.action;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import juuluuApp.appPermission.core.JuuluuAppPermissionCheckUtil;

import kgSiteCount.core.report.ReportTimeUtil;
import kgSiteCount.core.report.WebCountReportUtil;
import kgSiteCount.core.report.view.ItemCountReportViewBean;

import mall.kgmall.webCount.report.MallBuyerCountReportUtil;
import mall.kgmall.webCount.report.MallProductCountReportUtil;
import mall.kgmall.webCount.report.MallSalerCountReportUtil;
import mall.kgmall.webCount.report.ProductCatCountReportUtil;
import mall.kgmall.webCount.report.ProductSearchCountReportUtil;
import mall.security.portal.core.MallSecurityUserUtil;
import net.juluu.app.security.core.PortalUserLoginConfig;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.jfree.chart.JFreeChart;

import dao.MallCountProductCatLog;
import dao.MallCountShopBuyerLog;
import dao.MallCountShopSalerLog;
import dao.MallCountShopSearchLog;



import service.entryService.KgSiteCountUrlLogEntryService;

/**
 * /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=index
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class MallWebCountReportAction extends DispatchAction {

	//
	@SuppressWarnings("static-access")
	public ActionForward index(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		return mapping.findForward("reportIndexJsp");
	}
	
	public ActionForward indexCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		return mapping.findForward("indexCount_reportIndexJsp");
	}
	
	public ActionForward CatListCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		
		ProductCatCountReportUtil cu=new ProductCatCountReportUtil();
		String viewJspDir="CatListCount";
		//reportType=total
	String reportType=request.getParameter("reportType");
	if(reportType!=null&&reportType.equals("total")){
		//count product click total:
		
		//total all today yestoday month
		long huizong_item_click_all= cu.count_click_Total();
		long huizong_item_click_yestoday= cu.count_click_yestoday();
		long huizong_item_click_today= cu.count_click_today();
		long huizong_item_click_currentMonth= cu.count_click_currentMonth();
		//avg 
		//Double huizong_item_click_avg= cu.avg_MallCountProduct();
		//max product click
		//long huizong_item_click_max= cu.maxClick_MallCountProduct();
		//count product total
		long itemTotal=cu.count_item_Total();
		
		//bean
		ItemCountReportViewBean rb=new ItemCountReportViewBean();
		rb.setHuizong_item_click_all(huizong_item_click_all);
		rb.setHuizong_item_click_yestoday(huizong_item_click_yestoday);
		rb.setHuizong_item_click_today(huizong_item_click_today);
		rb.setHuizong_item_click_currentMonth(huizong_item_click_currentMonth);
		//rb.setHuizong_item_click_avg(huizong_item_click_avg);
		//rb.setHuizong_item_click_max(huizong_item_click_max);
		rb.setItemTotal(itemTotal);
		
		request.setAttribute("ItemCountReportTotalViewBean", rb);
	////new top
				List<MallCountProductCatLog> itemLogList=cu.getList_new_max();
				request.setAttribute("ItemLogNewList", itemLogList);
		
		return mapping.findForward(viewJspDir+"_total_reportJsp");
	}else if(reportType!=null&&reportType.equals("newTop")){
		
		////new top
		List<MallCountProductCatLog> itemLogList=cu.getList_new_max();
		request.setAttribute("ItemLogNewList", itemLogList);
		return mapping.findForward(viewJspDir+"_newTop_reportJsp");
	}else if(reportType!=null&&reportType.equals("hour24_today")){
		
		//24 hour count value today]
		
		JFreeChart chart=cu.zhoushi_24hours_today();
		int width_create=700;
		int height_create=450;
			if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
				width_create=Integer.parseInt(request.getParameter("w"));
				height_create=Integer.parseInt(request.getParameter("h"));
			}
		String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
		request.setAttribute("ChartFileName", fileName);
		
		request.setAttribute("Title_Hour24", "当天24小时访问趋势图");
		
		return mapping.findForward(viewJspDir+"_hour24_reportJsp");
	}else if(reportType!=null&&reportType.equals("hour24_yestoday")){
		
		//24 hour count value today]
		
		JFreeChart chart=cu.zhoushi_24hours_yestoday();
		int width_create=700;
		int height_create=450;
			if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
				width_create=Integer.parseInt(request.getParameter("w"));
				height_create=Integer.parseInt(request.getParameter("h"));
			}
		String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
		request.setAttribute("ChartFileName", fileName);
		
		request.setAttribute("Title_Hour24", "昨天24小时访问趋势图");
	
		return mapping.findForward(viewJspDir+"_hour24_reportJsp");
		
		
	}else if(reportType!=null&&reportType.equals("day_zhoushitu_month_this")){
		
		//day count:			
		//current month per day			
		
		JFreeChart chart=cu.zhoushitu_days_currentMonth();
		int width_create=700;
		int height_create=450;
			if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
				width_create=Integer.parseInt(request.getParameter("w"));
				height_create=Integer.parseInt(request.getParameter("h"));
			}
		String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
		request.setAttribute("ChartFileName", fileName);
		
		
		request.setAttribute("Title_report", " 当月日均访问走势图");
	
		return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
		
	}else if(reportType!=null&&reportType.equals("day_zhoushitu_30day_this")){
		
		//day count:		
		//30 day		
		
		JFreeChart chart=cu.zhoushitu_days_up30days();
		int width_create=700;
		int height_create=450;
			if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
				width_create=Integer.parseInt(request.getParameter("w"));
				height_create=Integer.parseInt(request.getParameter("h"));
			}
		String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
		request.setAttribute("ChartFileName", fileName);
		
		request.setAttribute("Title_report", "最近30天日均访问走势图 ");
		
		return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
	}else{
		////new top
		List<MallCountProductCatLog> itemLogList=cu.getList_new_max();
		request.setAttribute("ItemLogNewList", itemLogList);
		return mapping.findForward(viewJspDir+"_newTop_reportJsp");
	}
		
		//return mapping.findForward("CatListCount_reportIndexJsp");
	}
	
	
	public ActionForward ProductViewCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		
		MallProductCountReportUtil cu=new MallProductCountReportUtil();
		//reportType=total
		String reportType=request.getParameter("reportType");
		if(reportType!=null&&reportType.equals("total")){
			//count product click total:
			
			//total all today yestoday month
			long huizong_item_click_all= cu.count_click_Total();
			long huizong_item_click_yestoday= cu.count_click_yestoday();
			long huizong_item_click_today= cu.count_click_today();
			long huizong_item_click_currentMonth= cu.count_click_currentMonth();
			//avg 
			Double huizong_item_click_avg= cu.avg_MallCountProduct();
			//max product click
			long huizong_item_click_max= cu.maxClick_MallCountProduct();
			//count product total
			long itemTotal=cu.count_item_Total();
			
			//bean
			ItemCountReportViewBean rb=new ItemCountReportViewBean();
			rb.setHuizong_item_click_all(huizong_item_click_all);
			rb.setHuizong_item_click_yestoday(huizong_item_click_yestoday);
			rb.setHuizong_item_click_today(huizong_item_click_today);
			rb.setHuizong_item_click_currentMonth(huizong_item_click_currentMonth);
			rb.setHuizong_item_click_avg(huizong_item_click_avg);
			rb.setHuizong_item_click_max(huizong_item_click_max);
			rb.setItemTotal(itemTotal);
			
			request.setAttribute("ItemCountReportTotalViewBean", rb);
		////new top
					List<dao.MallCountProductLog> itemLogList=cu.getList_new_max();
					request.setAttribute("ItemLogNewList", itemLogList);
			
			return mapping.findForward("productLog_ItemCount_total_reportJsp");
		}else if(reportType!=null&&reportType.equals("newTop")){
			
			////new top
			List<dao.MallCountProductLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward("productLog_ItemCount_newTop_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_today")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_today();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "当天24小时访问趋势图");
			
			return mapping.findForward("productLog_ItemCount_hour24_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_yestoday")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_yestoday();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "昨天24小时访问趋势图");
		
			return mapping.findForward("productLog_ItemCount_hour24_reportJsp");
			
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_month_this")){
			
			//day count:			
			//current month per day			
			
			JFreeChart chart=cu.zhoushitu_days_currentMonth();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			
			request.setAttribute("Title_report", " 当月日均访问走势图");
		
			return mapping.findForward("productLog_ItemCount_day_zhouzhitu_reportJsp_reportJsp");
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_30day_this")){
			
			//day count:		
			//30 day		
			
			JFreeChart chart=cu.zhoushitu_days_up30days();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_report", "最近30天日均访问走势图 ");
			
			return mapping.findForward("productLog_ItemCount_day_zhouzhitu_reportJsp_reportJsp");
		}else{
			////new top
			List<dao.MallCountProductLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward("productLog_ItemCount_newTop_reportJsp");
		}
	
		
		
		//return mapping.findForward("ProductViewCount_reportIndexJsp");
	}
	
	
	public ActionForward ProductSearchCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		
		ProductSearchCountReportUtil cu=new ProductSearchCountReportUtil();
		String viewJspDir="ProductSearchCount";
			//reportType=total
		String reportType=request.getParameter("reportType");
		if(reportType!=null&&reportType.equals("total")){
			//count product click total:
			
			//total all today yestoday month
			long huizong_item_click_all= cu.count_click_Total();
			long huizong_item_click_yestoday= cu.count_click_yestoday();
			long huizong_item_click_today= cu.count_click_today();
			long huizong_item_click_currentMonth= cu.count_click_currentMonth();
			//avg 
			//Double huizong_item_click_avg= cu.avg_MallCountProduct();
			//max product click
			//long huizong_item_click_max= cu.maxClick_MallCountProduct();
			//count product total
			//long itemTotal=cu.count_item_Total();
			
			//bean
			ItemCountReportViewBean rb=new ItemCountReportViewBean();
			rb.setHuizong_item_click_all(huizong_item_click_all);
			rb.setHuizong_item_click_yestoday(huizong_item_click_yestoday);
			rb.setHuizong_item_click_today(huizong_item_click_today);
			rb.setHuizong_item_click_currentMonth(huizong_item_click_currentMonth);
			//rb.setHuizong_item_click_avg(huizong_item_click_avg);
			//rb.setHuizong_item_click_max(huizong_item_click_max);
			//rb.setItemTotal(itemTotal);
			
			request.setAttribute("ItemCountReportTotalViewBean", rb);
		////new top
					List<MallCountShopSearchLog> itemLogList=cu.getList_new_max();
					request.setAttribute("ItemLogNewList", itemLogList);
			
			return mapping.findForward(viewJspDir+"_total_reportJsp");
		}else if(reportType!=null&&reportType.equals("newTop")){
			
			////new top
			List<MallCountShopSearchLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_today")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_today();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "当天24小时访问趋势图");
			
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_yestoday")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_yestoday();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "昨天24小时访问趋势图");
		
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
			
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_month_this")){
			
			//day count:			
			//current month per day			
			
			JFreeChart chart=cu.zhoushitu_days_currentMonth();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			
			request.setAttribute("Title_report", " 当月日均访问走势图");
		
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_30day_this")){
			
			//day count:		
			//30 day		
			
			JFreeChart chart=cu.zhoushitu_days_up30days();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_report", "最近30天日均访问走势图 ");
			
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
		}else{
			////new top
			List<MallCountShopSearchLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}
	
		
		//return mapping.findForward("ProductSearchCount_reportIndexJsp");
	}
	
	
	public ActionForward buyerCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		
		
		String viewJspDir="buyerCount";
		MallBuyerCountReportUtil cu=new MallBuyerCountReportUtil();
		//reportType=total
		String reportType=request.getParameter("reportType");
		if(reportType!=null&&reportType.equals("total")){
			//count product click total:
			
			//total all today yestoday month
			long huizong_item_click_all= cu.count_click_Total();
			long huizong_item_click_yestoday= cu.count_click_yestoday();
			long huizong_item_click_today= cu.count_click_today();
			long huizong_item_click_currentMonth= cu.count_click_currentMonth();
			//avg 
			//Double huizong_item_click_avg= cu.avg_MallCountProduct();
			//max product click
			//long huizong_item_click_max= cu.maxClick_MallCountProduct();
			//count product total
			long itemTotal=cu.count_item_Total();
			
			//bean
			ItemCountReportViewBean rb=new ItemCountReportViewBean();
			rb.setHuizong_item_click_all(huizong_item_click_all);
			rb.setHuizong_item_click_yestoday(huizong_item_click_yestoday);
			rb.setHuizong_item_click_today(huizong_item_click_today);
			rb.setHuizong_item_click_currentMonth(huizong_item_click_currentMonth);
			//rb.setHuizong_item_click_avg(huizong_item_click_avg);
			//rb.setHuizong_item_click_max(huizong_item_click_max);
			rb.setItemTotal(itemTotal);
			
			request.setAttribute("ItemCountReportTotalViewBean", rb);
		////new top
					List<MallCountShopBuyerLog> itemLogList=cu.getList_new_max();
					request.setAttribute("ItemLogNewList", itemLogList);
			
			return mapping.findForward(viewJspDir+"_total_reportJsp");
		}else if(reportType!=null&&reportType.equals("newTop")){
			
			////new top
			List<MallCountShopBuyerLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_today")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_today();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "当天24小时访问趋势图");
			
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_yestoday")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_yestoday();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "昨天24小时访问趋势图");
		
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
			
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_month_this")){
			
			//day count:			
			//current month per day			
			
			JFreeChart chart=cu.zhoushitu_days_currentMonth();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			
			request.setAttribute("Title_report", " 当月日均访问走势图");
		
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_30day_this")){
			
			//day count:		
			//30 day		
			
			JFreeChart chart=cu.zhoushitu_days_up30days();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_report", "最近30天日均访问走势图 ");
			
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
		}else{
			////new top
			List<MallCountShopBuyerLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}
	
		
		
		//return mapping.findForward("buyerCount_reportIndexJsp");
	}
	
	public ActionForward productCommentsCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		return mapping.findForward("productCommentsCount_reportIndexJsp");
	}
	
	
	public ActionForward salerCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		
		String viewJspDir="salerCount";
		MallSalerCountReportUtil cu=new MallSalerCountReportUtil();
		//reportType=total
		String reportType=request.getParameter("reportType");
		if(reportType!=null&&reportType.equals("total")){
			//count product click total:
			
			//total all today yestoday month
			long huizong_item_click_all= cu.count_click_Total();
			long huizong_item_click_yestoday= cu.count_click_yestoday();
			long huizong_item_click_today= cu.count_click_today();
			long huizong_item_click_currentMonth= cu.count_click_currentMonth();
			//avg 
		//	Double huizong_item_click_avg= cu.avg_MallCountProduct();
			//max product click
			//long huizong_item_click_max= cu.maxClick_MallCountProduct();
			//count product total
			long itemTotal=cu.count_item_Total();
			
			//bean
			ItemCountReportViewBean rb=new ItemCountReportViewBean();
			rb.setHuizong_item_click_all(huizong_item_click_all);
			rb.setHuizong_item_click_yestoday(huizong_item_click_yestoday);
			rb.setHuizong_item_click_today(huizong_item_click_today);
			rb.setHuizong_item_click_currentMonth(huizong_item_click_currentMonth);
			//rb.setHuizong_item_click_avg(huizong_item_click_avg);
			//rb.setHuizong_item_click_max(huizong_item_click_max);
			rb.setItemTotal(itemTotal);
			
			request.setAttribute("ItemCountReportTotalViewBean", rb);
		////new top
					List<MallCountShopSalerLog> itemLogList=cu.getList_new_max();
					request.setAttribute("ItemLogNewList", itemLogList);
			
			return mapping.findForward(viewJspDir+"_total_reportJsp");
		}else if(reportType!=null&&reportType.equals("newTop")){
			
			////new top
			List<MallCountShopSalerLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_today")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_today();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "当天24小时访问趋势图");
			
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
		}else if(reportType!=null&&reportType.equals("hour24_yestoday")){
			
			//24 hour count value today]
			
			JFreeChart chart=cu.zhoushi_24hours_yestoday();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_Hour24", "昨天24小时访问趋势图");
		
			return mapping.findForward(viewJspDir+"_hour24_reportJsp");
			
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_month_this")){
			
			//day count:			
			//current month per day			
			
			JFreeChart chart=cu.zhoushitu_days_currentMonth();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			
			request.setAttribute("Title_report", " 当月日均访问走势图");
		
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
			
		}else if(reportType!=null&&reportType.equals("day_zhoushitu_30day_this")){
			
			//day count:		
			//30 day		
			
			JFreeChart chart=cu.zhoushitu_days_up30days();
			int width_create=700;
			int height_create=450;
				if(request.getParameter("w")!=null&&request.getParameter("h")!=null){
					width_create=Integer.parseInt(request.getParameter("w"));
					height_create=Integer.parseInt(request.getParameter("h"));
				}
			String fileName=cu.saveChartToWebSession(chart,width_create,height_create,request);
			request.setAttribute("ChartFileName", fileName);
			
			request.setAttribute("Title_report", "最近30天日均访问走势图 ");
			
			return mapping.findForward(viewJspDir+"_day_zhouzhitu_reportJsp");
		}else{
			////new top
			List<MallCountShopSalerLog> itemLogList=cu.getList_new_max();
			request.setAttribute("ItemLogNewList", itemLogList);
			return mapping.findForward(viewJspDir+"_newTop_reportJsp");
		}
	
		//return mapping.findForward("salerCount_reportIndexJsp");
	}

	
	//

	
	
	public ActionForward zjUserViewCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		return mapping.findForward("zjUserViewCount_reportIndexJsp");
	}
	
	
	
	public ActionForward zjUserCatListCount(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}
		return mapping.findForward("zjUserCatListCount_reportIndexJsp");
	}
	
	
	// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=MallCountProductLog_ListByStartTime&timeType=TimeType_ToDay
	//	//TimeType_YesToDay  TimeType_ToDay  TimeType_MonthCurrent  TimeType_AllTime
	//TimeType_InputTime TimeType_BenZhou TimeType_ShangZhou TimeType_ThreeMonth TimeType_Year
	public ActionForward MallCountProductLog_ListByStartTime(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}

com.juuluu.kgcore.dao.Member userlogin=mall.validaty.SessionValidaty.getInstance().getMemberSession(request);

String timeType=request.getParameter("timeType");
long timeStart=0;
util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
	timeStart=0;
}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
	timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
	timeStart=timeBean.getToDayStartTime();
}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
	timeStart=timeBean.getYestodatyStartTime();
	
}else if(timeType.equals("inputTime")){
	timeStart=timeBean.getYestodatyStartTime();
	
}

request.getSession().setAttribute("queryTimeType_log", timeType);

//List<dao.KgSiteCountUrlLog> userRegList=KgSiteCountUrlLogEntryService.getInstance()
//.getListByStartTimeLOng(timeStart);
//config query

String validatyTime="createTimeLong";
String orderBy="createTimeLong";

net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil
u=new net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil();
dao.MallCountProductLog item=null;

//from dao.KgSiteCountUrlLog where regTimeLong>:regTimeLong0
String HQL="select from dao.MallCountProductLog as f where "+validatyTime+" >="+timeStart+" order by "+orderBy +" desc";
String startTimeStr=request.getParameter("startTimeStr");
String endTimeStr=request.getParameter("endTimeStr");

if(startTimeStr!=null&&endTimeStr!=null){
	WebCountReportUtil ru=new WebCountReportUtil();
	long startTime=ru.getUserSelectTime_hhmmss(startTimeStr);
	long endTime=ru.getUserSelectTime_hhmmss(endTimeStr);
		if(startTime!=-1&&endTime!=-1){
			HQL="select from dao.MallCountProductLog as f where  "+validatyTime+"  >="+startTime 
					+" and  "+validatyTime+"  <="+endTime+" order by "+orderBy +" desc";
		}
		
		request.setAttribute("startTimeStr", startTimeStr);
		request.setAttribute("endTimeStr", endTimeStr);
}

//每页显示记录数
int maxrowsPage=20;
//每页显示分页ID数
int pageIdlinkCount=8;
//创建分页配置
net.juuluu.webUtil.DatePage.Listdata.ListDataConfig config=u.createConfig(HQL,maxrowsPage,pageIdlinkCount);
 request.getSession().setAttribute("ListDataConfig", config);
 
 u.getpagePageResult(request);		

//request.setAttribute("KgSiteCountUrlLogList", userRegList);


//生成授权码
//String path="/systemManage/SoftDevProjectUserHome/index.jsp";

//ActionForward a=new ActionForward();
//a.setPath(path);

//a.setRedirect(false);
//return a;
String target="MallCountProductLog_UrlListCountByStartTimejsp";		
return mapping.findForward(target);

}
	
	
	@SuppressWarnings("static-access")
	// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=article_mingXiLogIndex
	public ActionForward MallCountProductLog_mingXiIndex(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {

		String permissionSystemKey="Mall.WebCount";
		// 初始化控制器
		MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
		PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
		// 获取用户所在权限组，测试是否授权该用户访问该方法
		JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
		ActionForward errorCheckAction = checkBean
				.methodmemberAndGronpDbPermissionCheck(request,
						potalUserLoginConfig,permissionSystemKey);
		if (errorCheckAction != null) {
			return errorCheckAction;
		}

String timeType=ReportTimeUtil.TimeType_ToDay;
long timeStart=0;
util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
	timeStart=0;
}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
	timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
	timeStart=timeBean.getToDayStartTime();
}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
	timeStart=timeBean.getYestodatyStartTime();
	
}



return mapping.findForward("MallCountProductLog_mingXiLogIndexJsp");
	}
	
	
	
	// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=MallCountProductCatLog_ListByStartTime&timeType=TimeType_ToDay
		//	//TimeType_YesToDay  TimeType_ToDay  TimeType_MonthCurrent  TimeType_AllTime
		//TimeType_InputTime TimeType_BenZhou TimeType_ShangZhou TimeType_ThreeMonth TimeType_Year
		public ActionForward MallCountProductCatLog_ListByStartTime(ActionMapping mapping,
				ActionForm form, 
				HttpServletRequest request, 
				HttpServletResponse response)
				throws IOException, ServletException {

			String permissionSystemKey="Mall.WebCount";
			// 初始化控制器
			MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
			PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
			// 获取用户所在权限组，测试是否授权该用户访问该方法
			JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
			ActionForward errorCheckAction = checkBean
					.methodmemberAndGronpDbPermissionCheck(request,
							potalUserLoginConfig,permissionSystemKey);
			if (errorCheckAction != null) {
				return errorCheckAction;
			}

	com.juuluu.kgcore.dao.Member userlogin=mall.validaty.SessionValidaty.getInstance().getMemberSession(request);

	String timeType=request.getParameter("timeType");
	long timeStart=0;
	util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
	if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
		timeStart=0;
	}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
		timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
	}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
		timeStart=timeBean.getToDayStartTime();
	}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
		timeStart=timeBean.getYestodatyStartTime();
		
	}else if(timeType.equals("inputTime")){
		timeStart=timeBean.getYestodatyStartTime();
		
	}

	request.getSession().setAttribute("queryTimeType_log", timeType);

	//List<dao.KgSiteCountUrlLog> userRegList=KgSiteCountUrlLogEntryService.getInstance()
	//.getListByStartTimeLOng(timeStart);
	//config query

	String validatyTime="createTimeLong";
	String orderBy="createTimeLong";

	net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil
	u=new net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil();
	dao.MallCountProductCatLog item=null;

	//from dao.KgSiteCountUrlLog where regTimeLong>:regTimeLong0
	String HQL="select from dao.MallCountProductCatLog as f where "+validatyTime+" >="+timeStart+" order by "+orderBy +" desc";
	String startTimeStr=request.getParameter("startTimeStr");
	String endTimeStr=request.getParameter("endTimeStr");

	if(startTimeStr!=null&&endTimeStr!=null){
		WebCountReportUtil ru=new WebCountReportUtil();
		long startTime=ru.getUserSelectTime_hhmmss(startTimeStr);
		long endTime=ru.getUserSelectTime_hhmmss(endTimeStr);
			if(startTime!=-1&&endTime!=-1){
				HQL="select from dao.MallCountProductCatLog as f where  "+validatyTime+"  >="+startTime 
						+" and  "+validatyTime+"  <="+endTime+" order by "+orderBy +" desc";
			}
			
			request.setAttribute("startTimeStr", startTimeStr);
			request.setAttribute("endTimeStr", endTimeStr);
	}

	//每页显示记录数
	int maxrowsPage=20;
	//每页显示分页ID数
	int pageIdlinkCount=8;
	//创建分页配置
	net.juuluu.webUtil.DatePage.Listdata.ListDataConfig config=u.createConfig(HQL,maxrowsPage,pageIdlinkCount);
	 request.getSession().setAttribute("ListDataConfig", config);
	 
	 u.getpagePageResult(request);		

	//request.setAttribute("KgSiteCountUrlLogList", userRegList);


	//生成授权码
	//String path="/systemManage/SoftDevProjectUserHome/index.jsp";

	//ActionForward a=new ActionForward();
	//a.setPath(path);

	//a.setRedirect(false);
	//return a;
	String target="CatListCount_UrlListCountByStartTimejsp";		
	return mapping.findForward(target);

	}
		
		
		@SuppressWarnings("static-access")
		// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=article_mingXiLogIndex
		public ActionForward MallCountProductCatLog_mingXiIndex(ActionMapping mapping,
				ActionForm form, 
				HttpServletRequest request, 
				HttpServletResponse response)
				throws IOException, ServletException {

			String permissionSystemKey="Mall.WebCount";
			// 初始化控制器
			MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
			PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
			// 获取用户所在权限组，测试是否授权该用户访问该方法
			JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
			ActionForward errorCheckAction = checkBean
					.methodmemberAndGronpDbPermissionCheck(request,
							potalUserLoginConfig,permissionSystemKey);
			if (errorCheckAction != null) {
				return errorCheckAction;
			}

	String timeType=ReportTimeUtil.TimeType_ToDay;
	long timeStart=0;
	util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
	if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
		timeStart=0;
	}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
		timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
	}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
		timeStart=timeBean.getToDayStartTime();
	}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
		timeStart=timeBean.getYestodatyStartTime();
		
	}



	return mapping.findForward("MallCountProductCatLog_mingXiLogIndexJsp");
		}
		
		
		// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=MallCountShopBuyerLog_ListByStartTime&timeType=TimeType_ToDay
				//	//TimeType_YesToDay  TimeType_ToDay  TimeType_MonthCurrent  TimeType_AllTime
				//TimeType_InputTime TimeType_BenZhou TimeType_ShangZhou TimeType_ThreeMonth TimeType_Year
				public ActionForward MallCountShopBuyerLog_ListByStartTime(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			com.juuluu.kgcore.dao.Member userlogin=mall.validaty.SessionValidaty.getInstance().getMemberSession(request);

			String timeType=request.getParameter("timeType");
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}else if(timeType.equals("inputTime")){
				timeStart=timeBean.getYestodatyStartTime();
				
			}

			request.getSession().setAttribute("queryTimeType_log", timeType);

			//List<dao.KgSiteCountUrlLog> userRegList=KgSiteCountUrlLogEntryService.getInstance()
			//.getListByStartTimeLOng(timeStart);
			//config query

			String validatyTime="createTimeLong";
			String orderBy="createTimeLong";

			net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil
			u=new net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil();
			dao.MallCountProductCatLog item=null;

			//from dao.KgSiteCountUrlLog where regTimeLong>:regTimeLong0
			String HQL="select from dao.MallCountShopBuyerLog as f where "+validatyTime+" >="+timeStart+" order by "+orderBy +" desc";
			String startTimeStr=request.getParameter("startTimeStr");
			String endTimeStr=request.getParameter("endTimeStr");

			if(startTimeStr!=null&&endTimeStr!=null){
				WebCountReportUtil ru=new WebCountReportUtil();
				long startTime=ru.getUserSelectTime_hhmmss(startTimeStr);
				long endTime=ru.getUserSelectTime_hhmmss(endTimeStr);
					if(startTime!=-1&&endTime!=-1){
						HQL="select from dao.MallCountShopBuyerLog as f where  "+validatyTime+"  >="+startTime 
								+" and  "+validatyTime+"  <="+endTime+" order by "+orderBy +" desc";
					}
					
					request.setAttribute("startTimeStr", startTimeStr);
					request.setAttribute("endTimeStr", endTimeStr);
			}

			//每页显示记录数
			int maxrowsPage=20;
			//每页显示分页ID数
			int pageIdlinkCount=8;
			//创建分页配置
			net.juuluu.webUtil.DatePage.Listdata.ListDataConfig config=u.createConfig(HQL,maxrowsPage,pageIdlinkCount);
			 request.getSession().setAttribute("ListDataConfig", config);
			 
			 u.getpagePageResult(request);		

			String target="buyerCount_UrlListCountByStartTimejsp";		
			return mapping.findForward(target);

			}
				
				
				@SuppressWarnings("static-access")
				// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=article_mingXiLogIndex
				public ActionForward MallCountShopBuyerLog_mingXiIndex(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			String timeType=ReportTimeUtil.TimeType_ToDay;
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}



			return mapping.findForward("MallCountShopBuyerLog_mingXiLogIndexJsp");
				}		
				
				
				// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=MallCountShopSalerLog_ListByStartTime&timeType=TimeType_ToDay
				//	//TimeType_YesToDay  TimeType_ToDay  TimeType_MonthCurrent  TimeType_AllTime
				//TimeType_InputTime TimeType_BenZhou TimeType_ShangZhou TimeType_ThreeMonth TimeType_Year
				public ActionForward MallCountShopSalerLog_ListByStartTime(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			com.juuluu.kgcore.dao.Member userlogin=mall.validaty.SessionValidaty.getInstance().getMemberSession(request);

			String timeType=request.getParameter("timeType");
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}else if(timeType.equals("inputTime")){
				timeStart=timeBean.getYestodatyStartTime();
				
			}

			request.getSession().setAttribute("queryTimeType_log", timeType);

			
			//config query
			String validatyTime="createTimeLong";
			String orderBy="createTimeLong";
			String entryClass_query="dao.MallCountShopSalerLog";

			net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil
			u=new net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil();
			dao.MallCountProductCatLog item=null;

			//from dao.KgSiteCountUrlLog where regTimeLong>:regTimeLong0
			String HQL="select from "+entryClass_query+" as f where "+validatyTime+" >="+timeStart+" order by "+orderBy +" desc";
			String startTimeStr=request.getParameter("startTimeStr");
			String endTimeStr=request.getParameter("endTimeStr");

			if(startTimeStr!=null&&endTimeStr!=null){
				WebCountReportUtil ru=new WebCountReportUtil();
				long startTime=ru.getUserSelectTime_hhmmss(startTimeStr);
				long endTime=ru.getUserSelectTime_hhmmss(endTimeStr);
					if(startTime!=-1&&endTime!=-1){
						HQL="select from "+entryClass_query+" as f where  "+validatyTime+"  >="+startTime 
								+" and  "+validatyTime+"  <="+endTime+" order by "+orderBy +" desc";
					}
					
					request.setAttribute("startTimeStr", startTimeStr);
					request.setAttribute("endTimeStr", endTimeStr);
			}

			//每页显示记录数
			int maxrowsPage=20;
			//每页显示分页ID数
			int pageIdlinkCount=8;
			//创建分页配置
			net.juuluu.webUtil.DatePage.Listdata.ListDataConfig config=u.createConfig(HQL,maxrowsPage,pageIdlinkCount);
			 request.getSession().setAttribute("ListDataConfig", config);
			 
			 u.getpagePageResult(request);		

			String target="salerCount_UrlListCountByStartTimejsp";		
			return mapping.findForward(target);

			}
				
				
				@SuppressWarnings("static-access")
				// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=article_mingXiLogIndex
				public ActionForward MallCountShopSalerLog_mingXiIndex(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			String timeType=ReportTimeUtil.TimeType_ToDay;
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}



			return mapping.findForward("MallCountShopSalerLog_LogList_mingXi_IndexJsp");
				}		
				
				
				// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=MallCountShopSearchLog_ListByStartTime&timeType=TimeType_ToDay
				//	//TimeType_YesToDay  TimeType_ToDay  TimeType_MonthCurrent  TimeType_AllTime
				//TimeType_InputTime TimeType_BenZhou TimeType_ShangZhou TimeType_ThreeMonth TimeType_Year
				public ActionForward MallCountShopSearchLog_ListByStartTime(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					MallSecurityUserUtil securityUtil=new MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			com.juuluu.kgcore.dao.Member userlogin=mall.validaty.SessionValidaty.getInstance().getMemberSession(request);

			String timeType=request.getParameter("timeType");
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}else if(timeType.equals("inputTime")){
				timeStart=timeBean.getYestodatyStartTime();
				
			}

			request.getSession().setAttribute("queryTimeType_log", timeType);

			
			//config query
			String validatyTime="createTimeLong";
			String orderBy="createTimeLong";
			String entryClass_query="dao.MallCountShopSearchLog";

			net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil
			u=new net.juuluu.webUtil.DatePage.hibernate.HibernateDatePageUtil();
			dao.MallCountProductCatLog item=null;

			//from dao.KgSiteCountUrlLog where regTimeLong>:regTimeLong0
			String HQL="select from "+entryClass_query+" as f where "+validatyTime+" >="+timeStart+" order by "+orderBy +" desc";
			String startTimeStr=request.getParameter("startTimeStr");
			String endTimeStr=request.getParameter("endTimeStr");

			if(startTimeStr!=null&&endTimeStr!=null){
				WebCountReportUtil ru=new WebCountReportUtil();
				long startTime=ru.getUserSelectTime_hhmmss(startTimeStr);
				long endTime=ru.getUserSelectTime_hhmmss(endTimeStr);
					if(startTime!=-1&&endTime!=-1){
						HQL="select from "+entryClass_query+" as f where  "+validatyTime+"  >="+startTime 
								+" and  "+validatyTime+"  <="+endTime+" order by "+orderBy +" desc";
					}
					
					request.setAttribute("startTimeStr", startTimeStr);
					request.setAttribute("endTimeStr", endTimeStr);
			}

			//每页显示记录数
			int maxrowsPage=20;
			//每页显示分页ID数
			int pageIdlinkCount=8;
			//创建分页配置
			net.juuluu.webUtil.DatePage.Listdata.ListDataConfig config=u.createConfig(HQL,maxrowsPage,pageIdlinkCount);
			 request.getSession().setAttribute("ListDataConfig", config);
			 
			 u.getpagePageResult(request);		

			String target="ProductSearchCount_UrlListCountByStartTimejsp";		
			return mapping.findForward(target);

			}
				
				
				@SuppressWarnings("static-access")
				// /mall/kgmall/webCount/action/MallWebCountReportAction.do?method=article_mingXiLogIndex
				public ActionForward MallCountShopSearchLog_mingXiIndex(ActionMapping mapping,
						ActionForm form, 
						HttpServletRequest request, 
						HttpServletResponse response)
						throws IOException, ServletException {

					String permissionSystemKey="Mall.WebCount";
					// 初始化控制器
					mall.security.portal.core.MallSecurityUserUtil securityUtil=new mall.security.portal.core.MallSecurityUserUtil();
					PortalUserLoginConfig potalUserLoginConfig=securityUtil.initSiteEditorActionConfig();
					// 获取用户所在权限组，测试是否授权该用户访问该方法
					JuuluuAppPermissionCheckUtil checkBean = JuuluuAppPermissionCheckUtil.getInstance();
					ActionForward errorCheckAction = checkBean
							.methodmemberAndGronpDbPermissionCheck(request,
									potalUserLoginConfig,permissionSystemKey);
					if (errorCheckAction != null) {
						return errorCheckAction;
					}

			String timeType=ReportTimeUtil.TimeType_ToDay;
			long timeStart=0;
			util.TimeCreateBean timeBean=util.TimeCreateBean.getInstance();
			if(timeType.equals(ReportTimeUtil.TimeType_AllTime)){
				timeStart=0;
			}else if(timeType.equals(ReportTimeUtil.TimeType_MonthCurrent)){
				timeStart=timeBean.getMonthCurrentFisrtdatyStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_ToDay)){
				timeStart=timeBean.getToDayStartTime();
			}else if(timeType.equals(ReportTimeUtil.TimeType_YesToDay)){
				timeStart=timeBean.getYestodatyStartTime();
				
			}



			return mapping.findForward("MallCountShopSearchLog_LogList_mingXi_IndexJsp");
				}		
		

}//end class

