package mall.kgmall.webCount;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import service.entryService.KgsiteCountMemberLogEntryService;
import service.entryService.MallCountProductCatLogEntryService;
import service.entryService.MallCountProductLogEntryService;
import service.entryService.MallCountShopBuyerLogEntryService;
import service.entryService.MallCountShopSalerLogEntryService;
import service.entryService.MallCountShopSearchLogEntryService;
import service.entryService.MallShopDianpuUserEntryService;
import service.entryService.MallShopUserEntryService;

import dao.KgSiteCountUrlLog;

import kgSiteCount.core.count.BaseItemCountBean;
import kgSiteCount.core.count.KgItemCountUtil;
/**
 * java count code:
 * jsp count code:
 * ajax client code:
 * @author Guest
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class MallWebCountUtil {
	private static MallWebCountUtil instance;
	private MallWebCountUtil(){}
	public static MallWebCountUtil getInstance(){
		if(instance==null){
			instance=new MallWebCountUtil();
		}
		return instance;
	}
	
public void countIndex(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ShopIndex";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}



public void countMallProductCatList(dao.MallCountProductCatLog chlog,HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductCatListView";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
	dao.KgsiteCountItemLog  itemCount=baseCountBean.getItemLog();
	KgSiteCountUrlLog urlLog =baseCountBean.getUrlLog();
	 dao.KgsiteCountMemberLog  countMemberLog=baseCountBean.getCountMemberLog();
	
	 if(urlLog!=null){
		chlog.setCreateTime(urlLog.getRegTime());
		chlog.setCreateTimeLong(urlLog.getRegTimeLong());
		chlog.setRequestUrlId(urlLog.getUrlid());
		
	}
	if(itemCount!=null){
		chlog.setCountItemId((long)itemCount.getItemId());
		chlog.setCountItemName(itemCount.getItemName());
		chlog.setCountItemLogId(itemCount.getLogId());
		if(countMemberLog!=null){
			chlog.setSysUserid(countMemberLog.getSystemUserId());
			chlog.setSysUserName(countMemberLog.getUserName());
		}
	
		MallCountProductCatLogEntryService.getInstance()
		.merge(chlog);
	}

	
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallProductView(dao.MallCountProductLog chlog,HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductView";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
	dao.KgsiteCountItemLog  itemCount=baseCountBean.getItemLog();
	KgSiteCountUrlLog urlLog =baseCountBean.getUrlLog();
	 dao.KgsiteCountMemberLog  countMemberLog=baseCountBean.getCountMemberLog();
	
	 if(urlLog!=null){
		chlog.setCreateTime(urlLog.getRegTime());
		chlog.setCreateTimeLong(urlLog.getRegTimeLong());
		chlog.setRequestUrlId(urlLog.getUrlid());
		
	}
	if(itemCount!=null){
		chlog.setCountItemId((long)itemCount.getItemId());
		chlog.setCountItemName(itemCount.getItemName());
		chlog.setCountItemLogId(itemCount.getLogId());
		
		if(countMemberLog!=null){
			chlog.setSysUserid(countMemberLog.getSystemUserId());
			chlog.setSysUserName(countMemberLog.getUserName());
		}
		MallCountProductLogEntryService.getInstance()
		.merge(chlog);
	}
	
	
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallProductAdd(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallAdSearch(dao.MallCountShopSearchLog chlog,HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductSearche";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
	dao.KgsiteCountItemLog  itemCount=baseCountBean.getItemLog();
	KgSiteCountUrlLog urlLog =baseCountBean.getUrlLog();
	 dao.KgsiteCountMemberLog  countMemberLog=baseCountBean.getCountMemberLog();
	
	 if(urlLog!=null){
		chlog.setCreateTime(urlLog.getRegTime());
		chlog.setCreateTimeLong(urlLog.getRegTimeLong());
		chlog.setRequestUrlId(urlLog.getUrlid());
		
	}
	if(itemCount!=null){
		chlog.setCountItemId((long)itemCount.getItemId());
		chlog.setCountItemName(itemCount.getItemName());
		chlog.setCountItemLogId(itemCount.getLogId());
		
		if(countMemberLog!=null){
			chlog.setSysUserid(countMemberLog.getSystemUserId());
			chlog.setSysUserName(countMemberLog.getUserName());
		}
		
		MallCountShopSearchLogEntryService.getInstance()
		.merge(chlog);
	}
	
	
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallUserAdd(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}
public void countMallProductCommentAdd(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductAddComment";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}
		
public void countMallProductShouChang(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductSouChang";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallZjUserCatView(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.CatListView";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}

public void countMallZjUserView(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.TzUserView";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
	//mall user count
	mallUserCountBuyerAndSaler(baseCountBean);
}
		/*
public void countMallZjUserIndex(HttpServletRequest request, 
		HttpServletResponse response){
	String itemKey="Mall.ProductSouChang";
	KgItemCountUtil itemCountUtil= KgItemCountUtil.getInstance();
	
	BaseItemCountBean baseCountBean=itemCountUtil.baseItemCount(itemKey, request, response);
	
}*/
public void mallUserCountBuyerAndSaler(BaseItemCountBean baseCountBean){
	countBuyerUserLog(baseCountBean);
	countSalerrUserLog(baseCountBean);
}

public void countBuyerUserLog(BaseItemCountBean baseCountBean){

	dao.KgsiteCountItemLog  itemCount=baseCountBean.getItemLog();
	KgSiteCountUrlLog urlLog =baseCountBean.getUrlLog();
	 dao.KgsiteCountMemberLog  countMemberLog=baseCountBean.getCountMemberLog();
	 MallShopUserEntryService buyuserDao=MallShopUserEntryService.getInstance();
		if(countMemberLog!=null){
		long sysuserId=	countMemberLog.getSystemUserId();
		dao.MallShopUser buyerUser=buyuserDao.getShopUserBySystemUserId(sysuserId);
			if(buyerUser!=null){
				dao.MallCountShopBuyerLog chlog=new dao.MallCountShopBuyerLog();
				chlog.setSystemUserId(countMemberLog.getSystemUserId());
				chlog.setShopUserName(countMemberLog.getUserName());
				chlog.setShopUserid(buyerUser.getId());
				
				 if(urlLog!=null){
						chlog.setCreateTime(urlLog.getRegTime());
						chlog.setCreateTimeLong(urlLog.getRegTimeLong());
						chlog.setRequestUrlId(urlLog.getUrlid());
						
					}
					if(itemCount!=null){
						chlog.setCountItemId(itemCount.getItemId());
						chlog.setCountItemName(itemCount.getItemName());
						chlog.setCountItemLogId(itemCount.getLogId());
						
						//attr
						chlog.setAppId(itemCount.getAppId());
						chlog.setAppName(itemCount.getAppName());
						chlog.setCatId(itemCount.getCatId());
						chlog.setCatName(itemCount.getCatName());
						chlog.setCreateTime(urlLog.getRegTime());
						chlog.setCreateTimeLong(urlLog.getRegTimeLong());
					//	chlog.setItemId(itemCount.getItemId());
						//chlog.setItemName(itemCount.getItemName());
						chlog.setRequestUrl(urlLog.getTargetPath());
						//chlog.setTotalCount((long)1);
						
						chlog.setLogItemTitle(itemCount.getItemName());
					
					}
					MallCountShopBuyerLogEntryService.getInstance()
					.merge(chlog);
			System.out.println("add buyer count.");	
			}else{
				//System.out.println("user is not buyer , do`nt count!");
			}
			
			
		}
	

}

public void countSalerrUserLog(BaseItemCountBean baseCountBean){
	
	dao.KgsiteCountItemLog  itemCount=baseCountBean.getItemLog();
	KgSiteCountUrlLog urlLog =baseCountBean.getUrlLog();
	 dao.KgsiteCountMemberLog  countMemberLog=baseCountBean.getCountMemberLog();
	 MallShopDianpuUserEntryService dpUserDao= MallShopDianpuUserEntryService.getInstance();

	if(countMemberLog!=null){
		long sysuserId=	countMemberLog.getSystemUserId();
		dao.MallShopDianpuUser dpUser=dpUserDao.getUserBYSystemUserId(sysuserId);
		if(dpUser!=null){
			
			dao.MallCountShopSalerLog chlog=new dao.MallCountShopSalerLog ();
			chlog.setSystemUserId(countMemberLog.getSystemUserId());
			chlog.setSalerUserName(countMemberLog.getUserName());
			chlog.setSalerUserid(dpUser.getUserid());
			
			
			 if(urlLog!=null){
					chlog.setCreateTime(urlLog.getRegTime());
					chlog.setCreateTimeLong(urlLog.getRegTimeLong());
					chlog.setRequestUrlId(urlLog.getUrlid());
					
				}
				if(itemCount!=null){
					chlog.setCountItemId(itemCount.getItemId());
					chlog.setCountItemName(itemCount.getItemName());
					chlog.setCountItemLogId(itemCount.getLogId());
					
					//attr
					chlog.setAppId(itemCount.getAppId());
					chlog.setAppName(itemCount.getAppName());
					chlog.setCatId(itemCount.getCatId());
					chlog.setCatName(itemCount.getCatName());
					chlog.setCreateTime(urlLog.getRegTime());
					chlog.setCreateTimeLong(urlLog.getRegTimeLong());
				//	chlog.setItemId(itemCount.getItemId());
					//chlog.setItemName(itemCount.getItemName());
					chlog.setRequestUrl(urlLog.getTargetPath());
					//chlog.setTotalCount((long)1);
					
					chlog.setLogItemTitle(itemCount.getItemName());
				
				}
				MallCountShopSalerLogEntryService.getInstance()
				.merge(chlog);
				System.out.println("add saler count.");
		}//end if
		
		
	}
	
}
		
}
