package mall.kgmall.spider.web;
/**
 * 为采集器，文件下载等分析处理网页html的链接路径，返回要求格式路径，
 * 处理对象包括：图片路径，网页路径，mp3，电影文件等。
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
/**
 * 分析标签属性，<a> <img>，提取网络文件路径
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class LinkPathBean {
	
private  ArrayList<String> urlPathList;
//主机名
private String host;
//协议
private String agreementType;
//文件类型过滤
private String fileTypeList;
private StringBuffer log=new StringBuffer();
public LinkPathBean() {

	// TODO Auto-generated constructor stub
}

	public LinkPathBean(ArrayList<String> htmlTagList) {
		this.urlPathList=htmlTagList;
		// TODO Auto-generated constructor stub
	}
	/**分析网页链接路径
	 * 分析对象： ArrayList<HtmlTag> htmlTagList
	 * 元素类似：<a href="http://www.zsba.net/index.html" onclick="check()">
	 * 如果包含http://www.zsba.net/index.html
	 * 只取相对路径index.html
	 * 如果为/index.html
	 * 只取相对路径index.html
	 * @return
	 */
	public ArrayList<String> htmlLinkPathCreate(){
		ArrayList<String> linksNew=new ArrayList<String>();
		List<String> links=getUrlPathList();
		Iterator <String > i =links.iterator();
		String host=getHost() ;
		String agreement=getAgreementType() ;
		while(i.hasNext()){
			String s=i.next();
			//是否以http://等开头
			if(s.indexOf(agreement)!=-1){
				//是否采集站点如www.zsba.net 其它站点过滤
				System.out.println(agreement);
				//取根域名
				if(host.indexOf("www.")!=-1){
					host=host.replace("www.", "");
					System.out.println("www.");
					System.out.println("new:"+host);
				}
				
				
				if(s.indexOf(host)!=-1){
					//清除路径，只保留相对路径
					System.out.println("s.indexOf(host)!=-1"+host);

					
					StringBuffer bf=new StringBuffer(s);
					String dels=host+"/";
					int start =0;
					int end =bf.indexOf(dels)+dels.length();
					if(end!=-1){
						//从http://zsba.net/最后一个""/开始截取
						s=bf.substring(end);
						System.out.println("bf.substring"+s);
						
						linksNew.add(s);
					}
				
					
				}
				//是否以绝对路径开头
			}else if(s.indexOf("/")!=-1){
			s=	s.replaceFirst("/", "");
			linksNew.add(s);
			}
			
			
		}
		
		return linksNew;
	}
	

	
	/**
	 * 分析图片链接路径
	 * 分析对象： ArrayList<HtmlTag> htmlTagList
	 * 元素类似：<a href="http://www.zsba.net/index.html" onclick="check()">
	 * 如果包含http://www.zsba.net/index.html
	 * 只取相对路径index.html
	 * 如果为/index.html
	 * 只取相对路径index.html
	 * @return
	 */
	public ArrayList<String> imageLinkPathCreate(){
		ArrayList<String> linksNew=new ArrayList<String>();
		List<String> links=getUrlPathList();
		Iterator <String > i =links.iterator();
		String host=getHost() ;
		String agreement=getAgreementType() ;
		while(i.hasNext()){
			String s=i.next();
			//是否以http://等开头
			if(s.indexOf(agreement)!=-1){
				//是否采集站点如www.zsba.net 其它站点过滤
				System.out.println("完整路径："+agreement);
			
				//清理主机地址				
				if(s.indexOf(host)!=-1){
					//取根域名
					if(host.indexOf("www.")!=-1){
						host=host.replace("www.", "");
						System.out.println("www.");
						System.out.println("new:"+host);
					}
					//清除路径，只保留相对路径
					System.out.println("s.indexOf(host)!=-1"+host);

					
					StringBuffer bf=new StringBuffer(s);
					String dels=host+"/";
					int start =0;
					int end =bf.indexOf(dels)+dels.length();
					if(end!=-1){
						//从http://zsba.net/最后一个""/开始截取
						s=bf.substring(end);
						System.out.println("bf.substring"+s);
						//是否要采集的图片类型
						if(isValiableFileType(s)){
							linksNew.add(s);
						}
						
					}
				
				//非本网站设置主机路径 ,原址返回
				}else if((s.indexOf(host)==-1)){
					//是否要采集的图片类型
					   if(isValiableFileType(s)){
						   linksNew.add(s);
				    	}
					
					//continue;
				}
			//不含http:// 是否以绝对路径开头
			}else if(s.indexOf("/")!=-1){
			    s=	s.replaceFirst("/", "");
			//是否要采集的图片类型
			   if(isValiableFileType(s)){
				linksNew.add(s);
		    	}
			
			}else{
				//是否要采集的图片类型
				   if(isValiableFileType(s)){
					linksNew.add(s);
			    	}
			}
			
			
		}//end while
		
		return linksNew;
	}
	
	/**
	 * 分析flash链接路径
	 * 分析对象： ArrayList<HtmlTag> htmlTagList
	 * 元素类似：<a href="http://www.zsba.net/index.html" onclick="check()">
	 * 如果包含http://www.zsba.net/index.html
	 * 只取相对路径index.html
	 * 如果为/index.html
	 * 只取相对路径index.html
	 * @return
	 */
	public ArrayList<String> swfLinkPathCreate(){
		ArrayList<String> linksNew=new ArrayList<String>();
		List<String> links=getUrlPathList();
		Iterator <String > i =links.iterator();
		String host=getHost() ;
		String agreement=getAgreementType() ;
		while(i.hasNext()){
			String s=i.next();
			//是否以http://等开头
			if(s.indexOf(agreement)!=-1){
				//是否采集站点如www.zsba.net 其它站点过滤
				System.out.println(agreement);
				//取根域名
				if(host.indexOf("www.")!=-1){
					host=host.replace("www.", "");
					System.out.println("www.");
					System.out.println("new:"+host);
				}
				
				
				if(s.indexOf(host)!=-1){
					//清除路径，只保留相对路径
					System.out.println("s.indexOf(host)!=-1"+host);

					
					StringBuffer bf=new StringBuffer(s);
					String dels=host+"/";
					int start =0;
					int end =bf.indexOf(dels)+dels.length();
					if(end!=-1){
						//从http://zsba.net/最后一个""/开始截取
						s=bf.substring(end);
						System.out.println("bf.substring"+s);
						//是否要采集的图片类型
						if(isValiableFileType(s)){
							linksNew.add(s);
						}
						
					}
				
					
				}
				//是否以绝对路径开头
			}else if(s.indexOf("/")!=-1){
			    s=	s.replaceFirst("/", "");
			//是否要采集的图片类型
			   if(isValiableFileType(s)){
				linksNew.add(s);
		    	}
			
			}else{
				//是否要采集的图片类型
				   if(isValiableFileType(s)){
					linksNew.add(s);
			    	}
			}
			
			
		}
		
		return linksNew;
	}
	
	/**
	 * 分析MP3链接路径
	 * 分析对象： ArrayList<HtmlTag> htmlTagList
	 * 元素类似：<a href="http://www.zsba.net/index.html" onclick="check()">
	 * 如果包含http://www.zsba.net/index.html
	 * 只取相对路径index.html
	 * 如果为/index.html
	 * 只取相对路径index.html
	 * @return
	 */
	public ArrayList<String> mp3LinkPathCreate(){
		ArrayList<String> linksNew=new ArrayList<String>();
		List<String> links=getUrlPathList();
		Iterator <String > i =links.iterator();
		String host=getHost() ;
		String agreement=getAgreementType() ;
		while(i.hasNext()){
			String s=i.next();
			//是否以http://等开头
			if(s.indexOf(agreement)!=-1){
				//是否采集站点如www.zsba.net 其它站点过滤
				System.out.println(agreement);
				//取根域名
				if(host.indexOf("www.")!=-1){
					host=host.replace("www.", "");
					System.out.println("www.");
					System.out.println("new:"+host);
				}
				
				
				if(s.indexOf(host)!=-1){
					//清除路径，只保留相对路径
					System.out.println("s.indexOf(host)!=-1"+host);

					
					StringBuffer bf=new StringBuffer(s);
					String dels=host+"/";
					int start =0;
					int end =bf.indexOf(dels)+dels.length();
					if(end!=-1){
						//从http://zsba.net/最后一个""/开始截取
						s=bf.substring(end);
						System.out.println("bf.substring"+s);
						linksNew.add(s);
					}
				
					
				}
				//是否以绝对路径开头
			}else if(s.indexOf("/")!=-1){
			s=	s.replaceFirst("/", "");
			linksNew.add(s);
			}
			
			
		}
		
		return linksNew;
	}
	
	/**
	 * 分析电影链接路径
	 * 分析对象： ArrayList<HtmlTag> htmlTagList
	 * 元素类似：<a href="http://www.zsba.net/index.html" onclick="check()">
	 * 如果包含http://www.zsba.net/index.html
	 * 只取相对路径index.html
	 * 如果为/index.html
	 * 只取相对路径index.html
	 * @return
	 */
	public ArrayList<String> movieLinkPathCreate(){
		ArrayList<String> linksNew=new ArrayList<String>();
		List<String> links=getUrlPathList();
		Iterator <String > i =links.iterator();
		String host=getHost() ;
		String agreement=getAgreementType() ;
		while(i.hasNext()){
			String s=i.next();
			//是否以http://等开头
			if(s.indexOf(agreement)!=-1){
				//是否采集站点如www.zsba.net 其它站点过滤
				System.out.println(agreement);
				//取根域名
				if(host.indexOf("www.")!=-1){
					host=host.replace("www.", "");
					System.out.println("www.");
					System.out.println("new:"+host);
				}
				
				
				if(s.indexOf(host)!=-1){
					//清除路径，只保留相对路径
					System.out.println("s.indexOf(host)!=-1"+host);

					
					StringBuffer bf=new StringBuffer(s);
					String dels=host+"/";
					int start =0;
					int end =bf.indexOf(dels)+dels.length();
					if(end!=-1){
						//从http://zsba.net/最后一个""/开始截取
						s=bf.substring(end);
						System.out.println("bf.substring"+s);
						linksNew.add(s);
					}
				
					
				}
				//是否以绝对路径开头
			}else if(s.indexOf("/")!=-1){
			s=	s.replaceFirst("/", "");
			linksNew.add(s);
			}
			
			
		}
		
		return linksNew;
	}
	/**
	 * 默认采集类型，不须过虑.jpg .gif .png .jpeg
	 * @param filePath
	 * @return
	 */
	public boolean isValiableFileType(String filePath){
		ArrayList<String> l= fileTypeCreate();
		if(filePath.indexOf(".jpg")!=-1){
			return true;
		}
		if(filePath.indexOf(".gif")!=-1){
			return true;
		}
		if(filePath.indexOf(".png")!=-1){
			return true;
		}
		if(filePath.indexOf(".jpeg")!=-1){
			return true;
		}
		Iterator<String> i=l.iterator();
		boolean v=false;
		while(i.hasNext()){
			String s=i.next();
			if(filePath.indexOf(s)!=-1){
				v=true;
				break;
			}else{
				continue;
			}
		}
		return v;
	}
	
	//生成过虑文件类型列表	
	public ArrayList<String> fileTypeCreate(){
		ArrayList<String> type=new ArrayList<String>();
		String s= getFileTypeList();
		java.util.StringTokenizer st=new java.util.StringTokenizer(s,"|");
		while(st.hasMoreTokens()){
			type.add(st.nextToken());
		}
		return type;
	}


	//获取包含关键词的链接路径 href 
	//只返回href="xx"的内容，没进一步加工，如清除绝对路径，主机名等。
	public String getLinkPathByHtmlStr(String path,String prefix){
		String c=path;
		//链接是否包含关键词
		if(c.indexOf(prefix)!=-1){
			StringBuffer bf=new StringBuffer(c);
			//<a herf=c/a/b/a.html target=main
			int href=c.indexOf("href=");
			//是否包含其它属性 取=号后的空格
			int otherP=c.indexOf(" ",c.indexOf("=",href)+1);
			
			if(href==-1){
				//不包含路径
				getLog().append("\n不包含路径");
				return null;
			}
			
			if(otherP!=-1){
				String parse=bf.substring(href,otherP+1);
				
				getLog().append("\n//包含其它属性的路径,分析路径形式："+parse);
				
				//分析路径形式
				if(parse.indexOf("\"")!=-1){
					//href="h.html"链接形式
					return	parseLinkForDoubleFlag(c);
				}else if(parse.indexOf("\'")!=-1){
					//href='h.html'链接形式
					return	parseLinkForSimpleFlag(c);
				}else if(parse.indexOf(" ")!=-1){
					//href=h.html链接形式
					return	parseLinkForNoFlag(c);
				}else{
					//无空格无“ ‘号的路径，直接取
					getLog().append("\n//包含其它属性的路径，无法取得路径信息");
					
					return null;
				}
				//不包含其它属性
			}else{
				
				//分析路径形式
				if(c.indexOf("\"")!=-1){
					//href="h.html"链接形式
					return	parseLinkForDoubleFlag(c);
				}else if(c.indexOf("\'")!=-1){
					//href='h.html'链接形式
					return	parseLinkForSimpleFlag(c);
				}else if(c.indexOf(" ")!=-1){
					//href=h.html链接形式
					return	parseLinkForNoFlag(c);
				}else{
					getLog().append("\n//不包含其它属性的路径，无法取得路径信息");
					return null;
				}
			}
		
			
		}else{
			getLog().append("\n分析链接结果 路径不含关键词："+c);
			return null;
		}
		
	}
	//分析""形式路径 
	public String parseLinkForDoubleFlag(String path){
		String c=path;
		
		int href=c.indexOf("href=");
		//href="h.html"
		
		//分析以href="xxx.html"形式路径
		int pathstart=c.indexOf("\"",href);
		int pathend=c.indexOf("\"",pathstart+1);
		
		getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
		
		if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
			//获取链接
		String linkstr=	c.substring(pathstart+1,pathend);
		getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		
		///links.add(linkstr);
		
		return linkstr;
	  }else{
		getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		return null;
	   }
	}
	
	//分析<a href='xx/end/index.html' target=main>形式路径 
	public String parseLinkForSimpleFlag(String path){
		String c=path;
		
		int href=c.indexOf("href=");
		//href="h.html"
		

		
		
		
		//分析以href='xxx.html'形式路径
		int pathstart=c.indexOf("\'",href);
		int pathend=c.indexOf("\'",pathstart+1);
		
		getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
		
		if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
			//获取链接
		String linkstr=	c.substring(pathstart+1,pathend);
		getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		
		///links.add(linkstr);
			return linkstr;
		  }else{
				getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
				return null;
			   }
	}
	
	//分析<a href=xx/end/index.html target=main>形式路径 
	public String parseLinkForNoFlag(String path){
		String c=path;
		
			int href=c.indexOf("href=");
			//href="h.html"
			

			
			//分析以href=xxx.html形式路径
		
			int pathstart=c.indexOf("=",href);
			//取第一个空格
			int pathend=c.indexOf(" ",pathstart+1);
			
			getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
			
			if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
				//获取链接
			String linkstr=	c.substring(pathstart+1,pathend);
			getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
			
			///links.add(linkstr);
			
			  return linkstr;
			  }else{
					getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
					return null;
		 }
	}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		ArrayList<String> l=new ArrayList<String>();
		l.add("http://zsba.net/c/index.jpeg");
		l.add("http://feafo.cn/a/h.do?method=list");
		l.add("/index.swf");
		l.add("adf/sdfs.bmp");
		LinkPathBean lb=new LinkPathBean(l);
		lb.setHost("zsba.net");
		lb.setAgreementType("http://");
		lb.setFileTypeList("jpg|jpeg|gif|bmp");
		
		Iterator<String> i=lb.imageLinkPathCreate().iterator();
		while(i.hasNext()){
			System.out.println(i.next());
		}

	}
	public void setUrlPathList(ArrayList<String> htmlTagList) {
		this.urlPathList = htmlTagList;
	}
	public ArrayList<String> getUrlPathList() {
		return urlPathList;
	}
	public void setHost(String host) {
		this.host = host;
	}
	public String getHost() {
		return host;
	}
	public void setAgreementType(String agreementType) {
		this.agreementType = agreementType;
	}
	public String getAgreementType() {
		return agreementType;
	}
	public void setFileTypeList(String fileTypeList) {
		this.fileTypeList = fileTypeList;
	}
	public String getFileTypeList() {
		return fileTypeList;
	}

	public void setLog(StringBuffer log) {
		this.log = log;
	}

	public StringBuffer getLog() {
		return log;
	}
	
	public String getImgPathByHtml(String path){
		String c=path;
		StringBuffer bf=new StringBuffer(c);
		//<a herf=c/a/b/a.html target=main
		int href=c.indexOf("src=");
		//是否包含其它属性 取=号后的空格
		int otherP=c.indexOf(" ",c.indexOf("=",href)+1);
		
		if(href==-1){
			//不包含路径
			getLog().append("\n不包含路径");
			return null;
		}
		
		if(otherP!=-1){
			String parse=bf.substring(href,otherP+1);
			
			getLog().append("\n//包含其它属性的路径,分析路径形式："+parse);
			
			//分析路径形式
			if(parse.indexOf("\"")!=-1){
				//href="h.html"链接形式
				return	parseImgForDoubleFlag(c);
			}else if(parse.indexOf("\'")!=-1){
				//href='h.html'链接形式
				return	parseImgForSimpleFlag(c);
			}else if(parse.indexOf(" ")!=-1){
				//href=h.html 链接形式
				return	parseImgForNoFlag(c);
			}else{
				//无空格无“ ‘号的路径，直接取
				getLog().append("\n//包含其它属性的路径，无法取得路径信息");
				
				return null;
			}
			//不包含其它属性
		}else{
			
			//分析路径形式
			if(c.indexOf("\"")!=-1){
				//href="h.html"链接形式
				return	parseImgForDoubleFlag(c);
			}else if(c.indexOf("\'")!=-1){
				//href='h.html'链接形式
				return	parseImgForSimpleFlag(c);
			}else if(c.indexOf(" ")!=-1){
				//href=h.html链接形式
				return	parseImgForNoFlag(c);
			}else{
				getLog().append("\n//不包含其它属性的路径，无法取得路径信息");
				return null;
			}
		}
	
}
	//分析""形式路径 
	public String parseImgForDoubleFlag(String path){
		String c=path;
		
		int href=c.indexOf("src=");
		//href="h.html"
		
		//分析以href="xxx.html"形式路径
		int pathstart=c.indexOf("\"",href);
		int pathend=c.indexOf("\"",pathstart+1);
		
		getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
		
		if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
			//获取链接
		String linkstr=	c.substring(pathstart+1,pathend);
		getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		
		///links.add(linkstr);
		
		return linkstr;
	  }else{
		getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		return null;
	   }
	}
	
	//分析<a href='xx/end/index.html' target=main>形式路径 
	public String parseImgForSimpleFlag(String path){
		String c=path;
		
		int href=c.indexOf("src=");
		//href="h.html"
		

		
		
		
		//分析以href='xxx.html'形式路径
		int pathstart=c.indexOf("\'",href);
		int pathend=c.indexOf("\'",pathstart+1);
		
		getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
		
		if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
			//获取链接
		String linkstr=	c.substring(pathstart+1,pathend);
		getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
		
		///links.add(linkstr);
			return linkstr;
		  }else{
				getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
				return null;
			   }
	}
	
	//分析<a href=xx/end/index.html target=main>形式路径 
	public String parseImgForNoFlag(String path){
		String c=path;
		
			int href=c.indexOf("src=");
			//href="h.html"
			

			
			//分析以href=xxx.html形式路径
		
			int pathstart=c.indexOf("=",href);
			//取第一个空格
			int pathend=c.indexOf(" ",pathstart+1);
			
			getLog().append("\n链接"+c+"\n href: "+href+" pathstart:"+pathstart+" pathend:"+pathend);
			
			if(pathstart<pathend&&pathstart!=-1&&pathend!=-1){
				//获取链接
			String linkstr=	c.substring(pathstart+1,pathend);
			getLog().append("\n分析链接结果："+linkstr+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
			
			///links.add(linkstr);
			
			  return linkstr;
			  }else{
					getLog().append("\n未知错误getLinkPathByHtmlStr()"+"\n href: "+href+"pathstart:"+pathstart+"pathend:"+pathend);
					return null;
		 }
	}

}
