/**
 * 网页html标签处理器
 * 功能说明：添加，清除HTML标签，
 * 
 * @see cms.kgweb.Html
 */


package mall.kgmall.spider.web;
import java.util.LinkedHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;



import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class Html {
	private int htmlBeanId;
	//标签位置信息
	private LinkPathBean linkPathBean;
	private LinkedHashMap<String,Integer> startTagPosctionMap=new LinkedHashMap<String,Integer> ();
	private LinkedHashMap<String,Integer> endTagPosctionMap=new LinkedHashMap<String,Integer> ();
	
	private  ArrayList<HtmlTag> htmlTagList;
	private HtmlTag htmlTag;
	private StringBuffer log=new StringBuffer();
	
	//分析的网络文本
private StringBuffer htmlContent=new StringBuffer();
private String action;
	/**
	 * @param args
	 */

public Html (){
	this.linkPathBean=new LinkPathBean();
}
//截取字符之间的文本
public String getStringBetweenStr(String startStr,String endStr){
	
	if(startStr==null||endStr==null){
		System.out.println("错误，分隔符为空.");
		return "";
	}
	int start=getHtmlContent().indexOf(startStr);
	
	//采集内容开始位置
	int spiderStart=start+startStr.length();
	//以开始标签位置，取结束标签
	int end =getHtmlContent().indexOf(endStr,spiderStart);
	end=end-1;
	String s=null;
	if(spiderStart!=-1&&end!=-1&&spiderStart<end
			&&spiderStart>0&&end>0){
		s=getHtmlContent().substring(spiderStart,end);
		System.out.println("截取字符：start:"+start+" end:"+end);
	}else{
		////System.out.println("截取字符失败：start:"+start+" end:"+end);
	}
	
	return s;
}


public ArrayList<String> getImageFullPathList(){
	  //获取图片链接
	
		ArrayList<String>  links=new ArrayList<String> ();
		
		createAllHtmlTagByTagName("img");
		ArrayList<HtmlTag>  starttags= getAllStartTagByName("img");
		
		 Iterator <HtmlTag>is=starttags.iterator();
		 while(is.hasNext()){
			 HtmlTag link=is.next();
			int start =link.getStart();
			int end =link.getEnd();
			if(start<end&&start!=-1&&end!=-1){
				String c=getHtmlContent().substring(start, end);
				
					//获取链接
					//log.append("\n分析链接"+c+"\nstart: "+link.getStart()+"end:"+link.getEnd());
					String imagePath=getLinkPathBean().getImgPathByHtml(c);
					if(imagePath==null){
						//log.append("路径无效，无法获取。"+c+"\n路径分析日志："+getLinkPathBean().getLog().toString());
					}else{
						links.add(imagePath);
					}
					
				
			}
			
		 }
		
		 
		return links;
	

}
  //获取图片链接 路径经过处理，只获取相对路径
public ArrayList<String> getIMGPathList(){
	ArrayList<String>  links=new ArrayList<String> ();
	
	createAllHtmlTagByTagName("img");
	ArrayList<HtmlTag>  starttags= getAllStartTagByName("img");
	if(starttags==null||starttags.size()==0){
		System.out.println("无法提取图片标签：");
	}
	 Iterator <HtmlTag>is=starttags.iterator();
	 while(is.hasNext()){
		 HtmlTag link=is.next();
		int start =link.getStart();
		int end =link.getEnd();
		if(start<end&&start!=-1&&end!=-1){
			String c=getHtmlContent().substring(start, end);
			
				//获取链接
				//log.append("\n分析链接"+c+"\nstart: "+link.getStart()+"end:"+link.getEnd());
				String imagePath=getLinkPathBean().getImgPathByHtml(c);
				if(imagePath==null){
					//log.append("路径无效，无法获取。"+c+"\n路径分析日志："+getLinkPathBean().getLog().toString());
				}else{
					links.add(imagePath);
					System.out.println("成功提取图片地址："+imagePath);	
				}
				
			
		}
		
	 }
	 LinkPathBean lb= getLinkPathBean();
	 lb.setUrlPathList(links);
	 
	 
	return lb.imageLinkPathCreate();
}

	//获取包含关键词的链接
	public ArrayList<String> getLinkByNamePrefix(String prefix){
		ArrayList<String>  links=new ArrayList<String> ();
		//创建标签库
		//createAllHtmlTagByTagName("a");
		ArrayList<HtmlTag>  starttags= getAllStartTagByName("a");
		
		 Iterator <HtmlTag>is=starttags.iterator();
		 while(is.hasNext()){
			 HtmlTag link=is.next();
			int start =link.getStart();
			int end =link.getEnd();
				if(start<end&&start!=-1&&end!=-1){
				String c=getHtmlContent().substring(start, end+1);
				////log.append("\n分析链接"+c+"\nstart: "+link.getStart()+"end:"+link.getEnd());
				String linkPath=getLinkPathBean().getLinkPathByHtmlStr(c, prefix);
				if(linkPath==null){
					//log.append("路径无效，无法获取。"+c+"\n路径分析日志："+getLinkPathBean().getLog().toString());
				}else{
					links.add(linkPath);
				}
				
				}
			
		 }
		return links;
	}
	public String getStrByTagPos(int[] pos){
		if(pos[0]!=-1&&pos[1]!=-1){
			return htmlContent.substring(pos[0], pos[1]+1);
		}else{
			return "";
		}
		
	}
	public void AddLink(String tagName){
		
	}
	public void delTagList(List<String> list){
		Iterator<String> i=list.iterator();
		while(i.hasNext()){
			delAllTag(i.next());
		}
	}
	
	public void delTableTag(){
		delAllTag("table");
		delAllTag("tr");
		delAllTag("td");
		delAllTag("th");
		
	}
	public void delScriptTag(){
		delAllTag("script");
	}
	public void delDivTag(){
		delAllTag("div");
	}
	
	public void delAllTag(String tagName){
		List<int[]> p=new ArrayList<int[]>();
		if(getAllTagPosictionInfo( tagName)!=null){
			p=getAllTagPosictionInfo( tagName);}
		Iterator<int[]> i=p.iterator();
		int pos=0;
		int lenght=tagName.length();
		int tmp[]=new int[2];
		while(i.hasNext()){
			int []k=i.next();
			
			if(k[0]>=0&&k[1]>=0 &&k[0]<k[1]){
				htmlContent.delete(k[0], k[1]+1);
				tmp[0]=k[0];
				tmp[1]=k[1];

				//删除后，重建标签库
				resetTagStartEndPosictionMap();
			}
				//重新获取标签信息
				List<int[]> taglist=getAllTagPosictionInfo( tagName);
				i=taglist.iterator();
	
		}
		
		
	}
	
	/*
	 * 清除html脚本
	 * <script>
	 * xxx
	 * </script>
	 */
	public void delScript(String scriptName){
		delStartTagEndTagAndText(scriptName);
	}
	
	//清除链接及链接文本
	public void delLinkAndLinkText(){
		delStartTagEndTagAndText("a");
	}
	
	//替换文本
public void replaceByTextList(String textReplaceList){
	java.util.StringTokenizer st=new java.util.StringTokenizer(textReplaceList,";");
	while(st.hasMoreTokens()){
		String r=st.nextToken();
		java.util.StringTokenizer rt=new java.util.StringTokenizer(r," ");
		while(rt.hasMoreTokens()){
			String source =rt.nextToken();
			String target=null;
			if(rt.hasMoreTokens()){
				target =rt.nextToken();
			}
            if(target!=null){
            	replace(source,target);
            }
             
           	}
		
		
	}

	}
public void replace(String source, String target){
	  int start = getHtmlContent().indexOf(source);
      int end =start+source.length();
      if(start<end&&start!=-1&&end<  getHtmlContent().length()){
    	  getHtmlContent().replace(start, end, target);
    	//  System.out.println("htmlID:"+this.htmlBeanId+" 替换："+source+" target:"+target+" start:"+start+" end:"+end);
    	  
      }else{
    	  System.out.println("无法替换："+source+" target:"+target+" start:"+start+" end:"+end);
      }
      

}
	/*
	 * 清除链接及文本 限定词为开始标签的属性
	 * <a href="Prifix xxxx">
	 * xxxPrifix
	 * </a>
	 */
	public void delLinkAndLinkTextByPropertyPrefixList(String propertyLinkPrefixNameList){
		java.util.StringTokenizer st=new java.util.StringTokenizer(propertyLinkPrefixNameList," ");
		while(st.hasMoreTokens()){
			String name=st.nextToken();
			delStartTagEndTagAndTextByPropertyPrefix("a",name);
			
		}
		}
	/*
	 * delStartTagEndTagAndText
	 * 删除标签及标签之间的内容，标签内容要包含关键词
	 * 如<script> <!---sdfsf--></script>
	 */
	public void delStartTagEndTagAndTextByPropertyPrefix(String tagName,String propertyPrefixName){
		//创建标签库
		createAllHtmlTagByTagName(tagName);
		ArrayList<HtmlTag>  starttags= getAllStartTagByName(tagName);
		
		 Iterator <HtmlTag>is=starttags.iterator();
		 
		 while(is.hasNext()){
			 HtmlTag starttag=is.next();
			 
			 HtmlTag endtag=getEndHtmlTagByStartTag(starttag);
			 
			 int start=starttag.getStart();
			 int end=endtag.getEnd();
			 if(start<end&&start!=-1&&end!=-1){
				 int prefixNamePos=getHtmlContent().indexOf(propertyPrefixName,start);
				//属性关键词 在开始标签 <>内容 删除
				 if(prefixNamePos<starttag.getEnd()){
					 getHtmlContent().delete(start, end);
					 //重建标签<>库
					 resetTagStartEndPosictionMap();
						//创建标签库
						createAllHtmlTagByTagName(tagName);
						//重新赋值，直到删除完为止。
						starttags= getAllStartTagByName(tagName);
				 }
				
				
			 }
		 
		 }
	}
	
	/*
	 * 清除链接及文本 限定词为文本内容
	 * <a href="Prifix xxxx">
	 * xxxPrifix
	 * </a>
	 */
	public void delLinkAndLinkTextByTextList(String textNameList){
		java.util.StringTokenizer st=new java.util.StringTokenizer(textNameList," ");
		while(st.hasMoreTokens()){
			String name=st.nextToken();
			delStartTagEndTagAndTextByTextPrefix("a",name);
			
		}
		
		
	}
	/*
	 * delStartTagEndTagAndText
	 * 删除标签及标签之间的内容，标签内容要包含关键词
	 * 如<script> <!---sdfsf--></script>
	 */
	public void delStartTagEndTagAndTextByTextPrefix(String tagName,String textPrefixName){
		//创建标签库
		createAllHtmlTagByTagName(tagName);
		ArrayList<HtmlTag>  starttags= getAllStartTagByName(tagName);
		
		 Iterator <HtmlTag>is=starttags.iterator();
		 
		 while(is.hasNext()){
			 HtmlTag starttag=is.next();
			 
			 HtmlTag endtag=getEndHtmlTagByStartTag(starttag);
			 
			 int start=starttag.getStart();
			 int end=endtag.getEnd();
			 if(start<end&&start!=-1&&end!=-1){
				 int prefixNamePos=getHtmlContent().indexOf(textPrefixName,start);
				//关键词 在结束标签前，并在开始标签后 删除
				 if(prefixNamePos<end){
					 getHtmlContent().delete(start, end);
					 //重建标签<>库
					 resetTagStartEndPosictionMap();
						//创建标签库
						createAllHtmlTagByTagName(tagName);
						//重新赋值，直到删除完为止。
						starttags= getAllStartTagByName(tagName);
				 }
				
				
			 }
		 
		 }
	}
	/*
	 * delStartTagEndTagAndText
	 * 删除标签及标签之间的内容，如<script> <!---sdfsf--></script>
	 */
	public void delStartTagEndTagAndText(String tagName){
		//创建标签库
		createAllHtmlTagByTagName(tagName);
		ArrayList<HtmlTag>  starttags= getAllStartTagByName(tagName);
		
		 Iterator <HtmlTag>is=starttags.iterator();
		 
		 while(is.hasNext()){
			 HtmlTag starttag=is.next();
			 
			 HtmlTag endtag=getEndHtmlTagByStartTag(starttag);
			 
			 int start=starttag.getStart();
			 int end=endtag.getEnd();
			 if(start<end&&start!=-1&&end!=-1){
				 getHtmlContent().delete(start, end);
				 //重建标签<>库
				 resetTagStartEndPosictionMap();
					//创建标签库
					createAllHtmlTagByTagName(tagName);
					//重新赋值，直到删除完为止。
					starttags= getAllStartTagByName(tagName);
			 }
		 
		 }
	}
	//获取全部开始标签
	public ArrayList<HtmlTag>   getAllStartTagByName(String tagName){
		 ArrayList<HtmlTag>  starttags=new  ArrayList<HtmlTag> ();
		//创建TAG 
		 createAllHtmlTagByTagName(tagName);
		 
		
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		 Iterator <HtmlTag>is=taglist.iterator();
		 while(is.hasNext()){
			 HtmlTag tag=is.next();
			 if(tag.isStartTagIs()){
				 starttags.add(tag) ;
				 
				 
			 }
		 }
		 return starttags;
	}
	//获取标签对，包含开始标签 结束标签之间的文本判断
	public HtmlTag[] getStartEndHtmlTagByTextName(String textPrefix){
		 HtmlTag[] startendTag=new  HtmlTag[2];
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		// HtmlTag[] getStartEndHtmlTagByPropertyName();
		 return startendTag;
	}
	//获取标签对，包含开始标签包含 属性
	public HtmlTag[] getStartEndHtmlTagByPropertyName(String tagPrifex){
		 HtmlTag[] startendTag=new  HtmlTag[2];
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		 return startendTag;
	}
	
	//获取开始标签 的结束标签
	public HtmlTag getEndHtmlTagByStartTag(HtmlTag startTag){
		 HtmlTag startendTag=new  HtmlTag();
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		 return startendTag;
	}
	//获取结束标签 的开始标签
	public  HtmlTag getStartTagByEndHtmlTag(HtmlTag endTag){
		 HtmlTag startendTag=new  HtmlTag();
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		 return startendTag;
	}
	
	//删除全部文本列表
	public void delAllTextByTextList(String textList){
		if(textList==null){
			return;
		}
		java.util.StringTokenizer st=new java.util.StringTokenizer(textList," ");
		while(st.hasMoreTokens()){
			String t=st.nextToken();
			delAllTextByTextName(t);
		}
	}
	public void delAllTextByTextName(String text){
		int start=getHtmlContent().indexOf(text);
		int end=start+text.length();
		int index=0;
		while(start!=-1){
			if(start!=-1&&end!=-1){
				getHtmlContent().delete(start, end);
			}
			
			index=start;
			//查找新字符
			 start=getHtmlContent().indexOf(text,index);
			 end=start+text.length();
		}
		//重设标记库
		resetTagStartEndPosictionMap();
		 //System.out.println("重设标记库");
		
		//重建标签
	}
	//删除全部标签列表
	public void delAllHtmlTagByTagList(String taglist){
		

		
		java.util.StringTokenizer st=new java.util.StringTokenizer(taglist," ");
		while(st.hasMoreTokens()){
			String tag=st.nextToken();
			createAllHtmlTagByTagName(tag);
			delAllHtmlTagByTagName(tag);
		}
	}
	public void delAllHtmlTagByTagName(String tagName){
		
		 ArrayList<HtmlTag>  taglist=getHtmlTagList();
		 if(taglist.size()==0){
			 return ;
		 }
		 Iterator <HtmlTag>is=taglist.iterator();
			//创建TAG 
		 createAllHtmlTagByTagName(tagName);
		
		 while(is.hasNext()){
			 HtmlTag tag=is.next();
			 int start=tag.getStart();
			 int end=tag.getEnd();
			 if(start!=-1&&end!=-1){
				 //System.out.println("删除标签：start:"+start+" end:"+end);
					htmlContent.delete(start, end+1);
					//重设标记库
					resetTagStartEndPosictionMap();
					 //System.out.println("重设标记库");
					//重建标签
					createAllHtmlTagByTagName(tagName);
					 //System.out.println("重建标签");
					 taglist=getHtmlTagList();
					 is=getHtmlTagList().iterator();
					 if(is!=null){
						 continue;
					 }else{
						 //System.out.println("删除标签完毕！");
					 }
			 }else{
				 //System.out.println("该标签不存在，或已删除。");
				 continue;
			 }
		
		 }
	}
	public void createAllHtmlTagByTagName(String tagName){
		//System.out.println("\n创建标签：createAllHtmlTagByTagName()"+tagName);
		
		
		List<int[]> posctionInfo=getAllTagPosictionInfo( tagName);
		if(posctionInfo.size()==0){
			getLog().append("没有找到任何标签信息。");
			
		}
		Iterator <int []> i=posctionInfo.iterator();
		
		ArrayList<HtmlTag> list=new ArrayList<HtmlTag>();
		
		while(i.hasNext()){
			int []pos=i.next();
			HtmlTag tag=new HtmlTag();
			tag.setStart(pos[0]);
			tag.setEnd(pos[1]);
			tag.setTatNamePosction(pos[2]);
		
			
			int tagNamePosiction=pos[2];
			int tagStartPostion=pos[0];	
				int tagendPostion=pos[1];
				
			if(isEndTag( tagName, tagNamePosiction, tagendPostion)){
				tag.setEndTagIs(true);
				getLog().append("\n创建结束标签："+tagName+" start:"+tagStartPostion+" end:"+tagendPostion+" tagNamePosiction:"+tagNamePosiction);
				list.add(tag);
			}else if(isStartTag( tagNamePosiction, tagStartPostion)){
				tag.setStartTagIs(true);
				getLog().append("\n创建开始标签：tagName:"+tagName+" start:"+tagStartPostion+" end:"+tagendPostion+" tagNamePosiction:"+tagNamePosiction);
				list.add(tag);
				
			}else{
				getLog().append("该标签可能有误，既不是开始标签，也不是结束标签，位置："+tagNamePosiction+"开始<:"+tagStartPostion+"结束："+tagendPostion);
				list.add(tag);
			}
			
		
		}
		
		this.htmlTagList=list;
		
	}
	
	/*
	 * 返回数组
	 * a[0] 开始标签<位置
	 * a[1] 开始标签>位置
	 */
	public List<int[]> getAllTagPosictionInfo(String tagName){
		getLog().append("getAllTagPosictionInfo()");
	 int ContentLenght=htmlContent.length();
	 int tagNameLenght=tagName.length();

	 ArrayList<int[]> list=new ArrayList<int[]>();
	 
	 if(ContentLenght==-1){
		 return  list;
	 }else{
		
		int index=0;
		// 
		 //index=htmlContent.indexOf(tagName,index);
		int  tagLenght=ContentLenght;
		 while(index<ContentLenght){
			 int a[]=getPositionForTag(tagName,index);
			// ////System.out.println("index:"+index);
			 if(a!=null){	
				//getLog().append("找到标签：start:"+a[0]+"end:"+a[1]+"tagPosiction:"+a[2]); 
				int start=	a[0];
				int end=a[1];
				int tagposiction=a[2];
			     if(end>0&& start>=0 && tagposiction>0){
				 
				 int pos[]=new int[3];
				
				
					 pos[0]=a[0];
					 pos[1]=a[1];
					 pos[2]=a[2];
					 getLog().append("\n找到标签位置信息：start:"+a[0]+"end:"+a[1]+"tagPosiction:"+a[2]); 
					 list.add(pos);	 
					 //下一查找位置
					 
					 index=a[1]+1;
					 continue;
					
				     }else{
				    	 index++;
					 
					 continue;
				     }
				
				 //在该位置没找到标签a==null
			       }else{
			    	   index++;
				 
				   continue;
				 //没有找到字符
			     }
		 }
	 }
	 return list;
	}
	//删除单个标签
	public StringBuffer delSimpleTag(String tagName){
		int startFind=0;
		int p[]=getPositionForTag(tagName,startFind);
		//////System.out.println("del........................");
		//////System.out.println(htmlContent.toString());
		////System.out.println("firstTagtagBeginCharPosition"+p[0]);
		////System.out.println("firstTagtagEndCharPosition"+p[1]);
	if(p!=null){
		return htmlContent.delete(p[0],p[1]+1);
	}else{
		
		return htmlContent;
			}
		
	}
	public boolean delSimpleString(String delString){
		int positionbegin=htmlContent.indexOf(delString);
		if(positionbegin==-1){
			return false;
		}else{
			int end=delString.length()-1+positionbegin;
			htmlContent.delete(positionbegin, end);
			return true;
		}
	
	}
	//删除一对标签	
	
	public StringBuffer delDoubleTag(String tagName){
		delSimpleTag(tagName);
		return delSimpleTag(tagName);
		
	}
	
	/*
	 * 返回单个标签开始结束位置< >
	 * @return int[] 数组包含三个变量
	 * int [0]<
	 * int [1]>
	 * int [2]标签位置信息 如table a p 等 
	 * 
	 * 参数说明：int start: 标签开始寻找位置
	 * String tagName ：标签名
	 * LinkedHashMap tagBeginMap：文本全部<>标签信息
	 * 

	 * 
	 * 算法描述：

	 */
	public int[] getPositionForTag(String tagName,int start){
		String firstTag;
		String secondTag;
		String tagbegin="<";
		String tagEnd=">";
		String tagEndA="/";
		//getLog().append("\ngetPositionForTag()"+start);
		//处理第一个标签
		int tagBeginPosition;
		//第一个标签开始位置
		tagBeginPosition=htmlContent.indexOf(tagName,start);
		if(tagBeginPosition==-1){
			////System.out.println("找不到标签：getPositionForTag() 开始位置："+start);
			return null;
		}
		
		LinkedHashMap tagBeginMap=getStartTagPosctionMap();
		
		//第一个标签开始 字符位置
		int firstTagtagBeginCharPosition=getTagBeginChar(tagBeginPosition,tagBeginMap);
		
		//////System.out.println("tagBeginPosition:"+tagBeginPosition);//
		
		//////System.out.println("firstTagtagBeginCharPosition:"+firstTagtagBeginCharPosition);
		
		LinkedHashMap tagEndMap=getEndTagPosctionMap();
		
		int firsttagEndPosition;
		//第一个标签结束位置
		firsttagEndPosition=tagBeginPosition+tagName.length()-1;	
		
		//////System.out.println("tagEndPosition:"+firsttagEndPosition);//
		
		//第一个标签 结束字符位置
		int firstTagtagEndCharPosition=getTagEndChar(tagName,tagBeginPosition,tagEndMap);
		
	//	////System.out.println("endtag:"+firstTagtagEndCharPosition);
		
		int position[]=new int[3];

		if(firstTagtagBeginCharPosition==-2||firstTagtagEndCharPosition==-2){
			return null;
		}else{
			position[0]=firstTagtagBeginCharPosition;
			position[1]=firstTagtagEndCharPosition;
			position[2]=tagBeginPosition;
			return position;
		}

	}
	/*返回标签<位置 开始标签如：<table> 结束标签如：</table>
	 * 结果返回<的位置信息
	 * 
	 * tagPosision：标签位置，
	 * tagStartEndPosMaps：html文本全部<>位置信息
	 * 算法描述：
	 * 以标签（如table,a)位置tagPosision为基准，找出标签左边的值最大的<，
	 * 同时判断 标签位置-开始标签位置==1
	 * 假定：标签总是以<table 相连接的形式出现。
	 * 
	 * public int getTagBeginChar(int tagPosision,LinkedHashMap tagMaps){
	
	 * return int :-1 tagMaps为空,
	 * -2 结果为空 ,
	 * -3 开始标签也标签不相邻，如a <span>不是<a>
	 * -4 开始标签>标签
	 * 没有该标签起始字符位置
	
	 *
	 */
		
	public int getTagBeginChar(int tagPosision,LinkedHashMap tagStartEndPosMaps){
	
		////System.out.println("\n\n############查找标签开始符：getTagBeginChar()位置："+tagPosision);
		Object result=null;
		Object key;
		Object keyTmp;
		Integer value;
		//////System.out.println("getTagBeginChar(int tagPosision"+tagPosision);
		Iterator i=tagStartEndPosMaps.keySet().iterator();
		
		if(i.hasNext()){
			key=tagStartEndPosMaps.keySet().iterator().next();
		//	////System.out.println("Key"+key);//
		}else{
			////System.out.println("标签库没些标签符：");
			
			
			return -1;
		}
		
		//取标签左边最大的<
		while(i.hasNext()){
			keyTmp=i.next();
			//////System.out.println("keyTmp"+keyTmp);
			
			value=(Integer)tagStartEndPosMaps.get(keyTmp);
			//////System.out.println("keyTmp value:"+value);
			//
				
			if(value<tagPosision){
				
			//	////System.out.println("value<tagPosision:"+value);
				
				if(value>=(Integer)tagStartEndPosMaps.get(key)){
					key=keyTmp;
					result=key;
				}else{
					////System.out.println("value>tagPosision:"+value);
					return -2;
				}
				
			}else{
				continue;
			}
	
		}//end while
		
		//分析该值是否在标签位置库<>中
		 if(tagStartEndPosMaps.get(result)!=null){
			 
			 
			 int tagStart= (Integer)tagStartEndPosMaps.get(result);
		
			 
			 //分析标签位置与<开始位置是否相邻
			 
			 if(tagPosision<tagStart){
				 
				 ////System.out.println("开始标签<位置小于<位置："+tagStart);
					 
				return  -4;
				//开始标签<table>
			 } else if((tagPosision-tagStart)==1){
				 ////System.out.println("找到开始标签<位置："+tagStart);
				 return tagStart;
				//结束标签</table>
			     }else if((tagPosision-tagStart)==2){
				 //分析是否包含"/"结束符
				  if(getHtmlContent().charAt(tagPosision-1)=='/'){
					 ////System.out.println("找到结束标签<位置："+tagStart);	 
				   return tagStart;
				 
				 }else{
					 ////System.out.println("可能是结束标签<位置但不包含/："+tagStart);	 
						
					 
					 return -3;
				 }
				
			 }else{
				 ////System.out.println("标签符库没此<信息tagPosision-tagStart="+(tagPosision-tagStart));
					
				 
				 return -6;
			 }
			 //tagStartEndPosMaps.get(result)==null
		 }else {
			 
			 ////System.out.println("标签符库没此<信息：getTagBeginChar() 标签位置："+tagPosision);
				
			 return -2;
		     
		 }
		
	}
	/*
	 * 是否是结束标签
	 * 
	 */
	public boolean isEndTag(String tagName,int tagNamePosiction,int tagendPostion){
		////System.out.println("isEndTag() tagNamePosiction"+tagNamePosiction+"tagend:"+tagendPostion);
		
		LinkedHashMap<String,Integer> tagEndMaps=getEndTagPosctionMap();
		int tagBeginPosition=tagNamePosiction;
		//标签最后一个字符的位置
		int tagLastCharPosision=tagBeginPosition+tagName.length()-1;	
	
		if(getTagEndByTagMap(tagendPostion)!=null){
			 int tagEnd= (Integer)getTagEndByTagMap(tagendPostion);
			 //分析标签位置左边是否为"/" 结束标签以</a判断，完整：</table>
			
			 if(tagBeginPosition>tagEnd){
				 ////System.out.println("tagBeginPosition>tagEnd"+(tagBeginPosition>tagEnd));
					return  false;
			 } else if(tagBeginPosition<tagEnd){
				 
				 //结束标签</table>的/符
				 //分析标签结束符'>' 与标签最后一个字符是否相差1,即相邻
				
				 
				 if(tagEnd-tagLastCharPosision!=1){
					 ////System.out.println("不是结束标签  结束符'>' 与标签最后一个字符相差不为1 。");
					
				 }else{
					 //////System.out.println("tagBeginPosition>tagEnd"+(tagBeginPosition>tagEnd));
						
					 //可能是包含属性的开始标签如<a href="xxx.html">
				 }
				 
				 //如果是结束标签，判断是否包含"/"
				 int startTagPrefix=tagBeginPosition-1;
				char prefixEndtag='/';
				char c=getHtmlContent().charAt(startTagPrefix);
				 int startTag=tagBeginPosition-2;
				 //文本以<xxx>开始情况
				 if(startTag==-1){
					 startTag=tagBeginPosition-1;
				 }
				char tagStar='<';
				//开始位置<
				char starC=getHtmlContent().charAt(startTag);
				
				if(c==prefixEndtag && starC==tagStar) {
				 	 ////System.out.println("是结束标签 >位置："+tagEnd);
						
					 return true;
				
				   }else  if(starC==tagStar){
						 ////System.out.println("是开始标签 >位置："+tagEnd);

				    	 return false;
				    }else if(starC!=tagStar)	{
				    	//不是结束标签
						////System.out.println("不是结束标签，找不到<符 "+starC);
					    
						return false;
					      //结束标签</table>
				   //左边是<不含/如<table>为开始标签，返回>位置信息
				     }else if(c!=prefixEndtag){
				    	 ////System.out.println("不是结束标签，找不到/符"+c);
							return false;
				    	
				     }else{
				    	 ////System.out.println("c==prefixEndtag");
				    	 return false;
				     }
					
					
				 }else{
					 ////System.out.println("tagBeginPosition<tagEnd"+(tagBeginPosition<tagEnd));
						
					 
					 return false;
				 }
			
		 }else if(getTagEndByTagMap(tagendPostion)==null){
			 ////System.out.println("标签库没些标签符");
				
			 
			 return false;
		 }else{
			 return  false;
		 }
	}
	/*
	 * 是否是开始标签
	 */
	public boolean isStartTag(int tagNamePosiction,int tagStartPostion){
		 ////System.out.println("isStartTag() tagNamePosiction"+tagNamePosiction+"tagstart:"+tagStartPostion);
			
		//分析该值是否在标签位置库<>中
		LinkedHashMap<String,Integer> tagStartEndPosMaps=getStartTagPosctionMap();
		int tagPosision=tagNamePosiction;
		if(getTagStartByTagMap(tagStartPostion)!=null){
			 
			 
			 int tagStart= (Integer)getTagStartByTagMap(tagStartPostion);
		
			 
			 //分析标签位置与<开始位置是否相邻
			 
			 if(tagPosision<tagStart){
				return  false;
				//开始标签<table>
			 } else if((tagPosision-tagStart)==1){
				 ////System.out.println("是开始标签<位置："+tagStart);
				 return true;
				//结束标签</table>
				
				 
				 
			 }else if((tagPosision-tagStart)==2){
				 //分析是否包含"/"结束符
				 if(getHtmlContent().charAt(tagPosision-1)=='/'){
					 ////System.out.println("是结束标签<位置："+tagStart);	 
				   return false;
				 }else{
					 return false;
				 }
				
			 }else{
				 return false;
			 }
		 }else if(getTagStartByTagMap(tagStartPostion)==null){
			 return false;
		 }else{
			 return false;
		 }
		
		
		
		
	}
	/*返回标签>位置
		
	 * 
	 * tagPosision：标签结束位置，
	 * tagStartEndPosMaps：html文本全部<>位置信息
	 * 算法描述：
	 * 以标签（如table,a)位置tagPosision为基准，找出标签左边的值最小的>，
	 * 同时判断 标签位置-开始标签位置"/"==1
	 * 假定：结束标签总是以</table 相连接的形式出现。
	 * 关键点在判断"/"和标签的值是否为一，和查找出<标签。
	 * 返回值：-1 标签库中没有此标签
	 * -2  标签库中没有此标签
	 * -3
	 * -4
	 * 
	 */
	public int getTagEndChar(String tagName,int tagBeginPosition,LinkedHashMap tagStartEndMaps){
		 ////System.out.println("###找结束标签 >位置：getTagEndChar()"+tagBeginPosition);
			
		
		//标签最后一个字符的位置
		int tagLastCharPosision=tagBeginPosition+tagName.length()-1;	
		
		
		Object result=null;
		int k=0;
		Object b=null;
		Object key;
		Object keyTmp;
		Integer value;
	//	////System.out.println("...........................getTagEndChar(int tagPosision)"+tagPosision);
		Iterator i=tagStartEndMaps.keySet().iterator();
		
		if(i.hasNext()){
			key=tagStartEndMaps.keySet().iterator().next();
			//////System.out.println("Key"+key);//
		}else{
			return -1;
		}

		while(i.hasNext()){
			keyTmp=i.next();
			//////System.out.println("keyTmp"+keyTmp);
			
			value=(Integer)tagStartEndMaps.get(keyTmp);
			//////System.out.println("keyTmp value:"+value);
			//
				
			if(value>tagLastCharPosision){
				
				
				if(k==0){
					b=keyTmp;
					result=b;
					k++;
				//	////System.out.println("b:"+b);
				}
				//////System.out.println("value>tagPosision:"+value);
				
				if(value>=(Integer)tagStartEndMaps.get(b)){
					//////System.out.println("value<tagPosision:"+value);
					key=keyTmp;
					
					}else{
						if(value<(Integer)tagStartEndMaps.get(b)){
							b=keyTmp;
							result=b;
							continue;
						}
					}
			}else{
				key=keyTmp;
				continue;
			}
	
		}//end while
		
		 if(tagStartEndMaps.get(result)!=null){
			 int tagEnd= (Integer)tagStartEndMaps.get(result);
			 //分析标签位置左边是否为"/" 结束标签以</a判断，完整：</table>
			
			 if(tagBeginPosition>tagEnd){
					return  -4;
			 } else if(tagBeginPosition<tagEnd){
				 
				 //结束标签</table>的/符
				 //分析标签结束符'>' 与标签最后一个字符是否相差1,即相邻
				
				 
				 if(tagEnd-tagLastCharPosision!=1){
					 ////System.out.println("不是结束标签  结束符'>' 与标签最后一个字符相差不为1 。");
					
				 }else{
					 //可能是包含属性的开始标签如<a href="xxx.html">
				 }
				 
				 //如果是结束标签，判断是否包含"/"
				 int startTagPrefix=tagBeginPosition-1;
				char prefixEndtag='/';
				char c=getHtmlContent().charAt(startTagPrefix);
				
				//判断是否是结束标签</a>
				
				int startTag=tagBeginPosition-2;
				 //文本以<xxx>开始情况
				 if(startTag==-1){
					 startTag=tagBeginPosition-1;
				 }
				char tagStar='<';
				//开始位置<
				char starC=getHtmlContent().charAt(startTag);
				
				if(c==prefixEndtag && starC==tagStar) {
				 	 ////System.out.println("找到结束标签 >位置："+tagEnd);
						
					 return tagEnd;
				
				   }else {
					   
						//判断是否是开始标签</a>
						
						 startTag=tagBeginPosition-1;
							 tagStar='<';
							//开始位置<
							 starC=getHtmlContent().charAt(startTag);
							
					   if(starC==tagStar){
						 ////System.out.println("找到开始标签 >位置："+tagEnd);

				    	 return tagEnd;
				    }else if(starC!=tagStar)	{
				    	//不是结束标签
						////System.out.println("不是结束标签，找不到<符 "+starC+" 位置"+startTag);
					    
						return -5;
					      //结束标签</table>
				   //左边是<不含/如<table>为开始标签，返回>位置信息
				     }else if(c!=prefixEndtag){
				    	 ////System.out.println("不是结束标签，找不到/符"+c);
							return -4;
				    	
				     }else{
				    	 return -6;
				     }
			    }//end else 
			 }else{
				 return -5;
			 }
			
		 }else if(tagStartEndMaps.get(result)==null){
			 return -2;
		 }else{
			 return  -1;
		 }
		
	}
	
	/*
	 * 重设标签开始结束位置库<>
	 * 如删除标签时，文本标签位置变动，库须重建
	 * 可以重新分析库标签相对位置方式，也可重新分析进行重建
	 * 
	 */
	public void resetTagStartEndPosictionMap(){

		if(getStartTagPosctionMap() .size()!=0){
			getStartTagPosctionMap() .clear();
		}else if(getEndTagPosctionMap().size()!=0){
			getEndTagPosctionMap().clear();
		}
		tagCreateStartEndPosctinMap();
	}
	/*
	 * 创建开始结束标签库
	 * 
 	 */
	public void tagCreateStartEndPosctinMap(){
		String firstTag;
		String secondTag;
		String tagbegin="<";
		String tagEnd=">";
		String tagEndA="/";
		
		LinkedHashMap <String,Integer> startPositionTagMap=new LinkedHashMap <String,Integer> ();
		LinkedHashMap <String,Integer> endPositionTagMap=new LinkedHashMap <String,Integer> ();
		
		TagStartEndPOSMapcreate(startPositionTagMap,tagbegin,getHtmlContent());
		TagStartEndPOSMapcreate(endPositionTagMap,tagEnd,getHtmlContent());
	  this.startTagPosctionMap=startPositionTagMap;
	  this.endTagPosctionMap=endPositionTagMap;
	}
	
	//从标签库中获取标签
	public Integer getTagStartByTagMap(int startTagPosiction){
		String key="<"+startTagPosiction;
		return getStartTagPosctionMap().get(key);
	}
	public Integer getTagEndByTagMap(int endTagPosiction){
		String key=">"+endTagPosiction;
		return getEndTagPosctionMap().get(key);
	}
	/*
	 * 	获取所有标签的位置 如 ：开始，结束标签<>等
	 * tag 标签名
	 * content 网络文本
	 * 库元素命名规则：开始标签库
	 * KEY :<+<的位置信息
	 * value:<的位置信息
	 * 结束标签亦然。
	 */

	public void TagStartEndPOSMapcreate(LinkedHashMap <String,Integer> positionTagMap,String tag,StringBuffer content){

		 int k=0;
		 int lenght=content.length();
	     while(content.indexOf(tag,k)!=-1){
	    	 Integer at=content.indexOf(tag,k);
	    	 //判断是标签<a> <span> 只要<a的标签
	    	 int posstart=at-1;
	  
	    	 
	    	 //下一标签位置
	    	 k=at+1;
	    	 
	    	 if(k>lenght){
	    		break ;
	    	 }
	    	 String key=tag+at;
	    	// ////System.out.println("Map:"+key+"value"+at);
	    	 positionTagMap.put(key,at );
	     }
		 
	}

	public void delTable(){
		
	}
	public void delString (){
		
	}
	public void delLink(){
		
	}
	
	
	public int charAt(char c){
		return 0;
	}
	public void delDiv(){
		
	}
	public int  getLinkBegin(){
		return 0;
	}
	public int getLinkEnd(){
		return 0;
	}
	
	/*
	 * 设置HTML分析器文本，
	String htmlContent：输入的html文本
	 * 	 * 方法输入检查：判断文本是否为空
	 * 方法报告信息：如果为空，则输出文本无效信息。
	*/
	
	public  void setHtmlContent(String htmlContent) {
		if(htmlContent==null){
			htmlContent="";
		}
		
		this.htmlContent = new StringBuffer(htmlContent);
		//清空旧标签
		if(getStartTagPosctionMap().size()!=0){
			getStartTagPosctionMap().clear();
		}
	   //创建<>标签库	
		 tagCreateStartEndPosctinMap();
	}
	public  StringBuffer getHtmlContent() {
		return htmlContent;
	}

	public void setHtmlTagList(ArrayList<HtmlTag> htmlTagList) {
		this.htmlTagList = htmlTagList;
	}
	public ArrayList<HtmlTag> getHtmlTagList() {
		return htmlTagList;
	}
	public void setHtmlTag(HtmlTag htmlTag) {
		this.htmlTag = htmlTag;
	}
	public HtmlTag getHtmlTag() {
		return htmlTag;
	}
	public void setStartTagPosctionMap(LinkedHashMap<String,Integer> positionTagMap) {
		this.startTagPosctionMap = positionTagMap;
	}
	public LinkedHashMap<String,Integer> getStartTagPosctionMap() {
		return startTagPosctionMap;
	}
	
	public void setEndTagPosctionMap(LinkedHashMap<String,Integer> endTagPosctionMap) {
		this.endTagPosctionMap = endTagPosctionMap;
	}

	public LinkedHashMap<String,Integer> getEndTagPosctionMap() {
		return endTagPosctionMap;
	}

	public void setLog(StringBuffer log) {
		this.log = log;
	}

	public StringBuffer getLog() {
		return log;
	}

	public void setLinkPathBean(LinkPathBean linkPathBean) {
		this.linkPathBean = linkPathBean;
	}

	public LinkPathBean getLinkPathBean() {
		return linkPathBean;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public String getAction() {
		return action;
	}
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		Html html=new Html();
		String s="</ strong>dsfsd<a></a><a><img src=\"a\\b.gif\"><img src=\"a\\c.gif\"><img src=\"a\\j.gif\"> <table id=\"xx\"></table></strong>";
				html.setHtmlContent(s);
				//StringBuffer bf=html.delDoubleTag("aform");
			//	html.delSimpleString("吴家伟");
			//	bf.append("吴家伟");
				/*
				Iterator<int[]> i=html.getAllTagPosictionInfo("strong").iterator();
				while(i.hasNext()){
					int [] p=i.next();
					////System.out.println("i::::::::::::::::::");
					////System.out.println("i:"+p[0]);
					////System.out.println("i:end:"+p[1]);
				}
				*/
				//////System.out.println(s.indexOf("strong"));
				
				//////System.out.println(bf.toString());
				//html.delAllTag("Jstrong");
				//html.delDoubleTag("strong");
				Iterator<String> it=html.getIMGPathList().iterator();
	
			html.delAllHtmlTagByTagList("a table strong");
		         //System.out.println(html.getHtmlContent().toString());
					while(it.hasNext()){
						String tag=it.next();
						//System.out.println(tag);
						////System.out.println(tag.getTagName()+" start:"+tag.getStart()+"end:"+tag.getEnd());
					}
	}
	public void setHtmlBeanId(int htmlBeanId) {
		this.htmlBeanId = htmlBeanId;
	}
	public int getHtmlBeanId() {
		return htmlBeanId;
	}

	
}
