package mall.kgmall.saler.bean;
/**
 * 卖家货款管理，待收货款，已收货款
 * 
 * 现金总帐管理，汇率，跨国现金提现
 * 收入支出明细单
 * 
 * @author Administrator
 *
 */
import java.util.Date;

import dao.MallShopDianpuUser;
import dao.MallShopMallSalerKaijiBook;
import dao.MallShopMallSalerBalance;
import dao.MallShopMallSalerBalance;
import dao.MallShopTransmoneyOutMallSaler;

import service.entryService.MallShopDianpuUserEntryService;
import service.entryService.MallShopMallSalerKaijiBookEntryService;
import service.entryService.MallShopMallSalerMoneyEntryService;
import service.entryService.MallShopShipProductMallEntryService;
import service.entryService.MallShopMallSalerBalanceEntryService;
import service.entryService.MallShopTransmoneyOutMallSalerEntryService;
import dao.MallShopMallSalerMoney;



import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class HuoKuanManageBean {
	//获取卖家现金总帐
	
	public MallShopMallSalerBalance getSalerbalanceSheet(long shopSalerId){
		
		
		MallShopMallSalerBalanceEntryService balanceBean=MallShopMallSalerBalanceEntryService.getInstance();
		MallShopMallSalerBalance balance=balanceBean.loadOrCreateSalerbalanceSheet(shopSalerId);
		
		return balance;
	}
	
	//买家确认签收货物，货款转入卖家帐号
	public void buyerReceiveShipProduct(dao.MallShopShipProductMall ship){
		long salerId=ship.getDianpuUserId();
		
		dao.MallShopDianpuUser saler=(MallShopDianpuUser) MallShopDianpuUserEntryService.getInstance().get(salerId);
		long dianPuUserId0=saler.getUserid();
		
		
		//创建资金支出/收入明细
		MallShopMallSalerMoney money=new MallShopMallSalerMoney();
		
		money.setDianpuId(saler.getDefaultDianPuId().longValue());
		money.setDianPuName(saler.getDefalutDianPuName());
		
		money.setDianPuUserId(dianPuUserId0);
		
		money.setDianPuuserName(saler.getUserName());
		Date inputTime=new Date(System.currentTimeMillis());
		money.setHappanyTime(inputTime);
		money.setInutTime(inputTime);
		money.setItemName("产品销售收入");
		
		//获取订单
		dao.MallShopOrder order=service.entryService.MallShopOrderEntryService.getInstance()
		.getOrferByOrderId(ship.getOrderID());
		//金额
		money.setMoneyCount(order.getTotalPrice());
		//交易号
		String transactionId=order.getOrderID();
		money.setTransactionId(transactionId);
		money.setBinTrueOutFalse(true);
		
		//交易类型
		String transactionType=mall.kgmall.system.SystemValidatyApp.Money_TransActionType_Sale;		
		money.setTransactionType(transactionType);
		//现金收入状态 :待收，已收，作废
		String moneyState_Complee=mall.kgmall.system.SystemValidatyApp.Money_State_Complee;	
		
		money.setMoneyState(moneyState_Complee);
		
		MallShopMallSalerMoneyEntryService mbean=MallShopMallSalerMoneyEntryService.getInstance();
		MallShopMallSalerMoney moneySaved=	mbean.getMoneyByTransactionID(transactionId);
		//
		
		//资金帐号
		MallShopMallSalerBalance blance=getSalerbalanceSheet(salerId);
		if(moneySaved==null){
			
			money.setComment("买家签收，付款完成，款项已打入卖家现金帐号。");
			mbean.merge(money);
			
			//向卖家现金总帐号添加收入
			addIncomeMoneyToSalerBalance(blance,order.getTotalPrice());
		}else{
			System.out.println("该现金交易明细已存在："+transactionId);
			//卖家已付款，将现金状态改为完成,如果原状态为等待付款
			String state=	moneySaved.getMoneyState();
		    String moneyState_WaittingPay=mall.kgmall.system.SystemValidatyApp.Money_State_WaittingPay;	
			if(state.equals(moneyState_WaittingPay)==true ){
			moneySaved.setMoneyState(moneyState_Complee);
			moneySaved.setComment("买家签收，付款完成，款项已打入卖家现金帐号。");
			
			mbean.merge(moneySaved);
			
			//向卖家现金总帐号添加收入
			//向卖家现金总帐号添加收入
			addIncomeMoneyToSalerBalance(blance,order.getTotalPrice());
			}
			
		}
		
		//向总帐追加资金
		//修改发货单状态为已接收
		service.entryService.MallShopShipProductMallEntryService shipBean=service.entryService.MallShopShipProductMallEntryService.getInstance();
		String state=	ship.getShipState();
		if(state!=null&&state.equals(mall.kgmall.system.SystemValidatyApp.Order_send_Shiping)){
		ship.setShipState(mall.kgmall.system.SystemValidatyApp.Order_send_Received);
		shipBean.merge(ship);
		}
		
		
	}
	
	
	//向卖家现金账号打入汇款
	private void addIncomeMoneyToSalerBalance(MallShopMallSalerBalance blance,Double money){
		
		MallShopMallSalerBalanceEntryService balanceBean=MallShopMallSalerBalanceEntryService.getInstance();
	Double m=	blance.getIncomeMoneyCount();
		if(m==null){
			m=0.00;
		}
		m=m+money;
		blance.setIncomeMoneyCount(m);
		balanceBean.merge(blance);
	}
	
	//卖家申请退款，拒绝签收货物
	public void buyerAntiReceiveShipProduct(dao.MallShopShipProductMall ship){
		String transactionId=ship.getOrderID();
		MallShopMallSalerMoneyEntryService mbean=MallShopMallSalerMoneyEntryService.getInstance();
		MallShopMallSalerMoney moneySaved=	mbean.getMoneyByTransactionID(transactionId);
	//
		
		//资金帐号 收入明细改为付款无效
		
		if(moneySaved!=null){
			System.out.println("该现金交易明细已存在："+transactionId);
			//卖家已付款，将现金状态改为完成,如果原状态为等待付款
			String state=	moneySaved.getMoneyState();
		    String Money_State_BadMoney=mall.kgmall.system.SystemValidatyApp.Money_State_BadMoney;	
			
		    String moneyState_WaittingPay=mall.kgmall.system.SystemValidatyApp.Money_State_WaittingPay;
		    if(state.equals(moneyState_WaittingPay)==true ){
		    	//将待付款设置为无效
			moneySaved.setMoneyState(Money_State_BadMoney);
			
			moneySaved.setComment("买家拒绝签收货物，付款无效，将退款给买家，请商家返运货物。");
			mbean.merge(moneySaved);
			
			//向卖家现金总帐号添加收入
			//向卖家现金总帐号添加收入
		
			}
			
		}
		
		
		//修改发货单状态为已接收
		service.entryService.MallShopShipProductMallEntryService shipBean=service.entryService.MallShopShipProductMallEntryService.getInstance();
		String state=	ship.getShipState();
		if(state!=null&&state.equals(mall.kgmall.system.SystemValidatyApp.Order_send_Shiping)){
		ship.setShipState(mall.kgmall.system.SystemValidatyApp.Order_send_AnitRecevie);
		shipBean.merge(ship);
		}
		
	}
	//

	/**
	 * 卖家提交资金提现申请
	 * @param saler
	 * @param balance
	 * @param count
	 */
	public MallShopTransmoneyOutMallSaler createTransMoneyOutFormBySaler(	dao.MallShopDianpuUser saler,MallShopMallSalerBalance balance,
			Double count) {
		
		
		 
		// TODO Auto-generated method stub
	Double intotal=	balance.getIncomeMoneyCount();
	
	intotal=intotal-count;
	

	 if(count>intotal){
	    	//request.setAttribute("info", "错误，您提取的金额超出账号收入总额，请重新设置。");
	 		//提取现金到支付宝
	 		return null;
	 		
	    }
	balance.setIncomeMoneyCount(intotal);
	
		//创建退款明细
		dao.MallShopTransmoneyOutMallSaler trans=new dao.MallShopTransmoneyOutMallSaler();
		String timeStr=util.TimeUtil.getInstance().getYYMMddhhmmssSSS();
		//创建事务ID
		String transId="s"+balance.getDianPuUserId()+"t"+timeStr;
		trans.setTransactionId(transId);
		
		//提现金额
		trans.setMoneyCount(count);
		
		trans.setComment("卖家资金提现已提交，等待网站管理员处理。");
		trans.setDianpuId(saler.getDefaultDianPuId().longValue());
		trans.setDianPuName(saler.getDefalutDianPuName());
		
		trans.setDianPuUserId(saler.getUserid());
		trans.setDianPuuserName(saler.getUserName());
		
		trans.setItemName("卖家资金提现");
		trans.setInutTime(new Date(System.currentTimeMillis()));
		
		trans.setMoneyTransState(mall.kgmall.system.SystemValidatyApp.Money_Strans_Saler_Waiting);
		long balanceId=balance.getId();
		trans.setSalerBalandceId(balanceId);
		
		trans.setTransactionType("TransMoney");
		trans.setTransToolsName("支付宝");
		
		//提交
		MallShopTransmoneyOutMallSalerEntryService beanTrns=MallShopTransmoneyOutMallSalerEntryService.getInstance()
		;
		beanTrns.merge(trans);
		
		dao.MallShopTransmoneyOutMallSaler transSaved=	beanTrns.getTransByTransActionID(transId);
		
		return transSaved;
	}
}
