package mall.kgmall.mydianpu.init;

import dao.MallShopDianPu;
import service.entryService.MallShopDianPuEntryService;
import mall.kgmall.config.MallConfigUtil;
/*
 * 店铺初始化服务类
 */
public class DianPuInitServiceBean {
	
	
// 初始化店铺相关数据，如根据平台语言版本（中，英），设置店铺有关默认文章分类，简单介绍，相关文档及IM帐号，在线支付业务等。

public void initNewShop(dao.MallShopDianPu dpSaved){
	MallConfigUtil mc=new MallConfigUtil();
	dao.MallShopConfig config=mc.getDefaultMallConfig();	
	
	MallShopDianPuEntryService dpService=MallShopDianPuEntryService.getInstance();
	
	//通用商城店铺初始化
	Boolean isopenpayService=config.getBdianpuOpenPayService_newshop();
	if(isopenpayService!=null&&isopenpayService==true){
		dpSaved.setBopenOnliePay(true);
	}else{
		dpSaved.setBopenOnliePay(false);
	}
	
	int dpid=dpSaved.getDianPuId();
	//更新店铺
	dpService.merge(dpSaved);
	
	
	//专用商城平台业务类型初始化
	
	dao.MallShopDianPu reloadDp=(MallShopDianPu) dpService.get(dpid);
	
	MallShopInitIf shopInitIf=getInitImpl();

	shopInitIf.initShop(reloadDp);
	
}


public MallShopInitIf getInitImpl(){
	MallConfigUtil mc=new MallConfigUtil();
	dao.MallShopConfig config=mc.getDefaultMallConfig();

	//商城平台商业类型
	String serviceType=config.getServiceType();
	//商城平台语言版本
			String lan=config.getDefaultLanguage();
			
			System.out.println("初始化商城，获取平台配置，平台业务模式："+serviceType+" 平台使用语言："+lan);
	//
	

	MallShopInitIf shopInitIf=null;
	
	if(serviceType!=null&&serviceType.equals(mc.ServiceType_B2B2C)){
		
		
		if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
			shopInitIf=new B2B2CCnInitUtil();
			
		}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
			shopInitIf=new B2B2CEnInitUtil();
		}
	}else	if(serviceType!=null&&serviceType.equals(mc.ServiceType_B2B)){
		
		if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
			shopInitIf=new B2BCnInitUtil();
			
		}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
			shopInitIf=new B2BEnInitUtil();
		}
	}else	if(serviceType!=null&&serviceType.equals(mc.ServiceType_C2C)){
		
		if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
			
			shopInitIf=new C2CCnInitUtil();
			
		}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
			shopInitIf=new C2CEnInitUtil();
		}
	}else	if(serviceType!=null&&serviceType.equals(mc.ServiceType_ShopinShop)){
		
		if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
			shopInitIf=new ShopinShopCnInitUtil();
			
		}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
			shopInitIf=new ShopinShopEnInitUtil();
		}
	}else	if(serviceType!=null&&serviceType.equals(mc.ServiceType_O2O)){
			
		if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
			shopInitIf=new O2OCnInitUtil();
		}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
			shopInitIf=new O2OEnInitUtil();
		}
		
		
		
	}else{
				
				if(lan!=null&&lan.equals(mc.C_Lan_Zh_CN)){
					shopInitIf=new B2BCnInitUtil();
					
				}else if(lan!=null&&lan.equals(mc.C_Lan_Zh_En)){
					shopInitIf=new B2BEnInitUtil();
				}
	}
	
	
	return shopInitIf;
	
	
}

}
