package mall.kgmall.mydianpu.init;

import mall.kgmall.config.ShopDianPuConfig;
import service.entryService.MallShopCmsCatEntryService;
import service.entryService.MallShopMallArticleEntryService;

/**
 * 卖家注册时，初始化店铺设置
 * 如模板，语言，文章，公司介绍，行业等
 * 
 * 
 * 
 * @author root
 *
 */
public class B2BCnInitUtil extends MallDpInitBaseUtil implements MallShopInitIf {
	
	
	public void initShop(dao.MallShopDianPu newShop){
		//初始化店铺文章分类：公司新闻，公司资料,product manuals

		initCMSCat(newShop);
		//添加店铺默认文章：公司介绍，联系方式，
		
		initCMSDefaultArticle(newShop);
		
		
		//创建店铺IM帐号
		//创建店铺消息帐号
	}
	
	//创建默认文章
	public void initCMSDefaultArticle(dao.MallShopDianPu shop){
MallShopMallArticleEntryService aService=	MallShopMallArticleEntryService.getInstance();
		
		MallShopCmsCatEntryService cmsCatService=MallShopCmsCatEntryService.getInstance();
		//关于我们
		int shopDpId0=shop.getDianPuId();
		String catNameEn1=ShopDianPuConfig.Dp_Cms_Cat_En_AboutUs;
		dao.MallShopCmsCat cat_AboutUs=cmsCatService.getCatByDpNameCatCnName(shopDpId0, catNameEn1);
		//About us
		
		//"&syskey=AboutUs&catname_en
		dao.MallShopMallArticle a_aboutus=new dao.MallShopMallArticle ();
		a_aboutus.setTitle("关于我们");
		a_aboutus.setCatNameCn("关于我们");
		a_aboutus.setCatNameEn("About Us");
		
		//content
		a_aboutus.setContent("我们是一家＃＃＃，网店商号："+shop.getDianpuName()+"。主要经营：###。欢迎惠顾！");
		//html
		a_aboutus.setHtmlTitle("关于我们");
		a_aboutus.setHtmlKeyWord("关于我们");
		a_aboutus.setHtmlDescription("关于我们");
		//由系统定义，不可由用户修改
		a_aboutus.setSystemTag("AboutUs");
		
		intiShopCmsCat(a_aboutus,cat_AboutUs,shop);
		
		aService.merge(a_aboutus);
		
		
		//syskey=Certificates&catname_en=About Us
		
		dao.MallShopMallArticle a_Certificates=new dao.MallShopMallArticle ();
		
		a_Certificates.setTitle("资质认证");
		a_Certificates.setCatNameCn("关于我们");
		a_Certificates.setCatNameEn("About Us");		
		//由系统定义，不可由用户修改
		a_Certificates.setSystemTag("Certificates");
		
		
		//content
		a_Certificates.setContent("我们是一家＃＃＃，网店商号："+shop.getDianpuName()+"。主要经营：###。欢迎惠顾！");
				//html
		a_Certificates.setHtmlTitle("资质认证");
		a_Certificates.setHtmlKeyWord("资质认证");
		a_Certificates.setHtmlDescription("资质认证");
		
		intiShopCmsCat(a_Certificates,cat_AboutUs,shop);
		
		aService.merge(a_Certificates);
		
		//新闻设置
		
		String catNameEn_news=ShopDianPuConfig.Dp_Cms_Cat_En_News;
		dao.MallShopCmsCat cat_news=cmsCatService.getCatByDpNameCatCnName(shopDpId0, catNameEn_news);
	
		//第一篇新闻，店铺开通
		dao.MallShopMallArticle a_firstNews=new dao.MallShopMallArticle ();
		
		a_firstNews.setTitle("好消息，我的网店成功开通了！");
		a_firstNews.setCatNameCn("关于我们");
		a_firstNews.setCatNameEn("About Us");		
		//由系统定义，不可由用户修改
		a_firstNews.setSystemTag("FirstNews");	
		
		
		
		//content
		
		java.util.Date date=new java.util.Date(System.currentTimeMillis());
		java.text.SimpleDateFormat ft=new java.text.SimpleDateFormat("yyyy-MM-dd");
		String newsTime=ft.format(date);
	
		a_firstNews.setContent("大家好，我于"+newsTime+"开通了一家网店，网店商号："+shop.getDianpuName()+"。欢迎惠顾！");
				//html
		a_firstNews.setHtmlTitle("好消息，我的网店成功开通了！");
		a_firstNews.setHtmlKeyWord("网店开通,Kgmall B2B CN Tech By Juuluu");
		a_firstNews.setHtmlDescription("网店开通,Kgmall B2B Cn ");
		
		intiShopCmsCat(a_Certificates,cat_AboutUs,shop);
		
		
		intiShopCmsCat(a_firstNews,cat_news,shop);
		
		aService.merge(a_firstNews);
	}
	
	public void initCMSCat(dao.MallShopDianPu newShop){
		
		MallShopCmsCatEntryService cmsCatService=MallShopCmsCatEntryService.getInstance();
		//关于我们
		dao.MallShopCmsCat cat_AboutCmp=new dao.MallShopCmsCat();
		//cat_AboutCmp.setCatIcon(catIcon);
		cat_AboutCmp.setCatNameCn("关于我们");		
		cat_AboutCmp.setCatNameEn("About Us");
		//html
		cat_AboutCmp.setHtmlTitle("关于我们");
		cat_AboutCmp.setHtmlDescription("关于我们");
		cat_AboutCmp.setHtmlKeyWord("关于我们");
		
		intiShopCmsCat(cat_AboutCmp,newShop);
		cmsCatService.merge(cat_AboutCmp);
		//公司新闻
		dao.MallShopCmsCat cat_news=new dao.MallShopCmsCat();
		cat_news.setCatNameCn("新闻动态");	
		cat_news.setCatNameEn("News");
		
		//html
		cat_news.setHtmlTitle("新闻动态");
		cat_news.setHtmlDescription("新闻动态");
		cat_news.setHtmlKeyWord("新闻动态");
		intiShopCmsCat(cat_news,newShop);
		cmsCatService.merge(cat_news);	
			
		//产品手册 product manuals
		dao.MallShopCmsCat cat_product_manuals=new dao.MallShopCmsCat();
		cat_product_manuals.setCatNameCn("产品手册");	
		cat_product_manuals.setCatNameEn("Product Manuals");
		
		//html
		cat_product_manuals.setHtmlTitle("产品手册");
		cat_product_manuals.setHtmlDescription("产品手册");
		cat_product_manuals.setHtmlKeyWord("产品手册");
		
		intiShopCmsCat(cat_product_manuals,newShop);
		cmsCatService.merge(cat_product_manuals);
		//技术知识 tech_doc
		dao.MallShopCmsCat cat_tech_doc=new dao.MallShopCmsCat();
		cat_tech_doc.setCatNameCn("技术文档");	
		cat_tech_doc.setCatNameEn("Tech Document");
		
		//html
		cat_tech_doc.setHtmlTitle("技术文档");
		cat_tech_doc.setHtmlDescription("技术文档");
		cat_tech_doc.setHtmlKeyWord("技术文档");
		
		intiShopCmsCat(cat_tech_doc,newShop);
		cmsCatService.merge(cat_tech_doc);
	}
	

}
