package mall.kgmall.jianTai.lan.bean;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import service.entryService.MallShopDianPuEntryService;
import service.entryService.MallShopDianpuCatEntryService;
import service.entryService.MallShopProductEntryService;
import service.entryService.MallShopProductcatEntryService;
import dao.MallShopProduct;
import dao.MallShopProductcat;
/**
 * 生成商城静态网页路径，分类页，产品页，一级分类页面
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class ShopHtmlPathBean {
	//多国语言
	private String lan;
	
	//产品列表静态路径
public void resetProductPageHtmlPathByList(List<dao.MallShopProduct> productList){
		
	List<dao.MallShopProduct> pl=new ArrayList<dao.MallShopProduct>();
	for(int i=0;i<productList.size();i++){
			//, element))
			MallShopProduct p=productList.get(i);
			//创建显示产品
			MallShopProduct newp=new MallShopProduct();
			newp.setAddTime(p.getAddTime());
			newp.setPrice(p.getPrice());
			newp.setSmallDescription(p.getSmallDescription());
			newp.setSmallImgIConPath(p.getSmallImgIConPath());
			
			//if(p.getHtmlLinkPath()==null||p.getHtmlLinkPath().equals("")){
				//创建静态路径
				long pid=p.getId();
				 String link=getProductPageHtmlPath(pid);
			newp.setHtmlLinkPath(link);
			newp.setName(p.getName());
			pl.add(newp);
			
			//}
				 
			
		}
	}
	
	//产品页静态路径
	public String getProductPageHtmlPath(long ShopProductId){		
		
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		dao.MallShopProduct a=(MallShopProduct) as.get( ShopProductId);
		
		//文章静态相对路径
		String PathAndFileNameSd="";
		
		
		//文章静态相对路径是否已存在
			util.HtmlPathCreateUtil pathbean=new util.HtmlPathCreateUtil();
			//文件保存目录，相对目录
			String saveDir="/mall/html";
			//实体数据ID
			String Id=Long.toString(a.getId());
			//文件名前缀
			String fileNamePrefix="cp";
			//文件后缀
			String fileType="html";
			//创建含时间的相对路径
			PathAndFileNameSd=createTimeHtmlPathByEntryID(a,saveDir, Id, fileNamePrefix, fileType);
			//保存路径
			a.setHtmlLinkPath(PathAndFileNameSd);
			as.merge(a);
			System.out.println("创建静态路径："+PathAndFileNameSd);
			
		
		
		return PathAndFileNameSd;
	}
	private String fileType ="html";
	
	
	public String createTimeHtmlPathByEntryID(dao.MallShopProduct a,String saveDir,String Id,String fileNamePrefix,String fileType){
		if(fileType==null){
			fileType=this.fileType;
		}
		String filename=fileNamePrefix+"_"+Id+"."+fileType;
		String RootDir=saveDir+"";	
		
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		
		//时间路径
		String timePath=getTimeFilePath_YYYY_Data(a);
		String path=RootDir+"/"+timePath+"/"+filename;
		
		
		if(this.lan!=null&&this.lan.equals("")==false){
			path=RootDir+"/"+this.lan+"/"+timePath+"/"+filename;
		}
		
		return path;

	}
	//通过产品添加时间创建路径
	public String getTimeFilePath_YYYY_Data(dao.MallShopProduct a){

		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		
	
		java.util.Date timestamp=	a.getAddTime();
		if(timestamp==null){
			System.out.println("设置产品添加时间，原值为空。");
			long timeLOng=System.currentTimeMillis();
			timestamp=new java.util.Date(timeLOng);
			a.setAddTime(timestamp);
			as.merge(a);
		}
		long time=	timestamp.getTime();
		StringBuffer p=new StringBuffer();
		p.append(getYear(time));
		p.append("/");
		p.append(getMonth(time));
		p.append("/");
		p.append(getDate(time));
		//p.append(getSecend());
//		p.append("/");
		//p.append(getSSS());
		//p.append("/");
		return p.toString();
	}
	
	public String getYear(long time){
		
		Date d=new Date(time);
		SimpleDateFormat df =new SimpleDateFormat("yyyy");
		return df.format(d);

		}

		public String getMonth(long time){
			
			Date d=new Date(time);
			SimpleDateFormat df =new SimpleDateFormat("MM");
			return df.format(d);

			}
		public String getDate(long time){
		
			Date d=new Date(time);
			SimpleDateFormat df =new SimpleDateFormat("dd");
			return df.format(d);

			}
		public String getHour(long time){
			
			Date d=new Date(time);
			SimpleDateFormat df =new SimpleDateFormat("hh");
			return df.format(d);

			}
	
	/**
	 * 栏目子栏目列表首页静态路径路径
	 * @param catid
	 * @return
	 */
	public void resetListCatIndexHtmlPath(List<dao.MallShopProductcat> catList){
		service.entryService.MallShopProductcatEntryService bean=	service.entryService.MallShopProductcatEntryService.getInstance()
		;
		for(int i=0;i<catList.size();i++){
			MallShopProductcat cat=catList.get(i);
			getCatIndexHtmlPathByCatIDPageId(cat.getCatId());
		
		}
		
	}
	
	
	//生成产品分类页静态网页路径
	public String getCatIndexHtmlPathByCatIDPageId(int catid){
		
		service.entryService.MallShopProductcatEntryService bean=	service.entryService.MallShopProductcatEntryService.getInstance()
		;
			dao.MallShopProductcat icat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
			.get(catid);
			if(icat==null){
				System.out.println("找不到该栏目："+catid);
				return "";
			}
			//已生成静态路径
			//if(icat.getHtmLinkPath()!=null&&icat.getHtmLinkPath().equals("")==false){
			//	return icat.getHtmLinkPath();
			//}
			int ShopProductcatid;
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatid=icat.getCatId();
			}else{
				if(icat.getRootCatId()==null){
					System.out.println("一级栏目未设置："+catid);
					return "";
				}
				ShopProductcatid=icat.getRootCatId();
			}
			
			dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatid);
		   //根目录路径+产品分类路径
			String ShopProductcatDirRoot=ch.getEnglishCharname();
			//生成静态，产品目录路径
			String ShopProductcatDir="";
			//是否根产品分类
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatDir=ShopProductcatDirRoot;
			}else{
				//增加子分类栏目
				ShopProductcatDir=ShopProductcatDirRoot+"/"+icat.getEnglishCharname();
			}
			
			String catPathAndFileName="/mall/html/"+ShopProductcatDir+"/index.html";
			//多国语言
			if(this.lan!=null&&lan.equals("")==false){
				catPathAndFileName="/mall/html/"+this.lan+"/"+ShopProductcatDir+"/index.html";
				
			}
			//System.out.println("产品分类路径："+catPathAndFileName);
			
			//if(icat.getHtmLinkPath()==null||icat.getHtmLinkPath().equals("")){
			///	icat.setHtmLinkPath(catPathAndFileName);
			//	icat.setBhtml(true);
			//	bean.merge(icat);
			//}
			
			return catPathAndFileName;
	}
	
	//生成产品分类页静态网页路径
	public String getCatHtmlPathByCatIDPageId(int catid, int pageid){
		
			dao.MallShopProductcat icat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
			.get(catid);
			//获取一级栏目及其栏目，作为生成静态目录
			//生成静态，产品目录路径
			String ShopProductcatDir="";
			//根目录路径+产品分类路径
			String ShopProductcatDirRoot="";
			int ShopProductcatidRoot=0;
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatidRoot=icat.getCatId();
				dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatidRoot);
				   //根目录路径+产品分类路径
				ShopProductcatDirRoot=ch.getEnglishCharname();
			}else{
				if(icat.getRootCatId()==null){
					System.out.println("该子栏目没设置一级栏目，使用默认目录："+icat.getName()+" ID:"+icat.getCatId());
					ShopProductcatDirRoot="Cat"+catid;
				}else{
					ShopProductcatidRoot=icat.getRootCatId();
					dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatidRoot);
					   //根目录路径+产品分类路径
					ShopProductcatDirRoot=ch.getEnglishCharname();
				}
			}
			if(ShopProductcatDirRoot==null){
				System.out.println("栏目英文名未设置，使用默认目录：Cat"+catid);
				ShopProductcatDirRoot="Cat"+catid;
			}
			
		
			
			//是否根产品分类
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatDir=ShopProductcatDirRoot;
			}else{
				//增加子分类栏目
				ShopProductcatDir=ShopProductcatDirRoot+"/"+icat.getEnglishCharname();
			}
			String listPathAndFileName="/mall/html/"+ShopProductcatDir+"/"+"list_"+catid+"_"+pageid+".html";
			
			//多国语言
			if(this.lan!=null&&lan.equals("")==false){
				listPathAndFileName="/mall/html/"+this.lan+"/"+ShopProductcatDir+"/"+"list_"+catid+"_"+pageid+".html";
				
			}
			return listPathAndFileName;
	}
	/*8
	 * 店铺静态路径
	 */
	public String getDianPuLinkPath(int dianPuId) {
		// TODO Auto-generated method stub
		MallShopDianPuEntryService as=	MallShopDianPuEntryService.getInstance();
		dao.MallShopDianPu a=(dao.MallShopDianPu) as.get( dianPuId);
		if(a==null){
			//this.logBf.append("产品不存在"+ShopProductId);
			return "";
		}
		
		String listPathAndFileName="/mall/html/mall/mall_"+a.getDianPuId()+"/index.html";
		if(this.lan!=null&&this.lan.equals("")==false){
			listPathAndFileName="/mall/html/"+this.lan+"/mall/mall_"+a.getDianPuId()+"/index.html";
			
		}
		
		return listPathAndFileName;
		
	}
	/**
	 * 店铺地址
	 * @param dianpuCatId
	 * @return
	 */
	public String getCat_dianPu_linkPath_html(int dianpuCatId) {
		// TODO Auto-generated method stub
		
		MallShopDianpuCatEntryService as=	MallShopDianpuCatEntryService.getInstance();
		dao.MallShopDianpuCat a=(dao.MallShopDianpuCat) as.get( dianpuCatId);
		if(a==null){
			//this.logBf.append("产品不存在"+ShopProductId);
			return "";
		}
		
		String listPathAndFileName="/mall/html/mall/mall_"+a.getDianpubId()+"/cat_"+dianpuCatId+"/index"+".html";
		if(this.lan!=null&&this.lan.equals("")==false){
			listPathAndFileName="/mall/html/"+this.lan+"/mall/mall_"+a.getDianpubId()+"/cat_"+dianpuCatId+"/index"+".html";
			
		}
		
		return listPathAndFileName;
	}

	public void setLan(String lan) {
		this.lan = lan;
	}

	public String getLan() {
		return lan;
	}
}
