package mall.kgmall.jianTai.bean;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.net.URLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Iterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import util.DaoService;

import service.entryService.MallShopDianPuEntryService;
import service.entryService.MallShopDianpuCatEntryService;
import service.entryService.MallShopProductEntryService;
import service.entryService.MallShopProductcatEntryService;

import dao.MallShopProduct;
import dao.MallShopProduct;
import dao.MallShopProductcat;
import dao.MallShopProductcat;
/**
 * 网页生成器
 * 生成静态网页 创建服务器文章ID
 * @author Administrator
 *
 */


import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class PublishJianTaiProduct {
	private String htmlStoreDir;
	private String urlHost;
	private int urlPort;
	private String urlPath;
	private String qureyString[];
	private String  fileEncode="utf-8";
	private Log log=LogFactory.getLog(PublishJianTaiProduct.class);
	private String sessionId="";
	private boolean isgetIdFromRemoteServer=false;
	private StringBuffer logBf=new StringBuffer();
	//获取网页数据授权码，位于juuluuConfig.properties publish.getDateAppURL.MemberIdPermission
	//默认值21ds5f3eas43dfw6ev4sd_juuluu_org
	private String memberIdGetDateActionPermission="21ds5f3eas43dfw6ev4sd_juuluu_org";
	public PublishJianTaiProduct(){
		
		
	}
	/**
	 * 设置网页创建器参数
	 * @param URlHost 主机地址，如localhost www.juuluu.org
	 * @param URLPort 主机地址端口
	 * @param pathGetDateURLPath 获取网页数据的相对链接 
	 * @param qureyString 链接参数值
	 * @param fileEncode 生成网页编码
	 */
	
	public void setProperty(String URlHost,int URLPort,String pathGetDateURLPath,String qureyString[],String fileEncode){
		setUrlHost(URlHost);
		setUrlPort(URLPort);
		setQueryString( qureyString);
		setUrlPath(pathGetDateURLPath);
		setFileEncode(fileEncode);
	}
	/**
	 * 由网页生成器配置，创建获取网页数据URL，
	 * 以HTTP方式获取URL数据
	 * @param URlHost 主机
	 * @param URLFile 相对路径
	 * @param URLPort 端口
	 * @return
	 */
	public URL createURL(String URlHost,String URLFile,int URLPort){
		if(URlHost==null||URlHost.equals("")){
			this.logBf.append("主机地址没设置，无法获取网页数据！");
		}
		
		URL url=null;
		 try {
			 StringBuffer urlStr=new StringBuffer();
			 urlStr.append("http://");
			 urlStr.append(URlHost);
			 urlStr.append(":");
			 urlStr.append(URLPort);
			 urlStr.append(URLFile);
			 
			 //添加获取数据授权访问用户密码
			 String memberIDPersissionGetDate="memberIdPermission="+this.memberIdGetDateActionPermission;
			 if(urlStr.indexOf("?")!=-1){
				 urlStr.append("&"+memberIDPersissionGetDate);
			 }else{
				 urlStr.append("?"+memberIDPersissionGetDate);
			 }
			 //添加会话ID；
			 if(this.sessionId!=null&&this.sessionId.equals("")==false){
				 // 是否已有参数
				 if(urlStr.indexOf("?")!=-1){
					 urlStr.append("&"+this.sessionId);
				 }else{
					 urlStr.append("?"+this.sessionId);
				 }
				
			 }
			 
			 
			url=new URL(urlStr.toString());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return url;
		
	}
	/**
	 * 店铺产品分类页
	 * @param dianpuCatId
	 */
	public void store_Prodcut_cat_htmlIndex(int dianpuCatId)throws Exception {
		// TODO Auto-generated method stub
		//获取网页数据程序相对路径
		String URLFile= getUrlPath();
		URL url=createURL(this.urlHost,URLFile, this.urlPort);
				
		MallShopDianpuCatEntryService as=	MallShopDianpuCatEntryService.getInstance();
		dao.MallShopDianpuCat a=(dao.MallShopDianpuCat) as.get( dianpuCatId);
		if(a==null){
			//this.logBf.append("产品不存在"+ShopProductId);
			return ;
		}
		
		//文章静态相对路径
		ShopHtmlPathBean htmlPathBean=new ShopHtmlPathBean();
		String PathAndFileNameSd=htmlPathBean.getCat_dianPu_linkPath_html(dianpuCatId);
	
		createHtml( url,PathAndFileNameSd,getFileEncode());
	}


	/**
	 * 生成店铺页
	 * @param dianPuId
	 * @throws Exception
	 */
	public void createDianPu(int dianPuId)
	throws Exception{
		//获取网页数据程序相对路径
		String URLFile= getUrlPath();
		URL url=createURL(this.urlHost,URLFile, this.urlPort);
				
		MallShopDianPuEntryService as=	MallShopDianPuEntryService.getInstance();
		dao.MallShopDianPu a=(dao.MallShopDianPu) as.get( dianPuId);
		if(a==null){
			//this.logBf.append("产品不存在"+ShopProductId);
			return ;
		}
		
		//文章静态相对路径
		ShopHtmlPathBean htmlPathBean=new ShopHtmlPathBean();
		String PathAndFileNameSd=htmlPathBean.getDianPuLinkPath(dianPuId);
	
		createHtml( url,PathAndFileNameSd,getFileEncode());
	}
	
	
	/**
	 * 生成静态网页
	 * @param ShopProductId
	 * @throws Exception
	 */
	public void createShopProductHtml(long ShopProductId)
	throws Exception{
		//获取网页数据程序相对路径
		String URLFile= getUrlPath();
		URL url=createURL(this.urlHost,URLFile, this.urlPort);
				
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		dao.MallShopProduct a=(MallShopProduct) as.get( ShopProductId);
		if(a==null){
			this.logBf.append("产品不存在"+ShopProductId);
			return ;
		}
		if(a.getBhtml()!=null&&a.getBhtml()==false){
			//不生成静态
			a.setBhtml(true);
			as.merge(a);
		}
		//文章静态相对路径
		ShopHtmlPathBean htmlPathBean=new ShopHtmlPathBean();
		String PathAndFileNameSd=htmlPathBean.getProductPageHtmlPath(ShopProductId);
	
		createHtml( url,PathAndFileNameSd,getFileEncode());
	}
	
	public void createShopProductHtmlBySite()
	throws Exception{
		DaoService.getIntrance();
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		List<MallShopProduct> al=as.getListAll();
		Iterator<MallShopProduct> ia=al.iterator();
		while(ia.hasNext()){
			long aid=ia.next().getId();
			createShopProductHtml(aid);
			this.logBf.append("########/n########");
			this.logBf.append("create html sucess, ShopProduct id= "+aid);
			this.logBf.append("########/n########");
		}
	}
	

	
	public void createShopProductListHtmlBySite()
	throws Exception{
		DaoService ds=DaoService.getIntrance();
		MallShopProductEntryService as=MallShopProductEntryService.getInstance();
		service.entryService.MallShopProductcatEntryService chb=service.entryService.MallShopProductcatEntryService.getInstance();
		/**
		
		List chl=chb.getListAll();
		Iterator   ich=chl.iterator();
		
		
		while(ich.hasNext()){
			dao.MallShopProductcat ch=(ShopProductcat) ich.next();
			//ShopProductcat dir
			String ShopProductcatDir=ch.getShopProductcatdir();
				//获取全部栏目
			
			this.logBf.append("this ShopProductcat list,已生成.");
		}
		
		**/
		service.entryService.MallShopProductcatEntryService catb=service.entryService.MallShopProductcatEntryService.getInstance();
		
		
		List<dao.MallShopProductcat> catl=catb.getListAll();
		Iterator<dao.MallShopProductcat> icat=catl.iterator();
		while(icat.hasNext()){
			dao.MallShopProductcat cat=icat.next();
			//cat id 
			int catid=cat.getCatId();
			artilceLIstCreateByCatId(catid);
			this.logBf.append("this ShopProductcat ,已生成.");
		}
		this.logBf.append("all ShopProductcat list ,已生成.");
	}
	public void artilceLIstCreateByCatId(int catid){
		dao.MallShopProductcat cat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
		.get(catid);
		
		if(cat==null){
			this.logBf.append("栏目不存在，无法创建该栏目静态页:"+catid);
			return ;
		}else{
			catProductLIstCreateByCatId(cat);
		}
		
		
	}
	/**
	 * 根据目录生成产品静态列表页
	 * @param icat
	 */
	public void catProductLIstCreateByCatId(dao.MallShopProductcat icat){
		if(icat==null){
			this.logBf.append("栏目不存在，无法创建该栏目静态页");
			return ;
		}
		
		int ShopProductcatidROOT=0;
		//是否一级栏目
		if(icat.getBroot()!=null&&icat.getBroot()){
			ShopProductcatidROOT=	icat.getCatId();
		}else{
			if(icat.getRootCatId()==null){
				if(icat.getRootCatId()==null){
					this.logBf.append("子栏目未设置一级目录，无法创建静态页,ID:"+icat.getCatId()+" 错误栏目："+icat.getName());
					return ;
				}
			}
			ShopProductcatidROOT=icat.getRootCatId();
		}
		//该栏目的获取一级栏目
		dao.MallShopProductcat chRootCat=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatidROOT);
	
		//ShopProductcat dir
		String ShopProductcatRootDir=chRootCat.getEnglishCharname();
		
		
	//	ShopProductEntryService as=ShopProductEntryService.getInstance();
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		List<MallShopProduct> ShopProductList=as.getListShopProductcatId(icat.getCatId());
		Iterator<MallShopProduct> ia=ShopProductList.iterator();
		java.util.ArrayList<dao.MallShopProduct> al=new java.util.ArrayList<dao.MallShopProduct>();
		while(ia.hasNext()){
			dao.MallShopProduct a=ia.next();
		//	a.setShopProductid(ia.next());
			al.add(a);
		}
		
		util.ObjectMorePageView more=new util.ObjectMorePageView();
		more.setobjectList(al);
		
		int pageCount =more.getPageTotal();
		this.logBf.append("文章数："+al.size()+"共页数："+pageCount);
		if(al.size()==0){
			this.logBf.append("文章数为0,无法创建栏目页！");
		}
		for(int pageid=1;pageid<=pageCount;pageid++){
			try {
				createShopProductListHtmlOfPage( icat.getCatId(),  pageid);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	public void catIndexHtml(int catid){
		int pageid=1;
		dao.MallShopProductcat icat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
		.get(catid);
	
		 try {
			createShopProductListHtmlOfPage( catid,  pageid);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	/**
	 * 根据栏目ID，分页ID，创建静态分页
	 * @param catid
	 * @param pageid
	 * @param ShopProductcatDir
	 * @throws Exception
	 */
	public void createShopProductListHtmlOfPage(int catid, int pageid)
	throws Exception{

		ShopHtmlPathBean pathShopBean=new ShopHtmlPathBean();
		String listPathAndFileName=pathShopBean.getCatHtmlPathByCatIDPageId(catid, pageid);
		
		
		
		//组建完整网址
		String URLFile= createShopProductListURLFile(catid,pageid, getUrlPath());
		this.logBf.append("创建栏目页，模板："+URLFile);
		//生成获取数据网址，并追回授权码
		URL url=createURL(urlHost,URLFile, urlPort);
		DaoService.getIntrance();
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		
		dao.MallShopProductcat cat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance().get(catid);
		
		
		short catPageidFirst=1;
		if(pageid!=1){
			
			createHtml( url,listPathAndFileName,getFileEncode());
		}else if(pageid==catPageidFirst){
			//创建第一页
			createHtml( url,listPathAndFileName,getFileEncode());
			
			//第一页作为栏目首页
				String catPathAndFileName=pathShopBean.getCatIndexHtmlPathByCatIDPageId(catid);
				if(catPathAndFileName.equals("")!=true){
					createHtml( url,catPathAndFileName,getFileEncode());
					createHtml( url,listPathAndFileName,getFileEncode());
				}
				}
		
		
	}
	//生成获取数据程序路径
	/**
	 * /mall/action/ShopJinTaiTempleteViewActlion.do?method=cat&catId&pageId=1
	 */
	public String createShopProductListURLFile(int catid, int pageid,String path){
		String s=path+"&"+ "pageId="+pageid+"&"+"catId="+catid;
		return s;
	}

	
	public void rootCatIndexHtmlCreate(short ShopProductcatid)
	throws Exception{
		String URLFile=  getUrlPath()+ getQueryString()[0]+ShopProductcatid;
		URL url=createURL(urlHost,URLFile, urlPort);
		DaoService.getIntrance();
		
		
			//相对保存路径和文件名
		dao.MallShopProductcat ch=(MallShopProductcat)MallShopProductcatEntryService.getInstance().get(ShopProductcatid);
		
		
		
		String PathAndFileName="/mall/html/"+ch.getEnglishCharname()+"/index.html";
		
		
		
		if(PathAndFileName.equals("")!=true){
			createHtml( url,PathAndFileName,getFileEncode());
			
		}
		
	}
	
	
	/**
	 * 生成网页，
	 * @param savePathAndFileName 网页保存文件名及路径
	 * @throws Exception
	 */
	public void commentHtmlCreate(String savePathAndFileName)
	throws Exception{
		String URLFile=  getUrlPath();
		//根据网页生成器配置，创建目标网页访问URL，准备通过HTTP方式获取数据
		URL url=createURL(urlHost,URLFile, urlPort);
		//DaoService.getIntrance();		
		if(savePathAndFileName.equals("")!=true){
			//由URL，编码，保存地址等信息，生成静态网页
			createHtml( url,savePathAndFileName,getFileEncode());			
		}	
	}
	

	
	
	public void createHtml(URL url,String PathAndFileName,String encode)
	throws Exception{
this.logBf.append("生成文章,模板："+url.getProtocol()+"://"+url.getHost()+":"+url.getPort()+url.getPath()+"?"+url.getQuery());
		   try {
				InputStream in;
			// url=new URL("http://localhost:8080<bean:write name="SystemConfigApp" property="appContext"/>/watchAritcleAction.do?ShopProductId=3");
			
			 URLConnection cnn= url.openConnection();
			 HttpURLConnection httpurlc= (HttpURLConnection)cnn;
			 httpurlc.setRequestMethod("POST"); 
			 //设置会话ID
			 httpurlc.setRequestProperty("Cookie", sessionId); 

			 httpurlc.connect();
			 //;jsessionid=
			 //httpurlc.getHeaderField(name)
			 
			  String cookieValue=httpurlc.getHeaderField("Set-Cookie"); 
			  if(cookieValue!=null){
				  this.logBf.append("cookie value:"+cookieValue); 
		            String sessionId=cookieValue.substring(0, cookieValue.indexOf(";")); 
		            this.logBf.append("sessionId:"+sessionId);
		           // return sessionId; 
		            //判断sessionid是否相等
		            if(this.sessionId.equals(sessionId)==false){
		            	this.sessionId=sessionId;
		            	this.logBf.append("获取会话ID:"+this.sessionId);
		            }
			  }else{
				  this.logBf.append("无法获取会话ID:"+this.sessionId);
			  }
            

			 //处理异常
			 int error;
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_OK){
				 this.logBf.append("get url resource sucess.");
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_ENTITY_TOO_LARGE){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("HTTP_ENTITY_TOO_LARGE."+httpurlc.getResponseMessage());
				 return ;//返回,处理下一文章
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_CLIENT_TIMEOUT){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("CLIENT_TIMEOUT."+httpurlc.getResponseMessage());
				 return ;
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_NOT_FOUND){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				 this.logBf.append("NOT_FOUND."+httpurlc.getResponseMessage());
				 
				 return ;
			 }
			 if(httpurlc.getResponseCode()==HttpURLConnection.HTTP_INTERNAL_ERROR){
				 log.error(httpurlc.getURL().getFile()+httpurlc.getURL().getHost());
				 log.error(httpurlc.getResponseMessage());
				
				 this.logBf.append("服务器错误，内存溢出，或文章不存在；server error. may be file not exits.HTTP_INTERNAL_ERROR."+httpurlc.getResponseMessage());
				 
				 return ;
			 }
			 // httpurlc.setConnectTimeout(3000);
				
			 //ystem.out.println(httpurlc.getReadTimeout());
			// this.logBf.append(httpurlc.getReadTimeout());
			 
			 //this.logBf.append();
		//	this.logBf.append(httpurlc.getResponseMessage());
			
			// this.logBf.append("rulc encode:"+cnn.getContentEncoding());
			// this.logBf.append("rulc ContentTyp:"+cnn.getContentType());
			// this.logBf.append("rulc Properties:"+cnn.getRequestProperties());
		//	 this.logBf.append("rulc lenght:"+cnn.getContentLength());

			 
			 
			 in =  cnn.getInputStream();
			 
		//	 this.logBf.append(url.getContent());
		//	 this.logBf.append(url.getFile());
			// this.logBf.append(url.getHost());
			// this.logBf.append(url.getPath());
			// this.logBf.append(url.getQuery());
			// this.logBf.append(url.getHost());
			// this.logBf.append(url.getProtocol());
			 if(htmlStoreDir==null){
				 throw new Exception("palease set htmlStoreDir");
			 }
			 String file;
			 if(PathAndFileName.indexOf("/")==0){
				 file=htmlStoreDir+PathAndFileName;
					
			 }else{
				 file=htmlStoreDir+"/"+PathAndFileName;
					
			 }
				this.logBf.append("保存路径："+file);
			 
			 File f=new File(file);
			 String dirs=f.getPath();
			 File d=new File(dirs);
			 if(d.exists()==false){
				 d.mkdirs();
			 }
			 if(f.exists()){
				 f.delete();
				 f.createNewFile();
				 if(f.isDirectory()){
					 f.delete();
					 f.createNewFile();
			       }
				
			 }else{
				 f.createNewFile();
				 if(f.isDirectory()){
					 f.delete();
					 f.createNewFile();
				 }
			 }
			 
			 this.logBf.append("保存文章:"+f.getPath());
			// this.logBf.append("Parent:"+f.getParent());
			// this.logBf.append("exite:"+f.exists());
			
			 OutputStream out=new FileOutputStream(f);
			 
			 InputStreamReader inr=new InputStreamReader(in,encode );
			 
			 OutputStreamWriter outs=new OutputStreamWriter(out,encode);
			
			
			//this.logBf.append("encode:"+inr.getEncoding());
			 
			 char[] b = new char[2048];
			  String k="";
			  BufferedReader br=new BufferedReader(inr);
			  BufferedWriter bw=new BufferedWriter(outs);
			  StringBuffer bf=new StringBuffer();
			  int i=0;
			  while(k!=null){
				  k=br.readLine();
				  if(k!=null){
					  bf.append(k);
					  bf.append("\n");
				  }
				 
				 // this.logBf.append(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>"+ ++i);
				 
			  } //this.logBf.append(bf.toString());
			 
			  bw.flush();
			  bw.write(bf.toString());
			  
			  
				br.close();
				bw.close();
			in.close();
			out.close();
		
			httpurlc.disconnect();
			  /*
			while(in.read()!=-1){
				in.read(b);
				for(int i=0;i<b.length;i++){
					this.logBf.append(b[i]);
				}
				
			}
				
		*/
				
		   } catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			   this.logBf.append("生成静态失败，无法获取网站内容。");
			e.printStackTrace();
		}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
			
			

	}
	
	//public 

	/**
	 * @param args
	 */
	public void setHtmlStoreDir(String htmlStoreDir) {
		this.htmlStoreDir = htmlStoreDir;
	}

	public String getHtmlStoreDir() {
		return htmlStoreDir;
	}
	


	public void setUrlPath(String urlPath) {
		this.urlPath = urlPath;
	}
	public String getUrlPath() {
		return urlPath;
	}
	public void setQueryString(String qureyString[]) {
		this.qureyString = qureyString;
	}

	public String[] getQueryString() {
		return qureyString;
	}
	public void setUrlHost(String urlHost) {
		this.urlHost = urlHost;
	}
	public String getUrlHost() {
		return urlHost;
	}
	public void setUrlPort(int urlPort) {
		this.urlPort = urlPort;
	}
	public int getUrlPort() {
		return urlPort;
	}
	public void setFileEncode(String fileEncode) {
		this.fileEncode = fileEncode;
	}
	public String getFileEncode() {
		return fileEncode;
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub
	PublishJianTaiProduct p=new PublishJianTaiProduct();
	p.setHtmlStoreDir("html");
	//String query[]={"pageId=","ShopProductcatId="};
	String query[]={"objectId="};
	//p.setProperty("localhost", 8080, "/watchAritcleAction.do", query, "utf-8");
	p.setProperty("localhost", 8080, "/action/daoAction/ShopProductAction.do?method=readView&forward=update&type=int&", query, "utf-8");
	try{
		short s=122;
		//p.createShopProductListHtmlOfPage(s, 2, "jiancai");
	//	p.createShopProductListHtmlBySite();
		p.createShopProductHtml(2);
	//	p.createShopProductHtmlBySite();
	}catch(Exception e){
		e.printStackTrace();
	}
	}


	public void setIsgetIdFromRemoteServer(boolean isgetIdFromRemoteServer) {
		this.isgetIdFromRemoteServer = isgetIdFromRemoteServer;
	}

	public boolean isIsgetIdFromRemoteServer() {
		return isgetIdFromRemoteServer;
	}
	public void setMemberIdGetDateActionPermission(
			String memberIdGetDateActionPermission) {
		this.memberIdGetDateActionPermission = memberIdGetDateActionPermission;
	}
	public String getMemberIdGetDateActionPermission() {
		return memberIdGetDateActionPermission;
	}
	public void setLogBf(StringBuffer logBf) {
		this.logBf = logBf;
	}
	public StringBuffer getLogBf() {
		return logBf;
	}
	

}
