package mall.kgmall.html.action;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import mall.kgmall.jianTai.lan.bean.DianPuViewUtil;
import mall.serviceBean.ShopBean;
import mall.viewBean.ProductIndexBean;
import mall.viewBean.ShopPageMenuHtmlCreateBean_Lan;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

import service.entryService.MallShopProductEntryService;
import util.DaoService;

import dao.MallShopDianPu;
import dao.MallShopDianpuCat;
import mall.jianTai.bean.PublishConfig;

/**
 * 店铺模板预览
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class DianPuHtmlTempYiLangAction extends DispatchAction {
	public  ActionForward admin(ActionMapping mapping, ActionForm form,


			HttpServletRequest request, HttpServletResponse response)


			throws IOException, ServletException{
		//方法授权访问列表
		String []  userVisitMethonYesList={"complee","superAdmin"};
		//获取用户所在权限组，测试是否授权该用户访问该方法
		util.UserActionChecker checkBean=util.UserActionChecker.getInstance();
		ActionForward errorCheckAction=checkBean.methodCheckUserGrounpPermission(request, userVisitMethonYesList);
		if(errorCheckAction!=null){
			return errorCheckAction;
		}
		
		//生成授权码
		//获取网页生成器配置的授权码
		PublishConfig cmsHTMLConfig=PublishConfig.getInstance();
		String memberIDConfigCreator=	cmsHTMLConfig.getMemberIdPermissionHtmlCreateGetDataApp();
	    request.setAttribute("memberIdPermission",	memberIDConfigCreator);
		
	    
		//设置语言版本
		String lan="";
		if(request.getParameter("lan")!=null){
			lan=request.getParameter("lan");
			request.getSession().setAttribute("lan", lan);
		}
		//选择店铺
		selectDianPu(request);
		//选择店铺产品分类
		selectDianPuCat(request);
	    
		loadDianPu_Data_Base_kgmall_html(lan,request);
		String target="dianPuTempleteViewAdminjsp";	
		return mapping.findForward(target);
}
	//选择店铺
	public void selectDianPu(	HttpServletRequest request){
			if(request.getParameter("did")!=null){
				int did=Integer.parseInt(request.getParameter("did"));
		
			dao.MallShopDianPu dp=(MallShopDianPu) service.entryService.MallShopDianPuEntryService.getInstance()
			.get(did);
			request.getSession().setAttribute("ShopDianPuSelectTmp", dp);
				List<dao.MallShopDianpuCat> cl=service.entryService.MallShopDianpuCatEntryService.getInstance()
				.getListByDianpuId(did);
				request.getSession().setAttribute("ShopDianpuCatList", cl);
				
			}
	}
	//选择店铺分类
	public void selectDianPuCat(HttpServletRequest request){
		if(request.getParameter("catId")!=null){
			int catid=Integer.parseInt(request.getParameter("catId"));
			dao.MallShopDianpuCat cat=(MallShopDianpuCat) service.entryService.MallShopDianpuCatEntryService.getInstance()
			.get(catid);
			request.setAttribute("ShopDianpuCatSelectTmp", cat);
			//产品列表
			List<dao.MallShopProduct> pl=service.entryService.MallShopProductEntryService.getInstance()
			.getLIstByDpCatId_DianPu(catid);
			request.setAttribute("ShopProductList", pl);
			
		}
			
	}
	//加载店铺资料
	public void loadDianPu_Data_Base_kgmall_html(String lan,HttpServletRequest request){
		//店铺显示数据处理类
		DianPuViewUtil dputil=new DianPuViewUtil();
		dputil.setLan(lan);
		//最新加盟店铺整站
		int max=5;
		service.entryService.MallShopDianPuEntryService dpbean=service.entryService.MallShopDianPuEntryService.getInstance();
		List<dao.MallShopDianPu> newlist=dpbean.getNewListIndex(max);
		List<mall.viewBean.DianPuViewBean> newListViewIndex=dputil.getDianPuListViewBean_htmlPath(newlist);
		request.setAttribute("NewIndexShopDianPuList", newListViewIndex);
		
		//热门店铺整站
		List<dao.MallShopDianPu> hostlist=dpbean.getHostListIndex(max);
		List<mall.viewBean.DianPuViewBean> hostlistViewIndex=dputil.getDianPuListViewBean_htmlPath(hostlist);
		request.setAttribute("HostIndexShopDianPuList", hostlistViewIndex);
		
		
		//店铺推荐整站
		List<dao.MallShopDianPu> commandlist=dpbean.getCommnadListIndex(max);
		List<mall.viewBean.DianPuViewBean> commandlistViewIndex=dputil.getDianPuListViewBean_htmlPath(commandlist);
		request.setAttribute("CommandIndexShopDianPuList", commandlistViewIndex);
		
	
	}
	//设置生成语言
	public ActionForward setLan(ActionMapping mapping,
			ActionForm form, 
			HttpServletRequest request, 
			HttpServletResponse response)
			throws IOException, ServletException {
		String lan=request.getParameter("lan");
		request.getSession().setAttribute("lan", lan);
		ActionForward action=new ActionForward();
		action.setRedirect(false);
		request.setAttribute("info","设置语言成功："+lan);
		action.setPath("/mall/kgmall/html/action/DianPuHtmlTempYiLangAction.do?method=admin");
		return action;
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
