package mall.kgmall.config;

import javax.servlet.http.HttpServletRequest;

import service.entryService.MallShopConfigEntryService;


import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;

/** 平台默认支持币种及语言，国家等 
 * <p>
<span class="formElementLable">默认交易货币:</span>
<bean:write name="MallShopConfig" property="defaultFouBi" />

<select name="defaultFouBiNew">
<option vlaue="CNY">人民币</option>
<option vlaue="USD">美元</option>
<option vlaue="EUR">欧元</option>
</select>
</p>

<p>
<span class="formElementLable">系统默认语言:</span>
<bean:write name="MallShopConfig" property="defaultLanguage" />
<select name="defaultLanguageNew">
<option vlaue="中文简体">中文简体</option>
<option vlaue="中文繁体">中文繁体</option>
<option vlaue="English">英文</option>
</select>
</p>
 */
public class MallConfigUtil {
	
	
	public static final String C_Money_CNY="CNY";
	public static final String C_Money_USD="USD";
	public static final String C_Money_EUR="EUR";
	
	
	public static final String C_Lan_Zh_CN="中文简体";
	public static final String C_Lan_Zh_Big="中文繁体";
	public static final String C_Lan_Zh_En="English";
	
	//店铺业务类型
	
	public static final String ServiceType_B2B="B2B";
	public static final String ServiceType_C2C="C2C";
	public static final String ServiceType_B2B2C="B2B2C";
	public static final String ServiceType_O2O="O2O";
	public static final String ServiceType_ShopinShop="ShopinShop";
	
	//生成静态类型
	/*
	 * <select name="createHtmlTypeNew">
<option value="no" selected="selected">保留原值</option>
<option value="no">默认，纯动态</option>
<option value="mix">混合动静态</option>
<option value="ApacheUrlRewrite">Apache Url重写伪静态</option>
<option value="JavaUrlRewrite">Java Url重写伪静态</option>
<option value="AllHTML">HTML商城整体静态</option>
</select>
	 */
	
	public static final String HtmlType_no="no";
	public static final String Htmlype_mix="mix";
	public static final String HtmlType_ApacheUrlRewrite="ApacheUrlRewrite";
	public static final String HtmlType_JavaUrlRewrite="JavaUrlRewrite";
	public static final String HtmlType_AllHTML="AllHTML";
	
public dao.MallShopConfig getDefaultMallConfig(){
	

	

	
	MallShopConfigEntryService mb= MallShopConfigEntryService.getInstance()
			;
	//shopConfigBase
	
	String shopConfigBase="shopConfigBase";
	dao.MallShopConfig  c=	 mb.getShopConfigByName(shopConfigBase);
		if(c==null){
			c=new 	dao.MallShopConfig();
			c.setConfigName("shopConfigBase");
			c.setDefaultLanguage("zh_cn");
			c.setDefaultFouBi("RMB");
			c.setList_product_colsCount(5);
			c.setList_product_smallLenght(255);
			c.setList_product_titleLenght(255);
			c.setListPageRecordeCout(20);
			c.setShopIndexDescription("kgmall c2c");
			c.setShopIndexTitle("kgmall c2c");
			c.setShopIndexKeyWord("kgmall c2c");
			 c=	 mb.getShopConfigByName(shopConfigBase);
		}
	return c;
}

/*
public dao.MallShopConfig getDefaultConfigByName(){
	
	
	MallShopConfigEntryService mb= MallShopConfigEntryService.getInstance();

	String shopConfigBase="shopConfigBase";
	dao.MallShopConfig  c=	 mb.getShopConfigByName(shopConfigBase);
		if(c==null){
			c=new 	dao.MallShopConfig();
			c.setConfigName("shopConfigBase");
			c.setDefaultLanguage("zh_cn");
			c.setDefaultFouBi("RMB");
			c.setList_product_colsCount(5);
			c.setList_product_smallLenght(255);
			c.setList_product_titleLenght(255);
			c.setListPageRecordeCout(20);
			c.setShopIndexDescription("kgmall c2c");
			c.setShopIndexTitle("kgmall c2c");
			c.setShopIndexKeyWord("kgmall c2c");
			 c=	 mb.getShopConfigByName(shopConfigBase);
		}
	return c;
}
*/

//获取商城平台配置标签，用于前台显示 
/*
 * jsp Code:
 <%
 mall.kgmall.config.MallConfigUtil mcu=new mall.kgmall.config.MallConfigUtil.MallConfigUtil();
 mcu.loadMallConfigTagData(request);
  dao.MallShopConfig c= ( dao.MallShopConfig )request.getAttribute("MallShopConfigDefault");
  %>
 */
public void loadMallConfigTagData(HttpServletRequest request){
	 dao.MallShopConfig c=getDefaultMallConfig();
	 request.setAttribute("MallShopConfigDefault", c);
}

//将配置保存到上下文件
public  dao.MallShopConfig  loadMallConfigTagDataInApplication(HttpServletRequest request){
	 dao.MallShopConfig c=getDefaultMallConfig();
	 
	 if(request.getSession().getServletContext().getAttribute("MallShopConfigApplication")==null){
		 request.getSession().getServletContext().setAttribute("MallShopConfigApplication", c);
		 return c;
	 }else{
		 return ( dao.MallShopConfig )request.getSession().getServletContext().getAttribute("MallShopConfigApplication");
	 }
	
}


//将配置保存到上下文件
public  dao.MallShopConfig  flushMallConfigTagDataInApplication(HttpServletRequest request){
	 dao.MallShopConfig c=getDefaultMallConfig();
	 
	
		 request.getSession().getServletContext().setAttribute("MallShopConfigApplication", c);
		 return c;
	
	
}

}
