package mall.kgmall.buyer.bean;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import mall.action.ShopCart;


/**
 * 商城订单管理
 * @author Administrator
 *
 */
import dao.MallShopOrder;
import dao.MallShopOrderitem;
import dao.MallShopProduct;

/**
 * 处理用户会话中的商城各类变量数据，购物车，订单，
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class ShopOrderManage {
	private static ShopOrderManage instance;
	private String userOrderSessionName="MyOrder";
	private service.entryService.MallShopOrderitemEntryService itembean=	service.entryService.MallShopOrderitemEntryService.getInstance();

private service.entryService.MallShopOrderEntryService orderBean=	service.entryService.MallShopOrderEntryService.getInstance();
	//创建订单
private String myshopCartName="MyShopCatrt";
private ShopOrderManage(){
	
}


public ShopCart getOrInitMyShopCart(HttpServletRequest request){
	
return 	createMyShopCart(request);
}
public ShopCart createMyShopCart(HttpServletRequest request){
	
	ShopCart cart= (ShopCart) request.getSession(true).getAttribute(this.myshopCartName);
		if(cart==null){
			cart=new ShopCart();
			
			 request.getSession(true).setAttribute(this.myshopCartName,cart);
				
		}
	return cart;
}

//创建产品订单
/**
 * 一个订单绑定一个卖家，会员不能在一个订单中订购两个卖家产品
 */
public MallShopOrder create(HttpServletRequest request,dao.MallShopProduct productOrderCurrent,MallShopOrder order){
		if(productOrderCurrent==null){
			return null;
		}
		MallShopOrder osession=(MallShopOrder) request.getSession(true).getAttribute(this.userOrderSessionName);
		//创建订单
		if(osession==null){
			
			///创建订单ID
		java.text.SimpleDateFormat ft=new java.text.SimpleDateFormat("yyMMddhhss");
		String timeStr=	ft.format(new java.util.Date(System.currentTimeMillis()));
		int r=(int)(Math.random()*1000);
		//商城会员
		dao.MallShopUser userShop=mall.validaty.SessionValidaty.getInstance().getMallShopUserSession(request);
		
		//卖家信息
		long SalerUserId=productOrderCurrent.getDianpuUserId();
		String orderID="u"+userShop.getId()+"s"+SalerUserId+"t"+timeStr;
		order.setOrderID(orderID);
		order.setDianpuId(productOrderCurrent.getDianpuId().intValue());
		order.setDianPuName(productOrderCurrent.getDianpuName());
		order.setDianpuUserId(SalerUserId);
		order.setDianpuUserName(productOrderCurrent.getDianpuUserName());
		order.setOderTime(new Date(System.currentTimeMillis()));
		
		//订购用户
		order.setUserId(userShop.getId());
		//由表单设置
		//order.setOrderUserName(userShop.getUserName());
		
		//设置发货状态
		 order.setSendState(mall.kgmall.system.SystemValidatyApp.Order_send_waitingShip);
		 order.setBsendProduct(false);
		 
		
		
		//订购店铺
		//卖家
		
		//保存
		MallShopOrder saved=	this.orderBean.checkSaveOrder(order);
		
		 request.getSession(true).setAttribute(this.userOrderSessionName,saved);
		 System.out.println("创建会话订单：" +orderID);
		
		 if(saved==null){
			System.out.println("保存失败，订单格式错误！");
			return null;
		}else{
			System.out.println("创建订单成功！");
			osession=saved;
			
			//将订单添加到购物车
			
			 ShopCart cart= getOrInitMyShopCart(request);
			 cart.setMyOrder(osession);
		}
		 
		 
		return osession;
		
		//订单已存在
		}else{
			System.out.println("会话中已存在用户订单，返回默认订单");
			return osession;
		}

	}

/**
 * 重新创建订单，用于买家已订购一店铺产品，同时订购另一店铺产品情况
 * @param request
 * @param productOrderCurrent
 * @param order
 * @return
 */
public MallShopOrder reCreateSessionOrder(HttpServletRequest request,dao.MallShopProduct productOrderCurrent,MallShopOrder order){
	
	MallShopOrder osession=(MallShopOrder) request.getSession(true).getAttribute(this.userOrderSessionName);
	//创建订单
		
		///创建订单ID
	java.text.SimpleDateFormat ft=new java.text.SimpleDateFormat("yyMMddhhss");
	String timeStr=	ft.format(new java.util.Date(System.currentTimeMillis()));
	int r=(int)(Math.random()*1000);
	//商城会员
	dao.MallShopUser userShop=mall.validaty.SessionValidaty.getInstance().getMallShopUserSession(request);
	
	//卖家信息
	long SalerUserId=productOrderCurrent.getDianpuUserId();
	String orderID="u"+userShop.getId()+"s"+SalerUserId+"t"+timeStr;
	order.setOrderID(orderID);
	order.setDianpuId(productOrderCurrent.getDianpuId().intValue());
	order.setDianPuName(productOrderCurrent.getDianpuName());
	order.setDianpuUserId(SalerUserId);
	order.setDianpuUserName(productOrderCurrent.getDianpuUserName());
	
	
	//订购用户
	order.setUserId(userShop.getId());
	//由表单设置
	//order.setOrderUserName(userShop.getUserName());
	
	//将原订单总价等信息清零
	order.setTotalPrice(0.0);
	order.setPayed(false);
	order.setOderTime(new Date(System.currentTimeMillis()));
	//订购店铺
	//卖家
	
	//保存
	MallShopOrder saved=	this.orderBean.checkSaveOrder(order);
	
	 request.getSession(true).setAttribute(this.userOrderSessionName,saved);
	 System.out.println("创建会话订单：" +orderID);
	
	 if(saved==null){
		System.out.println("保存失败，订单格式错误！");
		return null;
	}else{
		System.out.println("创建订单成功！");
		osession=saved;
		
		//将订单添加到购物车
		
		 ShopCart cart= getOrInitMyShopCart(request);
		 cart.setMyOrder(osession);
	}
	return osession;
	
	//订单已存在
	

}

public List<dao.MallShopOrderitem> getOrderItemListByOrderId(long orderId){
	return this.itembean.getListShopOrderId(orderId);
}

//添加订购产品到购物车
/**
 * 订单项（产品）只可添加到同一卖家的订单中，
 * 如果是订购另一卖家的产品，则要重新创建订单。
 * 
 */
public void addOrderItemToOrder(HttpServletRequest request,MallShopOrder savedOrder,dao.MallShopOrderitem  item){
	//获取产品
	dao.MallShopProduct product=(MallShopProduct) service.entryService.MallShopProductEntryService.getInstance()
	.get(item.getProductId());
	
	//判断是否同一卖家
	Long salerId=savedOrder.getDianpuUserId();
	//不是同一卖家产品，重设购物车及当前订单
	if(salerId.equals(product.getDianpuUserId())==false){
		System.out.println("卖家已变更，重新创建订单；Change Order,You Order Anther Saler`s Product!");
		savedOrder= 	reCreateSessionOrder(request,product,savedOrder);
	}
	
	//添加产品名到订单产品列表中
	//savedOrder.set
	
item.setOrderid(savedOrder.getId());
item.setBpay(false);
	//计算订单总价格
Double priceOrder=	savedOrder.getTotalPrice();
if(priceOrder==null){
	priceOrder=0.0;
}
//获取订单项的数量及订单项总价
priceOrder=priceOrder+item.getItemTotalPrice();

savedOrder.setTotalPrice(priceOrder);

//设置订单的产品名列表
setOrderProductListName(savedOrder,item.getProductName());

this.orderBean.merge(savedOrder);
//保存订购产品
itembean.merge(item);
	//将订单项添加到汇总订单

//更购物车产品清单
ShopCart cart= getOrInitMyShopCart(request);
List<dao.MallShopOrderitem> orderItemList=getOrderItemListByOrderId(savedOrder.getId());
cart.setOrderItemList(orderItemList);

}

//设置订单产品名列表 订购套餐时，为套餐名+产品名
public void setOrderProductListName(MallShopOrder savedOrder,String pName){
	String nameList=savedOrder.getOrderProductNameList();

	if(nameList==null){
		nameList="";
	}
	if(nameList.indexOf(pName)!=-1){
		//已存在
	}else{
		nameList=nameList+" "+pName;
	}
	//是否超出长度
	if(nameList.length()>255){
		nameList=nameList.substring(0, 254);
	}
	
	savedOrder.setOrderProductNameList(nameList);
	//判断是否已存在
	
}
//根据订购的产品创建订单项
public dao.MallShopOrderitem createOrderItem( dao.MallShopProduct product, int count){
	//创建订单项
	MallShopOrderitem i=new MallShopOrderitem();
	i.setBpay(false);
	Double price_per=product.getPrice();
	i.setPrice(price_per);
	
	//默认为一件
	i.setOrderCount(count);
	
	//计算数量及总价
	Double totalPrice=price_per*count;	
	i.setItemTotalPrice(totalPrice);	
	float zk=(float) 1.0;
	i.setZhekuPerProucu(zk);
	i.setProductId(product.getId());
	i.setProductName(product.getName());
	
	return i;

}
//根据订购套餐创建订单项

public dao.MallShopOrderitem  createOrderItem(dao.MallShopProductSuit suite){
	//获取产品
	dao.MallShopProduct product=(MallShopProduct) service.entryService.MallShopProductEntryService.getInstance()
	.get(suite.getProductId());
	//订购套餐时，产品名为套餐名
	String ItemName=suite.getProductName()+":"+product.getName();
	
	//创建订单项
	MallShopOrderitem i=new MallShopOrderitem();
	i.setProductName(ItemName);
	//i.set
	i.setBpay(false);
	//总价
	i.setItemTotalPrice(suite.getPrice());
	//单价
	Double price_per=product.getPrice();
	i.setPrice(price_per);
	//默认套餐订购数
	i.setOrderCount(suite.getProductCount());
	i.setProductId(suite.getProductId());
	
	i.setZhekuPerProucu(suite.getZeKou());
	
	
	
	
	return i;
}
	//获取会话订单
public MallShopOrder getMyOrderAtSession(HttpServletRequest request){
	MallShopOrder o=(MallShopOrder) request.getSession(true).getAttribute(this.userOrderSessionName);
	//创建订单
	if(o==null){
		
			return null;
	}else{
		 System.out.println("获取会话订单：" +o.getOrderID());
		return o;
	}

}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}
	public void setUserOrderSessionName(String userOrderSessionName) {
		this.userOrderSessionName = userOrderSessionName;
	}
	public String getUserOrderSessionName() {
		return userOrderSessionName;
	}



	public static ShopOrderManage getInstance() {
		if(instance==null){
			instance=new ShopOrderManage();
		}
		return instance;
	}

}
