package mall.kgmall.buyer.action;


import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import mall.kgmall.buyer.bean.QuanXangByShopUser;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.juuluu.pay.paypal.PaypalCheckOutBean;

import com.paypal.sdk.profiles.APIProfile;

import dao.MallShopOrder;
import dao.MallShopPaymethod;
/**
 * 支付订单
 * @author Administrator
 * 
 * /mall/kgmall/buyer/action/PayMyOrderAction.do?method=initPayOrder_selectMethod
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class PayMyOrderAction  extends DispatchAction {
	

	//支付订单,选择支付方式
	public  ActionForward initPayOrder_selectMethod(ActionMapping mapping, ActionForm form,

			HttpServletRequest request, HttpServletResponse response)

			throws IOException, ServletException{	
		//方法授权访问 列表登录，操作权限，及安全过滤
		QuanXangByShopUser qxbean=QuanXangByShopUser.getInstance();
		boolean bloginsaler=	qxbean.chekMethodPermissionByRegUser(request, response);
			if(bloginsaler==false){
				
				response.flushBuffer();
				return null;
			}	
		
		//获取订单
			long orderId=Long.parseLong(request.getParameter("orderId"));
		dao.MallShopOrder order=(MallShopOrder) service.entryService.MallShopOrderEntryService.getInstance()
		.get(orderId);
		
		request.getSession().setAttribute("ShopOrderSession", order);
		
		//订单明细
		List<dao.MallShopOrderitem> shopItemList=service.entryService.MallShopOrderitemEntryService.getInstance()
		.getItemListByOrderId(orderId);
		
		request.getSession().setAttribute("ShopOrderItemListPay", shopItemList);
		
		//订单已被清空
		 if(shopItemList.size()==0){
			 return toPayError_paypal();
		 }
		
		
		//获取支付方法列表
		boolean benable0=true;
		service.entryService.MallShopPaymethodEntryService payBean=	service.entryService.MallShopPaymethodEntryService.getInstance();
		List<dao.MallShopPaymethod> paylist=payBean.getListByEnable(benable0);
		
		request.setAttribute("MallShopPaymethodList", paylist);
		

		mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
		String tmp=app.getSystemConfigAppApp().getTmpleteName();
		if(tmp==null  ||tmp.equals("")==true){
			tmp="default";
		}
		ActionForward a=new ActionForward();
		a.setRedirect(false);
		
		String page="/buyer/myOrder/PayOrderMethodListSelect.jsp";
		String path="/Templete/"+tmp+"/mall/dt/main/"+page;
		a.setPath(path);
		System.out.println("显示："+path);
		return a;

	}
	/**
	 * 使用第三方支付工具支付订单
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws IOException
	 * @throws ServletException
	 */
	public  ActionForward initPayOrder_PayForm3(ActionMapping mapping, ActionForm form,

			HttpServletRequest request, HttpServletResponse response)

			throws IOException, ServletException{	
		
		//方法授权访问 列表登录，操作权限，及安全过滤
		QuanXangByShopUser qxbean=QuanXangByShopUser.getInstance();
		boolean bloginsaler=	qxbean.chekMethodPermissionByRegUser(request, response);
			if(bloginsaler==false){
				
				response.flushBuffer();
				return null;
			}
			
			int ShopPaymethodId=Integer.parseInt(request.getParameter("payid"));
			
			dao.MallShopPaymethod pay=(MallShopPaymethod) service.entryService.MallShopPaymethodEntryService.getInstance()
			.get(ShopPaymethodId);
			
			request.setAttribute("ShopPaymethod", pay);
		
			
			//获取支付方法列表
			boolean benable0=true;
			service.entryService.MallShopPaymethodEntryService payBean=	service.entryService.MallShopPaymethodEntryService.getInstance();
			List<dao.MallShopPaymethod> paylist=payBean.getListByEnable(benable0);
		
			request.setAttribute("ShopPaymethodList", paylist);
			//判断支付方式
			String key=pay.getSystemKeyWord();
			//支付宝直接支付
			if(key!=null&&key.equals("alipay_zhizhe")){
				initPay_alipay_zhiZhe(request);
				
				//支付宝担保交易
			}else if(key!=null&&key.equals("alipay_DanBao")){
				initPay_alipay_DanBao(request);
			}
			//payThree_ali_double 支付宝双方式付款：直接，担保
			else if(key!=null&&key.equals("payThree_ali_double")){
				initPay_alipay_payThree_ali_double(request);
			}
			//paypal直接付款
			else if(key!=null&&key.equals("paypal_checkout")){
				
				PaypalCheckOutBean paypal=PaypalCheckOutBean.getInstance();
				//获取配置
				paypal.initPay_paypal_checkout(request,response);
				String saler_checkout="SetExpressCheckout.jsp?paymentType=Sale";
				//设置支付类型为卖家支付
				request.setAttribute("paymentType", "Sale");
				//澳大利亚eway
				return getPayal_SetExpressCheckoutjsp(pay);
			
			}else if(key!=null&&key.equals("eway")){
				initPay_alipay_eway(request);
				//QQ财富通
			}else if(key!=null&&key.equals("qqpay")){
				initPay_alipay_qqpay(request);
			
			//直接付款：银行卡转帐
		    }
			else if(key!=null&&key.equals("pay_cart_blank")){
		initPay_alipay_qqpay(request);
		
		//代收货款
		}else if(key!=null&&key.equals("pay_By_sender")){
			initPay_alipay_qqpay(request);
		}
			

			//进入表单页			
			return getFormJspAction(pay);
		

	}
	
	private void initPay_alipay_payThree_ali_double(HttpServletRequest request) {
		// TODO Auto-generated method stub
		
	}

	private void initPay_alipay_qqpay(HttpServletRequest request) {
		// TODO Auto-generated method stub
		
	}

	private void initPay_alipay_eway(HttpServletRequest request) {
		// TODO Auto-generated method stub
		
	}
	//paypal直接付款
	

	private void initPay_alipay_DanBao(HttpServletRequest request) {
		// TODO Auto-generated method stub
		
	}

	//准备支付宝直接付款数据
	
	public void initPay_alipay_zhiZhe(HttpServletRequest request){
		
	}
	//设置paypal订单页
public ActionForward getPayal_SetExpressCheckoutjsp(dao.MallShopPaymethod pay){
		
		
		//生成支付表单页
		String key=pay.getSystemKeyWord();
		if(key==null){
			key=String.valueOf(pay.getId());
		}
		String formFileName="SetExpressCheckout.jsp";
		/**
	//获取订单
	int orderId=Integer.parseInt(request.getParameter("orderId"));
	dao.MallShopOrder order=(ShopOrder) service.entryService.MallShopOrderEntryService.getInstance()
	.get(orderId);
	
	request.getSession().setAttribute("ShopOrderSession", order);
	**/
	

	mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
	String tmp=app.getSystemConfigAppApp().getTmpleteName();
	if(tmp==null  ||tmp.equals("")==true){
		tmp="default";
	}
	ActionForward a=new ActionForward();
	a.setRedirect(false);
	
	//String page="/buyer/pay/paypal/expressCheckout/"+formFileName;
	//String path="/Templete/"+tmp+"/mall/dt/main/"+page;
	String path="/mall/pay/payal/expressCheckOut/SetExpressCheckout.jsp";
	a.setPath(path);
	System.out.println("显示："+path);
	return a;
	}

public ActionForward toPayError_paypal(){
	
	
	//生成支付表单页
	
	String formFileName="SetExpressCheckout.jsp";
	/**
//获取订单
int orderId=Integer.parseInt(request.getParameter("orderId"));
dao.MallShopOrder order=(ShopOrder) service.entryService.MallShopOrderEntryService.getInstance()
.get(orderId);

request.getSession().setAttribute("ShopOrderSession", order);
**/


mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
String tmp=app.getSystemConfigAppApp().getTmpleteName();
if(tmp==null  ||tmp.equals("")==true){
	tmp="default";
}
ActionForward a=new ActionForward();
a.setRedirect(false);

//String page="/buyer/pay/paypal/expressCheckout/"+formFileName;
//String path="/Templete/"+tmp+"/mall/dt/main/"+page;
String path="/mall/pay/payal/expressCheckOut/Error.jsp";
a.setPath(path);
System.out.println("显示："+path);
return a;
}
	
	public ActionForward getFormJspAction(dao.MallShopPaymethod pay){
		
		
		//生成支付表单页
		String key=pay.getSystemKeyWord();
		if(key==null){
			key=String.valueOf(pay.getId());
		}
		String formFileName="PayFormThree_"+key+".jsp";
		/**
	//获取订单
	int orderId=Integer.parseInt(request.getParameter("orderId"));
	dao.MallShopOrder order=(ShopOrder) service.entryService.MallShopOrderEntryService.getInstance()
	.get(orderId);
	
	request.getSession().setAttribute("ShopOrderSession", order);
	**/
	

	mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
	String tmp=app.getSystemConfigAppApp().getTmpleteName();
	if(tmp==null  ||tmp.equals("")==true){
		tmp="default";
	}
	ActionForward a=new ActionForward();
	a.setRedirect(false);
	
	String page="/buyer/myOrder/"+formFileName;
	String path="/Templete/"+tmp+"/mall/dt/main/"+page;
	a.setPath(path);
	System.out.println("显示："+path);
	return a;
	}
}
