package mall.kgmall.buyer.action;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import mall.action.ShopCart;
import mall.kgmall.buyer.bean.QuanXangByShopUser;
import mall.kgmall.buyer.bean.ShopOrderManage;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import action.daoAction.MallShopOrderActionFacade;
import java.util.List;
import dao.MallShopOrder;
import dao.MallShopOrderDao;
import dao.MallShopOrderitem;
import dao.MallShopProduct;
import dao.MallShopUser;
import service.entryService.MallShopOrderEntryService;
import util.ActionFacade;
import util.ObjectDao;
import util.ObjectService;
/***
 * 添加修改实体类，表单处理控制器
 * @author 聚龙网络 www.juuluu.org
 *
 */


import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class MallShopOrderAddAction extends Action {
	private String actionPath;
	private ActionFacade actionFacade;
	private ObjectDao ObjectService;
	private Object object;	
	private String objectListByidTarget;
	private String objectViewTarget ;
	private  String objectUpdateTarget;
	private  String objectInitDateForAddTarget;
	private String viewBeanName;
	private String objectListName;
	private MallShopOrderEntryService service;
/***系统创建区开始******************/
//<@automethod_start>
	/**
	*功能：修实体类
	*权限级别：超级管理员方法
	 * java类类型 ：表单控制器方法
	 * 输入文件：/entryJsp/ShopOrderAddActionFormAdd.jsp
	*表单处理路径：/action/daoAction/ShopOrderAddActionAddAction.do?method=tj
	 */
	public ActionForward execute(ActionMapping mapping,

			ActionForm form, 

			HttpServletRequest request, 

			HttpServletResponse response)

			throws IOException, ServletException {

		//方法授权访问 列表登录，操作权限，及安全过滤
		QuanXangByShopUser qxbean=QuanXangByShopUser.getInstance();
		boolean bloginsaler=	qxbean.chekMethodPermissionByRegUser(request, response);
			if(bloginsaler==false){
				
				response.flushBuffer();
				return null;
			}
			
//初始化控制器
initAction();	

mall.validaty.SessionValidaty session=	mall.validaty.SessionValidaty.getInstance();
com.juuluu.kgcore.dao.Member user=session.getMemberSession(request);

if(user==null){
request.setAttribute("info", "未登录用户，不能使用商城订购功能！");
//商城用户注册
org.apache.struts.action.ActionRedirect action=new org.apache.struts.action.ActionRedirect();
action.setRedirect(false);
//添加或修改后，返回列表显示页		
action.setPath("/mall/admin/shopUserRegForm.jsp");
return toBuyerLoginJSP_en(request);
}
//从请求获取参数
//service 声明
MallShopOrderEntryService service=new  MallShopOrderEntryService();

//
initAction();
//将表单类数据转为持久化实体类
MallShopOrder o=(MallShopOrder) this.actionFacade.setEntryByAddForm(form, object);
//订单状态设置为等待发货
o.setShipToState(mall.kgmall.system.SystemValidatyApp.Order_send_waitingShip);

//订单验证
String orderID =o.getOrderID();
String errorInfo="";

String reciveUserName=o.getReciveUserName();
if(reciveUserName==null||reciveUserName.equals("")==true){
	request.setAttribute("info", "Error,Ship To UserName is Null!");
	errorInfo="Error,Ship To UserName is Null!";
return toProductOrderFormAction(request);
}
String reciveAddr=o.getReciveAddr();
if(reciveAddr==null||reciveAddr.equals("")==true){
	
	request.setAttribute("info", "Error,Ship To Address is Null!");
	errorInfo="Error,Ship To UserName is Null!";
	return toProductOrderFormAction(request);
}
String recevieTel =o.getRecevieTel();
if(recevieTel==null||recevieTel.equals("")==true){
	request.setAttribute("info", "Error,Ship To Tel is Null!");
	return toProductOrderFormAction(request);
}
String reciveEmail =o.getReciveEmail();
if(reciveEmail==null||reciveEmail.equals("")==true){
	
	request.setAttribute("info", "Error,Ship To E-mail is Null!");
	return  toProductOrderFormAction(request);
}

String orderUserName =o.getOrderUserName();
if(orderUserName==null||orderUserName.equals("")==true){
	
	request.setAttribute("info", "Error,Ship To E-mail is Null!");
	return  toProductOrderFormAction(request);
}

String orderAddr =o.getOrderAddr();
if(orderAddr==null||orderAddr.equals("")==true){
	
	request.setAttribute("info", "Error,Order User Address is Null!");
	return  toProductOrderFormAction(request);
}
String orderTel=o.getOrderTel();
if(orderTel==null||orderTel.equals("")==true){
	
	request.setAttribute("info", "Error,Order User Tel is Null!");
	return  toProductOrderFormAction(request);
}

//保存实体类

ShopOrderManage ob=ShopOrderManage.getInstance();

//当前订购产品
dao.MallShopProduct productOrderCurrent=(MallShopProduct) request.getSession().getAttribute("ProductOrderCurrent");//, p);
//创建订单
MallShopOrder savedOrder=	ob.create(request, productOrderCurrent,o);
if(savedOrder==null){

request.setAttribute("info", "创建订单失败，订单格式有错误！Error! please fill again!");
return  toProductOrderFormAction(request);
}


//创建购物车 
ShopCart cart=	ob.createMyShopCart(request);

//获取用户当前订购产品,用户未登录时订单
dao.MallShopOrderitem orderItem=(MallShopOrderitem) request.getSession(true).getAttribute("MyOrderItemNew");
//根据订单创建购物车,规范：购物车只存放保存到数据库中的产品项目

if(orderItem!=null){
System.out.println("获取用户未登录时订购的产品");

//添加订单项到订单中
ob.addOrderItemToOrder(request,savedOrder, orderItem);
List<dao.MallShopOrderitem> orderItemList=ob.getOrderItemListByOrderId(savedOrder.getId());
//登录商城会员
MallShopUser savedShopUser=(MallShopUser) mall.validaty.SessionValidaty.getInstance()
.getMallShopUserSession(request);

cart.setMyOrder(savedOrder);
cart.setOrderItemList(orderItemList);
cart.setShopUser(savedShopUser);


}

//添加订单成功，清除当前订购行为
String userAction=(String) request.getSession(true).getAttribute("action");
if(userAction!=null&&userAction.equals("orderProduct")){
	request.getSession(true).removeAttribute("action");
}

org.apache.struts.action.ActionRedirect action=new org.apache.struts.action.ActionRedirect();
//添加或修改后，返回列表显示页		
action.setRedirect(true);

action.setPath("/mall/kgmall/buyer/action/MallShopOrderAdminAction.do?method=mycurrentOrderManage");
return action;


}
	//返回订单表单页，
	private ActionForward toProductOrderFormAction(HttpServletRequest request){
		//通过模板显示内容
		mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
		String tmp=app.getSystemConfigAppApp().getTmpleteName();
		if(tmp==null  ||tmp.equals("")==true){
			tmp="default";
		}
		ActionForward a=new ActionForward();
		a.setRedirect(false);
		String page="/buyer/myOrder/MyOrderFormAdd.jsp";
		String path="/Templete/"+tmp+"/mall/dt/main/"+page;
		a.setPath(path);
		System.out.println("显示："+path);
		return a;
	}
	
	private ActionForward toBuyerLoginJSP_en(HttpServletRequest request){
		//通过模板显示内容
		mall.validaty.AppContextValidatyBean app=mall.validaty.AppContextValidatyBean.getInstance();
		String tmp=app.getSystemConfigAppApp().getTmpleteName();
		if(tmp==null  ||tmp.equals("")==true){
			tmp="default";
		}
		ActionForward a=new ActionForward();
		String page="/buyer/login.jsp";
		String path="/Templete/"+tmp+"/mall/dt/main/"+page;
		a.setPath(path);
		System.out.println("显示："+path);
		return a;
	}
//<@automethod_end>
/***系统创建区结束******************/
public void initAction() {

this.actionPath="/action/daoAction/ShopOrdergrounpAction.do?method=list";
this.actionFacade=new MallShopOrderActionFacade();
this.ObjectService=new MallShopOrderDao();
this.object=new MallShopOrder();	
this.objectListByidTarget="listJsp";
this.objectViewTarget= "viewJsp";
this.objectUpdateTarget= "updateJsp";
this.objectInitDateForAddTarget= "addJsp";
this.viewBeanName="ShopOrder";
this.objectListName="objectList";
this.service=MallShopOrderEntryService.getInstance();

}
}
