package mall.jianTai.bean;

import java.util.Iterator;
import java.util.List;

import service.entryService.MallShopProductEntryService;
import service.entryService.MallShopProductcatEntryService;
import dao.MallShopProduct;
import dao.MallShopProductcat;
/**
 * 生成商城静态网页路径，分类页，产品页，一级分类页面
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class ShopHtmlPathBean {
	//产品列表静态路径
public void resetProductPageHtmlPathByList(List<dao.MallShopProduct> productList){
		for(int i=0;i<productList.size();i++){
			//, element))
			MallShopProduct p=productList.get(i);
			
			if(p.getHtmlLinkPath()==null||p.getHtmlLinkPath().equals("")){
				//创建静态路径
				long pid=p.getId();
				 String link=getProductPageHtmlPath(pid);
				 p.setHtmlLinkPath(link);
			}
			
		}
	}
	
	//产品页静态路径
	public String getProductPageHtmlPath(long ShopProductId){		
		
		MallShopProductEntryService as=	MallShopProductEntryService.getInstance();
		dao.MallShopProduct a=(MallShopProduct) as.get( ShopProductId);
		
		//文章静态相对路径
		String PathAndFileNameSd="";
		
		
		//文章静态相对路径是否已存在
		if(a.getHtmlLinkPath()==null||a.getHtmlLinkPath().equals("")){
			util.HtmlPathCreateUtil pathbean=new util.HtmlPathCreateUtil();
			//文件保存目录，相对目录
			String saveDir="/mall/html";
			//实体数据ID
			String Id=Long.toString(a.getId());
			//文件名前缀
			String fileNamePrefix="cp";
			//文件后缀
			String fileType="html";
			//创建含时间的相对路径
			PathAndFileNameSd=pathbean.createTimeHtmlPathByEntryID(saveDir, Id, fileNamePrefix, fileType);
			//保存路径
			a.setHtmlLinkPath(PathAndFileNameSd);
			as.merge(a);
			System.out.println("创建静态路径："+PathAndFileNameSd);
		}else{
			PathAndFileNameSd=a.getHtmlLinkPath();
			//使用现成路径		
			System.out.println("已创建，使用原路径："+PathAndFileNameSd);
			
		}
		
		return PathAndFileNameSd;
	}
	
	/**
	 * 栏目子栏目列表首页静态路径路径
	 * @param catid
	 * @return
	 */
	public void resetListCatIndexHtmlPath(List<dao.MallShopProductcat> catList){
		service.entryService.MallShopProductcatEntryService bean=	service.entryService.MallShopProductcatEntryService.getInstance()
		;
		for(int i=0;i<catList.size();i++){
			MallShopProductcat cat=catList.get(i);
			getCatIndexHtmlPathByCatIDPageId(cat.getCatId());
		
		}
		
	}
	
	
	//生成产品分类页静态网页路径
	public String getCatIndexHtmlPathByCatIDPageId(int catid){
		service.entryService.MallShopProductcatEntryService bean=	service.entryService.MallShopProductcatEntryService.getInstance()
		;
			dao.MallShopProductcat icat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
			.get(catid);
			if(icat==null){
				System.out.println("找不到该栏目："+catid);
				return "";
			}
			//已生成静态路径
			if(icat.getHtmLinkPath()!=null&&icat.getHtmLinkPath().equals("")==false){
				return icat.getHtmLinkPath();
			}
			int ShopProductcatid;
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatid=icat.getCatId();
			}else{
				if(icat.getRootCatId()==null){
					System.out.println("一级栏目未设置："+catid);
					return "";
				}
				ShopProductcatid=icat.getRootCatId();
			}
			
			dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatid);
		   //根目录路径+产品分类路径
			String ShopProductcatDirRoot=ch.getEnglishCharname();
			//生成静态，产品目录路径
			String ShopProductcatDir="";
			//是否根产品分类
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatDir=ShopProductcatDirRoot;
			}else{
				//增加子分类栏目
				ShopProductcatDir=ShopProductcatDirRoot+"/"+icat.getEnglishCharname();
			}
			
			String catPathAndFileName="/mall/html/"+ShopProductcatDir+"/index.html";
			
			if(icat.getHtmLinkPath()==null||icat.getHtmLinkPath().equals("")){
				icat.setHtmLinkPath(catPathAndFileName);
				icat.setBhtml(true);
				bean.merge(icat);
			}
			
			return catPathAndFileName;
	}
	
	//生成产品分类页静态网页路径
	public String getCatHtmlPathByCatIDPageId(int catid, int pageid){
		
			dao.MallShopProductcat icat=(MallShopProductcat) service.entryService.MallShopProductcatEntryService.getInstance()
			.get(catid);
			//获取一级栏目及其栏目，作为生成静态目录
			//生成静态，产品目录路径
			String ShopProductcatDir="";
			//根目录路径+产品分类路径
			String ShopProductcatDirRoot="";
			int ShopProductcatidRoot=0;
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatidRoot=icat.getCatId();
				dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatidRoot);
				   //根目录路径+产品分类路径
				ShopProductcatDirRoot=ch.getEnglishCharname();
			}else{
				if(icat.getRootCatId()==null){
					System.out.println("该子栏目没设置一级栏目，使用默认目录："+icat.getName()+" ID:"+icat.getCatId());
					ShopProductcatDirRoot="Cat"+catid;
				}else{
					ShopProductcatidRoot=icat.getRootCatId();
					dao.MallShopProductcat ch=(MallShopProductcat) MallShopProductcatEntryService.getInstance().get(ShopProductcatidRoot);
					   //根目录路径+产品分类路径
					ShopProductcatDirRoot=ch.getEnglishCharname();
				}
			}
			if(ShopProductcatDirRoot==null){
				System.out.println("栏目英文名未设置，使用默认目录：Cat"+catid);
				ShopProductcatDirRoot="Cat"+catid;
			}
			
		
			
			//是否根产品分类
			if(icat.getBroot()!=null&&icat.getBroot()){
				ShopProductcatDir=ShopProductcatDirRoot;
			}else{
				//增加子分类栏目
				ShopProductcatDir=ShopProductcatDirRoot+"/"+icat.getEnglishCharname();
			}
			
			String listPathAndFileName="/mall/html/"+ShopProductcatDir+"/"+"list_"+catid+"_"+pageid+".html";
			return listPathAndFileName;
	}
}
