package mall.html.edit;

import mall.kgmall.spider.web.HTMLEditBean;
import mall.kgmall.spider.web.HtmlEditConfigBean;
import dao.MallShopProduct;
import service.entryService.MallShopProductEntryService;

/**
 * 网站内容批量编辑
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class ShopHtmlEditBean {
	//类型title  chContent enContent
public static String type_edit_title="title";
public static String type_edit_contentCh="chContent";
public static String type_edit_contentEn="enContent";


	private MallShopProductEntryService productBean=MallShopProductEntryService.getInstance();
	/**
	 * 
	 * @param productcatId
	 * @param type 批量编辑类型：标题，内容，或其它字段
	 */
	//栏目产品批量编辑 标题
	public void catProductHtmlEdit(HtmlEditConfigBean config,int catId0,String type){
		//获取产品
		java.util.List<MallShopProduct> list=productBean.getListShopProductcatId(catId0);
		for(int i=0;i<list.size();i++){
			MallShopProduct p=list.get(i);
			if(type.equals("title")){
				editName_Product(config,p.getId());
			}else if(type.equals("chContent")){
				editContent_Product(config,p.getId());
			}else if(type.equals("enContent")){
				editContentEnglish_Product(config,p.getId());
			}
		}
	}
	//采集产品批量编辑  标题
	public void spiderJobProductHtmlEdit(HtmlEditConfigBean config,int scSpiderjobId1,String type){
		//获取产品
		boolean bspider0=true;
		java.util.List<MallShopProduct> list=productBean.queryListByScSpiderjob(bspider0, scSpiderjobId1);
		for(int i=0;i<list.size();i++){
			MallShopProduct p=list.get(i);
			if(type.equals("title")){
				editName_Product(config,p.getId());
			}else if(type.equals("chContent")){
				editContent_Product(config,p.getId());
			}else if(type.equals("enContent")){
				editContentEnglish_Product(config,p.getId());
			}
		}
	}
	
	//通用产品编辑
	public void changeProductHtml(HtmlEditConfigBean config,String type,long productId){
		if(type.equals("title")){
			editName_Product(config,productId);
		}else if(type.equals("chContent")){
			editContent_Product(config,productId);
		}else if(type.equals("enContent")){
			editContentEnglish_Product(config,productId);
		}
	}
	
	
	//整站编辑 标题
	 
	public void editProductHtmlEdit_AllProduct(HtmlEditConfigBean config,String type){
		//获取产品
		java.util.List<MallShopProduct> list=productBean.getListAll();
		for(int i=0;i<list.size();i++){
			MallShopProduct p=list.get(i);
			if(type.equals("title")){
				editName_Product(config,p.getId());
			}else if(type.equals("chContent")){
				editContent_Product(config,p.getId());
			}else if(type.equals("enContent")){
				editContentEnglish_Product(config,p.getId());
			}
		}
	}
	
//单个产品标题编辑
	private void editName_Product(HtmlEditConfigBean config,long productId){
		System.out.println("修改产品标题："+productId);
		MallShopProduct product=(MallShopProduct) this.productBean.get(productId);		
		String title=product.getName();
		HTMLEditBean bean=new HTMLEditBean();
		String newCOntnet=bean.editHtmlContent(config, title);
		
		product.setName(newCOntnet);
		
		
		//保存新编辑内容
		productBean.merge(product);
	}
	
	//单个产品描述编辑
	private void editContent_Product(HtmlEditConfigBean config ,long productId){
		System.out.println("修改产品描述："+productId);
		MallShopProduct product=(MallShopProduct) this.productBean.get(productId);		
		String productDescription=product.getDescrptionProduct();
		HTMLEditBean bean=new HTMLEditBean();
		String newCOntnet=bean.editHtmlContent(config, productDescription);
		
		product.setDescrptionProduct(newCOntnet);
		//保存新编辑内容
		productBean.merge(product);
	}
	
	//单个产品描述编辑英文
	private void editContentEnglish_Product(HtmlEditConfigBean config,long productId){
		MallShopProduct product=(MallShopProduct) this.productBean.get(productId);		
		String productDescription=product.getDescriptProductEnglish();
		HTMLEditBean bean=new HTMLEditBean();
		String newCOntnet=bean.editHtmlContent(config, productDescription);
		//保存新编辑内容
		productBean.merge(product);
	}
}
