package mall.edit;

import javax.servlet.http.HttpServletRequest;

import com.juuluu.kgcore.dao.Member;
import dao.MallShopDianPu;
import dao.MallShopDianpuUser;
/**
 * 卖家仅能编辑自己的店铺，或只限越级管理员，才有权限编辑他的店铺
 * @author Administrator
 *
 */

import mall.security.portal.core.MallSecurityUserUtil;
import mall.security.portal.core.MallUserRoseConfig;
import net.juluu.app.security.core.PortalUserLoginConfig;
import net.juluu.app.security.core.SecurityActionCheckUtil;
public class DianPuEditInitBean {
	//当前店铺店主
	private  String MallShopUserEdit="shopDianpuUserSession";
	//当前编辑店铺
	private  String MallShopDianPuEdit="shopDianPuSession";
	private String EditorCurrent="memberSession";
	private static DianPuEditInitBean instance;
	//单例模式
	private DianPuEditInitBean(){}
	public static DianPuEditInitBean getInstance(){
		if(instance==null){
			instance=new DianPuEditInitBean();
		}
		return instance;
	}
	//初始化卖家环境
	public void initDefaultEditEVtByLoginSaler(com.juuluu.kgcore.base.SystemUserLogin ulogin,HttpServletRequest request){
		////登录用户
		if(ulogin==null){
			//未登录
			return ;
		}
		com.juuluu.kgcore.dao.Member uedit=ulogin.getUser();
		//获取店主资料
		long systemUserId0=uedit.getUserid();
		  dao.MallShopDianpuUser ud=(MallShopDianpuUser) service.entryService.MallShopDianpuUserEntryService.getInstance()
		  .getUserBYSystemUserId(systemUserId0);
		  if(ud==null){
			  //未开通店铺
			  return ;
		  }
		int defaluleDianpuId=  ud.getDefaultDianPuId();
		 dao.MallShopDianPu dinpu=(MallShopDianPu) service.entryService.MallShopDianPuEntryService.getInstance()
		  .get(defaluleDianpuId);
		 
		//设置缓存编辑数据
		  request.getSession(true).setAttribute(this.EditorCurrent, uedit);
		  request.getSession(true).setAttribute(this.MallShopUserEdit, ud);
		  request.getSession(true).setAttribute(this.MallShopDianPuEdit, dinpu);
 
	}
	
	
	//初始货店铺编辑数据
public boolean  initEdit(int dinpuId,HttpServletRequest request){
	////登录用户
        com.juuluu.kgcore.base.SystemUserLogin ulogin=	net.juuluu.plugs.webapp.strutsex.validaty.SessionValidaty.getInstance().getSystemUserLoginSession(request);
if(ulogin==null){
	//未登录
	return  false;
}
com.juuluu.kgcore.dao.Member uedit=ulogin.getUser();
//是否店主，或超级管理员


//初始化店铺管理员
  dao.MallShopDianPu dinpu=(MallShopDianPu) service.entryService.MallShopDianPuEntryService.getInstance()
  .get(dinpuId);
  long systemid=dinpu.getUserSystemId();
  if(uedit.getUserid()!=systemid){
	  
	  //是否超级管理员
	  if(ulogin.isBsuerAdmin()==false){
		  System.out.println("错误，无权限，您既不是店主，也不是超级管理员，不能编辑店铺！");
		  return  false;
	  }else{
		  System.out.println("超级管理员编辑店铺："+dinpu.getDianpuName());
	  }
	  System.out.println("店主编辑店铺："+dinpu.getDianpuName());
		 
  }
  
 
  
  
  long dinpuUserID=dinpu.getDianpuUserId();
  dao.MallShopDianpuUser ud=(MallShopDianpuUser) service.entryService.MallShopDianpuUserEntryService.getInstance()
  .get(dinpuUserID);
  
  //设置缓存编辑数据
  request.getSession(true).setAttribute(this.EditorCurrent, uedit);
  request.getSession(true).setAttribute(this.MallShopUserEdit, ud);
  request.getSession(true).setAttribute(this.MallShopDianPuEdit, dinpu);
  
  request.getSession(true).setAttribute("MallShopDianpuUserSession", ud);
  request.getSession(true).setAttribute("MallShopDianPuSession", dinpu);
  return true;
}

//获取店铺编辑信息
public com.juuluu.kgcore.dao.Member getShopEditor(HttpServletRequest request){
	com.juuluu.kgcore.dao.Member uedit =(Member) request.getSession(true).getAttribute(this.EditorCurrent);
return uedit;

}

public dao.MallShopDianPu getDianPuEditing(HttpServletRequest request){
	dao.MallShopDianPu uedit =(MallShopDianPu) request.getSession(true).getAttribute(this.MallShopDianPuEdit);
	return uedit;
}


public dao.MallShopDianpuUser geShopEditDianpuUser(HttpServletRequest request){
	dao.MallShopDianpuUser uedit =(MallShopDianpuUser) request.getSession(true).getAttribute(this.MallShopUserEdit);
	return uedit;
}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}
	private void setEditorCurrent(String editorCurrent) {
		EditorCurrent = editorCurrent;
	}
	public String getEditorCurrent() {
		return EditorCurrent;
	}
	private void setShopDianPuEdit(String shopDianPuEdit) {
		this.MallShopDianPuEdit = shopDianPuEdit;
	}
	public String getShopDianPuEdit() {
		return MallShopDianPuEdit;
	}
	private void setShopUserEdit(String shopUserEdit) {
		this.MallShopUserEdit = shopUserEdit;
	}
	public String getShopUserEdit() {
		return MallShopUserEdit;
	}

}
