package mall.base.projectRz.view;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import service.entryService.CreditCtcPmCaiwuEntryService;
import service.entryService.CreditCtcPmManageTeamEntryService;
import service.entryService.CreditCtcPmRongziLiShiEntryService;
import service.entryService.CreditCtcPmWorkCatEntryService;
import service.entryService.CreditCtcZijinCatServicecatEntryService;
import service.entryService.CreditCtcZijinCatSmallEntryService;
import service.entryService.CreditCtcZijinFenleiEntryService;
import service.entryService.MallShopProductEntryService;
import service.entryService.MallShopProductcatEntryService;

import dao.MallShopProduct;


/**
 *  creditCtC.projectRz.view.ProjectWebUtil
 * @author Guest
 *
 */

public class ProjectWebUtil {
	private static ProjectWebUtil instance;
	public static ProjectWebUtil getInstance(){
		if(instance==null){
			instance=new ProjectWebUtil();
		}
		return instance;
	}
	
	private ProjectWebUtil(){}
	
	public void loadCreditC2cData(HttpServletRequest request) {
		ServletContext sct=	request.getSession().getServletContext();
		
			if(sct.getAttribute("MallShopProductcatListRoot")==null){
				MallShopProductcatEntryService catDao=MallShopProductcatEntryService.getInstance();
				boolean broot0=true;
				List<dao.MallShopProductcat> catRootList=catDao.getListByIsRoot(broot0);
				
				sct.setAttribute("MallShopProductcatListRoot", catRootList);
			}
		
			if(sct.getAttribute("CreditCtcPmWorkCatList")==null){
				CreditCtcPmWorkCatEntryService workcatDao=CreditCtcPmWorkCatEntryService.getInstance();
				List<dao.CreditCtcPmWorkCat> workCatList=workcatDao.getListAll();
				
				sct.setAttribute("CreditCtcPmWorkCatList", workCatList);
			}
		
		
			if(sct.getAttribute("CreditCtcZijinCatSmallList")==null){
				List<dao.CreditCtcZijinCatSmall> zjCatSmallList=
						CreditCtcZijinCatSmallEntryService.getInstance().getListAll();
				sct.setAttribute("CreditCtcZijinCatSmallList", zjCatSmallList);
				
				
				
			}
		
			if(sct.getAttribute("CreditCtcZijinFenleiList")==null){
				List<dao.CreditCtcZijinFenlei> fenLeiCatList=CreditCtcZijinFenleiEntryService.getInstance()
						.getListAll();
				
				sct.setAttribute("CreditCtcZijinFenleiList", fenLeiCatList);
			}
			
			//cat service
			if(sct.getAttribute("CreditCtcZijinCatServicecatList")==null){
				List<dao.CreditCtcZijinCatServicecat> catServiceList=CreditCtcZijinCatServicecatEntryService.getInstance()
						.getListAll();
				
				sct.setAttribute("CreditCtcZijinCatServicecatList", catServiceList);
			}
		
			try {
				loadShopBaseDate_hot_new_indexCommand(request);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ServletException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		
	}
	
	public void reloadCreditC2cData(HttpServletRequest request) {
		ServletContext sct=	request.getSession().getServletContext();
		
			
				MallShopProductcatEntryService catDao=MallShopProductcatEntryService.getInstance();
				boolean broot0=true;
				List<dao.MallShopProductcat> catRootList=catDao.getListByIsRoot(broot0);
				
				sct.setAttribute("MallShopProductcatListRoot", catRootList);
			
		
			
				CreditCtcPmWorkCatEntryService workcatDao=CreditCtcPmWorkCatEntryService.getInstance();
				List<dao.CreditCtcPmWorkCat> workCatList=workcatDao.getListAll();
				
				sct.setAttribute("CreditCtcPmWorkCatList", workCatList);
			
		
		
			
				List<dao.CreditCtcZijinCatSmall> zjCatSmallList=
						CreditCtcZijinCatSmallEntryService.getInstance().getListAll();
				sct.setAttribute("CreditCtcZijinCatSmallList", zjCatSmallList);
				
				
				//cat service
						List<dao.CreditCtcZijinCatServicecat> catServiceList=CreditCtcZijinCatServicecatEntryService.getInstance()
							.getListAll();
					
					sct.setAttribute("CreditCtcZijinCatServicecatList", catServiceList);
				
		
			
				List<dao.CreditCtcZijinFenlei> fenLeiCatList=CreditCtcZijinFenleiEntryService.getInstance()
						.getListAll();
				
				sct.setAttribute("CreditCtcZijinFenleiList", fenLeiCatList);
			
				try {
					reloadShopBaseDate_hot_new_indexCommand(request);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					System.out.println(e.getMessage());
					e.printStackTrace();
				} catch (ServletException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					System.out.println(e.getMessage());
				}
		
	}
	
	// 获取商城基本数据
	public void loadShopBaseDate_hot_new_indexCommand(HttpServletRequest request)
				throws IOException, ServletException{
		MallShopProductEntryService sbean=MallShopProductEntryService.getInstance();
			//ProductcatListIndexHost ProductcatListIndexTopCommand ProductcatListIndexTopnew

		ServletContext s=	 request.getSession(true).getServletContext();
		

		//s.removeAttribute( "MallProductcatListIndexHost");
		//s.removeAttribute( "MallProductcatListIndexTopCommand");
		//s.removeAttribute( "MallProductcatListIndexTopnew");
		//首页热点产品
		if (s.getAttribute( "MallProductcatListIndexHost")==null){
		
			int maxResult=10;
			 List  < MallShopProduct>	news=sbean.getHostProductList(maxResult);
			s.setAttribute( "MallProductcatListIndexHost", news);

		}
		//首页  推荐产品
		if (s.getAttribute( "MallProductcatListIndexTopCommand")==null){
			int maxResult=10;
			boolean bindexCommand0=true;
			 List  < MallShopProduct>	news=sbean.getIndexTopCommand(bindexCommand0, maxResult);
			s.setAttribute( "MallProductcatListIndexTopCommand", news);
			
			System.out.println("command product size:"+news.size());

		}
		//首页最新产品
		if (s.getAttribute( "MallProductcatListIndexTopnew")==null){
			int maxResult=10;
			 List  < MallShopProduct>	news=sbean.getNewProductLIst(maxResult);
			s.setAttribute( "MallProductcatListIndexTopnew", news);
		}
	}

	
	// 获取商城基本数据
	public void reloadShopBaseDate_hot_new_indexCommand(HttpServletRequest request)
				throws IOException, ServletException{
		MallShopProductEntryService sbean=MallShopProductEntryService.getInstance();
			//ProductcatListIndexHost ProductcatListIndexTopCommand ProductcatListIndexTopnew

		ServletContext s=	 request.getSession(true).getServletContext();
		
		System.out.println("刷新系统缓存数据！");

		s.removeAttribute( "MallProductcatListIndexHost");
		s.removeAttribute( "MallProductcatListIndexTopCommand");
		s.removeAttribute( "MallProductcatListIndexTopnew");
			//首页热点产品
	
			//首页热点产品

		
			int maxResult=10;
			
			 List  < MallShopProduct>	hotList_mall=sbean.getHostProductList(maxResult);
			s.setAttribute( "MallProductcatListIndexHost", hotList_mall);

			System.out.println("hot product List:"+hotList_mall.size());
			//首页  推荐产品

			
			boolean bindexCommand0=true;
			
			List  < MallShopProduct>	cmdList_mall=sbean.getIndexTopCommand(bindexCommand0, maxResult);
			s.setAttribute( "MallProductcatListIndexTopCommand", cmdList_mall);
			
			System.out.println("cmmand product List:"+cmdList_mall.size());
			
			for(int i=0;i<cmdList_mall.size();i++){
				System.out.println(cmdList_mall.get(i).getName());
			}


			//首页最新产品

		
			 List  < MallShopProduct>	topList_mall=sbean.getNewProductLIst(maxResult);
			s.setAttribute( "MallProductcatListIndexTopnew", topList_mall);
		
			System.out.println("top product List:"+topList_mall.size());
		
	}

	
	
	public void reloadCreditC2cData(MallShopProduct dateBean,
			HttpServletRequest request) {
		ServletContext sct=	request.getSession().getServletContext();
		
			
		MallShopProductcatEntryService catDao=MallShopProductcatEntryService.getInstance();
		boolean broot0=true;
		List<dao.MallShopProductcat> catRootList=catDao.getListByIsRoot(broot0);
		
		sct.setAttribute("MallShopProductcatListRoot", catRootList);
		
		CreditCtcPmWorkCatEntryService workcatDao=CreditCtcPmWorkCatEntryService.getInstance();
		List<dao.CreditCtcPmWorkCat> workCatList=workcatDao.getListAll();
		
		sct.setAttribute("CreditCtcPmWorkCatList", workCatList);
		
		
		
		List<dao.CreditCtcZijinCatSmall> zjCatSmallList=
				CreditCtcZijinCatSmallEntryService.getInstance().getListAll();
		sct.setAttribute("CreditCtcZijinCatSmallList", zjCatSmallList);
		
		
		
		List<dao.CreditCtcZijinFenlei> fenLeiCatList=CreditCtcZijinFenleiEntryService.getInstance()
				.getListAll();
		
		sct.setAttribute("CreditCtcZijinFenleiList", fenLeiCatList);
		
		
		
	}


	public void loadProjectData(MallShopProduct dateBean,
			HttpServletRequest request) {
		// TODO Auto-generated method stub
		
		long projectid=dateBean.getId();
		
		MallShopProductEntryService pmDao=MallShopProductEntryService.getInstance();
		dao.MallShopProduct pm=(MallShopProduct) pmDao.get(projectid);
		
		
		CreditCtcPmManageTeamEntryService tmDao=	CreditCtcPmManageTeamEntryService.getInstance();
		List<dao.CreditCtcPmManageTeam> tmList=
			tmDao.getListByProjectId(projectid);
		
		request.setAttribute("CreditCtcPmManageTeamList", tmList);
		
		
	
		
		CreditCtcPmCaiwuEntryService cwDao=	CreditCtcPmCaiwuEntryService.getInstance();
		List<dao.CreditCtcPmCaiwu> cwList=
				cwDao.getListByProjectId(projectid);
		
		request.setAttribute("CreditCtcPmCaiwuList", cwList);
		
		
		

		CreditCtcPmRongziLiShiEntryService rzDao=	CreditCtcPmRongziLiShiEntryService.getInstance();
		List<dao.CreditCtcPmRongziLiShi> rzList=
				rzDao.getListByProjectId(projectid);
		
		request.setAttribute("CreditCtcPmRongziLiShiList", rzList);
		
		
	}

}
