package kgSiteCount.core.count;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import service.entryService.KgsiteCountItemEntryService;
import service.entryService.KgsiteCountItemLogEntryService;
import service.entryService.KgsiteCountMemberLogEntryService;

import dao.KgSiteCountUrlLog;

import kgSiteCount.bean.KgSiteCountUtil;

public class KgItemCountUtil {
	private static KgItemCountUtil instance;
	private KgItemCountUtil(){}
	public static KgItemCountUtil getInstance(){
		if(instance==null){
			instance=new KgItemCountUtil();
		}
		return instance;
	}
	
	public BaseItemCountBean baseItemCount(String itemKey,HttpServletRequest request, 
			HttpServletResponse response){
		
		
		BaseItemCountBean cb=new BaseItemCountBean();
		KgSiteCountUtil baseWebVisitCountUtil= KgSiteCountUtil.getInstance();
		//base url count
		KgSiteCountUrlLog urlLog=	baseWebVisitCountUtil.count(request, response);
			if(urlLog!=null){
				System.out.println("Count request url:"+itemKey+" name:"+" url:"+urlLog.getTargetPath());
				
			}
		dao.KgsiteCountItemLog itemLog= countItem( itemKey, urlLog, request, 
				 response);
		if(itemLog!=null){
			System.out.println("Count:"+itemKey+" name:"+itemLog.getItemName()+" url:"+itemLog.getRequestUrlPath());
			
		}
		dao.KgsiteCountMemberLog userCountLog= countMemberLog( itemKey, urlLog, request, 
				 response);
		if(userCountLog!=null){
			System.out.println("Count Login User:"+itemKey+" name:"+userCountLog.getUserName()+" url:"+itemLog.getRequestUrlPath());
			
		}
		
		cb.setUrlLog(urlLog);
		cb.setCountMemberLog(userCountLog);
		cb.setItemLog(itemLog);
		return cb;
		
	}
	private dao.KgsiteCountItemLog  countItem(String itemKey,KgSiteCountUrlLog urlLog,HttpServletRequest request, 
			HttpServletResponse response){
		KgsiteCountItemEntryService itemDao=KgsiteCountItemEntryService.getInstance();
		dao.KgsiteCountItem item=itemDao.getItemBySystemKey(itemKey);
		KgsiteCountItemLogEntryService itemLogDao=KgsiteCountItemLogEntryService.getInstance();
		if(item!=null){
				if(urlLog==null){
				System.out.println("not count request url path!");
				return null;
			}
			dao.KgsiteCountItemLog itemLog=new dao.KgsiteCountItemLog();
			
			itemLog.setAppId(item.getAppId());
			itemLog.setAppName(item.getAppName());
			itemLog.setCatId(item.getCatId());
			itemLog.setCatName(item.getCatName());
			itemLog.setCreateTime(urlLog.getRegTime());
			itemLog.setCreateTimeLong(urlLog.getRegTimeLong());
			itemLog.setItemId(item.getItemId());
			itemLog.setItemName(item.getItemName());
			itemLog.setRequestUrlPath(urlLog.getTargetPath());
			itemLog.setTotalCount((long)1);
			
			itemLog.setRequestUrlLogId(urlLog.getUrlid());
			
			juuluuApp.session.base.SessionValidaty sessionUtil=	juuluuApp.session.base.SessionValidaty.getInstance();
			
			com.juuluu.kgcore.dao.Member sysUser=sessionUtil.getMemberSession(request);
				if(sysUser!=null){
					itemLog.setBregUser(true);
					
					itemLog.setSysUserId(sysUser.getUserid());
					itemLog.setSysUserName(sysUser.getUserName());
					
				
					
				}
				
				String itemName0=item.getItemName();
				long  createTimeLong1=urlLog.getRegTimeLong();
				String  requestUrlPath2=urlLog.getTargetPath();
				dao.KgsiteCountItemLog itemLogSaved=	itemLogDao.getLogByItemNameAddTimeLongUrlPath(itemName0, createTimeLong1, requestUrlPath2);
				if(itemLogSaved==null){
					itemLogDao.merge(itemLog);
					System.out.println("save count item:"+itemName0);
					 itemLogSaved=	itemLogDao.getLogByItemNameAddTimeLongUrlPath(itemName0, createTimeLong1, requestUrlPath2);
							
				}
				
				return itemLogSaved;
		}else{
			System.out.println("count error,count item is null!"+itemKey);
			
			return null;
				}
		
		
	
	}
	
	
	
	private dao.KgsiteCountMemberLog  countMemberLog(String itemKey,KgSiteCountUrlLog urlLog,HttpServletRequest request, 
			HttpServletResponse response){
		KgsiteCountItemEntryService itemDao=KgsiteCountItemEntryService.getInstance();
		dao.KgsiteCountItem item=itemDao.getItemBySystemKey(itemKey);
		KgsiteCountMemberLogEntryService itemLogDao=KgsiteCountMemberLogEntryService.getInstance();

		            juuluuApp.session.base.SessionValidaty sessionUtil=	juuluuApp.session.base.SessionValidaty.getInstance();

		
		com.juuluu.kgcore.dao.Member sysUser=sessionUtil.getMemberSession(request);
	
		if(sysUser!=null){
			
		}else{
			System.out.println("not count user is don`t logined!");
			return null;
		}
		
		if(item!=null){
			KgSiteCountUtil baseWebVisitCountUtil= KgSiteCountUtil.getInstance();
			//base url count
				if(urlLog==null){
				System.out.println("not count request url path!");
				return null;
			}
			dao.KgsiteCountMemberLog itemLog=new dao.KgsiteCountMemberLog();
			
			itemLog.setAppId(item.getAppId());
			itemLog.setAppName(item.getAppName());
			
			itemLog.setCatId(item.getCatId());
			itemLog.setCatName(item.getCatName());
			
			itemLog.setCreateTime(urlLog.getRegTime());
			itemLog.setCreateTimeLong(urlLog.getRegTimeLong());
			
			itemLog.setCountItemId(item.getItemId());
			itemLog.setCountItemName(item.getItemName());
			
			itemLog.setRequestUrl(urlLog.getTargetPath());
			itemLog.setRequestUrlId(urlLog.getUrlid());
			
			
			itemLog.setSystemUserId(sysUser.getUserid());
			itemLog.setUserName(sysUser.getUserName());
			
			itemLog.setLogItemTitle(urlLog.getTargetPath());
			
				
				int countItemId0=item.getItemId();
				long  createTimeLong1=urlLog.getRegTimeLong();
				String  requestUrlPath2=urlLog.getTargetPath();
				dao.KgsiteCountMemberLog  itemLogSaved=	itemLogDao.
						getLogByItemIdAddTimeLongUrlPath(countItemId0, 
								createTimeLong1, requestUrlPath2);
				
				if(itemLogSaved==null){
					itemLogDao.merge(itemLog);
					System.out.println("save user count log"+sysUser.getUserName());
					
					 itemLogSaved=	itemLogDao.getLogByItemIdAddTimeLongUrlPath(countItemId0,  createTimeLong1, requestUrlPath2);
							
				}
				
				return itemLogSaved;
		}else{
			System.out.println("count error,count item is null!"+itemKey);
			
			return null;
				}
		
		
	
	}
}
