package kgSiteCount.bean;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dao.KgSiteCountUrlLog;

import service.entryService.KgSiteCountUrlLogEntryService;

/**
 * 通用站内统计
 * @author Administrator
 *  kgSiteCount.bean.KgSiteCountUtil 
 *
 */
public class KgSiteCountUtil {
	
	
private KgSiteCountUtil (){
	
}


private static KgSiteCountUtil instance;

public static KgSiteCountUtil getInstance(){
		if(instance==null){
			instance=new KgSiteCountUtil();
		}
		return instance;
		
}

public KgSiteCountUrlLog count(HttpServletRequest request, 
		HttpServletResponse response){
	//判断是否统计网站
	
	//网址统计
	return userVisitSiteUrlCount(request,response);
	//IP统计
	//URL统计
	//浏览器统计
	//来源地区统计
	//
}

//网站基础数据统计
private KgSiteCountUrlLog userVisitSiteUrlCount(HttpServletRequest request, 
		HttpServletResponse response){
	
	
	KgSiteCountUrlLogEntryService cb=KgSiteCountUrlLogEntryService.getInstance();
 
	KgSiteCountUrlLog log=new KgSiteCountUrlLog();
	
	String ip=request.getRemoteHost();
	
	
	String ref=request.getHeader("Referer");
	if(ref!=null&&ref.length()>255){
		ref=ref.substring(0,254);
		System.out.println("too long:"+ref);
	}
	System.out.println("Referer : " + ref+" requesturl:"+request.getRequestURL().toString());
	String targetUrl=request.getRequestURL().toString()+request.getQueryString();
	
	if(targetUrl!=null&&targetUrl.length()>255){
		targetUrl=targetUrl.substring(0,254);
		System.out.println("too long:"+targetUrl);
	}
	long timeLong=System.currentTimeMillis();
		
	com.juuluu.kgcore.dao.Member sysuer=	juuluuApp.session.base.SessionValidaty.getInstance().getMemberSession(request);
	
	if(sysuer!=null){
			log.setBloginSysuser(true);
			
			log.setSysUserMemberId(sysuer.getUserid());
			log.setSysUserMemberName(sysuer.getUserName());
	
			//log.setUserGrounpName(sysuer.get)
		
	}
	
	
	log.setTargetPath(targetUrl);
	log.setIpAddress(ip);
	log.setReffrencePath(ref);
	log.setRegTime(new java.util.Date(timeLong));
	log.setRegTimeLong(timeLong);
	
	//url log ID str
	int rvalu=(int)Math.random()*10000;
	String urlLogIDStr=Long.toString(timeLong)+Integer.toString(rvalu);
	log.setLogUrllIdStr(urlLogIDStr);
	
	KgSiteCountUrlLog  saved=null;
	//判断是否web用户 访问
	if(targetUrl!=null&&ip!=null){
		
		saved=	cb.getLogByAddTimeLongtargetUrlPath(timeLong, targetUrl,urlLogIDStr);
			if(saved==null){
				cb.merge(log);
				System.out.println("save url log:"+targetUrl+" url id:"+urlLogIDStr);
			}
			saved=	cb.getLogByAddTimeLongtargetUrlPath(timeLong, targetUrl,urlLogIDStr);
			if(saved!=null){
				System.out.println("save sucess!");
			}
	}else{
		System.out.println("非WEB用户请求,不统计.");
	}
	
		return saved;
	
}

}
