package juuluuApp.secure.simpleapp.user.visitfilter;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import juuluuApp.session.base.SessionValidaty;

import org.apache.struts.action.ActionForward;

import com.juuluu.kgcore.base.CompleeManageBean;
import com.juuluu.kgcore.base.SystemUserLogin;
import com.juuluu.kgcore.dao.Membergrounp;
import com.juuluu.kgcore.entryService.MemberEntryService;


/**
 * 对用户操作行为进行审核
 * 超级管理员级别行为：
 * 基本实体类添加，修改
 * 
 * @author Administrator
 *
 */
public class PortalUserActionChecker {
	private UserPortalConfig portalUserCodeWebConfig;
	private static PortalUserActionChecker instance;
	
	public static PortalUserActionChecker getInstance() {
		if(instance==null){
			instance=	new PortalUserActionChecker();
		}
		return instance;
	}
	private PortalUserActionChecker(){
		portalUserCodeWebConfig=new UserPortalConfig();
		
	}
	
	//超级管理员级用户操作 方法审核
	public ActionForward checkSuperAdminAction(HttpServletRequest request,HttpServletResponse response){
		com.juuluu.kgcore.base.SystemUserLogin  ulogin=SessionValidaty.getInstance()
		.getSystemUserLoginSession(request);
		if(ulogin==null){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "非法操作，无此权限，请注册或登录系统.error,please login in!");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		if(ulogin.isBsuerAdmin()==false){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "错误，权限不足，不能执行该操作，请以超级管理员登录");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		return null;
		
		}
	//新闻系统管理员操作
	public ActionForward checkCmsAdminAction(HttpServletRequest request,HttpServletResponse response){
		
	
		com.juuluu.kgcore.base.SystemUserLogin  ulogin=SessionValidaty.getInstance()
		.getSystemUserLoginSession(request);
		if(ulogin==null){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "非法操作，无此权限，请注册或登录系统.error,please login in!");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		
		//执行超级管理员审核，
		if(ulogin.isBsuerAdmin()==false){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "错误，权限不足，不能执行该操作，请以超级管理员登录");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		return null;
		
		}
	
	//商城系统管理员操作
	public ActionForward checkShopAdminAction(HttpServletRequest request,HttpServletResponse response){
		com.juuluu.kgcore.base.SystemUserLogin  ulogin=SessionValidaty.getInstance()
		.getSystemUserLoginSession(request);
		if(ulogin==null){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "非法操作，无此权限，请注册或登录系统.error,please login in!");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		if(ulogin.isBsuerAdmin()==false){
			ActionForward af=new ActionForward();
			af.setRedirect(false);
			request.setAttribute("info", "错误，权限不足，不能执行该操作，请以超级管理员登录");
			af.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
			return af;
		}
		return null;
		
		}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}
/**
 * 	
 * @param request
 * @param myUserGrounpList 授权用户组访问列表 
 * @return
 * 授权用户组访问列表 ，常见值：
 * complee
 * customer
 * superAdmin
 */
public ActionForward methodCheckUserGrounpPermission(HttpServletRequest request,String [] myUserGrounpNameListYes){
	//授权访问用户列表
	//"niMing","customper","complee","superAdmin"
	//是否通过授权访问
	boolean isPassedCheck=false;
	ActionForward errorCheckActionForward=null;
	//
	for(int k=0;k<myUserGrounpNameListYes.length;k++){
		String methoGrounpName=myUserGrounpNameListYes[k];
		if(methoGrounpName.equals("niMing")){
			System.out.println("授权匿名访问："+methoGrounpName);
			isPassedCheck=true;
			break;
		}
	}//end for
	//允许匿名访问
	if(isPassedCheck==true){
		return errorCheckActionForward;
	}
	//要求登录
	SystemUserLogin userLogin=	SessionValidaty.getInstance().getSystemUserLoginSession(request);
	if(userLogin==null){
		errorCheckActionForward=new ActionForward();
		request.setAttribute("info", "非授权访问，或登录超时，请登录系统！");
		errorCheckActionForward.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
		//System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
		return errorCheckActionForward;
	}
	//测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
	List<Membergrounp> userMemberGrounpList= userLogin.getGrounpLIst();
	for(int i=0;i<userMemberGrounpList.size();i++){
	
		Membergrounp g=	userMemberGrounpList.get(i);
		String mygronpName=g.getGroupname();
		//登录用户全员组，是在在的控制器方法的授权访问表中
		for(int k=0;k<myUserGrounpNameListYes.length;k++){
			String methoGrounpName=myUserGrounpNameListYes[k];
			if(mygronpName.equals(methoGrounpName)){
				System.out.println("授权访问："+methoGrounpName);
				isPassedCheck=true;
				break;
			}
		}//end for
		if(isPassedCheck==true){
			break;
		}
		
	}//end for
	
	//授权访问不通过，
	if(isPassedCheck==false){
		errorCheckActionForward=new ActionForward();
		request.setAttribute("info", "非授权访问，或登录超时，请登录系统！");
		errorCheckActionForward.setPath(this.portalUserCodeWebConfig.getUserLogingPage());
		
	}
	return errorCheckActionForward;
	//授权访问通过，继续执行程序代码
}

//通用用户登录模块

public ActionForward userLoginChceckComment(HttpServletRequest request,String loginInpuJsp,String loginSucessTargetJsp){
	final String name=request.getParameter("userName");		

	final String password=request.getParameter("password");	
	if(name==null||name.equals("")==true){
		
			request.setAttribute("info", "用户名没填写!");		
			ActionForward af=new ActionForward();
			af.setRedirect(false);			
			af.setPath(loginInpuJsp);
			return af;
	}else if(password==null||password.equals("")==true){
		
			request.setAttribute("info", "密码没填写!");
			final String target="Admin_userloginjsp";
			ActionForward af=new ActionForward();
			af.setRedirect(false);			
			af.setPath(loginInpuJsp);
			return af;
	}
		//设置菜单到Session			

	SystemUserLogin userSystemlogined=null;		

	final CompleeManageBean userbean=CompleeManageBean.getInstance();			//取超级用户菜单		

//	验证用户登录			

	userSystemlogined=userbean.logincheck(name, password);	

		if(userSystemlogined.getUser()==null){	

			///用户名或密码错误，返回登临界面	
			//错误类型，用户名不存在，
			final MemberEntryService mb=MemberEntryService.getInstance();
			if(mb.getByUserLoginName(name)==null){
				if(name==null||name.equals("")==true){
					request.setAttribute("info", "登录失败，用户名没填写!");
				}else{
					request.setAttribute("info", "登录失败，用户"+name+"不存在！");
				}
				
			}else{
				if(password==null||password.equals("")==true){
					request.setAttribute("info", "登录失败，密码没填写！");
				}else{
					request.setAttribute("info", "登录失败，密码错误！");
				}
				
			}//end else
			
			request.setAttribute("info", "登录失败，用户名或密码错误！");
			request.setAttribute("userName", name);
			request.setAttribute("password", password);
			//密码错误
			final String target="Admin_userloginjsp";
			ActionForward af=new ActionForward();
			af.setRedirect(false);			
			af.setPath(loginInpuJsp);
			return af;
	
	// 成功登录 保存用户信息 userSystemlogined.getUser()!=null
		}else{			

//	初始化管理数据			

//	默认显示文件，组的显示文件	
//转到用户管理中心		
			//将会员信息设置到系统会话环境				
			SessionValidaty session=	SessionValidaty.getInstance();
			session.setSystemUserLoginSession(request, userSystemlogined);	
			//保存登录信息到会话变量中
			session.setMemberSession(request, userSystemlogined.getUser());
			
	 SessionValidaty sessionBean=SessionValidaty.getInstance();	
	

	ActionForward af=new ActionForward();
	af.setRedirect(false);			
	af.setPath(loginSucessTargetJsp);
	return af;				

  }	//end if
}//end method

public UserPortalConfig getPortalUserCodeWebConfig() {
	return portalUserCodeWebConfig;
}

public void setPortalUserCodeWebConfig(UserPortalConfig portalUserCodeWebConfig) {
	this.portalUserCodeWebConfig = portalUserCodeWebConfig;
}
}
